/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import net.handle.hdllib.Util;

public class SessionInfo {
    private static int defaultTimeout = 86400;
    public int timeOut = 86400;
    public int sessionId;
    public byte[] sessionKey;
    public boolean encryptMessage = false;
    public boolean authenticateMessage = false;
    public byte[] identityKeyHandle = null;
    public int identityKeyIndex = -1;
    private int lastTransactionTime;

    public SessionInfo(int sessionid, byte[] sessionkey) {
        this.sessionId = sessionid;
        this.sessionKey = sessionkey;
        this.lastTransactionTime = (int)(System.currentTimeMillis() / 1000L);
        this.timeOut = defaultTimeout;
    }

    public SessionInfo(int sessionid, byte[] sessionkey, byte[] idenHandle, int idenIndex) {
        this.identityKeyHandle = idenHandle;
        this.identityKeyIndex = idenIndex;
        this.sessionId = sessionid;
        this.sessionKey = sessionkey;
        this.lastTransactionTime = (int)(System.currentTimeMillis() / 1000L);
        this.timeOut = defaultTimeout;
    }

    public boolean isSessionAnonymous() {
        return this.identityKeyHandle == null || this.identityKeyIndex == -1;
    }

    public void setTimeOut(int newTimeout) {
        if (newTimeout > 0) {
            this.timeOut = newTimeout;
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(byte[] sessionkey) {
        this.sessionKey = sessionkey;
    }

    public boolean getEncryptedMesssageFlag() {
        return this.encryptMessage;
    }

    public boolean getAuthenticateMessageFlag() {
        return this.authenticateMessage;
    }

    public void setEncryptedMesssageFlag(boolean flag) {
        this.encryptMessage = flag;
    }

    public void setAuthenticateMessageFlag(boolean flag) {
        this.authenticateMessage = flag;
    }

    public void touch() {
        this.lastTransactionTime = (int)(System.currentTimeMillis() / 1000L);
    }

    public final boolean hasExpired() {
        return (long)this.lastTransactionTime < System.currentTimeMillis() / 1000L - (long)this.timeOut;
    }

    public static void setDefaultTimeout(int maxSessionTimeout) {
        defaultTimeout = maxSessionTimeout;
    }

    public static int getDefaultTimeout() {
        return defaultTimeout;
    }

    public int getSessionID() {
        return this.sessionId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SessionInfo info = (SessionInfo)obj;
        if (this.timeOut != info.getTimeOut()) {
            return false;
        }
        if (this.sessionId != info.getSessionID()) {
            return false;
        }
        if (!Util.equals(this.sessionKey, info.getSessionKey())) {
            return false;
        }
        if (this.encryptMessage != info.getEncryptedMesssageFlag()) {
            return false;
        }
        if (this.authenticateMessage != info.getAuthenticateMessageFlag()) {
            return false;
        }
        if (this.identityKeyIndex != info.identityKeyIndex) {
            return false;
        }
        return Util.equals(this.identityKeyHandle, info.identityKeyHandle);
    }
}

