/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.versioning.manager;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import nl.mpi.util.DBConnection;
import nl.mpi.versioning.manager.VersioningAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersioningAPIImpl
implements VersioningAPI {
    private final String versionsTable = "versions";
    private static Logger logger = LoggerFactory.getLogger((String)VersioningAPIImpl.class.getName());
    private DBConnection dbCon = null;
    private boolean writeable = false;
    private PreparedStatement getAllSTM = null;
    private PreparedStatement isRetiredSTM = null;
    private PreparedStatement getTimestampSTM = null;
    private PreparedStatement getPreviousSTM = null;
    private PreparedStatement getNextSTM = null;
    private PreparedStatement setNewerSTM = null;
    private PreparedStatement linkNewerSTM = null;
    private PreparedStatement setOlderSTM = null;
    private PreparedStatement linkOlderSTM = null;
    private PreparedStatement setRetiredSTM = null;
    private PreparedStatement addRetiredSTM = null;

    public VersioningAPIImpl(String jdbcURL) {
        this.dbCon = new DBConnection(jdbcURL, "VersioningAPI/readonly");
        if (!this.prepareStatements(false)) {
            this.close();
        }
    }

    public VersioningAPIImpl(String jdbcURL, String user, String pass) {
        this.dbCon = new DBConnection(jdbcURL, user, pass, "VersioningAPI/writeable");
        if (this.getStatus("open writeable connection")) {
            this.writeable = true;
        }
        this.initDB();
        if (!this.prepareStatements(true)) {
            this.close();
        }
        if (!this.getStatus("verify writeable connection")) {
            this.writeable = false;
        }
    }

    @Override
    public boolean getStatus(String what) {
        if (this.dbCon != null && this.dbCon.getStatus()) {
            return true;
        }
        logger.error("Versioning: DB connection problem in " + what);
        return false;
    }

    @Override
    public void close() {
        if (this.dbCon != null) {
            this.unprepareStatements();
            this.dbCon.close();
        }
        this.dbCon = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.dbCon == null) {
            logger.info("shutdown: DB already closed");
            return;
        }
        logger.info("shutdown called for: " + this.dbCon.toString());
        if (this.dbCon.dbType != 2) {
            logger.info("shutdown: Ignored, no HSQLDB database");
            return;
        }
        if (!this.writeable) {
            logger.error("shutdown: ignored, read-only connection");
            return;
        }
        Statement s = null;
        DBConnection dBConnection = this.dbCon;
        synchronized (dBConnection) {
            try {
                s = this.dbCon.getConnection().createStatement();
                s.execute("SHUTDOWN COMPACT");
            }
            catch (NullPointerException npe) {
                logger.error("shutdown: Null pointer exception: ", (Throwable)npe);
            }
            catch (SQLException sqle) {
                if (sqle.toString().indexOf("is shutdown") != -1) {
                    logger.info("shutdown: database already shutdown");
                } else {
                    logger.error("shutdown: SQLException: " + sqle, (Throwable)sqle);
                }
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (SQLException se) {
                        logger.warn("shutdown: failed to close statement: " + se);
                    }
                }
            }
            this.dbCon.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initDB() {
        if (!this.getStatus("initDB")) {
            return false;
        }
        if (!this.writeable) {
            logger.error("initDB requires write-enabled connection");
            return false;
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            boolean noTable = true;
            statement = this.dbCon.getConnection().createStatement();
            try {
                rs = statement.executeQuery("SELECT count (*)  FROM versions");
                if (rs.next()) {
                    noTable = false;
                }
            }
            catch (SQLException sqle1) {
                logger.warn("initDB: No versionsTable yet, will create one");
            }
            if (noTable) {
                logger.warn("initDB: table is not existing - creating it...");
                statement.execute("CREATE " + this.dbCon.tableType + " TABLE " + "versions" + "( nodeid VARCHAR PRIMARY KEY " + ", olderversion VARCHAR " + ", newerversion VARCHAR " + ", retired BOOLEAN " + ", creation_ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL " + ")");
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException sqle2) {
            logger.error("initDB: SQL exception ", (Throwable)sqle2);
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("initDB: ResultSet close failed");
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.warn("initDB: Statement close failed");
                }
            }
        }
    }

    private boolean prepareStatements(boolean write) {
        try {
            this.getAllSTM = this.dbCon.getConnection().prepareStatement("SELECT nodeid FROM versions WHERE retired=?");
            this.isRetiredSTM = this.dbCon.getConnection().prepareStatement("SELECT retired FROM versions WHERE nodeid=?");
            this.getTimestampSTM = this.dbCon.getConnection().prepareStatement("SELECT creation_ts FROM versions WHERE nodeid=?");
            this.getPreviousSTM = this.dbCon.getConnection().prepareStatement("SELECT olderversion FROM versions WHERE nodeid=?");
            this.getNextSTM = this.dbCon.getConnection().prepareStatement("SELECT newerversion FROM versions WHERE nodeid=?");
            if (!write) {
                return true;
            }
            this.setNewerSTM = this.dbCon.getConnection().prepareStatement("UPDATE versions SET newerversion = ? WHERE nodeid = ?");
            this.linkNewerSTM = this.dbCon.getConnection().prepareStatement("INSERT INTO versions (newerversion, nodeid, olderversion, retired) VALUES (?, ?, null, false)");
            this.setOlderSTM = this.dbCon.getConnection().prepareStatement("UPDATE versions SET olderversion = ? WHERE nodeid = ?");
            this.linkOlderSTM = this.dbCon.getConnection().prepareStatement("INSERT INTO versions (nodeid, olderversion, newerversion, retired) VALUES (?, ?, null, false)");
            this.setRetiredSTM = this.dbCon.getConnection().prepareStatement("UPDATE versions SET retired = ? WHERE nodeid = ?");
            this.addRetiredSTM = this.dbCon.getConnection().prepareStatement("INSERT INTO versions (retired, nodeid, olderversion, newerversion) VALUES (?, ?, null, null)");
            return true;
        }
        catch (SQLException sqle) {
            logger.error("createStatements: SQLException: " + sqle, (Throwable)sqle);
            return false;
        }
    }

    private boolean unprepareStatements() {
        try {
            if (this.getAllSTM != null) {
                this.getAllSTM.close();
            }
            this.getAllSTM = null;
            if (this.isRetiredSTM != null) {
                this.isRetiredSTM.close();
            }
            this.isRetiredSTM = null;
            if (this.getTimestampSTM != null) {
                this.getTimestampSTM.close();
            }
            this.getTimestampSTM = null;
            if (this.getPreviousSTM != null) {
                this.getPreviousSTM.close();
            }
            this.getPreviousSTM = null;
            if (this.getNextSTM != null) {
                this.getNextSTM.close();
            }
            this.getNextSTM = null;
            if (this.setNewerSTM != null) {
                this.setNewerSTM.close();
            }
            this.setNewerSTM = null;
            if (this.linkNewerSTM != null) {
                this.linkNewerSTM.close();
            }
            this.linkNewerSTM = null;
            if (this.setOlderSTM != null) {
                this.setOlderSTM.close();
            }
            this.setOlderSTM = null;
            if (this.linkOlderSTM != null) {
                this.linkOlderSTM.close();
            }
            this.linkOlderSTM = null;
            if (this.setRetiredSTM != null) {
                this.setRetiredSTM.close();
            }
            this.setRetiredSTM = null;
            if (this.addRetiredSTM != null) {
                this.addRetiredSTM.close();
            }
            this.addRetiredSTM = null;
            return true;
        }
        catch (SQLException sqle) {
            logger.error("unprepareStatements: SQLException: " + sqle, (Throwable)sqle);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setVersionSQL(String oldId, String newId, PreparedStatement stm, String what) {
        try {
            PreparedStatement preparedStatement = stm;
            synchronized (preparedStatement) {
                stm.clearParameters();
                stm.setString(1, newId);
                stm.setString(2, oldId);
                int n = stm.executeUpdate();
                if (n == 1) {
                    return true;
                }
                if (n > 1) {
                    logger.warn("setVersionSQL: Unexpected n=" + n + " for " + what + "(" + oldId + ", " + newId + ")");
                }
            }
        }
        catch (SQLException sqle) {
            logger.error("setVersionSQL: SQLException " + sqle + " for " + what + "(" + oldId + ", " + newId + ")", (Throwable)sqle);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFlagSQL(String nodeId, boolean flag, PreparedStatement stm, String what) {
        try {
            PreparedStatement preparedStatement = stm;
            synchronized (preparedStatement) {
                stm.clearParameters();
                stm.setBoolean(1, flag);
                stm.setString(2, nodeId);
                int n = stm.executeUpdate();
                if (n == 1) {
                    return true;
                }
                if (n > 1) {
                    logger.warn("setFlagSQL: Unexpected n=" + n + " for " + what + " at: " + nodeId);
                }
            }
        }
        catch (SQLException sqle) {
            logger.error("setFlagSQL: SQLException " + sqle + " for " + what + " at: " + nodeId, (Throwable)sqle);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringSQL(String nodeId, PreparedStatement stm, String what) {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = stm;
            synchronized (preparedStatement) {
                block19: {
                    stm.clearParameters();
                    stm.setString(1, nodeId);
                    rs = stm.executeQuery();
                    if (!rs.next()) break block19;
                    String string = rs.getString(1);
                    return string;
                }
            }
        }
        catch (SQLException sqle) {
            logger.error("getStringSQL: SQLException " + sqle + " for " + what + " at: " + nodeId, (Throwable)sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("getStringSQL: ResultSet close failed");
                }
            }
        }
        return null;
    }

    private boolean badNodeId(String node, String why) {
        if (node == null) {
            logger.warn("badNodeId null in " + why);
            return true;
        }
        if (node.indexOf(92) != -1) {
            logger.warn("badNodeId with backslash in " + why);
            return true;
        }
        if (node.indexOf(39) != -1) {
            logger.warn("badNodeId with quote in " + why);
            return true;
        }
        return false;
    }

    @Override
    public boolean addNewVersionOf(String oldNodeId, String newNodeId) {
        if (!this.getStatus("addNewVersionOf")) {
            return false;
        }
        if (!this.writeable) {
            logger.error("addNewVersionOf requires write-enabled connection");
            return false;
        }
        if (this.badNodeId(oldNodeId, "addNewVersionOf/1") || this.badNodeId(newNodeId, "addNewVersionOf/2")) {
            return false;
        }
        if (this.getNewerVersion(oldNodeId) != null) {
            return false;
        }
        if (this.getOlderVersion(newNodeId) != null) {
            return false;
        }
        if (oldNodeId.equals(newNodeId)) {
            logger.warn("addNewVersionOf: Link between 2 equal versions ignored: " + newNodeId);
            return true;
        }
        if (!this.setVersionSQL(oldNodeId, newNodeId, this.setNewerSTM, "addNewVersionOf:updateold") && !this.setVersionSQL(oldNodeId, newNodeId, this.linkNewerSTM, "addNewVersionOf:addold")) {
            logger.warn("addNewVersionOf: Failed to link OLD=" + oldNodeId + " new=" + newNodeId);
            return false;
        }
        if (!this.setVersionSQL(newNodeId, oldNodeId, this.setOlderSTM, "addNewVersionOf:updatenew") && !this.setVersionSQL(oldNodeId, newNodeId, this.linkOlderSTM, "addNewVersionOf:addnew")) {
            logger.warn("addNewVersionOf: Failed to link old=" + oldNodeId + " NEW=" + newNodeId);
            return false;
        }
        return true;
    }

    @Override
    public boolean setVersionStatus(String nodeId, boolean retired) {
        if (!this.getStatus("setVersionStatus")) {
            return false;
        }
        if (!this.writeable) {
            logger.error("setVersionStatus requires write-enabled connection");
            return false;
        }
        if (this.badNodeId(nodeId, "setVersionStatus")) {
            return false;
        }
        if (!this.setFlagSQL(nodeId, retired, this.setRetiredSTM, "setVersionStatus/set") && !this.setFlagSQL(nodeId, retired, this.addRetiredSTM, "setVersionStatus/add")) {
            logger.warn("setVersionStatus: Failed to store flag for " + nodeId);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRetired(String nodeId) {
        Object result = null;
        if (this.badNodeId(nodeId, "isRetired")) {
            return true;
        }
        if (!this.getStatus("isRetired")) {
            return true;
        }
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.isRetiredSTM;
            synchronized (preparedStatement) {
                block21: {
                    this.isRetiredSTM.clearParameters();
                    this.isRetiredSTM.setString(1, nodeId);
                    rs = this.isRetiredSTM.executeQuery();
                    if (!rs.next()) break block21;
                    boolean bl = rs.getBoolean(1);
                    return bl;
                }
            }
        }
        catch (SQLException sqle) {
            logger.error("isRetired: SQLException " + sqle + " for node: " + nodeId, (Throwable)sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("isRetired: ResultSet close failed");
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getDateOfVersion(String nodeId) {
        Object result = null;
        if (this.badNodeId(nodeId, "getDateOfVersion")) {
            return null;
        }
        if (!this.getStatus("getDateOfVersion")) {
            return null;
        }
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.isRetiredSTM;
            synchronized (preparedStatement) {
                block21: {
                    this.getTimestampSTM.clearParameters();
                    this.getTimestampSTM.setString(1, nodeId);
                    rs = this.getTimestampSTM.executeQuery();
                    if (!rs.next()) break block21;
                    Timestamp timestamp = rs.getTimestamp(1);
                    return timestamp;
                }
            }
        }
        catch (SQLException sqle) {
            logger.error("getDateOfVersion: SQLException " + sqle + " for node: " + nodeId, (Throwable)sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("getDateOfVersion: ResultSet close failed");
                }
            }
        }
        return null;
    }

    @Override
    public String getOlderVersion(String nodeId) {
        Object result = null;
        if (this.badNodeId(nodeId, "getOlderVersion")) {
            return null;
        }
        if (!this.getStatus("getOlderVersion")) {
            return null;
        }
        return this.getStringSQL(nodeId, this.getPreviousSTM, "getOlderVersion");
    }

    @Override
    public String getNewerVersion(String nodeId) {
        Object result = null;
        if (this.badNodeId(nodeId, "getNewerVersion")) {
            return null;
        }
        if (!this.getStatus("getNewerVersion")) {
            return null;
        }
        return this.getStringSQL(nodeId, this.getNextSTM, "getNewerVersion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector listAllVersions(boolean retired) {
        ResultSet rs = null;
        Vector<String> results = new Vector<String>();
        try {
            PreparedStatement preparedStatement = this.getAllSTM;
            synchronized (preparedStatement) {
                this.getAllSTM.clearParameters();
                this.getAllSTM.setBoolean(1, retired);
                rs = this.getAllSTM.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(1));
                }
            }
        }
        catch (SQLException sqle) {
            logger.error("listAllVersions: SQLException " + sqle, (Throwable)sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("listAllVersions: ResultSet close failed");
                }
            }
        }
        return results;
    }

    @Override
    public String getNewestVersion(String nodeId) {
        if (!this.getStatus("getNewestVersion")) {
            return nodeId;
        }
        String node = nodeId;
        String newNode;
        while ((newNode = this.getNewerVersion(node)) != null) {
            node = newNode;
        }
        return node;
    }

    @Override
    public String getOldestVersion(String nodeId) {
        if (!this.getStatus("getOldestVersion")) {
            return nodeId;
        }
        String node = nodeId;
        String oldNode;
        while ((oldNode = this.getOlderVersion(node)) != null) {
            node = oldNode;
        }
        return node;
    }

    @Override
    public Vector getAllVersions(String nodeId, boolean showRetired) {
        Vector<String> result = new Vector<String>();
        if (!this.getStatus("getAllVersions")) {
            return result;
        }
        String where = this.getOldestVersion(nodeId);
        if (showRetired || !this.isRetired(where)) {
            result.add(where);
        }
        while ((where = this.getNewerVersion(where)) != null) {
            if (!showRetired && this.isRetired(where)) continue;
            result.add(where);
        }
        return result;
    }
}

