/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import nl.nikhef.slcshttps.crypto.CryptoSSL;
import nl.nikhef.slcshttps.crypto.CryptoStore;
import nl.nikhef.slcshttps.trust.HttxURLConnection;
import nl.nikhef.slcshttps.trust.TrustManagerImpl;

public abstract class CAHttps {
    private static SSLSocketFactory defaultHttpsSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
    private static SSLSocketFactory defaultHttxSSLSocketFactory = HttxURLConnection.getDefaultSSLSocketFactory();
    private static BigInteger CAHttpsCertNo = null;
    private static BigInteger CAHttxCertNo = null;
    public static final String HTTPS_PROP = "nl.nikhef.slcshttps.https";
    private static boolean useHttps;
    private static boolean useHttx;
    private static boolean maskHttps;
    public static final String SUCCESS_PROP = "nl.nikhef.slcshttps.acknowledge";
    static boolean showSuccess;
    CryptoStore cryptoStore;

    public abstract void initialize(String var1) throws IOException;

    public abstract void storeCertificate(String var1) throws IOException, CertificateException, KeyStoreException, KeyManagementException;

    public CAHttps() throws KeyStoreException {
        this(null, null, null, true);
    }

    public CAHttps(boolean bl) throws KeyStoreException {
        this(null, null, null, bl);
    }

    public CAHttps(PrintStream printStream, PrintStream printStream2, InputStream inputStream) throws KeyStoreException {
        this(printStream, printStream2, inputStream, true);
    }

    public CAHttps(PrintStream printStream, PrintStream printStream2, InputStream inputStream, boolean bl) throws KeyStoreException {
        if (printStream != null) {
            try {
                System.setErr(printStream);
            }
            catch (SecurityException securityException) {
                System.err.println("Cannot change errorstream, I/O will go to stderr");
            }
        }
        if (inputStream != null) {
            try {
                System.setIn(inputStream);
            }
            catch (SecurityException securityException) {
                System.err.println("Cannot change inputstream, I/O will come from stdin");
            }
        }
        if (printStream2 != null) {
            try {
                System.setOut(printStream2);
            }
            catch (SecurityException securityException) {
                System.err.println("Cannot change outputstream, I/O will go to stdout");
            }
        }
        try {
            this.cryptoStore = new CryptoStore();
        }
        catch (Exception exception) {
            throw new KeyStoreException("Cannot initialize CryptoStore object: " + exception.getMessage());
        }
        if (bl) {
            try {
                this.cryptoStore.CSRinit();
            }
            catch (SignatureException signatureException) {
                throw new KeyStoreException("Cannot create CSR in CryptoStore: " + signatureException.getMessage());
            }
        }
    }

    public X509Certificate getCertificate() throws KeyStoreException {
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = this.cryptoStore.getCertificate();
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreException("Cannot retrieve certificate: " + keyStoreException.getMessage());
        }
        return x509Certificate;
    }

    public void setHttpsSSLSocketFactory() throws KeyStoreException, KeyManagementException {
        SSLSocketFactory sSLSocketFactory;
        try {
            CryptoSSL cryptoSSL = new CryptoSSL(this.cryptoStore);
            sSLSocketFactory = cryptoSSL.getSSLSocketFactory();
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreException("Cannot get needed KeyManager: " + keyStoreException.getMessage());
        }
        catch (KeyManagementException keyManagementException) {
            throw new KeyManagementException("Cannot get SSLSocketFactory: " + keyManagementException.getMessage());
        }
        try {
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
            CAHttpsCertNo = this.cryptoStore.getCertificate().getSerialNumber();
        }
        catch (Exception exception) {
            throw new KeyManagementException("Cannot change default SSLSocketFactory for Https: " + exception.getMessage());
        }
    }

    public void resetHttpsSSLSocketFactory() throws KeyManagementException {
        try {
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultHttpsSSLSocketFactory);
            CAHttpsCertNo = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new KeyManagementException("Cannot restore defaultHttpsSSLSocketFactory, not defined: " + illegalArgumentException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new SecurityException("No permission to restore defaultHttpsSSLSocketFactory: " + securityException.getMessage());
        }
        catch (Exception exception) {
            throw new KeyManagementException("Error setting defaultHttpsSSLSocketFactory: " + exception.getMessage());
        }
    }

    public void setHttxSSLSocketFactory() throws KeyStoreException, KeyManagementException {
        SSLSocketFactory sSLSocketFactory;
        try {
            CryptoSSL cryptoSSL = new CryptoSSL(this.cryptoStore, new TrustManagerImpl());
            sSLSocketFactory = cryptoSSL.getSSLSocketFactory();
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreException("Cannot get needed Key- or TrustManager: " + keyStoreException.getMessage());
        }
        catch (KeyManagementException keyManagementException) {
            throw new KeyManagementException("Cannot get SSLSocketFactory: " + keyManagementException.getMessage());
        }
        try {
            HttxURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
            X509Certificate x509Certificate = this.cryptoStore.getCertificate();
            HttxURLConnection.setClientExpireDate(x509Certificate.getNotAfter());
            CAHttxCertNo = x509Certificate.getSerialNumber();
        }
        catch (Exception exception) {
            throw new KeyManagementException("Cannot change default SSLSocketFactory for HttxURLConnection: " + exception.getMessage());
        }
    }

    public void resetHttxSSLSocketFactory() throws KeyManagementException {
        try {
            HttxURLConnection.setDefaultSSLSocketFactory(defaultHttxSSLSocketFactory);
            HttxURLConnection.setClientExpireDate(null);
            CAHttxCertNo = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new KeyManagementException("defaultHttxSSLSocketFactory is not defined, cannot reset: " + illegalArgumentException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new SecurityException("No permission to restore defaultHttxSSLSocketFactory: " + securityException.getMessage());
        }
        catch (Exception exception) {
            throw new KeyManagementException("Error setting defaultHttxSSLSocketFactory: " + exception.getMessage());
        }
    }

    public void setSSLSocketFactory() throws KeyStoreException, KeyManagementException {
        if (useHttps) {
            this.setHttpsSSLSocketFactory();
        }
        if (useHttx) {
            this.setHttxSSLSocketFactory();
        }
    }

    public void resetSSLSocketFactory() throws KeyManagementException {
        if (useHttps) {
            this.resetHttpsSSLSocketFactory();
        }
        if (useHttx) {
            this.resetHttxSSLSocketFactory();
        }
    }

    public BigInteger getCAHttpsCertNo() {
        return CAHttpsCertNo;
    }

    public BigInteger getCAHttxCertNo() {
        return CAHttxCertNo;
    }

    public static String getSerialString(BigInteger bigInteger) {
        if (bigInteger != null) {
            String string = bigInteger.toString(16);
            int n = string.length() - 1;
            int n2 = n + n / 2;
            char[] cArray = new char[n2 + 1];
            for (int i = 0; i <= n; ++i) {
                cArray[n2--] = string.charAt(n - i);
                if (i >> 1 << 1 == i || i >= n) continue;
                cArray[n2--] = 58;
            }
            String string2 = new String(cArray);
            return string2;
        }
        return "none";
    }

    public boolean getMaskHttps() {
        return maskHttps;
    }

    public boolean getUseHttps() {
        return useHttps;
    }

    public boolean getUseHttx() {
        return useHttx;
    }

    public static void setShowSuccess(boolean bl) {
        showSuccess = bl;
    }

    public static boolean getShowSuccess() {
        return showSuccess;
    }

    static {
        String string = System.getProperty(HTTPS_PROP);
        if (string == null) {
            string = "mask";
        }
        if (string.equals("https")) {
            useHttps = true;
            useHttx = false;
            maskHttps = false;
        } else if (string.equals("httx")) {
            useHttps = false;
            useHttx = true;
            maskHttps = false;
        } else if (string.equals("both")) {
            useHttps = true;
            useHttx = true;
            maskHttps = false;
        } else if (string.equals("mask")) {
            useHttps = true;
            useHttx = true;
            maskHttps = true;
        }
        string = System.getProperty(SUCCESS_PROP);
        showSuccess = string == null || !"false".equals(string);
    }
}

