/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Whitespace;

public class Tokenize_1
extends SystemFunction {
    private static RegularExpression WHITESPACE_SEP;

    public static SequenceIterator splitOnWhitespace(CharSequence input) {
        if ((input = Whitespace.collapseWhitespace(input)).length() == 0) {
            return EmptyIterator.emptyIterator();
        }
        return WHITESPACE_SEP.tokenize(input);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        AtomicValue sv = (AtomicValue)arguments[0].head();
        if (sv == null) {
            return EmptySequence.getInstance();
        }
        CharSequence input = sv.getStringValueCS();
        return SequenceTool.toLazySequence(Tokenize_1.splitOnWhitespace(input));
    }

    static {
        try {
            WHITESPACE_SEP = new ARegularExpression(" ", "", "XP30", new ArrayList<String>());
        }
        catch (XPathException e) {
            throw new AssertionError((Object)e);
        }
    }
}

