/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.archiving.corpusstructure.core;

import java.util.ArrayList;
import java.util.List;

public enum CorpusNodeType {
    METADATA(1),
    COLLECTION(2),
    RESOURCE_VIDEO(3),
    RESOURCE_AUDIO(4),
    RESOURCE_LEXICAL(5),
    RESOURCE_ANNOTATION(6),
    RESOURCE_OTHER(7),
    IMDICATALOGUE(8),
    IMDIINFO(9),
    UNKOWN(10),
    RESOURCE_IMAGE(11);

    private final int numericalRepresentation;

    private CorpusNodeType(int numericalRepresentation) {
        this.numericalRepresentation = numericalRepresentation;
    }

    public static CorpusNodeType valueOfMimeType(String mimetype) {
        CorpusNodeType nodeType = null;
        nodeType = mimetype == null ? UNKOWN : (mimetype.equals("application/imdi") ? METADATA : (mimetype.equals("application/cmdi") ? METADATA : (mimetype.startsWith("text/") ? (mimetype.equals("text/praat-textgrid") ? RESOURCE_ANNOTATION : RESOURCE_OTHER) : (mimetype.startsWith("audio/") ? RESOURCE_AUDIO : (mimetype.startsWith("video/") ? RESOURCE_VIDEO : (mimetype.startsWith("image/") ? RESOURCE_IMAGE : RESOURCE_OTHER))))));
        return nodeType;
    }

    public static CorpusNodeType valueOf(Integer type) {
        CorpusNodeType nodeType = null;
        switch (type) {
            case 1: {
                nodeType = METADATA;
                break;
            }
            case 2: {
                nodeType = COLLECTION;
                break;
            }
            case 3: {
                nodeType = RESOURCE_VIDEO;
                break;
            }
            case 4: {
                nodeType = RESOURCE_AUDIO;
                break;
            }
            case 5: {
                nodeType = RESOURCE_LEXICAL;
                break;
            }
            case 6: {
                nodeType = RESOURCE_ANNOTATION;
                break;
            }
            case 7: {
                nodeType = RESOURCE_OTHER;
                break;
            }
            case 8: {
                nodeType = IMDICATALOGUE;
                break;
            }
            case 9: {
                nodeType = IMDIINFO;
            }
        }
        return nodeType;
    }

    public static List<CorpusNodeType> getAllResourceTypes() {
        ArrayList<CorpusNodeType> resourceTypes = new ArrayList<CorpusNodeType>();
        resourceTypes.add(RESOURCE_ANNOTATION);
        resourceTypes.add(RESOURCE_AUDIO);
        resourceTypes.add(RESOURCE_IMAGE);
        resourceTypes.add(RESOURCE_VIDEO);
        resourceTypes.add(RESOURCE_LEXICAL);
        resourceTypes.add(RESOURCE_OTHER);
        return resourceTypes;
    }

    public int getNumericalRepresentation() {
        return this.numericalRepresentation;
    }
}

