/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.border.EtchedBorder;
import net.handle.apps.gui.hadmin.HandleAdminJPanel;
import net.handle.apps.gui.hadmin.HandleTool;
import net.handle.apps.gui.jwidget.HandleValueListJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Util;

public class RemoveHandleJPanel
extends HandleAdminJPanel
implements ActionListener {
    protected RemoveDataList dataList;

    public RemoveHandleJPanel() {
        this(new HandleTool());
    }

    public RemoveHandleJPanel(HandleTool tool) {
        super(tool);
        GridBagLayout gridbag = new GridBagLayout();
        EtchedBorder etchBorder = new EtchedBorder();
        boolean x = false;
        boolean y = false;
        this.dataList = new RemoveDataList();
        this.dataPanel.add((Component)this.dataList, AwtUtil.getConstraints(0, 1, 1.0, 1.0, 1, 1, true, true));
        this.submitButton.setText("Remove");
        this.submitButton.setActionCommand("Remove");
        this.submitButton.addActionListener(this);
        this.upPanel.add((Component)this.handlePanel, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 2, 3, new Insets(5, 5, 5, 5), 17, false, true));
    }

    public void actionPerformed(ActionEvent ae) {
        String choice = ae.getActionCommand();
        if (ae.getSource() == this.nameField) {
            this.fetchHandleValues(this.tool.getAuthentication());
        } else if (choice.equals("Remove")) {
            this.submitRemove();
        }
    }

    private void submitRemove() {
        this.handleName = this.nameField.getText().trim();
        if (this.handleName == null || this.handleName.length() <= 0 || this.handleName.indexOf(47) <= 0) {
            this.warn("Invalid handle name, re-enter please ");
            this.nameField.requestFocus();
            return;
        }
        if (1 == JOptionPane.showConfirmDialog(this, "Remove this handle from service?", "Remove: ", 0, -1)) {
            return;
        }
        AuthenticationInfo authInfo = this.tool.getAuthentication();
        if (authInfo == null) {
            return;
        }
        DeleteHandleRequest req = new DeleteHandleRequest(Util.encodeString(this.handleName), authInfo);
        try {
            AbstractResponse resp = this.tool.processRequest(this, req, "Removing handle ...");
            if (resp == null) {
                this.warn("Can not process this request");
                return;
            }
            if (resp.responseCode != 1) {
                this.info("Response: Handle removal failed \n" + resp);
                if (resp.responseCode == 403 || resp.responseCode == 402 || resp.responseCode == 400) {
                    this.tool.changeAuthentication();
                }
                return;
            }
            this.info("Response: Handle removed successfully \n" + resp);
            this.dataList.clearAll();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.warn("Unexpected Exception " + e.getMessage());
        }
    }

    public void fetchHandleValues(AuthenticationInfo authInfo) {
        this.dataList.clearAll();
        this.handleName = this.nameField.getText().trim();
        if (this.handleName == null || this.handleName.length() <= 0 || this.handleName.indexOf(47) <= 0) {
            this.warn("Invalid handle name, re-enter please");
            this.nameField.requestFocus();
            return;
        }
        byte[] handlebytes = Util.encodeString(this.handleName);
        ResolutionRequest queryReq = null;
        AbstractResponse response = null;
        try {
            if (authInfo == null) {
                queryReq = new ResolutionRequest(handlebytes, null, null, authInfo);
                queryReq.ignoreRestrictedValues = true;
                queryReq.certify = true;
                this.warn("Retrieving handle values without restricted data");
            } else {
                queryReq = new ResolutionRequest(handlebytes, null, null, authInfo);
                queryReq.authoritative = true;
                queryReq.ignoreRestrictedValues = false;
                queryReq.certify = true;
            }
            response = this.tool.resolver.processRequest(queryReq);
            if (!(response instanceof ResolutionResponse) && authInfo != null) {
                this.warn("Unable to resolve the handle, illegal authentication\nRetrieving handle values without restricted data");
                queryReq = new ResolutionRequest(handlebytes, null, null, authInfo);
                queryReq.ignoreRestrictedValues = true;
                queryReq.certify = true;
                response = this.tool.resolver.processRequest(queryReq);
                if (response == null) {
                    this.warn("There was an error processing your request");
                    return;
                }
            }
            if (!(response instanceof ResolutionResponse)) {
                this.warn("Unable to retrieve handle:  \n" + response);
                return;
            }
            HandleValue[] values = ((ResolutionResponse)response).getHandleValues();
            if (values == null) {
                return;
            }
            for (int i = 0; i < values.length; ++i) {
                this.dataList.appendItem(values[i]);
            }
        }
        catch (Exception e) {
            this.warn("Unable to retrieve handle:\n" + e.getMessage());
            return;
        }
    }

    protected class RemoveDataList
    extends HandleValueListJPanel {
        protected RemoveDataList() {
            this.add((Component)this.pane, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 2, 10, true, true));
        }
    }
}

