/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Hashtable;
import net.handle.hdllib.MessageEnvelope;
import net.handle.server.HdlUdpPendingRequest;
import net.handle.server.HdlUdpRequestHandler;
import net.handle.server.Main;
import net.handle.server.NetworkInterface;
import net.handle.server.RequestHandlerPool;

public class HdlUdpInterface
extends NetworkInterface {
    private InetAddress bindAddress;
    private int threadLife = 500;
    private int bindPort;
    private int numThreads = 10;
    private int maxHandlers = 200;
    private boolean logAccesses = false;
    private boolean trackThreads = false;
    private DatagramSocket dsocket = null;
    private boolean keepServing = true;
    private Hashtable pendingRequests = new Hashtable();

    public HdlUdpInterface(Main main, Hashtable config) throws Exception {
        super(main);
        this.init(config);
    }

    private void init(Hashtable config) throws Exception {
        Object bindAddressStr = config.get("bind_address");
        this.bindAddress = bindAddressStr == null ? null : InetAddress.getByName(String.valueOf(bindAddressStr));
        this.bindPort = Integer.parseInt((String)config.get("bind_port"));
        try {
            this.numThreads = Integer.parseInt((String)config.get("num_threads"));
        }
        catch (Exception e) {
            this.main.logError(50, "unspecified thread count, using default: " + this.numThreads);
        }
        try {
            this.maxHandlers = Integer.parseInt((String)config.get("max_handlers"));
        }
        catch (Exception e) {
            this.main.logError(50, "unspecified max_handlers count, using default: " + this.maxHandlers);
        }
        try {
            if (config.containsKey("thread_life")) {
                this.threadLife = Integer.parseInt((String)config.get("thread_life"));
            }
        }
        catch (Exception e) {
            this.main.logError(50, "Invalid thread life, using default: " + this.threadLife);
        }
        this.trackThreads = config.containsKey("track_threads") && "yes".equals(config.get("track_threads"));
        this.logAccesses = config.containsKey("log_accesses") && "yes".equals(config.get("log_accesses"));
    }

    protected void stopService() {
        this.keepServing = false;
        try {
            this.dsocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void serveRequests() {
        try {
            this.dsocket = this.bindAddress == null ? new DatagramSocket(this.bindPort) : new DatagramSocket(this.bindPort, this.bindAddress);
        }
        catch (Exception e) {
            this.main.logError(100, String.valueOf(this.getClass()) + ": Error setting up server socket: " + e);
            return;
        }
        System.out.println("UDP handle Request Listener:");
        System.out.println("   address: " + (this.bindAddress == null ? "ANY" : "" + this.bindAddress));
        System.out.println("      port: " + this.bindPort);
        RequestHandlerPool handlerPool = new RequestHandlerPool(this.trackThreads ? "UDP" : null);
        handlerPool.setHandlerLife(this.threadLife);
        handlerPool.setMaxPossibleHandlers(this.maxHandlers);
        System.out.print("Starting UDP request handlers: ");
        for (int threadNum = 0; threadNum < this.numThreads; ++threadNum) {
            System.out.print('.');
            handlerPool.addHandler(new HdlUdpRequestHandler(this.main, this.dsocket, handlerPool, this, this.logAccesses));
        }
        System.out.println("");
        try {
            System.out.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        long reqCount = 0L;
        long recvTime = 0L;
        while (this.keepServing) {
            try {
                DatagramPacket dPacket = new DatagramPacket(new byte[512], 512);
                this.dsocket.receive(dPacket);
                recvTime = System.currentTimeMillis();
                ((HdlUdpRequestHandler)handlerPool.getHandler()).serviceRequest(dPacket, recvTime);
                if (++reqCount <= 1000L) continue;
                this.needsGC = true;
                reqCount = 0L;
            }
            catch (Exception e) {
                this.main.logError(75, "" + this.getClass() + ": Error handling request: " + e);
                e.printStackTrace(System.err);
            }
        }
        try {
            this.dsocket.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdlUdpPendingRequest addMultiPacketListener(MessageEnvelope env, DatagramPacket pkt, InetAddress addr, HdlUdpRequestHandler handler) {
        String id = HdlUdpPendingRequest.getRequestId(addr, env.requestId);
        HdlUdpPendingRequest req = null;
        boolean isFirstPacket = false;
        Object object = this.pendingRequests;
        synchronized (object) {
            req = (HdlUdpPendingRequest)this.pendingRequests.get(id);
            if (req != null) {
                req.addPacket(env, pkt);
                if (req.isComplete()) {
                    HdlUdpPendingRequest hdlUdpPendingRequest = req;
                    synchronized (hdlUdpPendingRequest) {
                        req.notifyAll();
                    }
                }
                return null;
            }
            req = new HdlUdpPendingRequest(id, env, pkt, handler);
            this.pendingRequests.put(id, req);
            isFirstPacket = true;
        }
        if (!isFirstPacket) {
            return null;
        }
        object = req;
        synchronized (object) {
            try {
                req.wait(5000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.pendingRequests.remove(req.idString);
        }
        if (!req.isComplete()) {
            return null;
        }
        return req;
    }
}

