/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdidb;

import nl.mpi.imdidb.IMDIDB;
import nl.mpi.util.DBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBImpl {
    private static final Object staticSyncFlag = new Object();
    private static boolean checkedDB = false;
    private boolean status = false;
    protected final DBConnection db;
    private static Logger logger = LoggerFactory.getLogger((String)IMDIDB.class.getName());

    protected DBImpl(DBConnection databaseConnection) {
        this.db = databaseConnection;
    }

    public static void setLogger(Logger l) {
        logger = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        Object object = staticSyncFlag;
        synchronized (object) {
            if (!this.db.getStatus()) {
                logger.error("DBImpl: init() ERROR status = false");
                this.setStatus(false);
                return false;
            }
            return this.createTables();
            {
            }
        }
    }

    public void reset() {
        this.dropOldIndexes();
        this.dropOldTables();
    }

    public abstract void shutdown();

    public synchronized void close() {
        this.closePreparedStatements();
        if (this.db != null) {
            this.db.close();
        }
    }

    protected abstract boolean createTables();

    protected abstract boolean createIndexes();

    protected abstract void dropOldTables();

    protected abstract void dropOldIndexes();

    protected abstract boolean initPreparedStatements();

    protected abstract void closePreparedStatements();

    public synchronized boolean getStatus() {
        return this.status;
    }

    protected synchronized void setStatus(boolean st) {
        this.status = st;
    }
}

