/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.dom;

import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import nl.mpi.metadata.api.MetadataDocumentException;
import nl.mpi.metadata.api.dom.MetadataDOMBuilder;
import nl.mpi.metadata.api.dom.MetadataDocumentWriter;
import nl.mpi.metadata.cmdi.api.model.CMDIDocument;
import org.w3c.dom.Document;

public class CMDIDocumentWriter
implements MetadataDocumentWriter<CMDIDocument> {
    private MetadataDOMBuilder<CMDIDocument> domBuilder;
    private Properties outputProperties;

    public CMDIDocumentWriter(MetadataDOMBuilder<CMDIDocument> domWriter) {
        this.domBuilder = domWriter;
    }

    @Override
    public void write(CMDIDocument metadataDocument, Result outputResult) throws MetadataDocumentException, TransformerException {
        Document dom = this.domBuilder.buildDomForDocument(metadataDocument);
        DOMSource source = new DOMSource(dom);
        Transformer transformer = this.getNewTransformer();
        transformer.transform(source, outputResult);
    }

    protected Transformer getNewTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (this.getOutputProperties() != null) {
            transformer.setOutputProperties(this.getOutputProperties());
        }
        return transformer;
    }

    public final Properties getOutputProperties() {
        return this.outputProperties;
    }

    public final void setOutputProperties(Properties outputProperties) {
        this.outputProperties = outputProperties;
    }
}

