/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.dom;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import nl.mpi.metadata.api.MetadataDocumentException;
import nl.mpi.metadata.api.MetadataException;
import nl.mpi.metadata.cmdi.api.model.CMDIDocument;
import nl.mpi.metadata.cmdi.api.model.DataResourceProxy;
import nl.mpi.metadata.cmdi.api.model.MetadataResourceProxy;
import nl.mpi.metadata.cmdi.api.model.ResourceProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMDIResourceProxyReader {
    private static final Logger logger = LoggerFactory.getLogger(CMDIResourceProxyReader.class);

    public void readResourceProxies(CMDIDocument cmdiDocument, Document domDocument, XPath xPath) throws DOMException, MetadataException {
        try {
            NodeList resourceProxyNodes = (NodeList)xPath.evaluate("/cmd:CMD/cmd:Resources/cmd:ResourceProxyList/cmd:ResourceProxy", domDocument, XPathConstants.NODESET);
            int resourceProxyNodesCount = resourceProxyNodes.getLength();
            logger.debug("Found {} resource proxy nodes in {}", (Object)resourceProxyNodesCount, (Object)cmdiDocument);
            for (int i = 0; i < resourceProxyNodesCount; ++i) {
                logger.debug("Reading resource proxy {}/{} in {}", new Object[]{i + 1, resourceProxyNodesCount, cmdiDocument});
                Node proxyNode = resourceProxyNodes.item(i);
                try {
                    ResourceProxy resourceProxy = this.createResourceProxy(cmdiDocument, proxyNode, xPath);
                    cmdiDocument.addDocumentResourceProxy(resourceProxy);
                    continue;
                }
                catch (MetadataException mEx) {
                    logger.warn("Skipping resource proxy due to error. See exception for details.", (Throwable)mEx);
                }
            }
        }
        catch (XPathExpressionException ex) {
            throw new MetadataDocumentException(cmdiDocument, "XPathExpressionException while reading resource proxies from CMDI document", ex);
        }
    }

    protected ResourceProxy createResourceProxy(CMDIDocument cmdiDocument, Node proxyNode, XPath xPath) throws DOMException, MetadataException, XPathExpressionException {
        Node resourceTypeNode = this.getResourceTypeNode(proxyNode, xPath);
        String resourceType = resourceTypeNode.getTextContent();
        Node resourceRefNode = this.getResourceRefNode(xPath, proxyNode);
        String id = this.getResourceProxyId(proxyNode);
        URI resourceRef = this.getResourceRef(resourceRefNode, xPath);
        URI location = this.getFileLocation(resourceRefNode);
        String type = resourceTypeNode.getTextContent();
        String mimeType = this.getResourceProxyMimeType(resourceTypeNode);
        if ("Metadata".equals(resourceType)) {
            return new MetadataResourceProxy(id, resourceRef, location, mimeType);
        }
        return new DataResourceProxy(id, resourceRef, location, type, mimeType);
    }

    private Node getResourceTypeNode(Node proxyNode, XPath xPath) throws XPathExpressionException, MetadataException {
        Node resourceTypeNode = (Node)xPath.evaluate("./cmd:ResourceType", proxyNode, XPathConstants.NODE);
        if (resourceTypeNode != null) {
            return resourceTypeNode;
        }
        throw new MetadataException("Encountered resource proxy without ResourceType");
    }

    private Node getResourceRefNode(XPath xPath, Node proxyNode) throws XPathExpressionException, MetadataException {
        Node resourceRefNode = (Node)xPath.evaluate("./cmd:ResourceRef", proxyNode, XPathConstants.NODE);
        if (resourceRefNode != null) {
            return resourceRefNode;
        }
        throw new MetadataException("Encountered resource proxy without ResourceRef");
    }

    private String getResourceProxyId(Node proxyNode) throws DOMException, MetadataException {
        Node idAttr = proxyNode.getAttributes().getNamedItem("id");
        if (idAttr instanceof Attr) {
            return idAttr.getNodeValue();
        }
        throw new MetadataException("Encountered resource proxy without id");
    }

    private URI getResourceRef(Node resourceRefNode, XPath xPath) throws MetadataException, XPathExpressionException, DOMException {
        String resourceRef = resourceRefNode.getTextContent();
        try {
            return new URI(resourceRef);
        }
        catch (URISyntaxException usEx) {
            throw new MetadataException("URI syntax exception in ResourceRef of resource proxy", usEx);
        }
    }

    private URI getFileLocation(Node resourceRefNode) throws XPathExpressionException, MetadataException {
        Node locationAttribute = resourceRefNode.getAttributes().getNamedItemNS("http://lat.mpi.nl/", "localURI");
        if (locationAttribute == null) {
            logger.debug("No location attribute on resource proxy {}", (Object)resourceRefNode);
            return null;
        }
        try {
            return new URI(locationAttribute.getNodeValue());
        }
        catch (URISyntaxException ex) {
            logger.warn("Failed to create URL for {}", (Object)locationAttribute.getNodeValue());
            throw new MetadataException("URI syntax exception in ResourceRef location attribute", ex);
        }
    }

    private String getResourceProxyMimeType(Node resourceTypeNode) throws DOMException {
        Node mimeTypeAttrNode = resourceTypeNode.getAttributes().getNamedItem("mimetype");
        if (mimeTypeAttrNode instanceof Attr) {
            return mimeTypeAttrNode.getNodeValue();
        }
        return null;
    }
}

