/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.model.impl;

import java.util.List;
import nl.mpi.metadata.api.model.MetadataElement;
import nl.mpi.metadata.api.type.MetadataElementType;
import nl.mpi.metadata.cmdi.api.model.impl.DisplayValueStrategy;
import nl.mpi.metadata.cmdi.api.type.ComponentType;
import nl.mpi.metadata.cmdi.api.type.ElementType;

public class DefaultDisplayValueStrategy
implements DisplayValueStrategy {
    @Override
    public String getDisplayValue(List<MetadataElement> children, MetadataElement element) {
        boolean component = element.getType() instanceof ComponentType;
        String displayValue = this.getDisplayNameFromElementType(children, component);
        if (displayValue != null) {
            return displayValue;
        }
        displayValue = this.getDisplayNameFromFirstComponentType(children);
        if (displayValue != null) {
            return displayValue;
        }
        return element.getName();
    }

    protected String getDisplayNameFromElementType(List<MetadataElement> children, boolean component) {
        int minPriority = 0;
        String displayValue = null;
        for (MetadataElement child : children) {
            int childPriority;
            String childDisplayValue;
            MetadataElementType type = child.getType();
            if (!(type instanceof ElementType) || null == (childDisplayValue = child.getDisplayValue()) || "".equals(childDisplayValue) || (childPriority = ((ElementType)child.getType()).getDisplayPriority()) <= 0 || minPriority != 0 && minPriority <= childPriority) continue;
            minPriority = childPriority;
            displayValue = childDisplayValue;
        }
        return displayValue;
    }

    protected String getDisplayNameFromFirstComponentType(List<MetadataElement> children) {
        String displayValue = null;
        for (MetadataElement child : children) {
            MetadataElementType type = child.getType();
            if (!(type instanceof ComponentType)) continue;
            displayValue = child.getDisplayValue();
            break;
        }
        return displayValue;
    }
}

