/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.table.TableColumn;
import nl.mpi.arbil.ui.ArbilFieldViews;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.TableController;
import nl.mpi.arbil.util.BugCatcherManager;

public class TableHeaderContextMenu
extends JPopupMenu {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus");
    private final ArbilTable table;
    private final ArbilTableModel tableModel;
    private final TableController tableController;

    public TableHeaderContextMenu(TableController tableController, ArbilTable table, int targetColumn) {
        this.table = table;
        this.tableModel = table.getArbilTableModel();
        this.tableController = tableController;
        this.initMenuItems(targetColumn);
    }

    private void initMenuItems(final int targetColumn) {
        final String targetColumnName = this.tableModel.getColumnName(targetColumn);
        JMenuItem saveViewMenuItem = new JMenuItem(menus.getString("SAVE CURRENT COLUMN VIEW"));
        saveViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableHeaderContextMenu.this.tableController.saveCurrentColumnView(TableHeaderContextMenu.this.table);
            }
        });
        JMenuItem editViewMenuItem = new JMenuItem(menus.getString("EDIT THIS COLUMN VIEW"));
        editViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableHeaderContextMenu.this.tableController.showColumnViewsEditor(TableHeaderContextMenu.this.table);
            }
        });
        JMenuItem showOnlyCurrentViewMenuItem = new JMenuItem(menus.getString("LIMIT VIEW TO CURRENT COLUMNS"));
        showOnlyCurrentViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TableHeaderContextMenu.this.tableModel.showOnlyCurrentColumns();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        JMenu fieldViewsMenuItem = new JMenu(menus.getString("COLUMN VIEW FOR THIS TABLE"));
        ButtonGroup viewMenuButtonGroup = new ButtonGroup();
        Enumeration savedViewsEnum = ArbilFieldViews.getSingleInstance().getSavedFieldViewLables();
        while (savedViewsEnum.hasMoreElements()) {
            String currentViewLabel = savedViewsEnum.nextElement().toString();
            JMenuItem viewLabelMenuItem = new JMenuItem();
            viewMenuButtonGroup.add(viewLabelMenuItem);
            viewLabelMenuItem.setText(currentViewLabel);
            viewLabelMenuItem.setName(currentViewLabel);
            viewLabelMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        TableHeaderContextMenu.this.tableModel.setCurrentView(ArbilFieldViews.getSingleInstance().getView(((Component)evt.getSource()).getName()));
                        TableHeaderContextMenu.this.table.doResizeColumns();
                    }
                    catch (Exception ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
            });
            fieldViewsMenuItem.add(viewLabelMenuItem);
        }
        JMenuItem setAllColumnsSizeFromColumn = new JMenuItem(MessageFormat.format(menus.getString("MAKE ALL COLUMNS THE SIZE OF"), targetColumnName));
        setAllColumnsSizeFromColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int targetWidth = TableHeaderContextMenu.this.table.getColumnModel().getColumn(targetColumn).getWidth();
                for (int i = 0; i < TableHeaderContextMenu.this.table.getColumnCount(); ++i) {
                    TableColumn column = TableHeaderContextMenu.this.table.getColumnModel().getColumn(i);
                    TableHeaderContextMenu.this.tableModel.getFieldView().setColumnWidth(column.getHeaderValue().toString(), targetWidth);
                }
                TableHeaderContextMenu.this.table.doResizeColumns();
            }
        });
        JMenuItem setAllColumnsSizeAuto = new JMenuItem(menus.getString("MAKE ALL COLUMNS FIT CONTENTS"));
        setAllColumnsSizeAuto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableHeaderContextMenu.this.tableModel.getFieldView().resetColumnWidths();
                TableHeaderContextMenu.this.table.doResizeColumns();
            }
        });
        JMenuItem setColumnSizeAuto = new JMenuItem(menus.getString("MAKE COLUMN FIT CONTENTS"));
        setColumnSizeAuto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableHeaderContextMenu.this.tableModel.getFieldView().setColumnWidth(targetColumnName, null);
                TableHeaderContextMenu.this.table.doResizeColumns(Arrays.asList(targetColumn));
            }
        });
        final JCheckBoxMenuItem setFixedColumnSize = new JCheckBoxMenuItem(menus.getString("FIXED COLUMN SIZE"));
        setFixedColumnSize.setSelected(this.tableModel.getPreferredColumnWidth(targetColumnName) != null);
        setFixedColumnSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableHeaderContextMenu.this.tableModel.getFieldView().setColumnWidth(targetColumnName, setFixedColumnSize.isSelected() ? Integer.valueOf(TableHeaderContextMenu.this.table.getColumnModel().getColumn(targetColumn).getWidth()) : null);
                TableHeaderContextMenu.this.table.doResizeColumns(Collections.singleton(targetColumn));
            }
        });
        JMenuItem deleteFieldFromNodes = new JMenuItem(menus.getString("DELETE FIELD FROM ALL NODES"));
        deleteFieldFromNodes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableHeaderContextMenu.this.tableController.deleteColumnFieldFromAllNodes(TableHeaderContextMenu.this.table, targetColumnName);
            }
        });
        if (this.tableModel.isHorizontalView()) {
            JMenu thisColumnMenu = new JMenu(MessageFormat.format(menus.getString("THIS COLUMN"), targetColumnName.trim().length() == 0 ? "nameless" : targetColumnName));
            thisColumnMenu.add(setFixedColumnSize);
            thisColumnMenu.add(setColumnSizeAuto);
            if (targetColumn != 0) {
                thisColumnMenu.add(new JSeparator());
                thisColumnMenu.add(this.createHideColumnMenuItem(targetColumn));
            }
            JMenu allColumnsMenu = new JMenu(menus.getString("ALL COLUMNS"));
            allColumnsMenu.add(setAllColumnsSizeFromColumn);
            allColumnsMenu.add(setAllColumnsSizeAuto);
            this.add(thisColumnMenu);
            this.add(allColumnsMenu);
            this.add(this.createShowChildNodesMenuItem());
            this.add(new JSeparator());
        }
        this.add(fieldViewsMenuItem);
        this.add(saveViewMenuItem);
        this.add(editViewMenuItem);
        this.add(showOnlyCurrentViewMenuItem);
        if (this.tableModel.isHorizontalView()) {
            this.add(new JSeparator());
            this.add(deleteFieldFromNodes);
        }
    }

    private JMenuItem createHideColumnMenuItem(final int targetColumn) {
        JMenuItem hideColumnMenuItem = new JMenuItem(menus.getString("HIDE COLUMN"));
        hideColumnMenuItem.setActionCommand(String.format("%d", targetColumn));
        hideColumnMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TableHeaderContextMenu.this.tableModel.hideColumn(targetColumn);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        return hideColumnMenuItem;
    }

    private JMenuItem createShowChildNodesMenuItem() {
        JMenuItem showChildNodesMenuItem = new JMenuItem();
        showChildNodesMenuItem.setText(menus.getString("SHOW CHILD NODES"));
        showChildNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableHeaderContextMenu.this.tableController.showRowChildData(TableHeaderContextMenu.this.tableModel);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        return showChildNodesMenuItem;
    }
}

