/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

import nl.mpi.util.CVEntry;
import nl.mpi.util.DescriptedObject;

public class MetadataCVEntry
extends CVEntry
implements DescriptedObject {
    private String followup;
    private String displayName;
    private int numberOfOccurrences;

    public void setNumberOfOccurrences(int i) {
        this.numberOfOccurrences = i;
    }

    public void setFollowup(String s) {
        this.followup = s;
    }

    public MetadataCVEntry() {
    }

    public MetadataCVEntry(String displayName, String value, String followup, String description) {
        this(displayName, value, followup, description, -1);
    }

    public MetadataCVEntry(String displayName, String value, String followup, String description, int numberOfOccurrences) {
        super(value == null ? "" : value, description);
        this.followup = followup;
        this.numberOfOccurrences = numberOfOccurrences;
        this.setDisplayName(displayName);
    }

    public void setDisplayName(String s) {
        if (this.displayName != null) {
            this.displayName = s;
        } else if (this.getValue() != null) {
            int start = this.getValue().lastIndexOf(47) + 1;
            int end = this.getValue().lastIndexOf(".xml");
            this.displayName = end > 0 ? this.getValue().substring(start, end) : this.getValue();
        }
    }

    public MetadataCVEntry(String value, String description) {
        this("", value, "", description);
    }

    public MetadataCVEntry(String value, String description, int numberOfOccurrences) {
        this("", value, "", description, numberOfOccurrences);
    }

    public String getFollowUp() {
        return this.followup;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    @Override
    public String toString() {
        return this.displayName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MetadataCVEntry other = (MetadataCVEntry)obj;
        if (!("" + this.getFollowUp()).equals("" + other.getFollowUp())) {
            return false;
        }
        if (!("" + this.getDisplayName()).equals("" + other.getDisplayName())) {
            return false;
        }
        if (!("" + this.getNumberOfOccurrences()).equals("" + other.getNumberOfOccurrences())) {
            return false;
        }
        if (!("" + this.getValue()).equals("" + other.getValue())) {
            return false;
        }
        return ("" + this.getDescription()).equals("" + other.getDescription());
    }

    @Override
    public int hashCode() {
        String text = "" + this.getValue() + this.getDescription() + this.getFollowUp() + this.getDisplayName() + this.getNumberOfOccurrences();
        return text.hashCode();
    }
}

