/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.test;

import java.io.File;
import java.io.FileInputStream;
import java.security.PrivateKey;
import java.util.Enumeration;
import java.util.Vector;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.RemoveValueRequest;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.jdb.DBHash;
import net.handle.util.StreamTable;

public class WriteTest {
    private static final String HDLSVR_CONFIG = "server_config";
    private static final String SERVER_ADMINS = "server_admins";
    private static final String PRIVATE_KEY_FILE = "admpriv.bin";
    private static final String NAMING_AUTHORITY = "nas.jdb";
    private static byte[] adminHandle = null;
    private static int adminIndex = -1;
    private static String testHandle = null;
    private static PublicKeyAuthenticationInfo auth;

    static void createTest(StreamTable config, File configDir) {
        block27: {
            ValueReference[] serverAdmins = new ValueReference[]{};
            if (config.containsKey(HDLSVR_CONFIG)) {
                StreamTable serverConfig = (StreamTable)config.get(HDLSVR_CONFIG);
                try {
                    Vector adminVect = (Vector)serverConfig.get(SERVER_ADMINS);
                    serverAdmins = new ValueReference[adminVect.size()];
                    for (int i = 0; i < adminVect.size(); ++i) {
                        String adminStr = String.valueOf(adminVect.elementAt(i));
                        int colIdx = adminStr.indexOf(58);
                        if (colIdx <= 0) {
                            throw new Exception("Invalid server administrator ID: \"" + adminStr + "\"");
                        }
                        serverAdmins[i] = new ValueReference(Util.encodeString(adminStr.substring(colIdx + 1)), Integer.parseInt(adminStr.substring(0, colIdx)));
                    }
                    adminHandle = serverAdmins[0].handle;
                    adminIndex = serverAdmins[0].index;
                }
                catch (Exception e) {
                    System.out.println("Error processing server administrator list");
                    System.exit(-1);
                }
            } else {
                System.out.println("No administrator listed in config.dct");
                System.exit(-1);
            }
            byte[] key = null;
            try {
                File privateKeyFile = new File(configDir, PRIVATE_KEY_FILE);
                if (!privateKeyFile.exists() || !privateKeyFile.canRead()) {
                    int input;
                    System.err.println("Missing or inaccessible private key file: " + privateKeyFile.getAbsolutePath());
                    System.out.println("\nGive location of admpriv.bin:  ");
                    byte[] readinDir = new byte[2048];
                    int charIdx = 0;
                    int length = 0;
                    while ((input = System.in.read()) >= 0 && input != 10 && input != 13) {
                        readinDir[charIdx++] = (byte)input;
                        ++length;
                    }
                    byte[] readinDirCopy = new byte[length];
                    for (int i = 0; i < length; ++i) {
                        readinDirCopy[i] = readinDir[i];
                    }
                    String keyDir = new String(readinDirCopy);
                    File admprivDir = new File(keyDir);
                    privateKeyFile = new File(admprivDir, PRIVATE_KEY_FILE);
                }
                FileInputStream in = new FileInputStream(privateKeyFile);
                key = new byte[(int)privateKeyFile.length()];
                int n = 0;
                while (n < key.length) {
                    key[n++] = (byte)in.read();
                }
                in.read(key);
            }
            catch (Throwable t) {
                System.err.println("Cannot read private key from admpriv.bin: " + t);
                System.exit(-1);
            }
            PrivateKey privkey = null;
            byte[] secKey = null;
            try {
                if (Util.requiresSecretKey(key)) {
                    secKey = Util.getPassphrase("Enter the passphrase for this server'sauthentication private key: ");
                }
                key = Util.decrypt(key, secKey);
                privkey = Util.getPrivateKeyFromBytes(key, 0);
            }
            catch (Throwable t) {
                System.err.println("Unable to authenticate.");
                System.err.println("Error loading private key: " + t);
                System.exit(-1);
            }
            String naHandle = null;
            try {
                File naFile = new File(configDir, NAMING_AUTHORITY);
                if (!naFile.exists() || !naFile.canRead()) {
                    System.err.println("Missing or inaccessible nas.jdb: " + naFile.getAbsolutePath());
                    System.exit(-1);
                }
                DBHash naDB = new DBHash(naFile, 1000, 500);
                Enumeration naIt = naDB.getEnumerator();
                HandleResolver naResolver = new HandleResolver();
                while (naIt.hasMoreElements()) {
                    byte[][] naHandleByte = (byte[][])naIt.nextElement();
                    try {
                        String naString = Util.decodeString(naHandleByte[0]);
                        HandleValue[] na = naResolver.resolveHandle(naString);
                        naHandle = new String(naHandleByte[0]);
                        break;
                    }
                    catch (Throwable e) {
                        if (naIt.hasMoreElements()) continue;
                        System.out.println("No valid naming authority found");
                        System.exit(-1);
                    }
                }
            }
            catch (Throwable t) {
                System.err.println("Error loading nas.jdb: " + t);
                System.exit(-1);
            }
            int slashIdx = naHandle.indexOf(47);
            naHandle = naHandle.substring(slashIdx + 1).trim();
            if (adminHandle != null && adminIndex != -1) {
                auth = new PublicKeyAuthenticationInfo(adminHandle, adminIndex, privkey);
                HandleResolver resolver = new HandleResolver();
                int handleNum = 0;
                while (true) {
                    testHandle = naHandle.toLowerCase().concat("/test" + String.valueOf(handleNum)).trim();
                    try {
                        ++handleNum;
                        AdminRecord admin = new AdminRecord(adminHandle, 300, true, true, true, true, true, true, true, true, true, true, true, true);
                        ValueReference[] refs = new ValueReference[]{};
                        int timestamp = (int)(System.currentTimeMillis() / 1000L);
                        HandleValue[] val = new HandleValue[]{new HandleValue(300, Common.STD_TYPE_HSADMIN, Encoder.encodeAdminRecord(admin), 0, 86400, timestamp, refs, true, true, true, false)};
                        CreateHandleRequest req = new CreateHandleRequest(Util.encodeString(testHandle), val, (AuthenticationInfo)auth);
                        AbstractResponse response = resolver.processRequest(req);
                        if (response.responseCode == 1) {
                            System.out.print("Creating test handle: " + testHandle + "\t***PASS***\n");
                            break block27;
                        }
                        if (response.responseCode == 101) continue;
                        System.out.println(AbstractMessage.getResponseCodeMessage(response.responseCode));
                        System.err.println("Unable to create test handle\t***FAIL***");
                        System.exit(-1);
                    }
                    catch (Throwable t) {
                        System.err.println("\n" + t);
                        System.err.println("Unable to create test handle\t***FAIL***");
                        System.exit(-1);
                    }
                }
            }
            System.err.println("Admin or admin index invalid.");
            System.exit(-1);
        }
    }

    static void addValueTest() {
        String testUrl = "http://www.handle.net";
        String adminString = new String(adminHandle);
        HandleResolver resolver = new HandleResolver();
        HandleValue[] values = new HandleValue[2];
        values[0] = new HandleValue();
        values[0].setIndex(1);
        values[0].setType(Common.STD_TYPE_URL);
        values[0].setData(Util.encodeString(testUrl));
        values[1] = new HandleValue();
        values[1].setIndex(100);
        values[1].setType(Common.STD_TYPE_HSADMIN);
        values[1].setData(Util.encodeString(adminString));
        try {
            AddValueRequest Areq = new AddValueRequest(Util.encodeString(testHandle), values, (AuthenticationInfo)auth);
            AbstractResponse response = resolver.processRequest(Areq);
            if (response.responseCode == 1) {
                System.out.println("Adding value in: " + testHandle + "\t\t***PASS***");
            } else {
                System.err.println("Adding value in: " + testHandle + "\t\t***FAIL***");
            }
        }
        catch (Throwable t) {
            System.err.println("\n" + t);
            System.err.println("Unable to add value to test handle\t\t***FAIL***");
            System.exit(-1);
        }
    }

    static void modifyValueTest() {
        String testUrl = "http://www.doi.org";
        String adminString = new String(adminHandle);
        HandleResolver resolver = new HandleResolver();
        HandleValue value = new HandleValue();
        value.setIndex(1);
        value.setType(Common.STD_TYPE_URL);
        value.setData(Util.encodeString(testUrl));
        try {
            ModifyValueRequest Mreq = new ModifyValueRequest(Util.encodeString(testHandle), value, (AuthenticationInfo)auth);
            AbstractResponse response = resolver.processRequest(Mreq);
            if (response.responseCode == 1) {
                System.out.println("Modifying value in: " + testHandle + "\t\t***PASS***");
            } else {
                System.err.println("Modifying value in: " + testHandle + "\t\t***FAIL***");
            }
        }
        catch (Throwable t) {
            System.err.println("\n" + t);
            System.err.println("Unable to modify value to test handle\t\t\t***FAIL***");
            System.exit(-1);
        }
    }

    static void deleteValueTest() {
        HandleResolver resolver = new HandleResolver();
        String adminString = new String(adminHandle);
        try {
            RemoveValueRequest Rreq = new RemoveValueRequest(Util.encodeString(testHandle), 1, (AuthenticationInfo)auth);
            AbstractResponse response = resolver.processRequest(Rreq);
            if (response.responseCode == 1) {
                System.out.println("Deleting value: " + testHandle + "\t\t***PASS***");
            } else {
                System.err.println("Deleting value: " + testHandle + "\t\t***FAIL***");
            }
        }
        catch (Throwable t) {
            System.err.println("\n" + t);
            System.err.println("Unable to delete value\t\t\t***FAIL***");
            System.exit(-1);
        }
    }

    static void deleteTest() {
        HandleResolver resolver = new HandleResolver();
        try {
            DeleteHandleRequest Dreq = new DeleteHandleRequest(Util.encodeString(testHandle), auth);
            AbstractResponse response = resolver.processRequest(Dreq);
            if (response.responseCode == 1) {
                System.out.println("Deleting handle: " + testHandle + "\t\t***PASS***");
            } else {
                System.err.println("Deleting handle: " + testHandle + "\t\t***FAIL***");
            }
        }
        catch (Throwable t) {
            System.err.println("\n" + t);
            System.err.println("Unable to delete test handle\t\t***FAIL***");
            System.exit(-1);
        }
    }
}

