/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import net.handle.server.RequestHandler;

public class RequestHandlerPool
implements Runnable {
    private static final int DEFAULT_POOL_SIZE = 100;
    private static final int SIZE_INCREMENT = 50;
    private int maxPossibleHandlers = 300;
    private int maxHandlerInvocations = 200;
    private RequestHandler[] pool = new RequestHandler[100];
    private int start = 0;
    private int end = 0;
    private String statusID = null;

    public RequestHandlerPool() {
        for (int i = 0; i < 100; ++i) {
            this.pool[i] = null;
        }
    }

    public RequestHandlerPool(String statusID) {
        this();
        this.statusID = statusID;
        if (statusID != null) {
            Thread analyzer = new Thread(this);
            analyzer.setDaemon(true);
            analyzer.start();
        }
    }

    public void setMaxPossibleHandlers(int maxHandlerCount) {
        this.maxPossibleHandlers = maxHandlerCount;
    }

    public void setHandlerLife(int handlerLife) {
        this.maxHandlerInvocations = handlerLife;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    System.err.println("<" + this.statusID + ':' + this.getAvailableCount() + ">");
                    Thread.currentThread();
                    Thread.sleep(60000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    int getAvailableCount() {
        int size = this.end - this.start;
        if (size < 0) {
            size = this.pool.length + size;
        }
        return size;
    }

    public void addHandler(RequestHandler handler) {
        this.returnHandler(handler);
    }

    public synchronized RequestHandler getHandler() {
        while (true) {
            if (this.start != this.end) {
                int idx = this.start++;
                if (this.start >= this.pool.length) {
                    this.start = 0;
                }
                return this.pool[idx];
            }
            if (this.pool.length < this.maxPossibleHandlers && this.pool.length > 0) {
                return this.pool[0].newHandler();
            }
            try {
                this.wait(1000L);
                continue;
            }
            catch (Exception e) {
                System.err.println("Got exception waiting for handler: " + e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnHandler(RequestHandler handler) {
        try {
            handler.resetState();
        }
        catch (Throwable t) {
            System.err.println("Exception resetting handler state: " + t);
        }
        try {
            RequestHandlerPool t = this;
            synchronized (t) {
                if (this.getAvailableCount() >= this.pool.length - 1) {
                    System.err.println("Growing handler pool... end=" + this.end + " pool.length=" + this.pool.length + " start=" + this.start);
                    RequestHandler[] newPool = new RequestHandler[this.pool.length + 50];
                    int i = 0;
                    while (this.start != this.end) {
                        newPool[i++] = this.pool[this.start++];
                        if (this.start < this.pool.length) continue;
                        this.start = 0;
                    }
                    this.start = 0;
                    this.end = i;
                    this.pool = newPool;
                }
                int thisHandlerIdx = this.end++;
                if (this.end >= this.pool.length) {
                    this.end = 0;
                }
                this.pool[thisHandlerIdx] = handler;
                if (this.pool[thisHandlerIdx].getInvocationCount() > this.maxHandlerInvocations) {
                    this.pool[thisHandlerIdx] = handler.newHandler();
                    handler.deactivate();
                }
                this.notify();
            }
        }
        catch (Exception e) {
            System.err.println("Error resetting handler: " + e);
        }
    }
}

