/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.TransactionQueueListener;
import net.handle.hdllib.TransactionScannerInterface;
import net.handle.hdllib.Util;
import net.handle.util.StringUtils;

public class TransactionQueue
implements TransactionQueueInterface {
    private File queueDir;
    private File queueIndexFile;
    private Vector queueFiles;
    private Calendar calendar;
    private File lockFile;
    private Vector queueListeners;
    private boolean haveLock = false;
    private boolean initialized = false;

    public TransactionQueue(File queueDir) throws Exception {
        this.queueDir = queueDir;
        this.lockFile = new File(queueDir, "lock");
        this.queueIndexFile = new File(queueDir, "index");
        this.queueListeners = new Vector();
        this.calendar = Calendar.getInstance();
        this.getLock();
        try {
            Class<?> rt = Runtime.getRuntime().getClass();
            Object[] args = new Object[]{new Thread(new Shutdown())};
            Class[] argTypes = new Class[]{args[0].getClass()};
            Method addHook = rt.getMethod("addShutdownHook", argTypes);
            addHook.invoke((Object)Runtime.getRuntime(), args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.initQueueIndex();
        this.initialized = true;
    }

    public synchronized long getFirstDate() {
        if (this.queueFiles.size() <= 0) {
            return Long.MAX_VALUE;
        }
        QueueFileEntry entry = (QueueFileEntry)this.queueFiles.elementAt(0);
        return entry.startDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getLastTxnId() {
        if (this.queueFiles.size() <= 0) {
            return 0L;
        }
        long txnId = 0L;
        try {
            Transaction txn;
            QueueScanner scanner = new QueueScanner((QueueFileEntry)this.queueFiles.elementAt(this.queueFiles.size() - 1));
            do {
                if ((txn = scanner.nextTransaction()) == null) continue;
                txnId = txn.txnId;
            } while (txn != null);
        }
        catch (Exception e) {
            System.err.println("Error getting transaction ID: " + e + "\n   using " + txnId);
        }
        finally {
            try {
                System.gc();
                System.runFinalization();
            }
            catch (Throwable throwable) {}
        }
        return txnId;
    }

    public void addQueueListener(TransactionQueueListener l) {
        this.queueListeners.addElement(l);
    }

    public void removeQueueListener(TransactionQueueListener l) {
        this.queueListeners.removeElement(l);
    }

    private void notifyQueueListeners(Transaction txn) {
        for (int i = 0; i < this.queueListeners.size(); ++i) {
            try {
                ((TransactionQueueListener)this.queueListeners.elementAt(i)).transactionAdded(txn);
                continue;
            }
            catch (Throwable e) {
                System.err.println("error notifying queue listeners: " + e);
                e.printStackTrace(System.err);
            }
        }
    }

    private synchronized int getQueueFileName(Date dt) {
        this.calendar.setTime(dt);
        return this.calendar.get(1) * 10000 + this.calendar.get(2) * 100 + this.calendar.get(5);
    }

    private synchronized void initQueueIndex() throws Exception {
        this.queueFiles = new Vector();
        if (!this.queueIndexFile.exists() || this.queueIndexFile.length() <= 0L) {
            Transaction dummyTxn = new Transaction();
            dummyTxn.txnId = -1L;
            dummyTxn.handle = new byte[0];
            dummyTxn.action = 0;
            dummyTxn.hashOnAll = 0;
            dummyTxn.hashOnNA = 0;
            dummyTxn.hashOnId = 0;
            dummyTxn.values = new HandleValue[0];
            this.addTransaction(dummyTxn);
        } else {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(this.queueIndexFile));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                long startDate = Long.parseLong(StringUtils.fieldIndex(line, '\t', 0));
                long firstTxnId = Long.parseLong(StringUtils.fieldIndex(line, '\t', 1));
                int queueNumber = Integer.parseInt(StringUtils.fieldIndex(line, '\t', 2));
                this.queueFiles.addElement(new QueueFileEntry(startDate, firstTxnId, queueNumber));
            }
        }
    }

    private synchronized void getLock() throws Exception {
        if (this.lockFile.exists()) {
            System.err.println("Error: lock file (" + this.lockFile + ") exists.  If you are sure " + "that another server is not running, remove this file and restart " + "the server");
            throw new Exception("Queue files are locked");
        }
        try {
            try {
                new File(this.lockFile.getParent()).mkdirs();
            }
            catch (Exception e) {
                // empty catch block
            }
            FileOutputStream out = new FileOutputStream(this.lockFile);
            ((OutputStream)out).write("lock".getBytes());
            ((OutputStream)out).close();
            this.haveLock = true;
        }
        catch (Exception e) {
            throw new Exception("Cannot create lock file: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void releaseLock() {
        if (!this.haveLock) {
            return;
        }
        try {
            this.lockFile.delete();
        }
        catch (Throwable e) {
            System.err.println("Error removing transaction queue lock file: " + e);
        }
        finally {
            this.lockFile = null;
        }
    }

    private synchronized QueueFileEntry getCurrentQueue() {
        if (this.queueFiles.size() <= 0) {
            return null;
        }
        return (QueueFileEntry)this.queueFiles.elementAt(this.queueFiles.size() - 1);
    }

    public void addTransaction(long txnId, byte[] handle, byte action, long date) throws Exception {
        Transaction txn = new Transaction();
        txn.txnId = txnId;
        txn.handle = handle;
        txn.action = action;
        txn.date = date;
        txn.hashOnAll = SiteInfo.getHandleHash(handle, 2);
        txn.hashOnNA = SiteInfo.getHandleHash(handle, 0);
        txn.hashOnId = SiteInfo.getHandleHash(handle, 1);
        this.addTransaction(txn);
        this.notifyQueueListeners(txn);
    }

    protected synchronized void addTransaction(Transaction txn) throws Exception {
        Date now = new Date();
        int qnum = this.getQueueFileName(now);
        QueueFileEntry currentQueue = this.getCurrentQueue();
        if (currentQueue == null || (long)qnum > currentQueue.getQueueNumber()) {
            currentQueue = this.createNewQueue(now.getTime(), txn.txnId, qnum);
        }
        currentQueue.writeRecord(this.encodeTransaction(txn));
    }

    private synchronized QueueFileEntry createNewQueue(long startDate, long firstTxnId, int queueNum) throws Exception {
        this.closeCurrentQueue();
        FileWriter writer = new FileWriter(this.queueIndexFile.getAbsolutePath(), true);
        QueueFileEntry newQueue = new QueueFileEntry(startDate, firstTxnId, queueNum);
        String record = String.valueOf(startDate) + '\t' + String.valueOf(firstTxnId) + '\t' + String.valueOf(queueNum) + "\t\n";
        writer.write(record);
        writer.close();
        this.queueFiles.addElement(newQueue);
        return newQueue;
    }

    private synchronized void closeCurrentQueue() throws Exception {
        QueueFileEntry qfe = this.getCurrentQueue();
        if (qfe != null) {
            qfe.close();
        }
    }

    private synchronized QueueFileEntry getNextQueue(QueueFileEntry presentQueue) {
        for (int i = this.queueFiles.size() - 2; i >= 0; --i) {
            QueueFileEntry qfe = (QueueFileEntry)this.queueFiles.elementAt(i);
            if (qfe != presentQueue) continue;
            return (QueueFileEntry)this.queueFiles.elementAt(i + 1);
        }
        return null;
    }

    protected String encodeTransaction(Transaction txn) {
        StringBuffer sb = new StringBuffer();
        sb.append(txn.txnId);
        sb.append('|');
        sb.append(txn.action);
        sb.append('|');
        sb.append(txn.date);
        sb.append('|');
        sb.append(txn.hashOnAll);
        sb.append('|');
        sb.append(txn.hashOnNA);
        sb.append('|');
        sb.append(txn.hashOnId);
        sb.append('|');
        sb.append(Util.decodeHexString(txn.handle, false));
        sb.append('|');
        sb.append('\n');
        return sb.toString();
    }

    protected int nextField(int currPos, String txnStr) throws Exception {
        int i;
        if (currPos >= txnStr.length()) {
            throw new Exception("No more fields in transaction");
        }
        for (i = currPos + 1; i < txnStr.length() && txnStr.charAt(i) != '|'; ++i) {
        }
        return i;
    }

    protected Transaction decodeTransaction(String txnStr) {
        try {
            int sepIdx = -1;
            Transaction txn = new Transaction();
            int n = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.txnId = Long.parseLong(txnStr.substring(n, sepIdx));
            int n2 = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.action = (byte)Integer.parseInt(txnStr.substring(n2, sepIdx));
            int n3 = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.date = Long.parseLong(txnStr.substring(n3, sepIdx));
            int n4 = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.hashOnAll = Integer.parseInt(txnStr.substring(n4, sepIdx));
            int n5 = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.hashOnNA = Integer.parseInt(txnStr.substring(n5, sepIdx));
            int n6 = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.hashOnId = Integer.parseInt(txnStr.substring(n6, sepIdx));
            int n7 = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.handle = Util.encodeHexString(txnStr.substring(n7, sepIdx));
            return txn;
        }
        catch (Exception e) {
            System.err.println("Exception decoding transaction: \n  " + txnStr + "\n  " + e);
            e.printStackTrace(System.err);
            return null;
        }
    }

    public void finalize() {
        try {
            this.shutdown();
        }
        catch (Throwable t) {
            System.err.println("Error finalizing txn queue: " + t);
        }
    }

    public synchronized void shutdown() {
        if (!this.initialized) {
            return;
        }
        try {
            this.closeCurrentQueue();
        }
        catch (Throwable e) {
            System.err.println("Error shutting down transaction queue: " + e);
        }
        this.releaseLock();
    }

    public synchronized TransactionScannerInterface getScanner(long lastTxnID) throws Exception {
        if (this.queueFiles.size() <= 0) {
            return null;
        }
        QueueFileEntry queueEntry = null;
        for (int i = 0; i < this.queueFiles.size(); ++i) {
            QueueFileEntry nextEntry = (QueueFileEntry)this.queueFiles.elementAt(i);
            if (nextEntry.firstTxnId >= 0L && nextEntry.firstTxnId > lastTxnID) {
                if (queueEntry == null) {
                    return new QueueScanner(nextEntry);
                }
                return new QueueScanner(queueEntry);
            }
            queueEntry = nextEntry;
        }
        if (queueEntry == null) {
            return new QueueScanner((QueueFileEntry)this.queueFiles.elementAt(0));
        }
        return new QueueScanner(queueEntry);
    }

    class Shutdown
    implements Runnable {
        Shutdown() {
        }

        public void run() {
            try {
                TransactionQueue.this.shutdown();
            }
            catch (Throwable t) {
                System.err.println("Error finalizing txn queue: " + t);
            }
        }
    }

    public class QueueScanner
    implements TransactionScannerInterface {
        private BufferedReader reader;
        private QueueFileEntry queueFileEntry;
        private long firstDateInLog;

        protected QueueScanner(QueueFileEntry queueFileEntry) throws Exception {
            this.firstDateInLog = queueFileEntry.getStartDate();
            this.connectToQueue(queueFileEntry);
        }

        public long getFirstDateInLog() {
            return this.firstDateInLog;
        }

        private void connectToQueue(QueueFileEntry nextQueue) throws Exception {
            block6: {
                this.queueFileEntry = nextQueue;
                this.reader = null;
                try {
                    File f = this.queueFileEntry.getQueueFile();
                    if (f.exists() && f.canRead()) {
                        this.reader = new BufferedReader(new FileReader(f));
                        break block6;
                    }
                    throw new Exception("Cannot access file: " + f);
                }
                catch (Exception e) {
                    throw new Exception("Unable to open transaction log: " + e);
                }
                finally {
                    System.gc();
                    System.runFinalization();
                }
            }
        }

        public synchronized Transaction nextTransaction() throws Exception {
            Transaction txn;
            String line = null;
            while (true) {
                if ((line = this.reader.readLine()) == null) {
                    QueueFileEntry nextQueue = TransactionQueue.this.getNextQueue(this.queueFileEntry);
                    if (nextQueue == null) {
                        return null;
                    }
                    this.connectToQueue(nextQueue);
                    continue;
                }
                if (line.trim().length() <= 0) continue;
                txn = TransactionQueue.this.decodeTransaction(line);
                if (txn.action != 0) break;
            }
            return txn;
        }

        public void close() {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class QueueFileEntry {
        private long startDate;
        private long firstTxnId;
        private int queueNumber;
        private Writer writer = null;
        private File queueFile = null;

        QueueFileEntry(long startDate, long firstTxnId, int queueNumber) {
            this.startDate = startDate;
            this.firstTxnId = firstTxnId;
            this.queueNumber = queueNumber;
        }

        long getStartDate() {
            return this.startDate;
        }

        long getFirstTxnId() {
            return this.firstTxnId;
        }

        long getQueueNumber() {
            return this.queueNumber;
        }

        synchronized File getQueueFile() {
            if (this.queueFile == null) {
                this.queueFile = new File(TransactionQueue.this.queueDir, String.valueOf(this.queueNumber) + ".q");
            }
            return this.queueFile;
        }

        synchronized void writeRecord(String record) throws IOException {
            if (this.writer == null) {
                this.writer = new FileWriter(this.getQueueFile().getAbsolutePath(), true);
            }
            this.writer.write(record);
            this.writer.flush();
        }

        synchronized void close() {
            Writer tmpWriter = this.writer;
            this.writer = null;
            if (tmpWriter != null) {
                try {
                    tmpWriter.close();
                }
                catch (Exception e) {
                    System.err.println("Error closing queue writer: " + e);
                    e.printStackTrace(System.err);
                }
            }
        }

        public String toString() {
            return String.valueOf(this.queueNumber) + "; firsttxn=" + this.firstTxnId + "; startDate=" + this.startDate + "; file=" + this.queueFile;
        }
    }
}

