/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.io.Serializable;
import net.handle.util.CapacityError;

public final class StringSet
implements Serializable {
    private static final int[] primes = new int[]{7, 13, 31, 61, 127, 251, 509, 1021, 2017, 4093, 5987, 9551, 15683, 19609, 31397, 65521, 131071, 262139, 524287, 1048573, 0x1FFFF7, 0x3FFFFD, 0x7FFFF1, 0xFFFFFD, 33554393, 0x3FFFFFB, 134217689, 0xFFFFFC7, 0x1FFFFFFD, 0x3FFFFFDD};
    private String[] keys = null;
    private int size;
    private transient int filled;
    private transient int prime = 0;
    private static final String DELETED_KEY = "<deleted key>";

    public StringSet() throws CapacityError {
        this.resize(4);
    }

    public int getSize() {
        return this.size;
    }

    public synchronized void add(String key) throws CapacityError {
        if (2 * this.filled > this.keys.length) {
            this.resize(this.keys.length + 1);
        }
        String[] table = this.keys;
        int maxindex = table.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % maxindex;
        int stepsize = maxindex / 5;
        while (true) {
            String tkey;
            if ((tkey = table[index]) == null) {
                table[index] = key;
                ++this.filled;
                ++this.size;
                break;
            }
            if (tkey.equals(key)) break;
            if (tkey == DELETED_KEY) {
                table[index] = key;
                ++this.size;
                break;
            }
            index = (index + stepsize) % maxindex;
        }
    }

    public synchronized boolean contains(String key) {
        String[] table = this.keys;
        int maxindex = table.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % maxindex;
        int stepsize = maxindex / 5;
        String tkey;
        while ((tkey = table[index]) != null) {
            if (tkey.equals(key)) {
                return true;
            }
            index = (index + stepsize) % maxindex;
        }
        return false;
    }

    public synchronized String[] members() {
        String[] keyTable = this.keys;
        int n = keyTable.length;
        String[] newKeys = new String[this.size];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            String key = keyTable[i];
            if (key == null || key == DELETED_KEY) continue;
            newKeys[j++] = key;
        }
        return newKeys;
    }

    public synchronized void remove(String key) {
        String[] table = this.keys;
        int maxindex = table.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % maxindex;
        int stepsize = maxindex / 5;
        while (true) {
            String tkey;
            if ((tkey = table[index]) == null) {
                return;
            }
            if (tkey.equals(key)) {
                table[index] = DELETED_KEY;
                --this.size;
                break;
            }
            index = (index + stepsize) % maxindex;
        }
    }

    public synchronized String toString() {
        String[] keyTable = this.keys;
        int n = keyTable.length;
        StringBuffer buf = new StringBuffer("{");
        for (int i = 0; i < n; ++i) {
            buf.append("'");
            buf.append(keyTable[i]);
            buf.append("', ");
        }
        int len = buf.length();
        if (len > 4) {
            buf.setLength(len - 2);
        }
        buf.append("}");
        return buf.toString();
    }

    private synchronized void resize(int capacity) throws CapacityError {
        int p;
        for (p = this.prime; p < primes.length && primes[p] < capacity; ++p) {
        }
        if (primes[p] < capacity) {
            throw new CapacityError(capacity, "StringSet");
        }
        capacity = primes[p];
        this.prime = p;
        String[] oldKeys = this.keys;
        this.keys = new String[capacity];
        this.size = 0;
        this.filled = 0;
        if (oldKeys != null) {
            int n = oldKeys.length;
            for (int i = 0; i < n; ++i) {
                String k = oldKeys[i];
                if (k == null || k == DELETED_KEY) continue;
                this.add(k);
            }
        }
    }
}

