/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison10;
import net.sf.saxon.expr.GeneralComparison20;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;

public class GeneralComparison
extends BinaryExpression
implements ComparisonExpression,
Callable {
    public static final int ONE_TO_ONE = 0;
    public static final int MANY_TO_ONE = 1;
    public static final int MANY_TO_MANY = 2;
    protected int singletonOperator;
    protected AtomicComparer comparer;
    protected boolean needsRuntimeCheck = true;
    protected int comparisonCardinality = 2;
    protected boolean doneWarnings = false;
    private static double[][] bounds = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10}, {1.0, 2.0, 20.0, 200.0, 2000.0, 20000.0, 200000.0, 2000000.0, 2.0E7, 2.0E8, 2.0E9, 2.0E10}, {1.0, 3.0, 30.0, 300.0, 3000.0, 30000.0, 300000.0, 3000000.0, 3.0E7, 3.0E8, 3.0E9, 3.0E10}, {1.0, 4.0, 40.0, 400.0, 4000.0, 40000.0, 400000.0, 4000000.0, 4.0E7, 4.0E8, 4.0E9, 4.0E10}, {1.0, 5.0, 50.0, 500.0, 5000.0, 50000.0, 500000.0, 5000000.0, 5.0E7, 5.0E8, 5.0E9, 5.0E10}, {1.0, 6.0, 60.0, 600.0, 6000.0, 60000.0, 600000.0, 6000000.0, 6.0E7, 6.0E8, 6.0E9, 6.0E10}, {1.0, 7.0, 70.0, 700.0, 7000.0, 70000.0, 700000.0, 7000000.0, 7.0E7, 7.0E8, 7.0E9, 7.0E10}, {1.0, 8.0, 80.0, 800.0, 8000.0, 80000.0, 800000.0, 8000000.0, 8.0E7, 8.0E8, 8.0E9, 8.0E10}, {1.0, 9.0, 90.0, 900.0, 9000.0, 90000.0, 900000.0, 9000000.0, 9.0E7, 9.0E8, 9.0E9, 9.0E10}, {1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11}};

    public GeneralComparison(Expression p0, int op, Expression p1) {
        super(p0, op, p1);
        this.singletonOperator = GeneralComparison.getCorrespondingSingletonOperator(op);
    }

    public boolean needsRuntimeCheck() {
        return this.needsRuntimeCheck;
    }

    public void setNeedsRuntimeCheck(boolean needsCheck) {
        this.needsRuntimeCheck = needsCheck;
    }

    public int getComparisonCardinality() {
        return this.comparisonCardinality;
    }

    public void setComparisonCardinality(int card) {
        this.comparisonCardinality = card;
    }

    public void setAtomicComparer(AtomicComparer comparer) {
        this.comparer = comparer;
    }

    public Expression simplify() throws XPathException {
        Expression e = super.simplify();
        if (e != this) {
            ExpressionTool.copyLocationInfo(this, e);
            return e;
        }
        if (this.getRetainedStaticContext().isBackwardsCompatibility()) {
            GeneralComparison10 gc10 = new GeneralComparison10(this.getLhsExpression(), this.getOperator(), this.getRhsExpression());
            gc10.setRetainedStaticContext(this.getRetainedStaticContext());
            gc10.setAtomicComparer(this.getAtomicComparer());
            ExpressionTool.copyLocationInfo(this, gc10);
            return gc10;
        }
        GeneralComparison20 gc20 = new GeneralComparison20(this.getLhsExpression(), this.getOperator(), this.getRhsExpression());
        gc20.setRetainedStaticContext(this.getRetainedStaticContext());
        gc20.setAtomicComparer(this.getAtomicComparer());
        ExpressionTool.copyLocationInfo(this, gc20);
        return gc20;
    }

    public String getExpressionName() {
        return "GeneralComparison";
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    public int getSingletonOperator() {
        return this.singletonOperator;
    }

    public boolean convertsUntypedToOther() {
        return true;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Configuration config = this.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        Expression oldOp0 = this.getLhsExpression();
        Expression oldOp1 = this.getRhsExpression();
        this.typeCheckChildren(visitor, contextInfo);
        if (Literal.isEmptySequence(this.getLhsExpression()) || Literal.isEmptySequence(this.getRhsExpression())) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        this.setLhsExpression(this.getLhsExpression().unordered(false, false));
        this.setRhsExpression(this.getRhsExpression().unordered(false, false));
        SequenceType atomicType = SequenceType.ATOMIC_SEQUENCE;
        RoleDiagnostic role0 = new RoleDiagnostic(1, Token.tokens[this.operator], 0);
        this.setLhsExpression(TypeChecker.staticTypeCheck(this.getLhsExpression(), atomicType, false, role0, visitor));
        RoleDiagnostic role1 = new RoleDiagnostic(1, Token.tokens[this.operator], 1);
        this.setRhsExpression(TypeChecker.staticTypeCheck(this.getRhsExpression(), atomicType, false, role1, visitor));
        if (this.getLhsExpression() != oldOp0) {
            this.adoptChildExpression(this.getLhsExpression());
        }
        if (this.getRhsExpression() != oldOp1) {
            this.adoptChildExpression(this.getRhsExpression());
        }
        ItemType t0 = this.getLhsExpression().getItemType();
        ItemType t1 = this.getRhsExpression().getItemType();
        if (t0 instanceof ErrorType || t1 instanceof ErrorType) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        if (((PlainType)t0).isExternalType() || ((PlainType)t1).isExternalType()) {
            XPathException err = new XPathException("Cannot perform comparisons involving external objects");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            err.setLocator(this.getLocation());
            throw err;
        }
        BuiltInAtomicType pt0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
        BuiltInAtomicType pt1 = (BuiltInAtomicType)t1.getPrimitiveItemType();
        int c0 = this.getLhsExpression().getCardinality();
        int c1 = this.getRhsExpression().getCardinality();
        if (c0 == 8192 || c1 == 8192) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        if (!(t0.equals(BuiltInAtomicType.ANY_ATOMIC) || t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || t1.equals(BuiltInAtomicType.ANY_ATOMIC) || t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || Type.isPossiblyComparable(pt0, pt1, Token.isOrderedOperator(this.singletonOperator)))) {
            String message = "Cannot compare " + t0.toString() + " to " + t1.toString();
            if (Cardinality.allowsZero(c0) || Cardinality.allowsZero(c1)) {
                if (!this.doneWarnings) {
                    this.doneWarnings = true;
                    String which = "one";
                    if (Cardinality.allowsZero(c0) && !Cardinality.allowsZero(c1)) {
                        which = "the first";
                    } else if (Cardinality.allowsZero(c1) && !Cardinality.allowsZero(c0)) {
                        which = "the second";
                    }
                    visitor.getStaticContext().issueWarning(message + ". The comparison can succeed only if " + which + " operand is empty, and in that case will always be false", this.getLocation());
                }
            } else {
                XPathException err = new XPathException(message);
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocator(this.getLocation());
                throw err;
            }
        }
        boolean bl = this.needsRuntimeCheck = !Type.isGuaranteedGenerallyComparable(pt0, pt1, Token.isOrderedOperator(this.singletonOperator));
        if (c0 == 16384 && c1 == 16384 && !t0.equals(BuiltInAtomicType.ANY_ATOMIC) && !t1.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            Expression e0 = this.getLhsExpression();
            Expression e1 = this.getRhsExpression();
            if (t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    e0 = new CastExpression(this.getLhsExpression(), BuiltInAtomicType.STRING, false);
                    this.adoptChildExpression(e0);
                    e1 = new CastExpression(this.getRhsExpression(), BuiltInAtomicType.STRING, false);
                    this.adoptChildExpression(e1);
                } else if (th.isSubType(t1, NumericType.getInstance())) {
                    e0 = new CastExpression(this.getLhsExpression(), BuiltInAtomicType.DOUBLE, false);
                    this.adoptChildExpression(e0);
                } else {
                    e0 = new CastExpression(this.getLhsExpression(), pt1, false);
                    this.adoptChildExpression(e0);
                }
            } else if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (th.isSubType(t0, NumericType.getInstance())) {
                    e1 = new CastExpression(this.getRhsExpression(), BuiltInAtomicType.DOUBLE, false);
                    this.adoptChildExpression(e1);
                } else {
                    e1 = new CastExpression(this.getRhsExpression(), pt0, false);
                    this.adoptChildExpression(e1);
                }
            }
            ValueComparison vc = new ValueComparison(e0, this.singletonOperator, e1);
            vc.setAtomicComparer(this.comparer);
            ExpressionTool.copyLocationInfo(this, vc);
            return vc.typeCheck(visitor, contextInfo);
        }
        StaticContext env = visitor.getStaticContext();
        if (this.comparer == null) {
            String defaultCollationName = env.getDefaultCollationName();
            StringCollator collation = config.getCollation(defaultCollationName);
            if (collation == null) {
                collation = CodepointCollator.getInstance();
            }
            this.comparer = GenericAtomicComparer.makeAtomicComparer(pt0, pt1, collation, config.getConversionContext());
        }
        if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
            return Literal.makeLiteral(this.evaluateItem(env.makeEarlyEvaluationContext()));
        }
        return this;
    }

    private static Expression makeMinOrMax(Expression exp, String function) throws XPathException {
        Expression fn = SystemFunction.makeCall(function, exp.getRetainedStaticContext(), exp);
        ((Minimax)((SystemFunctionCall)fn).getTargetFunction()).setIgnoreNaN(true);
        return fn;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        StaticContext env = visitor.getStaticContext();
        this.optimizeChildren(visitor, contextInfo);
        if (Literal.isEmptySequence(this.getLhsExpression()) || Literal.isEmptySequence(this.getRhsExpression())) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        this.setLhsExpression(this.getLhsExpression().unordered(false, false));
        this.setRhsExpression(this.getRhsExpression().unordered(false, false));
        if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
            return Literal.makeLiteral(SequenceTool.toGroundedValue(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext())));
        }
        ItemType t0 = this.getLhsExpression().getItemType();
        ItemType t1 = this.getRhsExpression().getItemType();
        int c0 = this.getLhsExpression().getCardinality();
        int c1 = this.getRhsExpression().getCardinality();
        boolean many0 = Cardinality.allowsMany(c0);
        boolean many1 = Cardinality.allowsMany(c1);
        if (many0) {
            this.comparisonCardinality = many1 ? 2 : 1;
        } else {
            if (many1) {
                GeneralComparison mc = this.getInverseComparison();
                mc.comparisonCardinality = 1;
                ExpressionTool.copyLocationInfo(this, mc);
                mc.comparer = this.comparer;
                mc.needsRuntimeCheck = this.needsRuntimeCheck;
                return mc.optimize(visitor, contextInfo);
            }
            this.comparisonCardinality = 0;
        }
        if (this.operator == 6) {
            GroundedValue value1;
            GroundedValue value0;
            if (this.getLhsExpression() instanceof RangeExpression) {
                Expression min = ((RangeExpression)this.getLhsExpression()).getLhsExpression();
                Expression max = ((RangeExpression)this.getLhsExpression()).getRhsExpression();
                IntegerRangeTest ir = new IntegerRangeTest(this.getRhsExpression(), min, max);
                ExpressionTool.copyLocationInfo(this, ir);
                return ir;
            }
            if (this.getRhsExpression() instanceof RangeExpression) {
                Expression min = ((RangeExpression)this.getRhsExpression()).getLhsExpression();
                Expression max = ((RangeExpression)this.getRhsExpression()).getRhsExpression();
                IntegerRangeTest ir = new IntegerRangeTest(this.getLhsExpression(), min, max);
                ExpressionTool.copyLocationInfo(this, ir);
                return ir;
            }
            if (this.getLhsExpression() instanceof Literal && (value0 = ((Literal)this.getLhsExpression()).getValue()) instanceof IntegerRange) {
                long min = ((IntegerRange)value0).getStart();
                long max = ((IntegerRange)value0).getEnd();
                IntegerRangeTest ir = new IntegerRangeTest(this.getRhsExpression(), Literal.makeLiteral(Int64Value.makeIntegerValue(min)), Literal.makeLiteral(Int64Value.makeIntegerValue(max)));
                ExpressionTool.copyLocationInfo(this, ir);
                return ir;
            }
            if (this.getRhsExpression() instanceof Literal && (value1 = ((Literal)this.getRhsExpression()).getValue()) instanceof IntegerRange) {
                long min = ((IntegerRange)value1).getStart();
                long max = ((IntegerRange)value1).getEnd();
                IntegerRangeTest ir = new IntegerRangeTest(this.getLhsExpression(), Literal.makeLiteral(Int64Value.makeIntegerValue(min)), Literal.makeLiteral(Int64Value.makeIntegerValue(max)));
                ExpressionTool.copyLocationInfo(this, ir);
                return ir;
            }
        }
        if (this.operator != 6 && this.operator != 22 && this.comparisonCardinality == 2 && (th.isSubType(t0, NumericType.getInstance()) || th.isSubType(t1, NumericType.getInstance()))) {
            ValueComparison vc;
            switch (this.operator) {
                case 12: 
                case 14: {
                    vc = new ValueComparison(GeneralComparison.makeMinOrMax(this.getLhsExpression(), "min"), this.singletonOperator, GeneralComparison.makeMinOrMax(this.getRhsExpression(), "max"));
                    vc.setResultWhenEmpty(BooleanValue.FALSE);
                    vc.setAtomicComparer(this.comparer);
                    break;
                }
                case 11: 
                case 13: {
                    vc = new ValueComparison(GeneralComparison.makeMinOrMax(this.getLhsExpression(), "max"), this.singletonOperator, GeneralComparison.makeMinOrMax(this.getRhsExpression(), "min"));
                    vc.setResultWhenEmpty(BooleanValue.FALSE);
                    vc.setAtomicComparer(this.comparer);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown operator " + this.operator);
                }
            }
            ExpressionTool.copyLocationInfo(this, vc);
            vc.setRetainedStaticContext(this.getRetainedStaticContext());
            return vc.typeCheck(visitor, contextInfo);
        }
        if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
            return Literal.makeLiteral(this.evaluateItem(env.makeEarlyEvaluationContext()));
        }
        return this.getConfiguration().obtainOptimizer().optimizeGeneralComparison(visitor, this, false, contextInfo);
    }

    public Expression copy(RebindingMap rebindings) {
        GeneralComparison gc = new GeneralComparison(this.getLhsExpression().copy(rebindings), this.operator, this.getRhsExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, gc);
        gc.setRetainedStaticContext(this.getRetainedStaticContext());
        gc.comparer = this.comparer;
        gc.singletonOperator = this.singletonOperator;
        gc.needsRuntimeCheck = this.needsRuntimeCheck;
        gc.comparisonCardinality = this.comparisonCardinality;
        return gc;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        switch (this.comparisonCardinality) {
            case 0: {
                AtomicValue value0 = (AtomicValue)this.getLhsExpression().evaluateItem(context);
                AtomicValue value1 = (AtomicValue)this.getRhsExpression().evaluateItem(context);
                return BooleanValue.get(this.evaluateOneToOne(value0, value1, context));
            }
            case 1: {
                SequenceIterator iter0 = this.getLhsExpression().iterate(context);
                AtomicValue value1 = (AtomicValue)this.getRhsExpression().evaluateItem(context);
                return BooleanValue.get(this.evaluateManyToOne(iter0, value1, context));
            }
            case 2: {
                SequenceIterator iter1 = this.getLhsExpression().iterate(context);
                SequenceIterator iter2 = this.getRhsExpression().iterate(context);
                return BooleanValue.get(this.evaluateManyToMany(iter1, iter2, context));
            }
        }
        return null;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        switch (this.comparisonCardinality) {
            case 0: {
                AtomicValue value0 = (AtomicValue)arguments[0].head();
                AtomicValue value1 = (AtomicValue)arguments[1].head();
                return BooleanValue.get(this.evaluateOneToOne(value0, value1, context));
            }
            case 1: {
                SequenceIterator iter0 = arguments[0].iterate();
                AtomicValue value1 = (AtomicValue)arguments[1].head();
                return BooleanValue.get(this.evaluateManyToOne(iter0, value1, context));
            }
            case 2: {
                SequenceIterator iter1 = arguments[0].iterate();
                SequenceIterator iter2 = arguments[1].iterate();
                return BooleanValue.get(this.evaluateManyToMany(iter1, iter2, context));
            }
        }
        return null;
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        switch (this.comparisonCardinality) {
            case 0: {
                AtomicValue value0 = (AtomicValue)this.getLhsExpression().evaluateItem(context);
                AtomicValue value1 = (AtomicValue)this.getRhsExpression().evaluateItem(context);
                return this.evaluateOneToOne(value0, value1, context);
            }
            case 1: {
                SequenceIterator iter0 = this.getLhsExpression().iterate(context);
                AtomicValue value1 = (AtomicValue)this.getRhsExpression().evaluateItem(context);
                return this.evaluateManyToOne(iter0, value1, context);
            }
            case 2: {
                SequenceIterator iter1 = this.getLhsExpression().iterate(context);
                SequenceIterator iter2 = this.getRhsExpression().iterate(context);
                return this.evaluateManyToMany(iter1, iter2, context);
            }
        }
        return false;
    }

    private boolean evaluateOneToOne(AtomicValue value0, AtomicValue value1, XPathContext context) throws XPathException {
        try {
            return value0 != null && value1 != null && GeneralComparison.compare(value0, this.singletonOperator, value1, this.comparer, this.needsRuntimeCheck, context, this.getRetainedStaticContext());
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getLocation());
            e.maybeSetContext(context);
            throw e;
        }
    }

    private boolean evaluateManyToOne(SequenceIterator iter0, AtomicValue value1, XPathContext context) throws XPathException {
        try {
            AtomicValue item0;
            if (value1 == null) {
                return false;
            }
            while ((item0 = (AtomicValue)iter0.next()) != null) {
                if (!GeneralComparison.compare(item0, this.singletonOperator, value1, this.comparer, this.needsRuntimeCheck, context, this.getRetainedStaticContext())) continue;
                iter0.close();
                return true;
            }
            return false;
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getLocation());
            e.maybeSetContext(context);
            throw e;
        }
    }

    public boolean evaluateManyToMany(SequenceIterator iter0, SequenceIterator iter1, XPathContext context) throws XPathException {
        try {
            boolean exhausted0 = false;
            boolean exhausted1 = false;
            ArrayList<AtomicValue> value0 = new ArrayList<AtomicValue>();
            ArrayList<AtomicValue> value1 = new ArrayList<AtomicValue>();
            while (true) {
                if (!exhausted0) {
                    AtomicValue item0 = (AtomicValue)iter0.next();
                    if (item0 == null) {
                        if (exhausted1) {
                            return false;
                        }
                        exhausted0 = true;
                    } else {
                        for (AtomicValue item1 : value1) {
                            if (!GeneralComparison.compare(item0, this.singletonOperator, item1, this.comparer, this.needsRuntimeCheck, context, this.getRetainedStaticContext())) continue;
                            iter0.close();
                            iter1.close();
                            return true;
                        }
                        if (!exhausted1) {
                            value0.add(item0);
                        }
                    }
                }
                if (exhausted1) continue;
                AtomicValue item1 = (AtomicValue)iter1.next();
                if (item1 == null) {
                    if (exhausted0) {
                        return false;
                    }
                    exhausted1 = true;
                    continue;
                }
                for (AtomicValue item0 : value0) {
                    if (!GeneralComparison.compare(item0, this.singletonOperator, item1, this.comparer, this.needsRuntimeCheck, context, this.getRetainedStaticContext())) continue;
                    iter0.close();
                    iter1.close();
                    return true;
                }
                if (exhausted0) continue;
                value1.add(item1);
            }
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getLocation());
            e.maybeSetContext(context);
            throw e;
        }
    }

    public static boolean compare(AtomicValue a0, int operator, AtomicValue a1, AtomicComparer comparer, boolean checkTypes, XPathContext context, NamespaceResolver nsResolver) throws XPathException {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        boolean u0 = a0 instanceof UntypedAtomicValue;
        boolean u1 = a1 instanceof UntypedAtomicValue;
        if (u0 != u1) {
            if (u0) {
                if (a1 instanceof NumericValue) {
                    return GeneralComparison.quickCompare((UntypedAtomicValue)a0, (NumericValue)a1, operator, rules);
                }
                StringConverter sc = a1.getItemType().getPrimitiveItemType().getStringConverter(rules);
                if (a1 instanceof QualifiedNameValue) {
                    sc = (StringConverter)sc.setNamespaceResolver(nsResolver);
                }
                a0 = sc.convertString(a0.getStringValueCS()).asAtomic();
            } else {
                if (a0 instanceof NumericValue) {
                    return GeneralComparison.quickCompare((UntypedAtomicValue)a1, (NumericValue)a0, Token.inverse(operator), rules);
                }
                StringConverter sc = a0.getItemType().getPrimitiveItemType().getStringConverter(rules);
                if (a0 instanceof QualifiedNameValue) {
                    sc = (StringConverter)sc.setNamespaceResolver(nsResolver);
                }
                a1 = sc.convertString(a1.getStringValueCS()).asAtomic();
            }
            checkTypes = false;
        }
        return ValueComparison.compare(a0, operator, a1, comparer.provideContext(context), checkTypes);
    }

    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public static int getCorrespondingSingletonOperator(int op) {
        switch (op) {
            case 6: {
                return 50;
            }
            case 13: {
                return 54;
            }
            case 22: {
                return 51;
            }
            case 12: {
                return 53;
            }
            case 11: {
                return 52;
            }
            case 14: {
                return 55;
            }
        }
        return op;
    }

    protected GeneralComparison getInverseComparison() {
        GeneralComparison gc2 = new GeneralComparison(this.getRhsExpression(), Token.inverse(this.operator), this.getLhsExpression());
        gc2.setRetainedStaticContext(this.getRetainedStaticContext());
        return gc2;
    }

    public String tag() {
        return "gc";
    }

    protected void explainExtraAttributes(ExpressionPresenter out) {
        String cc = "";
        switch (this.comparisonCardinality) {
            case 0: {
                cc = "1:1";
                break;
            }
            case 1: {
                cc = "N:1";
                break;
            }
            case 2: {
                cc = "M:N";
            }
        }
        out.emitAttribute("card", cc);
        out.emitAttribute("comp", this.comparer.save());
    }

    public static boolean quickCompare(UntypedAtomicValue a0, NumericValue a1, int operator, ConversionRules rules) throws XPathException {
        int comp;
        double d1 = a1.getDoubleValue();
        DoubleValue dv0 = a0.getDoubleValueIfKnown();
        if (dv0 != null) {
            double d0 = dv0.getDoubleValue();
            comp = Double.compare(d0, d1);
        } else {
            CharSequence cs = Whitespace.trimWhitespace(a0.getStringValueCS());
            boolean simple = true;
            int wholePartLength = 0;
            int firstDigit = -1;
            int decimalPoints = 0;
            int sign = 63;
            for (int i = 0; i < cs.length(); ++i) {
                char c = cs.charAt(i);
                if (c >= '0' && c <= '9') {
                    if (firstDigit < 0) {
                        firstDigit = c - 48;
                    }
                    if (decimalPoints != 0) continue;
                    ++wholePartLength;
                    continue;
                }
                if (c == '-') {
                    if (sign != 63 || wholePartLength > 0 || decimalPoints > 0) {
                        simple = false;
                        break;
                    }
                    sign = c;
                    continue;
                }
                if (c == '.') {
                    if (decimalPoints > 0) {
                        simple = false;
                        break;
                    }
                    decimalPoints = 1;
                    continue;
                }
                simple = false;
                break;
            }
            if (firstDigit < 0) {
                simple = false;
            }
            if (simple && wholePartLength > 0 && wholePartLength <= 10) {
                double lowerBound = bounds[firstDigit][wholePartLength];
                double upperBound = bounds[firstDigit + 1][wholePartLength];
                if (sign == 45) {
                    double temp = lowerBound;
                    lowerBound = -upperBound;
                    upperBound = -temp;
                }
                switch (operator) {
                    case 50: {
                        if (!(lowerBound > d1) && !(upperBound < d1)) break;
                        return false;
                    }
                    case 55: {
                        if (lowerBound > d1) {
                            return false;
                        }
                        if (!(upperBound <= d1)) break;
                        return true;
                    }
                    case 53: {
                        if (lowerBound >= d1) {
                            return false;
                        }
                        if (!(upperBound < d1)) break;
                        return true;
                    }
                    case 54: {
                        if (upperBound < d1) {
                            return false;
                        }
                        if (!(lowerBound >= d1)) break;
                        return true;
                    }
                    case 52: {
                        if (upperBound <= d1) {
                            return false;
                        }
                        if (!(lowerBound > d1)) break;
                        return true;
                    }
                    case 51: {
                        if (!(upperBound < d1) && !(lowerBound > d1)) break;
                        return true;
                    }
                }
            }
            if (simple && decimalPoints == 0 && wholePartLength <= 15 && a1 instanceof Int64Value) {
                long l0 = Long.parseLong(a0.getStringValue());
                comp = new Long(l0).compareTo(a1.longValue());
            } else {
                double d0 = ((DoubleValue)BuiltInAtomicType.DOUBLE.getStringConverter(rules).convertString(cs).asAtomic()).getDoubleValue();
                a0.setDoubleValue(new DoubleValue(d0));
                comp = Double.compare(d0, d1);
            }
        }
        switch (operator) {
            case 50: {
                return comp == 0;
            }
            case 55: {
                return comp <= 0;
            }
            case 53: {
                return comp < 0;
            }
            case 54: {
                return comp >= 0;
            }
            case 52: {
                return comp > 0;
            }
        }
        return comp != 0;
    }
}

