/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.Vector;
import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.ArchiveObjectsDBImpl;
import nl.mpi.corpusstructure.ArchiveObjectsDBWrite;
import nl.mpi.corpusstructure.ArchiveObjectsDBWriteImpl;
import nl.mpi.corpusstructure.CorpusStructureDB;
import nl.mpi.corpusstructure.CorpusStructureDBWrite;
import nl.mpi.corpusstructure.Node;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.corpusstructure.UpdateInProgressException;
import nl.mpi.util.DBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorpusStructureDBWriteImpl
extends ArchiveObjectsDBWriteImpl
implements ArchiveObjectsDB,
ArchiveObjectsDBWrite,
CorpusStructureDB,
CorpusStructureDBWrite {
    protected static final Logger logger = LoggerFactory.getLogger(CorpusStructureDBWriteImpl.class);
    private HashSet issuedCorpusNodes = new HashSet();
    private PreparedStatement newNodeInCorpusStructureSTM = null;
    private PreparedStatement newNodeInCorpusNodesSTM = null;
    private PreparedStatement updateNodeInCorpusNodesSTM = null;

    public CorpusStructureDBWriteImpl(String dbname, boolean bootstrapMode, String user, String passwd) throws UpdateInProgressException {
        super(dbname, bootstrapMode, user, passwd);
        this.initPreparedStatements();
        logger.debug("## CorpusStructureDBWriteImpl constructor done");
    }

    @Override
    protected synchronized void initPreparedStatements() {
        super.initPreparedStatements();
        try {
            int i;
            this.newNodeInCorpusNodesSTM = this.db.getConnection().prepareStatement("INSERT INTO " + CorpusStructureDBWriteImpl.getCORPUSNODES() + " (NODEID, NODETYPE, FORMAT, NAME, TITLE) VALUES (?,?,?,?,?)");
            this.updateNodeInCorpusNodesSTM = this.db.getConnection().prepareStatement("UPDATE " + CorpusStructureDBWriteImpl.getCORPUSNODES() + " SET NODETYPE = ?, FORMAT = ?, NAME = ?, TITLE = ?" + " WHERE NODEID = ?");
            StringBuilder cmd = new StringBuilder(200);
            cmd.append("INSERT INTO ");
            cmd.append(CorpusStructureDBWriteImpl.getCORPUSSTRUCTURE());
            cmd.append(" (NODEID, VPATH, CANONICAL");
            for (i = 0; i < 3; ++i) {
                cmd.append(", VPATH" + i);
            }
            cmd.append(") VALUES (?,?,?");
            for (i = 0; i < 3; ++i) {
                cmd.append(",?");
            }
            cmd.append(")");
            this.newNodeInCorpusStructureSTM = this.db.getConnection().prepareStatement(cmd.toString());
        }
        catch (SQLException e) {
            logger.error("initPreparedStatements: SQLException: " + e, (Throwable)e);
        }
    }

    @Override
    protected synchronized void closePreparedStatements() {
        super.closePreparedStatements();
        try {
            if (this.newNodeInCorpusStructureSTM != null) {
                this.newNodeInCorpusStructureSTM.close();
            }
            if (this.updateNodeInCorpusNodesSTM != null) {
                this.updateNodeInCorpusNodesSTM.close();
            }
            if (this.newNodeInCorpusNodesSTM != null) {
                this.newNodeInCorpusNodesSTM.close();
            }
        }
        catch (SQLException sqle) {
            logger.error("closePreparedStatements: ", (Throwable)sqle);
        }
        this.newNodeInCorpusStructureSTM = null;
        this.updateNodeInCorpusNodesSTM = null;
        this.newNodeInCorpusNodesSTM = null;
    }

    @Override
    public void shutdown() {
        this.issuedCorpusNodes.clear();
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setNode(String nodeId, int nodeType, String format, String name, String title) throws UpdateInProgressException, UnknownNodeException {
        boolean log = false;
        if (!this.statusLog("setNode")) {
            return false;
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error("setNode: Not a NodeId: " + nodeId + " nodeType=" + nodeType + " format=" + format + " name=" + name + " title=" + title);
            throw new UnknownNodeException("setNode: Not a NodeId: " + nodeId);
        }
        try {
            boolean n = false;
            if (this.isBootstrapMode() && !this.issuedCorpusNodes.contains(nodeId)) {
                throw new UnknownNodeException("create me, don't modify me");
            }
            if (this.isBootstrapMode()) {
                logger.warn("setNode: Update! Bootstrap mode should not touch nodes twice: " + nodeId);
            }
            Node node = this.getNode(nodeId);
            if (format == null) {
                format = node.getFormat();
            }
            if (name == null) {
                name = node.getName();
            }
            if (title == null) {
                title = node.getTitle();
            }
            if (log) {
                logger.debug("# setNode: UPDATE " + nodeId + " " + name + " " + nodeType);
            }
            PreparedStatement preparedStatement = this.updateNodeInCorpusNodesSTM;
            synchronized (preparedStatement) {
                this.updateNodeInCorpusNodesSTM.clearParameters();
                this.updateNodeInCorpusNodesSTM.setInt(1, nodeType);
                this.updateNodeInCorpusNodesSTM.setString(2, format);
                this.updateNodeInCorpusNodesSTM.setString(3, name);
                this.updateNodeInCorpusNodesSTM.setString(4, title);
                this.updateNodeInCorpusNodesSTM.setInt(5, NodeIdUtils.TOINT(nodeId));
                if (this.updateNodeInCorpusNodesSTM.executeUpdate() > 0) {
                    return true;
                }
            }
        }
        catch (SQLException sqle) {
            logger.error("setNode: SQL exception in update: " + sqle);
        }
        catch (UnknownNodeException une) {
            // empty catch block
        }
        if (log) {
            logger.debug("# setNode: CREATE " + nodeId + " " + name + " " + nodeType);
        }
        try {
            PreparedStatement une = this.newNodeInCorpusNodesSTM;
            synchronized (une) {
                boolean okay;
                this.newNodeInCorpusNodesSTM.clearParameters();
                this.newNodeInCorpusNodesSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                this.newNodeInCorpusNodesSTM.setInt(2, nodeType);
                this.newNodeInCorpusNodesSTM.setString(3, format);
                this.newNodeInCorpusNodesSTM.setString(4, name);
                this.newNodeInCorpusNodesSTM.setString(5, title);
                boolean bl = okay = this.newNodeInCorpusNodesSTM.executeUpdate() > 0;
                if (okay && this.isBootstrapMode()) {
                    this.issuedCorpusNodes.add(nodeId);
                }
                return okay;
            }
        }
        catch (SQLException sqle) {
            logger.error("setNode: SQL exception in create: " + sqle);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteCorpusNode(String nodeId) throws UnknownNodeException, UpdateInProgressException {
        if (!this.statusLog("deleteCorpusNode")) {
            return false;
        }
        this.checkWriteAccess();
        if (this.isBootstrapMode()) {
            this.panic("deleteCorpusNode");
        }
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error("deleteCorpusNode: invalidNodeId: " + nodeId);
            throw new UnknownNodeException("deleteCorpusNode: invalid NodeId: " + nodeId);
        }
        int n = 0;
        Statement statement = null;
        DBConnection dBConnection = this.db;
        synchronized (dBConnection) {
            try {
                statement = this.db.getConnection().createStatement();
                String cmd1 = "DELETE FROM " + CorpusStructureDBWriteImpl.getCORPUSNODES() + " WHERE NODEID = " + NodeIdUtils.TOINT(nodeId);
                n = statement.executeUpdate(cmd1);
                if (n == 0) {
                    this.throwUnknownNodeException("deleteCorpusNode", "", nodeId);
                }
                boolean bl = true;
                return bl;
            }
            catch (SQLException sqle) {
                logger.error("deleteCorpusNode: SQL exception: " + sqle);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sqle) {
                        logger.error("deleteCorpusNode: Failed to close statement: " + sqle);
                    }
                }
                statement = null;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCorpusStructureEntry(String nodeId, String cvPath, boolean canonical) throws UpdateInProgressException, UnknownNodeException {
        if (!this.statusLog("addCorpusStructureEntry")) {
            return;
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error("addCorpusStructureEntry: invalidNodeId: " + nodeId + ", " + cvPath + ", " + canonical);
            throw new UnknownNodeException("addCorpusStructureEntry: invalid NodeId: " + nodeId + ", " + cvPath + ", " + canonical);
        }
        try {
            this.cacheExpire(nodeId);
            PreparedStatement preparedStatement = this.newNodeInCorpusStructureSTM;
            synchronized (preparedStatement) {
                this.setNewNodeInCorpusStructureSTM(nodeId, cvPath, canonical);
                this.newNodeInCorpusStructureSTM.executeUpdate();
            }
            this.cacheExpire(nodeId);
            return;
        }
        catch (SQLException sqle) {
            logger.error("addCorpusStructureEntry: SQL exception: " + sqle);
            return;
        }
    }

    @Override
    public boolean addLinkToTree(String nodeId, String parentNodeId, boolean canonical, boolean childIsIMDI) throws UnknownNodeException, UpdateInProgressException {
        if (!this.statusLog("addLinkToTree")) {
            return false;
        }
        this.checkWriteAccess();
        if (this.isBootstrapMode()) {
            this.panic("addLinkToTree");
        }
        if (!NodeIdUtils.isNodeId(nodeId) || parentNodeId != null && !NodeIdUtils.isNodeId(parentNodeId)) {
            logger.error("addLinkToTree: must use NodeIds: " + nodeId + ", " + parentNodeId + ", " + canonical);
            throw new UnknownNodeException("addLinkToTree: must use NodeIds: " + nodeId + ", " + parentNodeId + ", " + canonical);
        }
        String[] pathsToReplaceWith = new String[]{""};
        if (parentNodeId != null) {
            pathsToReplaceWith = this.getVPaths(parentNodeId);
        }
        boolean okay = true;
        for (int i = 0; pathsToReplaceWith != null && i < pathsToReplaceWith.length; ++i) {
            String childPath = pathsToReplaceWith[i] + '/' + parentNodeId;
            okay &= this.addLinkToPath(nodeId, parentNodeId, childPath, canonical, childIsIMDI);
        }
        return okay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addLinkToPath(String nodeId, String parentNodeId, String childPath, boolean canonical, boolean childIsIMDI) throws UnknownNodeException, UpdateInProgressException {
        statement = null;
        pathToReplaceWith = "";
        pathToReplaceWith = childPath;
        descendants = null;
        try {
            if (childIsIMDI) {
                descendants = this.listDescendants(nodeId);
            }
        }
        catch (UnknownNodeException une) {
            // empty catch block
        }
        var9_10 = this.db;
        synchronized (var9_10) {
            try {
                newCVPath = pathToReplaceWith;
                statement = this.db.getConnection().createStatement();
                this.cacheExpire(nodeId);
                this.db.getConnection().setAutoCommit(false);
                if (canonical) {
                    cmd = "UPDATE " + CorpusStructureDBWriteImpl.getCORPUSSTRUCTURE() + " SET CANONICAL = FALSE " + "WHERE NODEID = " + NodeIdUtils.TOINT(nodeId);
                    statement.executeUpdate((String)cmd);
                }
                cmd = this.newNodeInCorpusStructureSTM;
                synchronized (cmd) {
                    this.setNewNodeInCorpusStructureSTM(nodeId, newCVPath, canonical);
                    this.newNodeInCorpusStructureSTM.executeUpdate();
                    ** if (descendants != null && descendants.length != 0) goto lbl30
                }
lbl-1000:
                // 1 sources

                {
                    cmd = true;
                    return cmd;
                }
lbl30:
                // 1 sources

                CorpusStructureDBWriteImpl.logger.debug("addLinkToPath: changing also ndescendants = " + descendants.length + " child = " + nodeId + ", vPath parent = " + pathToReplaceWith);
                for (i = 0; i < descendants.length; ++i) {
                    descId = descendants[i];
                    pathsToDesc = this.getVPaths(descId);
                    pathToDesc = "";
                    idx = -1;
                    for (j = 0; j < pathsToDesc.length && (idx = (pathToDesc = pathsToDesc[j]).indexOf(nodeId)) == -1; ++j) {
                    }
                    if (idx == -1) {
                        CorpusStructureDBWriteImpl.logger.error("addLinkToPath: desc=" + descId + " has vpath not touching ancestor=" + nodeId);
                        var16_29 = false;
                        return var16_29;
                    }
                    newCVPath = pathToReplaceWith + '/' + pathToDesc.substring(idx);
                    var16_28 = this.newNodeInCorpusStructureSTM;
                    synchronized (var16_28) {
                        this.setNewNodeInCorpusStructureSTM(descId, newCVPath, false);
                        this.newNodeInCorpusStructureSTM.executeUpdate();
                        continue;
                    }
                }
                i = 1;
                return (boolean)i;
            }
            catch (SQLException sqle) {
                try {
                    this.db.getConnection().rollback();
                    this.db.getConnection().setAutoCommit(true);
                }
                catch (SQLException e1) {
                    CorpusStructureDBWriteImpl.logger.error("addLinkToPath", (Throwable)e1);
                }
                CorpusStructureDBWriteImpl.logger.error("addLinkToPath", (Throwable)sqle);
            }
            finally {
                try {
                    this.db.getConnection().commit();
                    this.db.getConnection().setAutoCommit(true);
                }
                catch (SQLException sqle) {
                    CorpusStructureDBWriteImpl.logger.error("addLinkToPath", (Throwable)sqle);
                }
                this.cacheExpire(nodeId);
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sqle) {
                        CorpusStructureDBWriteImpl.logger.error("addLinkToPath: Failed to close statement: " + sqle);
                    }
                }
                statement = null;
            }
            return false;
        }
    }

    @Override
    public synchronized String[] deleteLinksRecursively(String nodeId) throws UnknownNodeException, UpdateInProgressException {
        if (!this.statusLog("deleteLinksRecursively")) {
            return null;
        }
        this.checkWriteAccess();
        if (this.isBootstrapMode()) {
            this.panic("deleteLinksRecursively");
        }
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error("deleteLinksRecursively: Not a NodeId: " + nodeId);
            throw new UnknownNodeException("deleteLinksRecursively: Not a NodeId: " + nodeId);
        }
        Vector orphans = new Vector();
        String[] vPaths = this.getVPaths(nodeId);
        if (vPaths == null || vPaths.length == 0) {
            throw new UnknownNodeException("deleteLinksRecursively: Node " + nodeId + " was not part of the tree");
        }
        this.cacheExpire(null);
        for (int i = 0; i < vPaths.length; ++i) {
            String vPath = vPaths[i];
            orphans.addAll(this.removeChildOfPath(vPath, nodeId, false));
        }
        if (vPaths.length > 1) {
            logger.debug("deleteLinksRecursively: deleted " + vPaths.length + " paths to " + nodeId);
        }
        this.cacheExpire(null);
        return orphans.toArray(new String[0]);
    }

    @Override
    public synchronized String[] removeLink(String nodeId, String childNodeId) throws UnknownNodeException, UpdateInProgressException {
        if (!this.statusLog("removeLink")) {
            return null;
        }
        this.checkWriteAccess();
        if (this.isBootstrapMode()) {
            this.panic("removeLink");
        }
        if (!NodeIdUtils.isNodeId(nodeId) || !NodeIdUtils.isNodeId(childNodeId)) {
            logger.error("removeLink: must use NodeIds: " + nodeId + ", " + childNodeId);
            throw new UnknownNodeException("removeLink: must use NodeIds: " + nodeId + ", " + childNodeId);
        }
        Vector orphans = new Vector();
        String[] vPaths = this.getVPaths(nodeId);
        if (vPaths == null || vPaths.length == 0) {
            throw new UnknownNodeException("removeLink: Parent node " + nodeId + " was not part of the tree");
        }
        this.cacheExpire(null);
        for (int i = 0; i < vPaths.length; ++i) {
            String vPath = vPaths[i] + "/" + nodeId;
            orphans.addAll(this.removeChildOfPath(vPath, childNodeId, true));
        }
        if (vPaths.length > 1) {
            logger.debug("removeLink: " + vPaths.length + " paths to " + nodeId);
        }
        this.cacheExpire(null);
        return orphans.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector removeChildOfPath(String vPath, String childNodeId, boolean removeLink) throws UnknownNodeException, UpdateInProgressException {
        ResultSet rs = null;
        Statement statement = null;
        Statement ps = null;
        String cmd = null;
        Vector<String> orphans = new Vector<String>();
        try {
            statement = this.db.getConnection().createStatement();
            this.db.getConnection().setAutoCommit(false);
            String cpath = vPath + '/' + childNodeId;
            String cpathQuery = this.matchVPathColumnsSQL(cpath, false);
            cmd = "SELECT NODEID,VPATH FROM " + CorpusStructureDBWriteImpl.getCORPUSSTRUCTURE() + " AS CS1" + " WHERE (" + cpathQuery + ")" + " AND NOT EXISTS ( SELECT NODEID FROM " + CorpusStructureDBWriteImpl.getCORPUSSTRUCTURE() + " AS CS2 " + " WHERE CS1.NODEID = CS2.NODEID AND NOT (" + cpathQuery.replace("VPATH", "CS2.VPATH") + ") )";
            rs = statement.executeQuery(cmd);
            while (rs.next()) {
                String node = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
                logger.debug("// removeChildOfPath: Orphan grandchild of " + childNodeId + ": " + node);
                orphans.add(node);
            }
            rs.close();
            rs = null;
            int n = 0;
            if (removeLink) {
                cmd = "DELETE FROM " + CorpusStructureDBWriteImpl.getCORPUSSTRUCTURE() + " WHERE NODEID = ? AND VPATH = ?";
                ps = this.db.getConnection().prepareStatement(cmd);
                ps.setInt(1, NodeIdUtils.TOINT(childNodeId));
                ps.setString(2, vPath);
                n = ps.executeUpdate();
                ps.close();
                ps = null;
                if (n == 0) {
                    logger.warn("removeChildOfPath: ignored call: " + vPath + " does not lead to " + childNodeId);
                    Vector<String> vector = orphans;
                    return vector;
                }
            } else {
                Vector<String> vector = orphans;
                return vector;
            }
            cmd = "DELETE FROM " + CorpusStructureDBWriteImpl.getCORPUSSTRUCTURE() + " WHERE " + cpathQuery;
            int m = statement.executeUpdate(cmd);
            if (n > 1 || m > 0) {
                logger.debug("removeChildOfPath: removed " + n + " links at " + vPath + " - " + childNodeId + " and " + m + " links to grandchildren");
            }
            ps = this.db.getConnection().prepareStatement("SELECT CANONICAL, VPATH FROM " + CorpusStructureDBWriteImpl.getCORPUSSTRUCTURE() + " WHERE NODEID = ? ORDER BY CANONICAL DESC");
            ps.setInt(1, NodeIdUtils.TOINT(childNodeId));
            rs = ps.executeQuery();
            String newCanonicalPath = null;
            boolean canonicalPathStillFirst = false;
            if (rs.next()) {
                if (rs.getBoolean("CANONICAL")) {
                    canonicalPathStillFirst = true;
                } else {
                    newCanonicalPath = rs.getString("VPATH");
                }
            }
            rs.close();
            rs = null;
            ps.close();
            ps = null;
            if (canonicalPathStillFirst) {
                Vector<String> vector = orphans;
                return vector;
            }
            if (newCanonicalPath == null) {
                logger.debug("removeLink created orphan child " + childNodeId);
                orphans.add(childNodeId);
                Vector<String> vector = orphans;
                return vector;
            }
            cmd = "UPDATE " + CorpusStructureDBWriteImpl.getCORPUSSTRUCTURE() + " SET CANONICAL = TRUE WHERE NODEID = ? AND VPATH = ?";
            ps = this.db.getConnection().prepareStatement(cmd);
            ps.setInt(1, NodeIdUtils.TOINT(childNodeId));
            ps.setString(2, newCanonicalPath);
            n = ps.executeUpdate();
            ps.close();
            ps = null;
            if (n == 0) {
                logger.warn("removeLink: No canonical path left for " + childNodeId);
            }
            if (n > 1) {
                logger.error("removeLink: There are now several canonical paths for " + childNodeId);
            }
            Vector<String> vector = orphans;
            return vector;
        }
        catch (SQLException sqle) {
            try {
                this.db.getConnection().rollback();
                this.db.getConnection().setAutoCommit(true);
            }
            catch (SQLException e1) {
                logger.error("removeChildOfPath: Failed to rollback transaction: " + e1);
            }
            logger.error("removeChildOfPath: SQL exception in command: " + cmd + " -> " + sqle);
        }
        finally {
            try {
                this.db.getConnection().commit();
                this.db.getConnection().setAutoCommit(true);
            }
            catch (SQLException sqle) {
                logger.error("removeChildOfPath: Failed to commit transaction: " + sqle);
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    logger.error("removeChildOfPath: Failed to close statement: " + sqle);
                }
            }
            statement = null;
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sqle) {
                    logger.error("removeChildOfPath: Failed to close prepared statement: " + sqle);
                }
            }
            ps = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    logger.error("removeChildOfPath: Failed to close result set: " + sqle);
                }
            }
            rs = null;
        }
        throw new UnknownNodeException("removeChildOfPath: error, no result for: " + vPath + " - " + childNodeId);
    }

    @Override
    public void replaceDescendantAccessRights(String nodeId, String oldReadRights, String newRights) throws UpdateInProgressException, UnknownNodeException {
        this.replaceDescendantAccessRights(nodeId, oldReadRights, newRights, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceDescendantAccessRights(String nodeId, String newReadRights, String newWriteRights, int newAccessLevel) throws UpdateInProgressException, UnknownNodeException {
        if (!this.statusLog("replaceDescendantAccessRights")) {
            return;
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error("replaceDescendantAccessRights: not a nodeId: " + nodeId);
            throw new UnknownNodeException("replaceDescendantAccessRights: not a nodeId: " + nodeId);
        }
        if (this.isBootstrapMode()) {
            logger.warn("replaceDescendantAccessRights: ignored in bootstrap mode");
            return;
        }
        if (newWriteRights != null && !newWriteRights.matches("^[a-zA-Z0-9_@.,;: -]*$")) {
            throw new IllegalArgumentException("replaceDescendantAccessRights: new write rights contain unsupported characters: " + newWriteRights);
        }
        if (newReadRights != null && !newReadRights.matches("^[a-zA-Z0-9_@.,;: -]*$")) {
            throw new IllegalArgumentException("replaceDescendantAccessRights: new read rights contain unsupported characters: " + newReadRights);
        }
        if (!(newReadRights == null || newReadRights.equals("everybody") || newReadRights.equals("nobody") || newReadRights.equals("cleared") || newReadRights.equals("anyAuthenticatedUser") || newReadRights.equals("ignore"))) {
            throw new IllegalArgumentException("replaceDescendantAccessRights:new read rights must be one of the AccessInfo constants, not: " + newReadRights);
        }
        if (!(newWriteRights == null || newWriteRights.equals("everybody") || newWriteRights.equals("nobody") || newWriteRights.equals("cleared") || newWriteRights.equals("anyAuthenticatedUser"))) {
            throw new IllegalArgumentException("replaceDescendantAccessRights: new write rights must be one of the AccessInfo constants, not: " + newWriteRights);
        }
        if (newAccessLevel != -1 && newAccessLevel != 1 && newAccessLevel != 2 && newAccessLevel != 3 && newAccessLevel != 4) {
            throw new IllegalArgumentException("replaceDescendantAccessRigths: new access level must be one of the AccessInfo constants, not: " + newAccessLevel);
        }
        logger.debug("replaceDescendantAccessRights: nodeId=" + nodeId + " newReadRights=" + newReadRights + " newWriteRights=" + newWriteRights + " newAccessLevel=" + newAccessLevel);
        boolean iterate = this.getRootNodeId().equals(nodeId);
        Statement statement = null;
        String rightQuery = "";
        String query = null;
        String vPath = this.getCanonicalVPath(nodeId) + "/" + nodeId;
        String vq = this.matchVPathColumnsSQL(vPath, false);
        query = "SELECT DISTINCT NODEID FROM " + CorpusStructureDBWriteImpl.getCORPUSSTRUCTURE() + " WHERE " + vq + " OR NODEID = " + NodeIdUtils.TOINT(nodeId);
        String uQuery = "UPDATE " + CorpusStructureDBWriteImpl.getARCHIVEOBJECTS() + " SET ";
        if (newReadRights != null) {
            uQuery = uQuery + "READRIGHTS = '" + newReadRights + "', ";
        }
        if (newWriteRights != null) {
            uQuery = uQuery + "WRITERIGHTS = '" + newWriteRights + "', ";
        }
        uQuery = uQuery + "ACCESSLEVEL = " + newAccessLevel;
        if (vq.toUpperCase().indexOf("LIKE") == -1 && vq.toUpperCase().indexOf("BETWEEN") == -1) {
            iterate = true;
        }
        if (vq.toUpperCase().indexOf("VPATH2") != -1) {
            iterate = false;
        }
        if (this.db.dbType == 1) {
            iterate = false;
        }
        uQuery = iterate ? uQuery + " WHERE " + rightQuery + "EXISTS ( " + query.replace("DISTINCT", "") + " AND " + CorpusStructureDBWriteImpl.getARCHIVEOBJECTS() + ".NODEID = " + CorpusStructureDBWriteImpl.getCORPUSSTRUCTURE() + ".NODEID )" : uQuery + " WHERE " + rightQuery + "NODEID IN ( " + query + " )";
        logger.debug("### replaceDescendantAccessRights: query = " + uQuery);
        try {
            statement = this.db.getConnection().createStatement();
            int n = statement.executeUpdate(uQuery);
            logger.info("replaceDescendantAccessRights: updated access rights n=" + n);
        }
        catch (SQLException sqle) {
            logger.error("replaceDescendantAccessRights: ", (Throwable)sqle);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    logger.error("replaceDescendantAccessRights: Failed to close statement: " + sqle);
                }
            }
            statement = null;
        }
    }

    protected void setNewNodeInCorpusStructureSTM(String nodeId, String vPath, boolean canonical) throws SQLException, UnknownNodeException {
        this.newNodeInCorpusStructureSTM.clearParameters();
        this.newNodeInCorpusStructureSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
        this.newNodeInCorpusStructureSTM.setString(2, vPath);
        this.newNodeInCorpusStructureSTM.setBoolean(3, canonical);
        String[] id = vPath.split("/");
        for (int i = 0; i < 3; ++i) {
            if (i < id.length - 1) {
                this.newNodeInCorpusStructureSTM.setInt(4 + i, NodeIdUtils.TOINT(id[i + 1]));
                continue;
            }
            this.newNodeInCorpusStructureSTM.setNull(4 + i, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] listDescendants(String nodeId) throws UnknownNodeException {
        if (!this.statusLog("listDescendants")) {
            return null;
        }
        String query = "SELECT nodeid FROM " + CorpusStructureDBWriteImpl.getCORPUSSTRUCTURE() + " WHERE ";
        String[] vPaths = this.getVPaths(nodeId);
        if (vPaths == null || vPaths.length == 0) {
            logger.error("listDescendants: Node is not linked: " + nodeId);
            return null;
        }
        String[] commonPathElements = vPaths[0].split("/");
        if (vPaths.length > 1 && commonPathElements.length > 1) {
            for (int i = 1; i < vPaths.length; ++i) {
                String[] id = vPaths[i].split("/");
                for (int j = 0; j < commonPathElements.length; ++j) {
                    if (j >= id.length) {
                        commonPathElements[j] = null;
                    }
                    if (commonPathElements[j] == null || commonPathElements[j].equals(id[j])) continue;
                    commonPathElements[j] = null;
                }
            }
            StringBuilder commonPathBuilder = new StringBuilder();
            for (int i = 1; commonPathElements[i] != null && i < commonPathElements.length; ++i) {
                commonPathBuilder.append("/");
                commonPathBuilder.append(commonPathElements[i]);
            }
            String commonPath = commonPathBuilder.toString();
            if (commonPath.lastIndexOf("/") > 1) {
                query = query + this.matchVPathColumnsSQL(commonPath, false) + " AND ";
                logger.debug("listDescendants: Constraint for: " + nodeId + " Prefix: " + commonPath + "* Paths: " + vPaths.length);
            }
        }
        StringBuilder pathQueryBuilder = new StringBuilder(64);
        pathQueryBuilder.append("(");
        for (int i = 0; i < vPaths.length; ++i) {
            String vPath = vPaths[i] + "/" + nodeId;
            pathQueryBuilder.append(this.matchVPathColumnsSQL(vPath, false));
            if (i + 1 >= vPaths.length) continue;
            pathQueryBuilder.append(" OR ");
        }
        pathQueryBuilder.append(")");
        Statement statement = null;
        ResultSet rs = null;
        TreeSet<String[]> items = new TreeSet<String[]>(new ArchiveObjectsDBImpl.NodeIdComparator());
        try {
            String[] descId;
            statement = this.db.getConnection().createStatement();
            rs = statement.executeQuery(query + pathQueryBuilder.toString());
            while (rs.next()) {
                descId = NodeIdUtils.TONODEID(rs.getInt(1));
                items.add(descId);
            }
            descId = items.toArray(new String[0]);
            return descId;
        }
        catch (SQLException sqle) {
            logger.error("listDescendants: ", (Throwable)sqle);
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    logger.error("listDescendants: Failed to close statement: " + sqle);
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    logger.error("listDescendants: Failed to close result set: " + sqle);
                }
            }
            rs = null;
        }
    }

    @Override
    public void close() {
        if (this.issuedCorpusNodes != null) {
            this.issuedCorpusNodes.clear();
        }
        super.close();
    }

    private void panic(String method) {
        logger.error(method + " not allowed in bootstrap mode!");
        System.exit(1);
    }
}

