/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.archiving.tree;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import nl.mpi.archiving.tree.GenericTreeModelListener;
import nl.mpi.archiving.tree.GenericTreeModelProvider;
import nl.mpi.archiving.tree.LinkedTreeNode;

public class LinkedTreeModelProvider
implements GenericTreeModelProvider<LinkedTreeNode>,
Serializable {
    private final LinkedTreeNode rootNode;
    private final Set<GenericTreeModelListener> treeModelListeners;

    public LinkedTreeModelProvider(LinkedTreeNode rootNode) {
        this.rootNode = rootNode;
        this.treeModelListeners = new CopyOnWriteArraySet<GenericTreeModelListener>();
    }

    @Override
    public LinkedTreeNode getRoot() {
        return this.rootNode;
    }

    public LinkedTreeNode getChild(LinkedTreeNode parent, int index) {
        return parent.getChild(index);
    }

    @Override
    public int getChildCount(LinkedTreeNode parent) {
        return parent.getChildCount();
    }

    @Override
    public boolean isLeaf(LinkedTreeNode node) {
        return node.getChildCount() == 0;
    }

    @Override
    public int getIndexOfChild(LinkedTreeNode parent, LinkedTreeNode child) {
        return parent.getIndexOfChild(child);
    }

    @Override
    public void addTreeModelListener(GenericTreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(GenericTreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    @Override
    public void onDetach() {
    }

    @Override
    public Iterator<LinkedTreeNode> getChildren(LinkedTreeNode parent) {
        return new LinkedTreeNodeIterator(parent);
    }

    private static class LinkedTreeNodeIterator
    implements Iterator<LinkedTreeNode> {
        private final LinkedTreeNode parent;
        private int nextIndex = 0;

        public LinkedTreeNodeIterator(LinkedTreeNode parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.parent.getChildCount();
        }

        @Override
        public LinkedTreeNode next() {
            return this.parent.getChild(this.nextIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove linked tree nodes");
        }
    }
}

