/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.api.util;

import java.io.IOException;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultResourceResolver
implements LSResourceResolver {
    private static Logger logger = LoggerFactory.getLogger(DefaultResourceResolver.class);
    private EntityResolver entityResolver;

    public DefaultResourceResolver() {
        this((EntityResolver)new CatalogResolver());
    }

    public DefaultResourceResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        Exception exception = null;
        try {
            InputSource resolveEntity = this.entityResolver.resolveEntity(publicId, systemId);
            resolveEntity.setEncoding("UTF-8");
            DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
            LSInput lsInput = domImplementation.createLSInput();
            lsInput.setEncoding("UTF-8");
            lsInput.setByteStream(resolveEntity.getByteStream());
            lsInput.setCharacterStream(resolveEntity.getCharacterStream());
            return lsInput;
        }
        catch (ClassNotFoundException ex) {
            exception = ex;
        }
        catch (InstantiationException ex) {
            exception = ex;
        }
        catch (IllegalAccessException ex) {
            exception = ex;
        }
        catch (ClassCastException ex) {
            exception = ex;
        }
        catch (SAXException ex) {
            exception = ex;
        }
        catch (IOException ex) {
            exception = ex;
        }
        if (exception != null) {
            logger.error(String.format("Exception while attempting to resolve resource: type=%1$s nameSpaceUri=%2$s publicId=%3$s systemId=%4$s baseURI=%5$s", type, namespaceURI, publicId, systemId, baseURI), (Throwable)exception);
        }
        return null;
    }
}

