/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.dom;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.NamespaceContext;

public class CMDINamespaceContext
implements NamespaceContext {
    public static final String CMD_PREFIX = "cmd";
    public static final String XSI_PREFIX = "xsi";
    private final Map<String, String> prefixNsMap = new ConcurrentHashMap<String, String>();
    private final Map<String, List<String>> nsPrefixMap = new ConcurrentHashMap<String, List<String>>();

    public CMDINamespaceContext() {
        this.add("", "http://www.clarin.eu/cmd/");
        this.add(CMD_PREFIX, "http://www.clarin.eu/cmd/");
        this.add(XSI_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
    }

    private void add(String prefix, String namespaceURI) {
        this.prefixNsMap.put(prefix, namespaceURI);
        List<String> prefixes = this.nsPrefixMap.get(namespaceURI);
        if (prefixes == null) {
            prefixes = new CopyOnWriteArrayList<String>();
            this.nsPrefixMap.put(namespaceURI, prefixes);
        }
        prefixes.add(namespaceURI);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.prefixNsMap.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        List<String> prefixes = this.nsPrefixMap.get(namespaceURI);
        if (prefixes.size() > 0) {
            return prefixes.get(0);
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        List<String> prefixes = this.nsPrefixMap.get(namespaceURI);
        return prefixes.iterator();
    }
}

