/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.type.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import nl.mpi.metadata.api.type.MetadataDocumentTypeReader;
import nl.mpi.metadata.cmdi.api.dom.CMDIApiDOMBuilderFactory;
import nl.mpi.metadata.cmdi.api.dom.DOMBuilderFactory;
import nl.mpi.metadata.cmdi.api.type.CMDIProfile;
import nl.mpi.metadata.cmdi.api.type.CMDITypeException;
import nl.mpi.metadata.cmdi.api.type.impl.CMDIProfileImpl;
import nl.mpi.metadata.cmdi.api.type.impl.CmdiProfileElementSchemaReader;
import nl.mpi.metadata.cmdi.util.CMDIEntityResolver;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class CMDIProfileReader
implements MetadataDocumentTypeReader<CMDIProfile> {
    private static final Logger logger = LoggerFactory.getLogger(CMDIProfileReader.class);
    public static final QName CMD_TYPE_NAME = new QName("http://www.clarin.eu/cmd/", "CMD");
    public static final QName COMPONENTS_TYPE_NAME = new QName("http://www.clarin.eu/cmd/", "Components");
    public static final QName HEADER_TYPE_NAME = new QName("http://www.clarin.eu/cmd/", "Header");
    private final EntityResolver entityResolver;
    private DOMBuilderFactory domBuilderFactory;

    public CMDIProfileReader() {
        this(new CMDIEntityResolver());
    }

    public CMDIProfileReader(EntityResolver entityResolver) {
        this(entityResolver, new CMDIApiDOMBuilderFactory(entityResolver));
    }

    public CMDIProfileReader(EntityResolver entityResolver, DOMBuilderFactory domBuilderFactory) {
        this.entityResolver = entityResolver;
        this.domBuilderFactory = domBuilderFactory;
    }

    @Override
    public CMDIProfile read(URI uri) throws IOException, CMDITypeException {
        logger.debug("Reading profile at {}", (Object)uri);
        SchemaType schemaRoot = this.loadSchemaRootElement(uri);
        SchemaProperty schemaElement = this.loadRootComponentProperty(schemaRoot);
        StringBuilder rootPath = new StringBuilder("/cmd:CMD/cmd:Components/cmd:").append(schemaElement.getName().getLocalPart());
        List<String> headerNames = this.readHeaderNames(schemaRoot);
        CMDIProfileImpl profile = new CMDIProfileImpl(uri, schemaElement, rootPath, headerNames);
        try {
            Document schemaDom = this.getSchemaDocument(uri);
            CmdiProfileElementSchemaReader schemaReader = new CmdiProfileElementSchemaReader(schemaDom);
            schemaReader.readSchema(profile);
            return profile;
        }
        catch (ParserConfigurationException pcEx) {
            throw new CMDITypeException(profile, "Parser configuration exception while reading profile schema", (Throwable)pcEx);
        }
        catch (SAXException sEx) {
            throw new CMDITypeException(profile, "Parser exception while reading profile schema", (Throwable)sEx);
        }
    }

    private List<String> readHeaderNames(SchemaType cmdType) throws CMDITypeException {
        SchemaProperty headersProperty = this.findPropertyByName(cmdType, HEADER_TYPE_NAME);
        if (headersProperty == null) {
            logger.warn("No header element found in profile");
            return Collections.emptyList();
        }
        SchemaProperty[] headerProperties = headersProperty.getType().getProperties();
        ArrayList<String> headerNames = new ArrayList<String>(headerProperties.length);
        for (SchemaProperty headerProperty : headerProperties) {
            logger.debug("Found header item {}", (Object)headerProperty.getName());
            headerNames.add(headerProperty.getName().getLocalPart());
        }
        return headerNames;
    }

    private SchemaType loadSchemaRootElement(URI uri) throws IOException, CMDITypeException {
        InputStream inputStream = CMDIEntityResolver.getInputStreamForURI(this.entityResolver, uri);
        try {
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setCharacterEncoding("UTF-8");
            if (this.entityResolver != null) {
                xmlOptions.setEntityResolver(this.entityResolver);
            }
            SchemaTypeSystem sts = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{XmlObject.Factory.parse((InputStream)inputStream, (XmlOptions)xmlOptions)}, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)xmlOptions);
            SchemaType schemaType = this.findCmdType(sts);
            return schemaType;
        }
        catch (XmlException ex) {
            throw new CMDITypeException(null, "XML exception while loading schema " + uri, (Throwable)ex);
        }
        finally {
            inputStream.close();
        }
    }

    private SchemaType findCmdType(SchemaTypeSystem sts) throws CMDITypeException {
        SchemaType[] documentTypes = sts.documentTypes();
        if (documentTypes.length != 1) {
            throw new CMDITypeException(null, "DocumentTypes count for profile schema should be exactly 1, found " + documentTypes.length);
        }
        SchemaType cmdType = documentTypes[0].getElementProperty(CMD_TYPE_NAME).getType();
        if (cmdType == null) {
            throw new CMDITypeException(null, "Element CMD not found in profile schema");
        }
        return cmdType;
    }

    private SchemaProperty loadRootComponentProperty(SchemaType cmdType) throws CMDITypeException {
        SchemaProperty componentsElement = this.findPropertyByName(cmdType, COMPONENTS_TYPE_NAME);
        return this.findRootComponentElement(componentsElement);
    }

    private SchemaProperty findPropertyByName(SchemaType parentType, QName propertyName) throws CMDITypeException {
        SchemaProperty componentsType = parentType.getElementProperty(propertyName);
        if (componentsType == null) {
            throw new CMDITypeException(null, "Element Components not found in profile schema");
        }
        return componentsType;
    }

    private SchemaProperty findRootComponentElement(SchemaProperty componentsElement) throws CMDITypeException {
        SchemaProperty[] componentsChildren = componentsElement.getType().getElementProperties();
        if (componentsChildren.length != 1) {
            throw new CMDITypeException(null, "Expecting 1 root component for profile, found " + componentsChildren.length);
        }
        return componentsChildren[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getSchemaDocument(URI uri) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = this.domBuilderFactory.newDOMBuilder();
        InputStream schemaDomInputStream = CMDIEntityResolver.getInputStreamForURI(this.entityResolver, uri);
        try {
            Document document;
            Document document2 = document = documentBuilder.parse(schemaDomInputStream);
            return document2;
        }
        finally {
            schemaDomInputStream.close();
        }
    }
}

