/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import nl.nikhef.slcshttps.CAHttps;
import nl.nikhef.slcshttps.gui.NonEditableDefaultTableModel;

public class SerialPanel
extends JPanel
implements ActionListener {
    CAHttps ca = null;
    NonEditableDefaultTableModel serialModel;
    JButton actButton;
    JButton deactButton;
    private boolean showHttx;
    private boolean showBoth;
    private boolean maskHttps;

    public SerialPanel(CAHttps cAHttps, boolean bl) throws KeyStoreException {
        this.ca = cAHttps;
        this.showHttx = bl;
        this.maskHttps = this.ca.getMaskHttps();
        this.showBoth = this.ca.getUseHttx() && this.ca.getUseHttps() && !this.maskHttps;
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = this.ca.getCertificate();
        }
        catch (KeyStoreException keyStoreException) {
            x509Certificate = null;
            throw new KeyStoreException("SerialPanel: " + keyStoreException.getMessage());
        }
        this.serialModel = new NonEditableDefaultTableModel(0, 2);
        this.serialModel.addRow(new String[]{"Active serialnumber", this.getSerial(cAHttps, this.showHttx)});
        JTable jTable = new JTable(this.serialModel);
        jTable.setFocusable(false);
        if (this.showBoth) {
            jTable.getColumnModel().getColumn(0).setPreferredWidth(500);
            jTable.getColumnModel().getColumn(1).setPreferredWidth(500);
        } else {
            jTable.getColumnModel().getColumn(0).setPreferredWidth(333);
            jTable.getColumnModel().getColumn(1).setPreferredWidth(667);
        }
        Dimension dimension = jTable.getPreferredScrollableViewportSize();
        dimension.height = jTable.getRowHeight() * this.serialModel.getRowCount();
        jTable.setPreferredScrollableViewportSize(dimension);
        jTable.setTableHeader(null);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (this.showHttx) {
            jPanel.add(new JLabel("HTTX Client Certificate Information"));
        } else {
            jPanel.add(new JLabel("HTTPS Client Certificate Information"));
        }
        jPanel.add(Box.createRigidArea(new Dimension(0, jTable.getRowHeight() / 2)));
        jPanel.add(new JScrollPane(jTable));
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(0, jTable.getRowHeight() / 2)));
        if (bl) {
            this.add(this.getButtonPanel(x509Certificate != null, this.ca.getCAHttxCertNo() != null));
        } else {
            this.add(this.getButtonPanel(x509Certificate != null, this.ca.getCAHttpsCertNo() != null));
        }
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = actionEvent.getActionCommand();
        try {
            if (string2.equals("activate")) {
                if (this.showHttx) {
                    this.ca.setHttxSSLSocketFactory();
                }
                if (!this.showHttx || this.maskHttps) {
                    this.ca.setHttpsSSLSocketFactory();
                }
                this.actButton.setText("update");
                this.deactButton.setEnabled(true);
            } else if (string2.equals("deactivate")) {
                if (this.showHttx) {
                    this.ca.resetHttxSSLSocketFactory();
                }
                if (!this.showHttx || this.maskHttps) {
                    this.ca.resetHttpsSSLSocketFactory();
                }
                this.actButton.setText("activate");
                this.deactButton.setEnabled(false);
            }
            string = this.getSerial(this.ca, this.showHttx);
        }
        catch (Exception exception) {
            string = exception.getMessage();
        }
        this.serialModel.setValueAt(string, 0, 1);
    }

    private JPanel getButtonPanel(boolean bl, boolean bl2) {
        String string;
        String string2 = "activate";
        String string3 = "update";
        String string4 = string = "deactivate";
        this.actButton = new JButton(string4);
        this.deactButton = new JButton(string4);
        Dimension dimension = new Dimension(this.actButton.getPreferredSize());
        this.actButton.setPreferredSize(dimension);
        this.deactButton.setPreferredSize(dimension);
        this.actButton.addActionListener(this);
        this.actButton.setActionCommand("activate");
        this.deactButton.addActionListener(this);
        this.deactButton.setActionCommand("deactivate");
        this.deactButton.setText(string);
        if (bl) {
            this.actButton.setEnabled(true);
        } else {
            this.actButton.setEnabled(false);
        }
        if (bl2) {
            this.deactButton.setEnabled(true);
            this.actButton.setText(string3);
        } else {
            this.deactButton.setEnabled(false);
            this.actButton.setText(string2);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.actButton);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.deactButton);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private String getSerial(CAHttps cAHttps, boolean bl) {
        if (cAHttps == null) {
            return CAHttps.getSerialString(null);
        }
        return bl ? CAHttps.getSerialString(cAHttps.getCAHttxCertNo()) : CAHttps.getSerialString(cAHttps.getCAHttpsCertNo());
    }
}

