/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.archiving.corpusstructure.core;

public enum AccessLevel {
    ACCESS_LEVEL_UNKNOWN(-1),
    ACCESS_LEVEL_OPEN_EVERYBODY(1),
    ACCESS_LEVEL_OPEN_REGISTERED_USERS(2),
    ACCESS_LEVEL_PERMISSION_NEEDED(3),
    ACCESS_LEVEL_CLOSED(4),
    ACCESS_LEVEL_EXTERNAL(5);

    private final int numericalRepresentation;

    private AccessLevel(int numericalRepresentation) {
        this.numericalRepresentation = numericalRepresentation;
    }

    public int getNumericalRepresentation() {
        return this.numericalRepresentation;
    }

    public static AccessLevel fromInteger(Integer level) {
        AccessLevel lvl = ACCESS_LEVEL_UNKNOWN;
        switch (level) {
            case -1: {
                lvl = ACCESS_LEVEL_UNKNOWN;
                break;
            }
            case 1: {
                lvl = ACCESS_LEVEL_OPEN_EVERYBODY;
                break;
            }
            case 2: {
                lvl = ACCESS_LEVEL_OPEN_REGISTERED_USERS;
                break;
            }
            case 3: {
                lvl = ACCESS_LEVEL_PERMISSION_NEEDED;
                break;
            }
            case 4: {
                lvl = ACCESS_LEVEL_CLOSED;
                break;
            }
            case 5: {
                lvl = ACCESS_LEVEL_EXTERNAL;
            }
        }
        return lvl;
    }
}

