/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.archiving.corpusstructure.core.handle;

import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import nl.mpi.archiving.corpusstructure.core.URLConnections;
import nl.mpi.archiving.corpusstructure.core.handle.HandleResolver;
import nl.mpi.archiving.corpusstructure.core.handle.InvalidHandleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHandleResolver
implements HandleResolver,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(HttpHandleResolver.class);
    private final URLConnections connections = new URLConnections();

    @Override
    public URI resolve(URI uri) throws InvalidHandleException {
        try {
            if (uri.getScheme() == null) {
                throw new InvalidHandleException("Scheme is required");
            }
            if (uri.getScheme().equals("http") || uri.getScheme().equals("https")) {
                return this.resolve(uri.toURL()).toURI();
            }
            if (uri.getScheme().equalsIgnoreCase("hdl")) {
                return this.resolve(new URL("http://hdl.handle.net/" + uri.getSchemeSpecificPart())).toURI();
            }
            throw new InvalidHandleException("Handle uri scheme [" + uri.getScheme() + "] is invalid.");
        }
        catch (IOException ex) {
            throw new InvalidHandleException("Handle resolution error", ex);
        }
        catch (URISyntaxException ex) {
            throw new InvalidHandleException("Handle resolution error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL resolve(URL url) throws IOException {
        logger.debug("Resolving handle URL {}", (Object)url);
        HttpURLConnection httpCon = null;
        try {
            URL resolveUrl = this.determineResolveUrl(url);
            logger.debug("connecting to [{}]", (Object)resolveUrl);
            if (resolveUrl.getProtocol().equalsIgnoreCase("file")) {
                URL uRL = resolveUrl;
                return uRL;
            }
            httpCon = (HttpURLConnection)resolveUrl.openConnection();
            httpCon.setInstanceFollowRedirects(true);
            URL uRL = this.connections.getUrlCheckRedirects(httpCon);
            return uRL;
        }
        finally {
            if (httpCon != null) {
                httpCon.disconnect();
            }
        }
    }

    protected URL determineResolveUrl(URL url) throws MalformedURLException {
        return url;
    }
}

