/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.InputStream;
import java.io.OutputStream;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;

public abstract class AbstractResponse
extends AbstractMessage {
    public InputStream stream = null;
    public boolean streaming = false;

    public AbstractResponse() {
    }

    public AbstractResponse(int opCode, int responseCode) {
        super(opCode);
        this.responseCode = responseCode;
    }

    public AbstractResponse(AbstractRequest req, int responseCode) throws HandleException {
        super(req.opCode);
        this.requestId = req.requestId;
        this.responseCode = responseCode;
        this.sessionId = req.sessionId;
        if (req.returnRequestDigest) {
            this.takeDigestOfRequest(req);
        }
        this.takeValuesFrom(req);
    }

    public AbstractResponse getContinuedResponse() {
        return null;
    }

    final void takeDigestOfRequest(AbstractRequest req) throws HandleException {
        if ((req.majorProtocolVersion == 2 || req.majorProtocolVersion == 5) && req.minorProtocolVersion == 0) {
            this.requestDigest = Util.doMD5Digest(req.getEncodedMessageBody());
            this.rdHashType = 0;
        } else {
            this.requestDigest = Util.doSHA1Digest(req.getEncodedMessageBody());
            this.rdHashType = (byte)2;
        }
    }

    public void streamResponse(OutputStream out) throws HandleException {
    }
}

