/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;

public class ResolutionResponse
extends AbstractResponse {
    public byte[] handle;
    public byte[][] values;

    public ResolutionResponse(byte[] handle, byte[][] values) {
        super(1, 1);
        this.handle = handle;
        this.values = values;
    }

    public ResolutionResponse(AbstractRequest req, byte[] handle, byte[][] clumps) throws HandleException {
        super(req, 1);
        this.handle = handle;
        this.values = clumps;
    }

    public HandleValue[] getHandleValues() throws HandleException {
        HandleValue[] retValues = new HandleValue[this.values.length];
        for (int i = 0; i < retValues.length; ++i) {
            retValues[i] = new HandleValue();
            Encoder.decodeHandleValue(this.values[i], 0, retValues[i]);
        }
        return retValues;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(' ');
        if (this.handle == null) {
            sb.append(String.valueOf(this.handle));
        } else {
            sb.append(new String(this.handle));
        }
        sb.append("\n");
        if (this.values != null) {
            try {
                HandleValue[] vals = this.getHandleValues();
                for (int i = 0; i < vals.length; ++i) {
                    sb.append("   ");
                    sb.append(String.valueOf(vals[i]));
                    sb.append('\n');
                }
            }
            catch (HandleException handleException) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

