/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.handle.hdllib4.HandleResponse;
import net.handle.hdllib4.XdrDecoder;
import net.handle.hdllib4.XdrEncoder;
import net.handle.hdllib4.XdrEncodingException;

public class HashBucket {
    public int slotNo = -1;
    public int weight = -1;
    public byte[] ipAddress = null;
    public int udpQueryPort = -1;
    public int tcpQueryPort = -1;
    public int adminPort = -1;
    public int secondarySlotNo = -1;

    public HashBucket(XdrDecoder decoder) throws XdrEncodingException, IOException {
        this.slotNo = decoder.readShort();
        this.weight = decoder.readShort();
        this.ipAddress = decoder.readByteArray();
        this.udpQueryPort = decoder.readShort();
        this.tcpQueryPort = decoder.readShort();
        this.adminPort = decoder.readShort();
        this.secondarySlotNo = decoder.readShort();
    }

    public HashBucket(InetAddress address, int udpPort, int tcpPort, int admPort) {
        this.ipAddress = address.getAddress();
        this.udpQueryPort = udpPort;
        this.tcpQueryPort = tcpPort;
        this.adminPort = admPort;
    }

    public HashBucket() {
    }

    public int getEncodingSize() {
        return 8 + XdrEncoder.calcArraySize(this.ipAddress.length) + 4 + 4 + 4 + 4;
    }

    public void writeBucket(XdrEncoder encoder) {
        encoder.writeShort(this.slotNo);
        encoder.writeShort(this.weight);
        encoder.writeByteArray(this.ipAddress);
        encoder.writeShort(this.udpQueryPort);
        encoder.writeShort(this.tcpQueryPort);
        encoder.writeShort(this.adminPort);
        encoder.writeShort(this.secondarySlotNo);
    }

    public void setFromForwardingInfo(HandleResponse response) {
        this.ipAddress = response.redirectedHandleServer;
        this.udpQueryPort = (int)response.udpPortNumber;
        this.tcpQueryPort = (int)response.tcpPortNumber;
    }

    public int getPortForProtocol(int protocol) {
        if (protocol == 1) {
            return this.tcpQueryPort;
        }
        if (protocol == 0) {
            return this.udpQueryPort;
        }
        return -1;
    }

    public String getAddressString() {
        return "" + (0xFFL & (long)this.ipAddress[0]) + '.' + (0xFFL & (long)this.ipAddress[1]) + '.' + (0xFFL & (long)this.ipAddress[2]) + '.' + (0xFFL & (long)this.ipAddress[3]);
    }

    public String getIDString() {
        return this.getAddressString() + ':' + this.udpQueryPort + ':' + this.tcpQueryPort + ':' + this.adminPort;
    }

    public String toString() {
        return this.getIDString();
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName("" + (0xFFL & (long)this.ipAddress[0]) + '.' + (0xFFL & (long)this.ipAddress[1]) + '.' + (0xFFL & (long)this.ipAddress[2]) + '.' + (0xFFL & (long)this.ipAddress[3]));
    }

    public void printValues(PrintStream out) {
        out.print("HashBucket: slot=" + this.slotNo + " weight=" + this.weight + " address=");
        for (int i = 0; i < this.ipAddress.length; ++i) {
            out.print((long)this.ipAddress[i] & 0xFFL);
            if (i == this.ipAddress.length - 1) continue;
            out.print('.');
        }
        out.println(" udp-port=" + this.udpQueryPort + " tcp-port=" + this.tcpQueryPort + " admin-port=" + this.adminPort + " secondary=" + this.secondarySlotNo);
    }
}

