/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class MacAdapter {
    public boolean initMacApplicationHandlers() throws MacAdapterException {
        try {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            try {
                Object application = applicationClass.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
                this.initMacQuitHandler(applicationClass, application);
                if (this.shouldShowAbout()) {
                    this.initMacAboutHandler(applicationClass, application);
                }
                return true;
            }
            catch (IllegalAccessException ex) {
                throw new MacAdapterException((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                throw new MacAdapterException((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw new MacAdapterException((Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new MacAdapterException((Throwable)ex);
            }
            catch (SecurityException ex) {
                throw new MacAdapterException((Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                throw new MacAdapterException((Throwable)ex);
            }
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private void initMacQuitHandler(Class applicationClass, Object application) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException, SecurityException, NoSuchMethodException, InvocationTargetException {
        this.initMacHandler(applicationClass, application, "com.apple.eawt.QuitHandler", "setQuitHandler", new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("handleQuitRequestWith") && !MacAdapter.this.performApplicationExit() && args.length >= 2) {
                    Object quitResponse = args[1];
                    Class<?> quitResponseClass = Class.forName("com.apple.eawt.QuitResponse");
                    if (quitResponse.getClass().equals(quitResponseClass)) {
                        quitResponseClass.getMethod("cancelQuit", new Class[0]).invoke(quitResponse, new Object[0]);
                    }
                }
                return null;
            }
        });
    }

    private void initMacAboutHandler(Class applicationClass, Object application) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException, SecurityException, NoSuchMethodException, InvocationTargetException {
        this.initMacHandler(applicationClass, application, "com.apple.eawt.AboutHandler", "setAboutHandler", new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                MacAdapter.this.performApplicationAbout();
                return null;
            }
        });
    }

    private void initMacHandler(Class applicationClass, Object application, String interfaceName, String setMethodName, InvocationHandler invocationHandler) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException, SecurityException, NoSuchMethodException, InvocationTargetException {
        Class<?> handlerInterface = Class.forName(interfaceName);
        Object handler = Proxy.newProxyInstance(handlerInterface.getClassLoader(), new Class[]{handlerInterface}, invocationHandler);
        applicationClass.getMethod(setMethodName, handlerInterface).invoke(application, handler);
    }

    protected abstract boolean performApplicationExit();

    protected abstract void performApplicationAbout();

    protected boolean shouldShowAbout() {
        return true;
    }

    public class MacAdapterException
    extends Exception {
        public MacAdapterException(String message) {
            super(message);
        }

        public MacAdapterException(Throwable cause) {
            super(cause);
        }

        public MacAdapterException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

