/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.net.URI;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import nl.mpi.arbil.clarin.HandleUtils;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilDataNodeLoaderCallBack;
import nl.mpi.arbil.data.ArbilDataNodeService;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.DataNodeLoaderThreadManager;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.flap.model.PluginDataNode;
import nl.mpi.flap.plugin.WrongNodeTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataNodeLoader
implements DataNodeLoader {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDataNodeLoader.class);
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private Hashtable<String, ArbilDataNode> arbilHashTable = new Hashtable();
    private Vector<ArbilDataNode> nodesNeedingSave = new Vector();
    private DataNodeLoaderThreadManager threadManager;
    private ArbilDataNodeService dataNodeService;
    private final MetadataFormat metadataFormat = new MetadataFormat();
    private final HandleUtils handleUtils = new HandleUtils();

    public DefaultDataNodeLoader(DataNodeLoaderThreadManager loaderThreadManager, ArbilDataNodeService dataNodeService) {
        this(loaderThreadManager);
        this.dataNodeService = dataNodeService;
    }

    protected DefaultDataNodeLoader(DataNodeLoaderThreadManager loaderThreadManager) {
        logger.debug("ArbilDataNodeLoader init");
        this.threadManager = loaderThreadManager;
    }

    protected final void setDataNodeService(ArbilDataNodeService dataNodeService) {
        this.dataNodeService = dataNodeService;
    }

    public ArbilDataNode getArbilDataNodeWithoutLoading(URI localUri) {
        ArbilDataNode currentDataNode = null;
        if (localUri != null && (currentDataNode = this.arbilHashTable.get((localUri = this.resolveAndNormaliseUri(localUri)).toString())) == null) {
            currentDataNode = new ArbilDataNode(this.dataNodeService, localUri, this.metadataFormat.shallowCheck(localUri));
            this.arbilHashTable.put(localUri.toString(), currentDataNode);
        }
        return currentDataNode;
    }

    public PluginDataNode getPluginArbilDataNode(Object registeringObject, URI localUri) {
        return this.getArbilDataNode(registeringObject, localUri);
    }

    public ArbilDataNode getArbilDataNode(Object registeringObject, URI localUri) {
        ArbilDataNode currentDataNode = null;
        if (localUri != null && localUri.toString().length() > 0) {
            currentDataNode = this.getArbilDataNodeWithoutLoading(localUri);
            if (!currentDataNode.getParentDomNode().isDataLoaded() && !currentDataNode.isLoading()) {
                if (MetadataFormat.isStringChildNode(currentDataNode.getUrlString())) {
                    currentDataNode.getParentDomNode();
                } else if (MetadataFormat.isPathMetadata(currentDataNode.getUrlString()) || ArbilDataNode.isPathHistoryFile(currentDataNode.getUrlString())) {
                    this.threadManager.addNodeToQueue(currentDataNode);
                } else if (!MetadataFormat.isPathMetadata(currentDataNode.getUrlString())) {
                    // empty if block
                }
            }
            if (registeringObject != null && registeringObject instanceof ArbilDataNodeContainer) {
                currentDataNode.registerContainer((ArbilDataNodeContainer)registeringObject);
            }
        }
        return currentDataNode;
    }

    public ArbilDataNode getArbilDataNodeOnlyIfLoaded(URI arbilUri) {
        arbilUri = this.resolveAndNormaliseUri(arbilUri);
        return this.arbilHashTable.get(arbilUri.toString());
    }

    public void requestReloadOnlyIfLoaded(URI arbilUri) {
        ArbilDataNode currentDataNode = this.arbilHashTable.get((arbilUri = this.resolveAndNormaliseUri(arbilUri)).toString());
        if (currentDataNode != null) {
            this.requestReload(currentDataNode);
        }
    }

    public void requestReload(ArbilDataNode currentDataNode) {
        this.requestReload(currentDataNode, null);
    }

    public void requestReload(ArbilDataNode currentDataNode, ArbilDataNodeLoaderCallBack callback) {
        this.requestReload(currentDataNode, currentDataNode.getRequestedLoadingState(), callback);
    }

    public void requestShallowReload(ArbilDataNode currentDataNode) {
        this.requestReload(currentDataNode, ArbilDataNode.LoadingState.PARTIAL, null);
    }

    private void requestReload(ArbilDataNode requestNode, ArbilDataNode.LoadingState loadingState, ArbilDataNodeLoaderCallBack callback) {
        ArbilDataNode reloadNode = requestNode.isChildNode() ? requestNode.getParentDomNode() : requestNode;
        this.removeNodesNeedingSave(reloadNode);
        if (!ArbilDataNode.LoadingState.LOADED.equals((Object)reloadNode.getRequestedLoadingState())) {
            reloadNode.setRequestedLoadingState(loadingState);
        }
        if (callback != null) {
            this.threadManager.addLoaderCallback(requestNode, callback);
        }
        this.threadManager.addNodeToQueue(reloadNode);
    }

    public void requestReloadAllNodes() {
        ArbilDataNode[] currentNodes;
        for (ArbilDataNode currentDataNode : currentNodes = this.arbilHashTable.values().toArray(new ArbilDataNode[0])) {
            this.requestReload(currentDataNode);
        }
    }

    public void requestReloadAllMetadataNodes() {
        ArbilDataNode[] currentNodes;
        for (ArbilDataNode currentDataNode : currentNodes = this.arbilHashTable.values().toArray(new ArbilDataNode[0])) {
            if (!currentDataNode.isMetaDataNode()) continue;
            this.requestReload(currentDataNode);
        }
    }

    public void startLoaderThreads() {
        this.threadManager.startLoaderThreads();
    }

    public void stopLoaderThreads() {
        this.threadManager.stopLoaderThreads();
    }

    protected void finalize() throws Throwable {
        this.threadManager.setContinueThread(false);
        super.finalize();
    }

    public void addNodeNeedingSave(ArbilDataNode nodeToSave) {
        if (!this.nodesNeedingSave.contains(nodeToSave = nodeToSave.getParentDomNode())) {
            this.nodesNeedingSave.add(nodeToSave);
        }
    }

    public void removeNodesNeedingSave(ArbilDataNode savedNode) {
        this.nodesNeedingSave.remove(savedNode);
    }

    public ArbilDataNode[] getNodesNeedSave() {
        return this.nodesNeedingSave.toArray(new ArbilDataNode[0]);
    }

    public boolean nodesNeedSave() {
        return this.nodesNeedingSave.size() > 0;
    }

    public synchronized void saveNodesNeedingSave(boolean updateIcons) {
        while (this.nodesNeedingSave.size() > 0) {
            ArbilDataNode currentNode = this.nodesNeedingSave.remove(0);
            if (currentNode == null) continue;
            currentNode.saveChangesToCache(updateIcons);
            if (!updateIcons) continue;
            this.requestReload(currentNode);
        }
    }

    public URI getNodeURI(PluginDataNode dataNode) throws WrongNodeTypeException {
        if (dataNode instanceof ArbilDataNode) {
            return ((ArbilDataNode)dataNode).getURI();
        }
        throw new WrongNodeTypeException("Not an ArbilDataNode.");
    }

    public boolean isNodeLoading(PluginDataNode dataNode) {
        if (dataNode instanceof ArbilDataNode) {
            return ((ArbilDataNode)dataNode).isLoading();
        }
        return false;
    }

    public boolean isSchemaCheckLocalFiles() {
        return this.threadManager.isSchemaCheckLocalFiles();
    }

    public void setSchemaCheckLocalFiles(boolean schemaCheckLocalFiles) {
        this.threadManager.setSchemaCheckLocalFiles(schemaCheckLocalFiles);
    }

    public ArbilDataNode createNewDataNode(URI uri) {
        uri = this.resolveAndNormaliseUri(uri);
        return new ArbilDataNode(this.dataNodeService, uri, this.metadataFormat.shallowCheck(uri));
    }

    protected DataNodeLoaderThreadManager getThreadManager() {
        return this.threadManager;
    }

    private URI resolveAndNormaliseUri(URI uri) {
        return this.handleUtils.followRedirect(ArbilDataNodeService.normaliseURI(uri));
    }
}

