/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.util.Enumeration;
import java.util.Hashtable;
import nl.mpi.arbil.ui.ArbilFieldView;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;

public class ArbilFieldViews {
    protected static final String SAVED_FIELDVIEWS_FILE = "savedFieldViewsV3";
    private Hashtable<String, ArbilFieldView> savedFieldViews;
    private String currentGlobalViewName = "";
    private static ArbilFieldViews singleInstance = null;
    private static SessionStorage sessionStorage;

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static synchronized ArbilFieldViews getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilFieldViews();
        }
        return singleInstance;
    }

    private ArbilFieldViews() {
        this.loadArbilFieldViews();
    }

    public ArbilFieldView getView(String viewName) {
        return this.savedFieldViews.get(viewName);
    }

    public ArbilFieldView getCurrentGlobalView() {
        ArbilFieldView fieldView = this.savedFieldViews.get(this.currentGlobalViewName);
        if (fieldView == null) {
            return new ArbilFieldView();
        }
        return fieldView;
    }

    public String getCurrentGlobalViewName() {
        return this.currentGlobalViewName;
    }

    public void setCurrentGlobalViewName(String nextViewName) {
        this.currentGlobalViewName = nextViewName;
        sessionStorage.saveString("currentGlobalViewName", this.currentGlobalViewName);
    }

    public Enumeration getSavedFieldViewLables() {
        return this.savedFieldViews.keys();
    }

    private void loadArbilFieldViews() {
        try {
            this.savedFieldViews = (Hashtable)sessionStorage.loadObject(SAVED_FIELDVIEWS_FILE);
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError("load savedFieldViews failed", ex);
            this.savedFieldViews = new Hashtable();
            this.createDefaultFieldViews();
        }
        try {
            this.currentGlobalViewName = sessionStorage.loadString("currentGlobalViewName");
            if (this.currentGlobalViewName == null) {
                this.currentGlobalViewName = (String)sessionStorage.loadObject("currentGlobalViewName");
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError("load currentGlobalViewName failed ", ex);
            if (this.savedFieldViews.isEmpty()) {
                this.createDefaultFieldViews();
            }
            this.currentGlobalViewName = this.savedFieldViews.keys().nextElement();
            sessionStorage.saveString("currentGlobalViewName", this.currentGlobalViewName);
        }
    }

    private void createDefaultFieldViews() {
        ArbilFieldView currentGlobalView = new ArbilFieldView();
        this.addArbilFieldView("All", currentGlobalView);
        ArbilFieldView fewFieldView = new ArbilFieldView();
        fewFieldView.setShowOnlyColumns(new String[]{"Name", "Description", "Title"});
        this.addArbilFieldView("Minimal", fewFieldView);
    }

    public void saveViewsToFile() {
        try {
            sessionStorage.saveObject(this.savedFieldViews, SAVED_FIELDVIEWS_FILE);
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public boolean addArbilFieldView(String viewLabel, ArbilFieldView fieldView) {
        if (!this.savedFieldViews.containsKey(viewLabel)) {
            this.savedFieldViews.put(viewLabel, fieldView);
            this.saveViewsToFile();
            return true;
        }
        return false;
    }
}

