/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.util.MimeHashQueue;

class JListToolTip
extends JToolTip {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    JPanel jPanel;
    Object targetObject;
    String preSpaces = "      ";

    public JListToolTip() {
        this.setLayout(new BorderLayout());
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BoxLayout(this.jPanel, 1));
        this.add((Component)this.jPanel, "Center");
        this.jPanel.setBackground(this.getBackground());
        this.jPanel.setBorder(this.getBorder());
        ToolTipManager.sharedInstance().setDismissDelay(100000);
    }

    private String truncateString(String inputString) {
        if (inputString.length() > 100) {
            inputString = inputString.substring(0, 100) + widgets.getString("ELIPSIS");
        }
        return inputString + " ";
    }

    private void addIconLabel(Object tempObject) {
        JLabel jLabel = new JLabel(this.truncateString(tempObject.toString()));
        if (tempObject instanceof ArbilDataNode) {
            jLabel.setIcon(((ArbilDataNode)tempObject).getIcon());
        }
        jLabel.doLayout();
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBackground(this.getBackground());
        labelPanel.add((Component)jLabel, "Center");
        this.jPanel.add(labelPanel);
    }

    private void addDetailLabel(String labelString) {
        this.addDetailLabelIcon(labelString, null);
    }

    private void addDetailLabelIcon(String labelString, Icon icon) {
        JLabel jLabel = icon == null ? new JLabel(labelString) : new JLabel(labelString, icon, 11);
        jLabel.setBackground(this.getBackground());
        jLabel.doLayout();
        this.jPanel.add(jLabel);
    }

    private void addTabbedLabel(String labelString) {
        this.addDetailLabel(this.preSpaces + labelString);
    }

    private void addDetailLabel(String prefixString, ArbilField[] tempFieldArray) {
        if (tempFieldArray != null) {
            for (ArbilField tempField : tempFieldArray) {
                String labelString = tempField.toString();
                this.addTabbedLabel(prefixString + labelString);
            }
        }
    }

    private void addFieldType(ArbilField field) {
        if (field.hasVocabulary()) {
            StringBuilder sb = new StringBuilder();
            sb.append(field.isVocabularyOpen() ? "Open vocabulary" : "Closed vocabulary");
            if (field.isVocabularyList()) {
                sb.append(" list. To enter multiple values, insert a comma (,) between separate entries.");
            } else {
                sb.append(". Only one value can be entered.");
            }
            this.addDetailLabelIcon(sb.toString(), ArbilIcons.getSingleInstance().getIconForVocabulary(field));
        }
        if (field.isAttributeField()) {
            this.addDetailLabelIcon(MessageFormat.format(widgets.getString("ATTRIBUTE OF {0}"), field.getParentDataNode().toString()), ArbilIcons.getSingleInstance().attributeIcon);
        }
        if (field.hasEditableFieldAttributes()) {
            List<String[]> fieldAttributePaths = field.getAttributePaths();
            this.addDetailLabel(MessageFormat.format(widgets.getString("FIELD HAS {0} ATTRIBUTE(S)"), fieldAttributePaths.size()));
            for (String[] path : fieldAttributePaths) {
                Object attributeValue = field.getAttributeValue(path[0]);
                if (attributeValue == null) continue;
                this.addDetailLabelIcon(path[1] + ": " + attributeValue, ArbilIcons.getSingleInstance().attributeIcon);
            }
            this.addDetailLabel(widgets.getString("OPEN IN LONG FIELD EDITOR TO SET ATTRIBUTES"));
        }
        if (field.isAllowsLanguageId()) {
            this.addDetailLabelIcon(widgets.getString("TOOLTIP_FIELD HAS LANGUAGE ATTRIBUTE"), ArbilIcons.getSingleInstance().languageIcon);
        }
    }

    private void addLabelsForDataNode(ArbilDataNode tempObject) {
        if (tempObject.isMetaDataNode()) {
            Map<String, ArbilField[]> tempFields = tempObject.getFields();
            this.addDetailLabel(widgets.getString("TOOLTIP_NAME: "), tempFields.get("Name"));
            this.addDetailLabel(widgets.getString("TOOLTIP_TITLE: "), tempFields.get("Title"));
            this.addDetailLabel(widgets.getString("TOOLTIP_DESCRIPTION: "), tempFields.get(widgets.getString("DESCRIPTION")));
            this.addTabbedLabel(MessageFormat.format(widgets.getString("TEMPLATE: {0}"), tempObject.getNodeTemplate().getTemplateName()));
            String nodePath = tempObject.getNodePath();
            if (nodePath != null) {
                this.addTabbedLabel(MessageFormat.format(widgets.getString("TOOLTIP_PATH: {0}"), nodePath));
            }
            this.addDetailLabel(widgets.getString("TOOLTIP_FORMAT: "), tempFields.get("Format"));
        } else if (!tempObject.isDirectory()) {
            this.addTabbedLabel(widgets.getString("TOOLTIP_UNATTACHED FILE"));
            if (tempObject.getTypeCheckerState().equals((Object)MimeHashQueue.TypeCheckerState.CHECKED)) {
                if (tempObject.isArchivableFile()) {
                    this.addTabbedLabel(widgets.getString("TOOLTIP_ARCHIVABLE FILE"));
                } else {
                    this.addTabbedLabel(widgets.getString("TOOLTIP_NOT ARCHIVABLE"));
                    this.addTabbedLabel(MessageFormat.format(widgets.getString("TOOLTIP_TYPE CHECKER MESSAGE"), tempObject.typeCheckerMessage));
                }
            } else {
                this.addTabbedLabel(MessageFormat.format(widgets.getString("TOOLTIP_STATUS: {0}"), new Object[]{tempObject.getTypeCheckerState()}));
            }
        }
        if (tempObject.hasResource() || !tempObject.isMetaDataNode() && !tempObject.isDirectory()) {
            this.addTabbedLabel(MessageFormat.format(widgets.getString("TOOLTIP_COPIES IN CACHE: {0}"), tempObject.matchesInCache));
            this.addTabbedLabel(MessageFormat.format(widgets.getString("TOOLTIP_COPIES ON LOCAL FILE SYSTEM: {0}"), tempObject.matchesLocalFileSystem));
            this.addTabbedLabel(widgets.getString("TOOLTIP_COPIES ON SERVER: ?"));
        }
        if (!tempObject.isLocal()) {
            this.addTabbedLabel(widgets.getString("TOOLTIP_REMOTE FILE (READ ONLY)"));
        } else if (tempObject.hasResource()) {
            if (tempObject.resourceFileNotFound()) {
                this.addTabbedLabel(widgets.getString("TOOLTIP_RESOURCE FILE NOT FOUND"));
            }
        } else if (tempObject.isMetaDataNode()) {
            if (tempObject.isEditable()) {
                this.addTabbedLabel(widgets.getString("TOOLTIP_LOCAL FILE (EDITABLE)"));
            } else {
                this.addTabbedLabel(widgets.getString("TOOLTIP_LOCAL FILE (READ ONLY)"));
            }
            if (tempObject.fileNotFound) {
                this.addTabbedLabel(widgets.getString("TOOLTIP_FILE NOT FOUND"));
            }
        }
        if (tempObject.hasHistory()) {
            this.addTabbedLabel(widgets.getString("TOOLTIP_HISTORY OF CHANGES ARE AVAILABLE"));
        }
        if (tempObject.getNeedsSaveToDisk(true)) {
            this.addTabbedLabel(widgets.getString("TOOLTIP_UNSAVED CHANGES"));
        }
        if (tempObject.isFavorite()) {
            this.addTabbedLabel(widgets.getString("TOOLTIP_AVAILABLE IN THE FAVOURITES MENU"));
        }
        if (tempObject.hasSchemaError) {
            this.addTabbedLabel(widgets.getString("TOOLTIP_SCHEMA VALIDATION ERROR (CHECK XML CONFORMANCE FOR DETAILS)"));
        }
    }

    public void updateList() {
        this.jPanel.removeAll();
        if (this.targetObject != null) {
            if (this.targetObject instanceof Object[]) {
                for (int childCounter = 0; childCounter < ((Object[])this.targetObject).length; ++childCounter) {
                    this.addIconLabel(((Object[])this.targetObject)[childCounter]);
                }
                if (((Object[])this.targetObject)[0] != null && ((Object[])this.targetObject)[0] instanceof ArbilField) {
                    this.addDetailLabel(((ArbilField)((Object[])this.targetObject)[0]).getParentDataNode().getNodeTemplate().getHelpStringForField(((ArbilField)((Object[])this.targetObject)[0]).getFullXmlPath()));
                }
            } else if (this.targetObject instanceof ArbilDataNode) {
                this.addIconLabel(this.targetObject);
                this.addLabelsForDataNode((ArbilDataNode)this.targetObject);
            } else if (this.targetObject instanceof ArbilField) {
                this.addDetailLabel(this.targetObject.toString());
                this.addDetailLabel(((ArbilField)this.targetObject).getParentDataNode().getNodeTemplate().getHelpStringForField(((ArbilField)this.targetObject).getFullXmlPath()));
                this.addFieldType((ArbilField)this.targetObject);
            } else {
                this.addDetailLabel(this.targetObject.toString());
            }
            this.jPanel.doLayout();
            this.doLayout();
        }
    }

    public String getTipText() {
        return "";
    }

    public Dimension getPreferredSize() {
        return this.jPanel.getPreferredSize();
    }

    public void setTartgetObject(Object targetObjectLocal) {
        this.targetObject = targetObjectLocal;
    }
}

