/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilRootNode;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.data.ContainerNode;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.data.importexport.ArbilCsvImporter;
import nl.mpi.arbil.favourites.ArbilFavourites;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ArbilTreeController;
import nl.mpi.arbil.ui.ArbilTreePanels;
import nl.mpi.arbil.ui.ImportExportDialog;
import nl.mpi.arbil.ui.favourites.FavouritesImportExportGUI;
import nl.mpi.arbil.ui.menu.ArbilContextMenu;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;

public class TreeContextMenu
extends ArbilContextMenu {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus");
    private final TreeHelper treeHelper;
    private final MessageDialogHandler dialogHandler;
    private final ArbilTreeController treeController;
    private final ArbilNode leadSelectedNode;
    private final SessionStorage sessionStorage;
    private final WindowManager windowManager;
    private final ApplicationVersionManager versionManager;
    private ArbilTree tree;
    private JMenu addFromFavouritesMenu = new JMenu();
    private JMenuItem addLocalDirectoryMenuItem = new JMenuItem();
    private JCheckBoxMenuItem showHiddenFilesMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem groupFavouritesMenuItem = new JCheckBoxMenuItem();
    private JMenuItem addDefaultLocationsMenuItem = new JMenuItem();
    private JMenu addMenu = new JMenu();
    private JMenuItem addRemoteCorpusMenuItem = new JMenuItem();
    private JMenuItem addRemoteCorpusToRootMenuItem = new JMenuItem();
    private JMenuItem addToFavouritesMenuItem = new JMenuItem();
    private JMenuItem removeFromFavouritesMenuItem = new JMenuItem();
    private JMenuItem copyBranchMenuItem = new JMenuItem();
    private JMenuItem searchRemoteBranchMenuItem = new JMenuItem();
    private JMenuItem copyNodeUrlMenuItem = new JMenuItem();
    private JMenuItem deleteMenuItem = new JMenuItem();
    private JMenuItem exportMenuItem = new JMenuItem();
    private JMenuItem importCsvMenuItem = new JMenuItem();
    private JMenuItem importBranchMenuItem = new JMenuItem();
    private JMenuItem reImportBranchMenuItem = new JMenuItem();
    private JMenuItem pasteMenuItem1 = new JMenuItem();
    private JMenuItem reloadSubnodesMenuItem = new JMenuItem();
    private JMenuItem removeCachedCopyMenuItem = new JMenuItem();
    private JMenuItem removeLocalDirectoryMenuItem = new JMenuItem();
    private JMenuItem removeRemoteCorpusMenuItem = new JMenuItem();
    private JMenuItem searchSubnodesMenuItem = new JMenuItem();
    private JMenuItem validateMenuItem = new JMenuItem();
    private JMenu historyMenu = new JMenu();
    private JMenuItem viewSelectedNodesMenuItem = new JMenuItem();
    private JMenuItem viewSelectedSubnodesMenuItem = new JMenuItem();
    private JMenuItem editInLongFieldEditor = new JMenuItem();
    private JMenuItem setManualResourceLocationMenuItem = new JMenuItem();
    private JMenuItem importExportFavouritesMenuItem = new JMenuItem();
    private JMenuItem forceTypeCheckMenuItem = new JMenuItem();

    public TreeContextMenu(ArbilTree tree, ArbilTreeController treeController, TreeHelper treeHelper, MessageDialogHandler dialogHandler, WindowManager windowManager, SessionStorage sessionStorage, ApplicationVersionManager versionManager) {
        this.treeController = treeController;
        this.treeHelper = treeHelper;
        this.dialogHandler = dialogHandler;
        this.sessionStorage = sessionStorage;
        this.windowManager = windowManager;
        this.versionManager = versionManager;
        this.tree = tree;
        this.setInvoker(tree);
        this.selectedTreeNodes = tree.getSelectedNodes();
        this.leadSelectedNode = tree.getLeadSelectionNode();
        this.leadSelectedDataNode = tree.getLeadSelectionDataNode();
    }

    protected void setUpMenu() {
        this.setUpItems();
        this.setUpActions();
    }

    private void setUpItems() {
        int selectionCount = this.tree.getSelectionCount();
        int nodeLevel = selectionCount > 0 ? this.tree.getSelectionPath().getPathCount() : -1;
        boolean showRemoveLocationsTasks = selectionCount == 1 && nodeLevel == 2 || selectionCount > 1;
        boolean showAddLocationsTasks = selectionCount == 1 && nodeLevel == 1;
        this.viewSelectedNodesMenuItem.setText(menus.getString("VIEW SELECTED"));
        this.viewSelectedSubnodesMenuItem.setText(this.leadSelectedDataNode != null && this.leadSelectedDataNode.isEditable() ? menus.getString("EDIT ALL METADATA") : menus.getString("VIEW ALL METADATA"));
        this.editInLongFieldEditor.setText(this.leadSelectedDataNode != null && this.leadSelectedDataNode.getParentDomNode().isEditable() ? menus.getString("EDIT IN LONG FIELD EDITOR") : menus.getString("VIEW IN LONG FIELD EDITOR"));
        this.deleteMenuItem.setEnabled(true);
        if (this.getTreePanel() != null) {
            if (this.tree == this.getTreePanel().remoteCorpusTree) {
                this.removeRemoteCorpusMenuItem.setVisible(showRemoveLocationsTasks);
                this.addRemoteCorpusMenuItem.setVisible(showAddLocationsTasks);
                this.addRemoteCorpusToRootMenuItem.setVisible(selectionCount > 0 && nodeLevel > 2);
                this.copyBranchMenuItem.setVisible(selectionCount > 0 && nodeLevel > 1);
                this.addDefaultLocationsMenuItem.setVisible(showAddLocationsTasks);
                this.searchRemoteBranchMenuItem.setVisible(selectionCount > 0 && nodeLevel > 1 && !this.leadSelectedDataNode.isCmdiMetaDataNode());
            }
            if (this.tree == this.getTreePanel().localCorpusTree) {
                this.viewSelectedNodesMenuItem.setText(menus.getString("VIEW/EDIT SELECTED"));
                this.pasteMenuItem1.setVisible(selectionCount > 0 && nodeLevel > 1);
                this.searchSubnodesMenuItem.setVisible(selectionCount > 0);
                this.addMenu.setVisible(selectionCount == 1);
                this.deleteMenuItem.setVisible(nodeLevel > 1);
                if (this.leadSelectedDataNode != null) {
                    boolean nodeIsChild = this.leadSelectedDataNode.isChildNode();
                    this.validateMenuItem.setVisible(!nodeIsChild);
                    this.historyMenu.setVisible(this.leadSelectedDataNode.hasHistory());
                    this.exportMenuItem.setVisible(!nodeIsChild);
                    this.importCsvMenuItem.setVisible(this.leadSelectedDataNode.isCorpus());
                    this.importBranchMenuItem.setVisible(this.leadSelectedDataNode.isCorpus());
                    this.reImportBranchMenuItem.setVisible(this.selectedTreeNodes.length == 1 && this.leadSelectedDataNode.archiveHandle != null && !this.leadSelectedDataNode.isChildNode());
                }
                this.addFromFavouritesMenu.setVisible(true);
            }
            if (this.tree == this.getTreePanel().localDirectoryTree) {
                this.removeLocalDirectoryMenuItem.setVisible(showRemoveLocationsTasks);
                if (showAddLocationsTasks) {
                    this.showHiddenFilesMenuItem.setState(this.treeHelper.isShowHiddenFilesInTree());
                    this.showHiddenFilesMenuItem.setVisible(true);
                }
                this.addLocalDirectoryMenuItem.setVisible(showAddLocationsTasks);
                if (this.leadSelectedDataNode != null) {
                    this.copyBranchMenuItem.setVisible(this.leadSelectedDataNode.isCorpus() || this.leadSelectedDataNode.isSession());
                }
            }
        }
        if (this.leadSelectedDataNode != null) {
            if (this.leadSelectedDataNode.canHaveResource()) {
                this.setManualResourceLocationMenuItem.setVisible(true);
            }
            if (this.leadSelectedDataNode.isResourceSet() || !this.leadSelectedDataNode.isMetaDataNode()) {
                this.forceTypeCheckMenuItem.setVisible(true);
            }
            if (this.leadSelectedDataNode.isFavorite()) {
                boolean isFavouriteTopLevel = this.treeHelper.isInFavouritesNodes(this.leadSelectedDataNode);
                this.addToFavouritesMenuItem.setVisible(false);
                this.removeFromFavouritesMenuItem.setVisible(isFavouriteTopLevel);
                this.removeFromFavouritesMenuItem.setEnabled(isFavouriteTopLevel);
                this.addMenu.setVisible(this.selectedTreeNodes.length == 1);
                this.viewSelectedNodesMenuItem.setText(menus.getString("VIEW/EDIT SELECTED"));
                this.deleteMenuItem.setVisible(!isFavouriteTopLevel && this.selectedTreeNodes.length == 1);
                this.deleteMenuItem.setEnabled(!isFavouriteTopLevel && this.selectedTreeNodes.length == 1);
            } else {
                this.removeFromFavouritesMenuItem.setVisible(false);
                this.addToFavouritesMenuItem.setVisible(this.leadSelectedDataNode.isMetaDataNode());
                this.addToFavouritesMenuItem.setEnabled(!this.leadSelectedDataNode.isCorpus() && this.leadSelectedDataNode.isMetaDataNode());
            }
        } else {
            this.addToFavouritesMenuItem.setVisible(false);
        }
        if (this.leadSelectedNode instanceof ArbilRootNode && this.leadSelectedNode.equals(((DefaultMutableTreeNode)this.treeHelper.getFavouritesTreeModel().getRoot()).getUserObject())) {
            this.importExportFavouritesMenuItem.setVisible(true);
            this.groupFavouritesMenuItem.setState(this.treeHelper.isGroupFavouritesByType());
            this.groupFavouritesMenuItem.setVisible(true);
        }
        ArbilNode[] selectedNodes = this.tree.getAllSelectedNodes();
        this.copyNodeUrlMenuItem.setVisible((selectionCount == 1 && nodeLevel > 1 || selectionCount > 1) && !(selectedNodes[0] instanceof ContainerNode));
        this.viewSelectedNodesMenuItem.setVisible(selectionCount >= 1 && nodeLevel > 1 && !(selectedNodes[0] instanceof ContainerNode));
        this.reloadSubnodesMenuItem.setVisible(selectionCount > 0 && nodeLevel > 1 && !(selectedNodes[0] instanceof ContainerNode));
        this.viewSelectedSubnodesMenuItem.setVisible(selectionCount > 0 && nodeLevel > 1 && selectedNodes[0].isMetaDataNode() && !selectedNodes[0].isCorpus() && !(selectedNodes[0] instanceof ContainerNode));
        this.editInLongFieldEditor.setVisible(selectionCount > 0 && nodeLevel > 1 && !selectedNodes[0].isEmptyMetaNode() && !(selectedNodes[0] instanceof ContainerNode));
    }

    private void setUpActions() {
        this.viewSelectedNodesMenuItem.setText(menus.getString("VIEW SELECTED"));
        this.viewSelectedNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeContextMenu.this.treeController.viewSelectedNodes((ArbilTree)TreeContextMenu.this.getInvoker());
            }
        });
        this.addItem("node", 0, this.viewSelectedNodesMenuItem);
        this.editInLongFieldEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeContextMenu.this.treeController.startLongFieldEditor((ArbilTree)TreeContextMenu.this.getInvoker());
            }
        });
        this.addItem("node", 1, this.editInLongFieldEditor);
        this.viewSelectedSubnodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeContextMenu.this.treeController.viewSelectedSubnodes((ArbilTree)TreeContextMenu.this.getInvoker());
            }
        });
        this.addItem("node", 2, this.viewSelectedSubnodesMenuItem);
        this.deleteMenuItem.setText(menus.getString("DELETE"));
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.treeHelper.deleteNodes(TreeContextMenu.this.getInvoker());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("edit", 10, this.deleteMenuItem);
        this.copyNodeUrlMenuItem.setText(menus.getString("COPY"));
        this.copyNodeUrlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (TreeContextMenu.this.selectedTreeNodes == null) {
                        TreeContextMenu.this.dialogHandler.addMessageDialogToQueue(menus.getString("NO NODE SELECTED"), menus.getString("COPY"));
                    } else {
                        ArbilTree sourceTree = (ArbilTree)TreeContextMenu.this.getInvoker();
                        sourceTree.copyNodeUrlToClipboard(TreeContextMenu.this.selectedTreeNodes);
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("edit", 15, this.copyNodeUrlMenuItem);
        this.pasteMenuItem1.setText(menus.getString("PASTE"));
        this.pasteMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode currentNode : TreeContextMenu.this.selectedTreeNodes) {
                        currentNode.pasteIntoNode();
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("edit", 20, this.pasteMenuItem1);
        this.searchRemoteBranchMenuItem.setText(menus.getString("SEARCH REMOTE CORPUS"));
        this.searchRemoteBranchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.treeController.searchRemoteSubnodes(TreeContextMenu.this.getTreePanel());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("node", 50, this.searchRemoteBranchMenuItem);
        this.copyBranchMenuItem.setText(menus.getString("IMPORT TO LOCAL CORPUS"));
        this.copyBranchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.treeController.copyBranch(TreeContextMenu.this.tree);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("remote corpus", 50, this.copyBranchMenuItem);
        this.searchSubnodesMenuItem.setText(menus.getString("SEARCH"));
        this.searchSubnodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.treeController.searchSubnodes(TreeContextMenu.this.getTreePanel());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("node", 50, this.searchSubnodesMenuItem);
        this.reloadSubnodesMenuItem.setText(menus.getString("RELOAD"));
        this.reloadSubnodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode currentNode : TreeContextMenu.this.selectedTreeNodes) {
                        currentNode.reloadNode();
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("node", 55, this.reloadSubnodesMenuItem);
        this.groupFavouritesMenuItem.setText(menus.getString("GROUP FAVOURITES BY TYPE"));
        this.groupFavouritesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.treeHelper.setGroupFavouritesByType(TreeContextMenu.this.groupFavouritesMenuItem.getState());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("add+favourites", 0, this.groupFavouritesMenuItem);
        this.addMenu.setText(menus.getString("ADD"));
        this.addMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                try {
                    TreeContextMenu.this.initAddMenu(TreeContextMenu.this.addMenu, TreeContextMenu.this.leadSelectedDataNode);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("add+favourites", 0, this.addMenu);
        this.addFromFavouritesMenu.setText(menus.getString("ADD FROM FAVOURITES"));
        this.addFromFavouritesMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                TreeContextMenu.this.initAddFromFavouritesMenu();
            }
        });
        this.addItem("add+favourites", 50, this.addFromFavouritesMenu);
        if (this.leadSelectedDataNode != null && this.leadSelectedDataNode.isContainerNode()) {
            this.addToFavouritesMenuItem.setText(menus.getString("ADD CHILDREN TO FAVOURITES LIST"));
        } else {
            this.addToFavouritesMenuItem.setText(menus.getString("ADD TO FAVOURITES LIST"));
        }
        this.addToFavouritesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilFavourites.getSingleInstance().toggleFavouritesList(((ArbilTree)TreeContextMenu.this.getInvoker()).getSelectedNodes(), true);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("add+favourites", 55, this.addToFavouritesMenuItem);
        this.removeFromFavouritesMenuItem.setText(menus.getString("REMOVE FROM FAVOURITES LIST"));
        this.removeFromFavouritesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilFavourites.getSingleInstance().toggleFavouritesList(((ArbilTree)TreeContextMenu.this.getInvoker()).getSelectedNodes(), false);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("add+favourites", 55, this.removeFromFavouritesMenuItem);
        this.validateMenuItem.setText(menus.getString("CHECK XML CONFORMANCE"));
        this.validateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.treeController.validateNodes(TreeContextMenu.this.selectedTreeNodes);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("xml", 50, this.validateMenuItem);
        this.historyMenu.setText(menus.getString("HISTORY"));
        this.historyMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                try {
                    TreeContextMenu.this.initHistoryMenu();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("edit", 100, this.historyMenu);
        this.addRemoteCorpusMenuItem.setText(menus.getString("ADD REMOTE LOCATION"));
        this.addRemoteCorpusMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.treeController.addRemoteCorpus();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("remote corpus", 50, this.addRemoteCorpusMenuItem);
        this.addRemoteCorpusToRootMenuItem.setText(menus.getString("ADD TO TREE ROOT"));
        this.addRemoteCorpusToRootMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode node : TreeContextMenu.this.selectedTreeNodes) {
                        TreeContextMenu.this.treeController.addRemoteCorpus(node.getUrlString());
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("remote corpus", 50, this.addRemoteCorpusToRootMenuItem);
        this.addDefaultLocationsMenuItem.setText(menus.getString("ADD DEFAULT REMOTE LOCATIONS"));
        this.addDefaultLocationsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (0 < TreeContextMenu.this.treeHelper.addDefaultCorpusLocations()) {
                        TreeContextMenu.this.treeHelper.applyRootLocations();
                    } else {
                        TreeContextMenu.this.dialogHandler.addMessageDialogToQueue(menus.getString("THE DEFAULT LOCATIONS ALREADY EXISTS AND WILL NOT BE ADDED AGAIN"), menus.getString("ADD DEFAULT LOCATIONS"));
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("remote corpus", 55, this.addDefaultLocationsMenuItem);
        this.removeRemoteCorpusMenuItem.setText(menus.getString("REMOVE REMOTE LOCATION"));
        this.removeRemoteCorpusMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode selectedNode : TreeContextMenu.this.selectedTreeNodes) {
                        TreeContextMenu.this.treeHelper.removeLocation(selectedNode);
                    }
                    TreeContextMenu.this.treeHelper.applyRootLocations();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("remote corpus", 60, this.removeRemoteCorpusMenuItem);
        this.addLocalDirectoryMenuItem.setText(menus.getString("ADD WORKING DIRECTORY"));
        this.addLocalDirectoryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.treeController.addLocalDirectory();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("working dir", 0, this.addLocalDirectoryMenuItem);
        this.showHiddenFilesMenuItem.setText(menus.getString("SHOW HIDDEN FILES"));
        this.showHiddenFilesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.treeHelper.setShowHiddenFilesInTree(TreeContextMenu.this.showHiddenFilesMenuItem.getState());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("working dir", 55, this.showHiddenFilesMenuItem);
        this.removeLocalDirectoryMenuItem.setText(menus.getString("REMOVE LINK TO DIRECTORY"));
        this.removeLocalDirectoryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode selectedNode : TreeContextMenu.this.selectedTreeNodes) {
                        TreeContextMenu.this.treeHelper.removeLocation(selectedNode);
                    }
                    TreeContextMenu.this.treeHelper.applyRootLocations();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("remote corpus", 100, this.removeLocalDirectoryMenuItem);
        this.exportMenuItem.setText(menus.getString("EXPORT"));
        this.exportMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ImportExportDialog importExportDialog = new ImportExportDialog(((TreeContextMenu)TreeContextMenu.this).getTreePanel().remoteCorpusTree);
                    importExportDialog.selectExportDirectoryAndExport(((ArbilTree)TreeContextMenu.this.getInvoker()).getSelectedNodes());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("disk", 5, this.exportMenuItem);
        this.importCsvMenuItem.setText(menus.getString("IMPORT CSV"));
        this.importCsvMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilCsvImporter csvImporter = new ArbilCsvImporter(TreeContextMenu.this.leadSelectedDataNode);
                    csvImporter.doImport();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("import", 0, this.importCsvMenuItem);
        this.importBranchMenuItem.setText(menus.getString("IMPORT BRANCH"));
        this.importBranchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ImportExportDialog importExportDialog = new ImportExportDialog(((TreeContextMenu)TreeContextMenu.this).getTreePanel().localCorpusTree);
                    importExportDialog.setDestinationNode(TreeContextMenu.this.leadSelectedDataNode);
                    importExportDialog.importArbilBranch();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("import", 5, this.importBranchMenuItem);
        if (this.leadSelectedDataNode != null) {
            if (this.leadSelectedDataNode.isSession()) {
                this.reImportBranchMenuItem.setText(menus.getString("RE-IMPORT THIS SESSION"));
            } else {
                this.reImportBranchMenuItem.setText(menus.getString("RE-IMPORT THIS BRANCH"));
            }
            this.reImportBranchMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TreeContextMenu.this.treeController.reImportBranch(TreeContextMenu.this.leadSelectedDataNode, TreeContextMenu.this.getTreePanel());
                }
            });
            this.addItem("import", 50, this.reImportBranchMenuItem);
        }
        this.setManualResourceLocationMenuItem.setText(menus.getString("INSERT MANUAL RESOURCE LOCATION"));
        this.setManualResourceLocationMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeContextMenu.this.treeController.setManualResourceLocation(TreeContextMenu.this.leadSelectedDataNode);
            }
        });
        this.addItem("resource", 50, this.setManualResourceLocationMenuItem);
        this.forceTypeCheckMenuItem.setText(menus.getString("FORCE TYPE CHECKING"));
        this.forceTypeCheckMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeContextMenu.this.treeController.forceTypeCheck(TreeContextMenu.this.leadSelectedDataNode);
            }
        });
        this.addItem("resource", 100, this.forceTypeCheckMenuItem);
        this.importExportFavouritesMenuItem.setText(menus.getString("IMPORT/EXPORT FAVOURITES"));
        this.importExportFavouritesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FavouritesImportExportGUI importExportUI = new FavouritesImportExportGUI(TreeContextMenu.this.dialogHandler, TreeContextMenu.this.sessionStorage, TreeContextMenu.this.treeHelper, TreeContextMenu.this.versionManager.getApplicationVersion());
                importExportUI.showDialog(TreeContextMenu.this.windowManager.getMainFrame());
            }
        });
        this.addItem("import", 0, this.importExportFavouritesMenuItem);
    }

    public void initAddMenu(JMenu addMenu, Object targetNodeUserObject) {
        addMenu.removeAll();
        if (!(targetNodeUserObject instanceof ArbilDataNode) || ((ArbilDataNode)targetNodeUserObject).isCorpus()) {
            for (ArbilTemplateManager.MenuItemData currentAddable : ArbilTemplateManager.getSingleInstance().getSelectedTemplatesMenuItems()) {
                if (targetNodeUserObject instanceof ArbilDataNode && currentAddable.type != ArbilTemplateManager.MenuItemData.Type.IMDI) continue;
                JMenuItem addMenuItem = new JMenuItem();
                addMenuItem.setText(currentAddable.menuText);
                addMenuItem.setName(currentAddable.menuText);
                addMenuItem.setActionCommand(currentAddable.menuAction);
                addMenuItem.setToolTipText(currentAddable.menuToolTip);
                addMenuItem.setIcon(currentAddable.menuIcon);
                addMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        TreeContextMenu.this.treeController.addNodeFromTemplate(TreeContextMenu.this.leadSelectedDataNode, evt.getActionCommand(), ((JMenuItem)evt.getSource()).getText());
                    }
                });
                addMenu.add(addMenuItem);
            }
        }
        if (targetNodeUserObject instanceof ArbilDataNode) {
            ArbilTemplate currentTemplate = ((ArbilDataNode)targetNodeUserObject).getNodeTemplate();
            MetadataBuilder mdBuilder = new MetadataBuilder();
            Enumeration menuItemName = currentTemplate.listTypesFor(targetNodeUserObject);
            while (menuItemName.hasMoreElements()) {
                String[] currentField = (String[])menuItemName.nextElement();
                final String nodeText = currentField[0];
                final String nodeType = currentField[1];
                JMenuItem addMenuItem = new JMenuItem();
                addMenuItem.setText(nodeText);
                addMenuItem.setName(nodeText);
                addMenuItem.setToolTipText(nodeType);
                if (null != currentTemplate.pathIsChildNode(nodeType)) {
                    addMenuItem.setIcon(ArbilIcons.getSingleInstance().dataIcon);
                } else {
                    addMenuItem.setIcon(ArbilIcons.getSingleInstance().fieldIcon);
                }
                if (mdBuilder.canAddChildNode((ArbilDataNode)targetNodeUserObject, nodeType)) {
                    addMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            TreeContextMenu.this.treeController.addSubnode(TreeContextMenu.this.leadSelectedDataNode, nodeType, nodeText);
                        }
                    });
                } else {
                    addMenuItem.setEnabled(false);
                }
                addMenu.add(addMenuItem);
            }
        }
    }

    public void initHistoryMenu() {
        this.historyMenu.removeAll();
        for (String[] currentHistory : this.leadSelectedDataNode.getHistoryList()) {
            JMenuItem revertHistoryMenuItem = new JMenuItem();
            revertHistoryMenuItem.setText(currentHistory[0]);
            revertHistoryMenuItem.setName(currentHistory[0]);
            revertHistoryMenuItem.setActionCommand(currentHistory[1]);
            revertHistoryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        if (!TreeContextMenu.this.leadSelectedDataNode.resurrectHistory(evt.getActionCommand())) {
                            TreeContextMenu.this.dialogHandler.addMessageDialogToQueue(menus.getString("COULD NOT REVERT VERSION, NO CHANGES MADE"), menus.getString("HISTORY"));
                        }
                    }
                    catch (Exception ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
            });
            this.historyMenu.add(revertHistoryMenuItem);
        }
    }

    public void initAddFromFavouritesMenu() {
        this.addFromFavouritesMenu.removeAll();
        Object targetObject = this.leadSelectedDataNode;
        if (targetObject == null) {
            targetObject = ((DefaultMutableTreeNode)this.treeHelper.getLocalCorpusTreeModel().getRoot()).getUserObject();
        }
        for (ArbilDataNode menuItemName : ArbilFavourites.getSingleInstance().listFavouritesFor(targetObject)) {
            JMenuItem addFavouriteMenuItem = new JMenuItem();
            addFavouriteMenuItem.setText(menuItemName.toString());
            addFavouriteMenuItem.setName(menuItemName.toString());
            addFavouriteMenuItem.setActionCommand(menuItemName.getUrlString());
            addFavouriteMenuItem.setIcon(menuItemName.getIcon());
            addFavouriteMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TreeContextMenu.this.treeController.addFromFavourite(TreeContextMenu.this.leadSelectedDataNode, evt.getActionCommand(), ((JMenuItem)evt.getSource()).getText());
                }
            });
            this.addFromFavouritesMenu.add(addFavouriteMenuItem);
        }
    }

    private ArbilTreePanels getTreePanel() {
        if (this.treeHelper instanceof ArbilTreeHelper) {
            return ((ArbilTreeHelper)this.treeHelper).getArbilTreePanel();
        }
        return null;
    }

    protected void setAllInvisible() {
        this.removeCachedCopyMenuItem.setVisible(false);
        this.removeLocalDirectoryMenuItem.setVisible(false);
        this.addLocalDirectoryMenuItem.setVisible(false);
        this.showHiddenFilesMenuItem.setVisible(false);
        this.removeRemoteCorpusMenuItem.setVisible(false);
        this.addRemoteCorpusMenuItem.setVisible(false);
        this.addRemoteCorpusToRootMenuItem.setVisible(false);
        this.copyBranchMenuItem.setVisible(false);
        this.searchRemoteBranchMenuItem.setVisible(false);
        this.copyNodeUrlMenuItem.setVisible(false);
        this.pasteMenuItem1.setVisible(false);
        this.searchSubnodesMenuItem.setVisible(false);
        this.reloadSubnodesMenuItem.setVisible(false);
        this.addDefaultLocationsMenuItem.setVisible(false);
        this.addMenu.setVisible(false);
        this.deleteMenuItem.setVisible(false);
        this.viewSelectedNodesMenuItem.setVisible(false);
        this.addFromFavouritesMenu.setVisible(false);
        this.importExportFavouritesMenuItem.setVisible(false);
        this.groupFavouritesMenuItem.setVisible(false);
        this.validateMenuItem.setVisible(false);
        this.historyMenu.setVisible(false);
        this.exportMenuItem.setVisible(false);
        this.importCsvMenuItem.setVisible(false);
        this.importBranchMenuItem.setVisible(false);
        this.reImportBranchMenuItem.setVisible(false);
        this.addToFavouritesMenuItem.setVisible(false);
        this.removeFromFavouritesMenuItem.setVisible(false);
        this.viewSelectedSubnodesMenuItem.setVisible(false);
        this.editInLongFieldEditor.setVisible(false);
        this.setManualResourceLocationMenuItem.setVisible(false);
        this.forceTypeCheckMenuItem.setVisible(false);
    }
}

