/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdi.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nl.mpi.imdi.api.CreateLinks;
import nl.mpi.imdi.api.IMDIAPIImpl;
import nl.mpi.imdi.api.IMDIEdit;
import nl.mpi.imdi.api.IMDIElement;
import nl.mpi.imdi.api.IMDILink;
import nl.mpi.imdi.api.IMDIXMLFormat;
import nl.mpi.imdi.api.KeyValuePairs;
import nl.mpi.imdi.api.MyErrorHandler;
import nl.mpi.imdi.api.WSNodeType;
import nl.mpi.util.OurURL;
import nl.mpi.util.URIUtil;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IMDIDom
implements IMDIEdit {
    private static Logger logger = LoggerFactory.getLogger((String)IMDIDom.class.getName());
    private EntityResolver resolver = null;
    private String message = "";
    private boolean verbose = false;
    public final String defLangId = "ISO639-2:eng";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMDIDom() {
        try {
            if (TransformerFactory.newInstance().newTransformer() != null) {
                // empty if block
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            logger.error("No XML Transformer - no IMDI API writeDOM / applyStyleSheet. Install Xerces and Xalan...", (Throwable)ncdfe);
            System.out.println("No XML Transformer - no writeDOM / applyStyleSheet. install Xerces and Xalan...");
            throw new RuntimeException(ncdfe);
        }
        catch (TransformerConfigurationException tce) {
            logger.error("Got TransformerConfigurationException, cannot init transformer: " + tce, (Throwable)tce);
            System.out.println("XML Transformer configuration invalid??");
            throw new RuntimeException(tce);
        }
        try {
            if (!IMDIXMLFormat.pointsToAttribute("/:Bogus")) return;
            return;
        }
        catch (NoClassDefFoundError ncdfe) {
            logger.error("No XPathAPI implementation, IMDI API cannot start. Install Xerces and Xalan...", (Throwable)ncdfe);
            System.out.println("No XPathAPI implementation, IMDI API cannot start. Install Xerces and Xalan...");
            throw new RuntimeException(ncdfe);
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setVerbose(boolean verb) {
        this.verbose = verb;
    }

    protected boolean getVerbose() {
        return this.verbose;
    }

    @Override
    public void setEntityResolver(EntityResolver res) {
        if (this.verbose) {
            logger.debug("## setEntityResolver: " + res);
        }
        this.resolver = res;
    }

    @Override
    public boolean writeDOM(Document dom, File file, boolean clean) {
        boolean success = true;
        try {
            dom.normalize();
            if (clean) {
                IMDIXMLFormat.removeDomIds(dom.getDocumentElement());
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(dom);
            FileOutputStream fos = new FileOutputStream(file);
            StreamResult result = new StreamResult(fos);
            transformer.transform(source, result);
            result.getOutputStream().flush();
            result.getOutputStream().close();
        }
        catch (IOException ioe) {
            this.SEPe("writeDOM: error writing to disk, " + ioe);
            success = false;
        }
        catch (TransformerConfigurationException tce) {
            success = false;
            this.SEPe("writeDOM: TransformerConfigurationException writing IMDI file: " + tce.getMessage());
        }
        catch (TransformerException te) {
            success = false;
            this.SEPe("writeDOM: TransformerException writing IMDI file: " + te.getMessage());
        }
        return success;
    }

    @Override
    public Document loadIMDIDocument(OurURL url, boolean validateFile) {
        return this.loadIMDIDocument(url, validateFile, this.resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document loadIMDIDocument(OurURL url, boolean validateFile, EntityResolver eResolver) {
        Document doc;
        InputStream fileStream = null;
        try {
            String fileName = url.toString();
            String uri = fileName.substring(0, fileName.lastIndexOf(47) + 1);
            fileStream = url.openStream();
            InputSource fileSource = new InputSource(fileStream);
            fileSource.setSystemId(uri);
            if (validateFile) {
                MyErrorHandler me = new MyErrorHandler();
                DocumentBuilder documentBuilder = IMDIXMLFormat.valDocBuilder;
                synchronized (documentBuilder) {
                    IMDIXMLFormat.valDocBuilder.setEntityResolver(eResolver);
                    IMDIXMLFormat.valDocBuilder.setErrorHandler(me);
                    doc = IMDIXMLFormat.valDocBuilder.parse(fileSource);
                }
                if (me.hasParseErrors()) {
                    this.message = me.getErrorMessage();
                    documentBuilder = null;
                    return documentBuilder;
                }
            } else {
                DocumentBuilder documentBuilder = IMDIXMLFormat.docBuilder;
                synchronized (documentBuilder) {
                    IMDIXMLFormat.docBuilder.setEntityResolver(eResolver);
                    doc = IMDIXMLFormat.docBuilder.parse(fileSource);
                }
            }
            doc.normalize();
        }
        catch (SAXParseException spe) {
            doc = null;
            this.SEPe("SAXParseException opening IMDI file: " + spe.getMessage());
            this.message = spe.getMessage();
        }
        catch (SAXException sxe) {
            doc = null;
            this.SEPe("SAXException opening IMDI file: " + sxe.getMessage());
            this.message = sxe.getMessage();
        }
        catch (IOException ioe) {
            doc = null;
            this.SEPe("IOException opening IMDI file: " + url + " " + ioe.getMessage() + " resolver=" + eResolver);
        }
        catch (NullPointerException npe) {
            doc = null;
            this.SEPe("NullPointerException opening IMDI file: " + url + " " + npe.getMessage() + " resolver=" + eResolver);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (doc == null) {
            return null;
        }
        boolean domOkay = IMDIXMLFormat.domify(doc);
        return doc;
    }

    @Override
    public Document createIMDIDOM(int imdiFileType) {
        Document doc = null;
        GregorianCalendar now = new GregorianCalendar();
        StringBuffer dateNow = new StringBuffer(12);
        dateNow.append(now.get(1)).append("-");
        if (now.get(2) < 9) {
            dateNow.append("0");
        }
        dateNow.append(1 + now.get(2) - 0).append("-");
        if (now.get(5) < 10) {
            dateNow.append("0");
        }
        dateNow.append(now.get(5));
        if (imdiFileType == 1 || imdiFileType == 2 || imdiFileType == 8) {
            doc = IMDIXMLFormat.loadTemplate(imdiFileType);
            if (doc != null) {
                doc.normalize();
                IMDIXMLFormat.domify(doc);
            }
            if (doc != null && imdiFileType == 1) {
                if (!this.removeIMDILink(doc, new IMDIElement("Session.MediaFile"))) {
                    this.SEPi("No removable Session.MediaFile placeholder anyway");
                }
                if (!this.removeIMDILink(doc, new IMDIElement("Session.WrittenResource"))) {
                    this.SEPi("No removable Session.WrittenResource placeholder anyway");
                }
                if (!this.removeIMDILink(doc, new IMDIElement("Session.LexiconResource"))) {
                    this.SEPi("No removable Session.LexiconResource placeholder anyway");
                }
            }
            if (doc != null && (imdiFileType == 2 || imdiFileType == 8 || imdiFileType == 1)) {
                try {
                    Node rootThing = XPathAPI.selectSingleNode((Node)doc.getDocumentElement(), (String)"/:METATRANSCRIPT");
                    if (rootThing != null && rootThing instanceof Element) {
                        ((Element)rootThing).setAttribute("Type", imdiFileType == 2 ? "CORPUS" : (imdiFileType == 1 ? "SESSION" : "CATALOGUE"));
                    }
                    if (rootThing != null && rootThing instanceof Element) {
                        ((Element)rootThing).setAttribute("Date", dateNow.toString());
                    }
                }
                catch (TransformerException te) {
                    this.SEPe("Cannot set Type for template for: " + WSNodeType.nameForType(imdiFileType));
                }
            }
        } else {
            this.SEPe("Cannot load template for type: " + WSNodeType.nameForType(imdiFileType));
        }
        return doc;
    }

    @Override
    public boolean isIMDIFileType(Document doc, int imdiFileType) {
        if (imdiFileType != 2 && imdiFileType != 1 && imdiFileType != 8) {
            this.SEPe("Invalid IMDI file type check requested. Type: " + imdiFileType);
            return false;
        }
        Element root = doc.getDocumentElement();
        return IMDIXMLFormat.selectElement(root, imdiFileType) != null;
    }

    @Override
    public boolean isValidIMDIFile(OurURL url) {
        return this.isValidIMDIFile(url, this.resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidIMDIFile(OurURL url, EntityResolver eResolver) {
        block27: {
            boolean bl;
            String fileName = url.toString();
            String uri = "";
            uri = fileName.lastIndexOf(47) > fileName.lastIndexOf(92) ? fileName.substring(0, fileName.lastIndexOf(47) + 1) : fileName.substring(0, fileName.lastIndexOf(92) + 1);
            MyErrorHandler me = new MyErrorHandler();
            InputSource fileSource = null;
            InputStream fileStream = null;
            try {
                fileStream = url.openStream();
                fileSource = new InputSource(fileStream);
                fileSource.setSystemId(uri);
                Document doc = null;
                DocumentBuilder documentBuilder = IMDIXMLFormat.valDocBuilder;
                synchronized (documentBuilder) {
                    IMDIXMLFormat.valDocBuilder.setEntityResolver(eResolver);
                    IMDIXMLFormat.valDocBuilder.setErrorHandler(me);
                    doc = IMDIXMLFormat.valDocBuilder.parse(fileSource);
                }
                if (me.hasParseErrors()) {
                    boolean bl2 = false;
                    return bl2;
                }
                doc.normalize();
                bl = true;
            }
            catch (SAXException sxe) {
                this.SEPe("SAXException validating IMDI: " + sxe.getMessage());
                this.message = sxe.getMessage();
                break block27;
            }
            catch (IOException ioe) {
                this.SEPe("IOException validating IMDI: " + ioe.getMessage());
                this.message = ioe.getMessage();
                break block27;
            }
            catch (NullPointerException npe) {
                this.SEPe("NullPointerException validating IMDI: " + npe.getMessage());
                this.message = npe.getMessage();
                break block27;
            }
            finally {
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (IOException ioe2) {}
                }
            }
            return bl;
        }
        return false;
    }

    boolean applyStyleSheet(OurURL url, String styleSheetName) {
        try {
            StreamSource sSource = new StreamSource(IMDIAPIImpl.class.getResource(styleSheetName).openStream());
            return this.applyStyleSheet(url, sSource);
        }
        catch (IOException ioe) {
            this.SEPw("applyStyleSheet: cannot load resource: " + styleSheetName);
            return false;
        }
    }

    boolean applyStyleSheet(OurURL url, OurURL styleSheetURL) {
        StreamSource sSource = new StreamSource(styleSheetURL.getPath());
        return this.applyStyleSheet(url, sSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean applyStyleSheet(OurURL url, StreamSource styleSource) {
        boolean success = true;
        File temp = new File(url.getPath() + ".tmp");
        TransformerFactory tFactory = TransformerFactory.newInstance();
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(url.getPath());
            os = new FileOutputStream(temp);
            StreamSource source = new StreamSource(is);
            StreamResult result = new StreamResult(os);
            Transformer transformer = tFactory.newTransformer(styleSource);
            transformer.transform(source, result);
            os.flush();
            os.close();
            os = null;
            is.close();
            is = null;
            File nw = new File(url.getPath());
            if (temp.renameTo(nw)) {
                boolean bl = this.isValidIMDIFile(url);
                return bl;
            }
            this.SEPi("Problem applying style sheet: unable to rename transformed file: deleting temp file " + temp.toString());
            if (!temp.delete()) {
                this.SEPe("Failed to delete temp file: " + temp);
            }
        }
        catch (TransformerException te) {
            this.SEPe("TransformerException applying style sheet: " + te.getMessage());
        }
        catch (IOException ioe) {
            this.SEPe("IOException applying style sheet: " + ioe.getMessage());
        }
        catch (SecurityException se) {
            this.SEPe("SecurityException applying style sheet: " + se.getMessage());
        }
        finally {
            if (temp.exists()) {
                try {
                    if (!temp.delete()) {
                        this.SEPe("Failed to delete temp file: " + temp);
                    }
                }
                catch (SecurityException se) {
                    this.SEPe("SecurityException trying to delete file: " + temp);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    this.SEPe("IOException closing input stream in applying style sheet: " + ioe);
                }
            }
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException ioe) {
                    this.SEPe("IOException closing output stream in applying style sheet: " + ioe);
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IMDILink createIMDILink(Document doc, OurURL url, String urlToLink, String linkName, int linkType, String spec) {
        IMDILink link;
        IMDILink result;
        block40: {
            OurURL targetURL;
            block39: {
                if (this.verbose) {
                    logger.debug("## createIMDILink called, url=" + urlToLink + " name=" + linkName + " type=" + WSNodeType.nameForType(linkType) + " spec=" + spec);
                }
                targetURL = null;
                result = null;
                try {
                    targetURL = new OurURL(url, urlToLink);
                }
                catch (MalformedURLException mue) {
                    if (urlToLink == null || urlToLink.length() <= 0 || urlToLink.startsWith("notyet")) break block39;
                    this.SEPw("Malformed URL ignored: " + urlToLink);
                }
            }
            link = new IMDILink(spec, null, linkType, targetURL);
            link.setLinkName(linkName);
            link.setValue(linkName);
            if (urlToLink != null && urlToLink.startsWith("notyet")) {
                link.setLinkDefinition(urlToLink);
            } else {
                String relativeUrl = urlToLink;
                if (targetURL != null && "file".equals(targetURL.getProtocol())) {
                    File targetFile = new File(targetURL.getFile().replaceAll("%20", " "));
                    File domFile = new File(url.getFile().replaceAll("%20", " "));
                    relativeUrl = URIUtil.calculateRelativeURI((File)domFile, (File)targetFile);
                    if (this.verbose) {
                        logger.debug("## calculateRelativeURI: " + domFile + ", " + targetFile + " -> " + relativeUrl);
                    }
                }
                link.setLinkDefinition(relativeUrl);
            }
            link.setURIDfromURL();
            if (spec != null && linkType != 3) {
                this.SEPi("Link type is " + WSNodeType.nameForType(linkType) + ", not Info file, spec ignored: " + spec);
            }
            if (linkName != null && (linkType == 5 || linkType == 4 || linkType == 8 || linkType == 7)) {
                this.SEPi("Link description ignored for " + WSNodeType.nameForType(linkType) + ": " + linkName);
            }
            if (!(linkType != 4 && linkType != 5 && linkType != 7 || this.isIMDIFileType(doc, 1))) {
                this.SEPe("Link to resources only allowed in session files");
                return null;
            }
            if (linkType == 2 || linkType == 1) {
                if (!this.isIMDIFileType(doc, 2)) {
                    this.SEPi("Cannot create CorpusLink in non-corpus file!");
                    result = null;
                } else {
                    result = CreateLinks.createCorpusLink(doc, link, this);
                }
            } else {
                if (linkType == 8) {
                    if (!this.isIMDIFileType(doc, 2)) {
                        this.SEPi("Cannot create CatalogueLink in non-corpus file!");
                        result = null;
                        break block40;
                    } else {
                        if (this.verbose) {
                            logger.debug("## CatalogueLink set: " + url + " -> " + urlToLink);
                        }
                        if (!this.setIMDIValue(doc, "Corpus.Catalogue.CatalogueLink", link.getLinkDefinition())) return null;
                        IMDILink iMDILink = link;
                        result = iMDILink;
                        if (result != null) {
                            result.setLinkDefinition(urlToLink);
                            if (link.getURID() != null && link.getURID().length() > 0) {
                                if (!this.setIMDIValue(doc, "Corpus.Catalogue.CatalogueHandle", link.getURID())) {
                                    return null;
                                }
                            } else {
                                this.removeIMDIElement(doc, new IMDIElement("Corpus.Catalogue.CatalogueHandle"));
                            }
                        }
                        if (result == null) {
                            return null;
                        }
                        IMDILink iMDILink2 = this.getCatalogueLink(doc, url);
                        return iMDILink2;
                    }
                }
                if (linkType == 5) {
                    result = CreateLinks.createMediaFile(doc, link, this);
                } else if (linkType == 4) {
                    result = CreateLinks.createWrittenResource(doc, link, this);
                } else if (linkType == 7) {
                    result = CreateLinks.createLexiconResource(doc, link, this);
                } else if (linkType == 3) {
                    if (link.getLanguageId() == null) {
                        link.setLanguageId("ISO639-2:eng");
                    }
                    this.message = "";
                    if (link.getSpec() == null || link.getSpec().length() == 0) {
                        if (this.isIMDIFileType(doc, 1)) {
                            link.setSpec("Session");
                        } else if (this.isIMDIFileType(doc, 2)) {
                            link.setSpec("Corpus");
                        } else {
                            if (!this.isIMDIFileType(doc, 8)) {
                                this.SEPe("createIMDILink: Cannot add default info links to unknown file=" + url);
                                return null;
                            }
                            link.setSpec("Catalogue");
                        }
                    }
                    if (this.verbose) {
                        logger.debug("## createInfoFile called, target url=" + link.getRawURL() + " desc=" + link.getValue() + " spec=" + link.getSpec());
                    }
                    result = CreateLinks.createInfoFile(doc, link, this);
                } else {
                    this.SEPe("Unknown link type: " + linkType);
                    result = null;
                }
            }
        }
        if (result != null) return result;
        this.SEPw("createIMDILink: Failed for type=" + WSNodeType.nameForType(linkType) + " spec=" + link.getSpec() + " file=" + url);
        return result;
    }

    @Override
    public boolean changeIMDILink(Document doc, OurURL url, IMDILink link) {
        Element el;
        boolean result = false;
        if (doc == null || doc.getDocumentElement() == null) {
            this.SEPw("changeIMDILink: Empty document! Link was: " + link);
            return false;
        }
        if (link == null) {
            return false;
        }
        Object spec = null;
        String linkUrl = null;
        if (link.getRawURL() != null) {
            linkUrl = link.getRawURL().toString();
            if ("file".equals(link.getRawURL().getProtocol())) {
                File targetFile = new File(link.getRawURL().getFile().replaceAll("%20", " "));
                File domFile = new File(url.getFile().replaceAll("%20", " "));
                linkUrl = URIUtil.calculateRelativeURI((File)domFile, (File)targetFile);
                if (this.verbose) {
                    logger.debug("## calculateRelativeURI: " + domFile + ", " + targetFile + " -> " + linkUrl);
                }
            }
            link.setLinkDefinition(linkUrl);
        } else {
            linkUrl = link.getLinkDefinition();
        }
        if (link.getNodeType() == 8) {
            result = this.setIMDIValue(doc, "Corpus.Catalogue.CatalogueLink", link.getLinkDefinition());
            if (result) {
                if (link.getURID() != null && link.getURID().length() > 0) {
                    result = this.setIMDIValue(doc, "Corpus.Catalogue.CatalogueHandle", link.getURID());
                } else {
                    this.removeIMDIElement(doc, new IMDIElement("Corpus.Catalogue.CatalogueHandle"));
                }
            }
            if (this.verbose) {
                logger.debug("## changeIMDILink: catalogue link=" + link + " url=" + link.getRawURL() + " urid=" + link.getURID() + " success=" + result);
            }
            return result;
        }
        Element uridEl = el = IMDIXMLFormat.getElementById(link.getDomId(), doc.getDocumentElement());
        if (el == null) {
            this.SEPw("changeIMDILink: no such element: " + link.getDomId());
            return false;
        }
        if (!el.getNodeName().equals(IMDIXMLFormat.getElementName(link.getNodeType()))) {
            this.SEPw("changeIMDILink: Element name " + el.getNodeName() + " not suitable for link type: " + WSNodeType.nameForType(link.getNodeType()) + " (" + link.getNodeType() + "), expected: " + IMDIXMLFormat.getElementName(link.getNodeType()) + ", RawURL: " + link.getRawURL() + ", LinkDef: " + link.getLinkDefinition() + ", DocURL: " + url);
            return false;
        }
        if (link.getNodeType() == 2 || link.getNodeType() == 1) {
            IMDIXMLFormat.setFirstChildValue(doc, el, linkUrl);
            if (link.getLinkName() != null && link.getLinkName().length() > 0) {
                el.setAttribute("Name", link.getLinkName());
                result = true;
            }
        } else if (link.getNodeType() == 3) {
            el.setAttribute(IMDIXMLFormat.getLinkXPath(3), linkUrl);
            if (link.getLanguageId() != null && link.getLanguageId().length() > 0) {
                el.setAttribute("LanguageId", link.getLanguageId());
            } else {
                el.setAttribute("LanguageId", "");
            }
            if (link.getValue() != null) {
                IMDIXMLFormat.setFirstChildValue(doc, el, link.getValue());
            } else {
                IMDIXMLFormat.setFirstChildValue(doc, el, "");
            }
            result = true;
        } else if (link.getNodeType() == 5 || link.getNodeType() == 4 || link.getNodeType() == 7) {
            Node resLinkNode = IMDIXMLFormat.selectLink(el, link.getNodeType());
            if (resLinkNode instanceof Element) {
                uridEl = (Element)resLinkNode;
            }
            if (!IMDIXMLFormat.setFirstChildValue(doc, resLinkNode, linkUrl)) {
                this.SEPw("changeIMDILink: node for update not found: " + el + " type: " + WSNodeType.nameForType(link.getNodeType()));
                return false;
            }
            result = true;
            if (link.getType() != null && link.getType().length() > 0) {
                Node typeNode = IMDIXMLFormat.selectType(el);
                result = IMDIXMLFormat.setFirstChildValue(doc, typeNode, link.getType());
            }
            if (link.getFormat() != null && link.getFormat().length() > 0) {
                Node fmtNode = IMDIXMLFormat.selectFormat(el);
                result = IMDIXMLFormat.setFirstChildValue(doc, fmtNode, link.getFormat());
            }
        }
        if (result && link.getURID() != null && link.getURID().length() > 0) {
            uridEl.setAttribute("ArchiveHandle", link.getURID());
        } else {
            uridEl.removeAttribute("ArchiveHandle");
        }
        if (this.verbose) {
            logger.debug("## changeIMDILink: link=" + link + " url=" + link.getRawURL() + " urid=" + link.getURID() + " success=" + result);
        }
        return result;
    }

    @Override
    public boolean removeIMDILink(Document doc, IMDIElement il) {
        if ("Corpus.Catalogue.CatalogueLink".equals(il.getSpec())) {
            this.removeIMDIElement(doc, new IMDIElement("Corpus.Catalogue.CatalogueHandle"));
        }
        return this.removeIMDIElement(doc, il);
    }

    @Override
    public IMDILink[] getIMDILinks(Document doc, OurURL url, int nodeType) {
        if (nodeType == 6) {
            int i;
            IMDILink[] cls = this.getAllCorpusOrResourceLinks(doc, url, 2);
            IMDILink[] mfls = this.getAllCorpusOrResourceLinks(doc, url, 5);
            IMDILink[] wrls = this.getAllCorpusOrResourceLinks(doc, url, 4);
            IMDILink[] lxls = this.getAllCorpusOrResourceLinks(doc, url, 7);
            IMDILink[] ifs = this.getAllInfoFileLinks(doc, url);
            IMDILink c = this.getCatalogueLink(doc, url);
            if (cls == null || mfls == null || wrls == null || lxls == null || ifs == null) {
                return null;
            }
            int count = cls.length + mfls.length + wrls.length + lxls.length + ifs.length;
            if (c != null) {
                ++count;
            }
            IMDILink[] links = new IMDILink[count];
            if (c != null) {
                links[0] = c;
            }
            count = c != null ? 1 : 0;
            for (i = 0; i < cls.length; ++i) {
                links[count++] = cls[i];
            }
            for (i = 0; i < mfls.length; ++i) {
                links[count++] = mfls[i];
            }
            for (i = 0; i < wrls.length; ++i) {
                links[count++] = wrls[i];
            }
            for (i = 0; i < lxls.length; ++i) {
                links[count++] = lxls[i];
            }
            for (i = 0; i < ifs.length; ++i) {
                links[count++] = ifs[i];
            }
            return links;
        }
        if (nodeType == 2 || nodeType == 5 || nodeType == 4 || nodeType == 7) {
            return this.getAllCorpusOrResourceLinks(doc, url, nodeType);
        }
        if (nodeType == 3) {
            return this.getAllInfoFileLinks(doc, url);
        }
        if (nodeType == 8) {
            IMDILink c = this.getCatalogueLink(doc, url);
            if (c == null) {
                return new IMDILink[0];
            }
            IMDILink[] links = new IMDILink[]{c};
            return links;
        }
        this.SEPi("getIMDILinks: invalid link type: " + nodeType);
        return null;
    }

    @Override
    public IMDILink getIMDILink(Document doc, OurURL url, String domNodeId) {
        this.message = "generic getIMDILink error";
        if (domNodeId == null || domNodeId.length() == 0) {
            return null;
        }
        Element el = null;
        if (!domNodeId.startsWith("i")) {
            String query = IMDIXMLFormat.spec2XPath(domNodeId);
            if (query == null) {
                return null;
            }
            try {
                domNodeId = IMDIXMLFormat.getDomId(XPathAPI.selectSingleNode((Node)doc.getDocumentElement(), (String)query));
            }
            catch (TransformerException te) {
                domNodeId = null;
            }
            if (this.verbose) {
                logger.debug("## getIMDILink: " + query + " => " + domNodeId);
            }
            if (domNodeId == null) {
                return null;
            }
        }
        if ((el = IMDIXMLFormat.getElementById(domNodeId, doc.getDocumentElement())) == null) {
            return null;
        }
        String spec = IMDIXMLFormat.generateSpecFromNode(el);
        if (el.getNodeName().equals(IMDIXMLFormat.getElementName(8))) {
            return this.getCatalogueLink(doc, url);
        }
        if (el.getNodeName().equals(IMDIXMLFormat.getElementName(2))) {
            String linkUrl = IMDIXMLFormat.getFirstChildValue(el);
            if (linkUrl == null || linkUrl.trim().length() == 0) {
                logger.debug("getIMDILink: null CorpusLink ignored in " + url);
                return null;
            }
            OurURL curl = null;
            try {
                curl = new OurURL(url, linkUrl.trim());
            }
            catch (MalformedURLException murl) {
                curl = null;
            }
            IMDILink result = new IMDILink(spec, domNodeId, 2, curl);
            result.setLinkDefinition(linkUrl);
            result.setLinkName(IMDIXMLFormat.getAttribute(el, "Name"));
            result.setURID(IMDIXMLFormat.getAttribute(el, "ArchiveHandle"));
            return result;
        }
        if (el.getNodeName().equals(IMDIXMLFormat.getElementName(3))) {
            OurURL curl = null;
            String linkUrl = IMDIXMLFormat.getAttribute(el, IMDIXMLFormat.getLinkXPath(3));
            if (linkUrl != null && linkUrl.trim().length() == 0) {
                try {
                    curl = new OurURL(url, linkUrl.trim());
                }
                catch (MalformedURLException murl) {
                    curl = null;
                }
            }
            IMDILink result = new IMDILink(spec, domNodeId, 3, curl);
            if (linkUrl != null && linkUrl.trim().length() > 0) {
                result.setLinkDefinition(linkUrl);
            }
            result.setLanguageId(IMDIXMLFormat.getAttribute(el, "LanguageId"));
            if (result.getLanguageId() == null) {
                result.setLanguageId("ISO639-2:eng");
            }
            result.setURID(IMDIXMLFormat.getAttribute(el, "ArchiveHandle"));
            result.setValue(IMDIXMLFormat.getFirstChildValue(el));
            return result;
        }
        if (el.getNodeName().equals(IMDIXMLFormat.getElementName(5)) || el.getNodeName().equals(IMDIXMLFormat.getElementName(4)) || el.getNodeName().equals(IMDIXMLFormat.getElementName(7))) {
            int nodeType = 4;
            if (el.getNodeName().equals(IMDIXMLFormat.getElementName(5))) {
                nodeType = 5;
            }
            if (el.getNodeName().equals(IMDIXMLFormat.getElementName(7))) {
                nodeType = 7;
            }
            OurURL curl = null;
            Node resLinkNode = IMDIXMLFormat.selectLink(el, nodeType);
            if (resLinkNode != null) {
                String linkUrl = IMDIXMLFormat.getFirstChildValue(resLinkNode);
                if (linkUrl == null || linkUrl.trim().length() == 0) {
                    logger.debug("getIMDILink: null resource link in: " + url);
                    return null;
                }
                try {
                    curl = new OurURL(url, linkUrl.trim());
                }
                catch (MalformedURLException murl) {
                    curl = null;
                }
                IMDILink result = new IMDILink(spec, domNodeId, nodeType, curl);
                result.setLinkDefinition(linkUrl);
                result.setURID(IMDIXMLFormat.getAttribute(el, "ArchiveHandle"));
                result.setType(IMDIXMLFormat.getFirstChildValue(IMDIXMLFormat.selectType(el)));
                result.setFormat(IMDIXMLFormat.getFirstChildValue(IMDIXMLFormat.selectFormat(el)));
                if (result.getURID() == null) {
                    result.setURID(IMDIXMLFormat.getAttribute(resLinkNode, "ArchiveHandle"));
                }
                return result;
            }
            this.SEPw("getIMDILink: no ResourceLink element below: " + el);
            return null;
        }
        return null;
    }

    @Override
    public IMDIElement setIMDIElement(Document doc, IMDIElement il) {
        if (il.getValue() == null) {
            return null;
        }
        IMDIElement result = null;
        if (il.getDomId() != null) {
            Element el = IMDIXMLFormat.getElementById(il.getDomId(), doc.getDocumentElement());
            if (el != null) {
                String attName = il.getAttributeName();
                if (attName != null && attName.length() > 0) {
                    try {
                        el.setAttribute(attName, il.getValue());
                        result = il;
                    }
                    catch (DOMException de) {
                        this.SEPe("DOMException while setting IMDI value: " + de.getMessage());
                    }
                } else if (IMDIXMLFormat.setFirstChildValue(doc, el, il.getValue())) {
                    result = il;
                }
                if (result != null) {
                    if (this.verbose) {
                        logger.debug("## setIMDIElement: by domId=" + il.getDomId() + " value='" + il.getValue() + "' result=" + result + " ignored-spec=" + il.getSpec());
                    }
                    return result;
                }
                this.SEPw("setIMDIElement: domId access problems, trying to set by spec");
            } else {
                this.SEPe("setIMDIElement: domid not found: " + il.getDomId() + " (spec:" + il.getSpec() + ")");
            }
            return null;
        }
        try {
            Element root = doc.getDocumentElement();
            String query = IMDIXMLFormat.spec2XPath(il.getSpec());
            if (query == null) {
                return null;
            }
            if (IMDIXMLFormat.pointsToAttribute(query)) {
                String nodeQuery = query.substring(0, query.lastIndexOf(64) - 1);
                String attName = IMDIXMLFormat.whichAttribute(il.getSpec());
                Node node = XPathAPI.selectSingleNode((Node)root, (String)nodeQuery);
                if (node == null) {
                    this.SEPw("setIMDIElement: No element for: " + query + " / " + nodeQuery);
                    return null;
                }
                if (!(node instanceof Element)) {
                    this.SEPw("setIMDIElement: Not an element: " + query + " / " + nodeQuery);
                    return null;
                }
                Element el = (Element)node;
                String domId = IMDIXMLFormat.getDomId(el);
                if (domId == null) {
                    this.SEPw("setIMDIElement: no domId attribute present at: " + nodeQuery);
                    return null;
                }
                il.setDomId(domId);
                el.setAttribute(attName, il.getValue());
                result = il;
            } else {
                Node node = XPathAPI.selectSingleNode((Node)root, (String)query);
                if (node == null || !(node instanceof Element)) {
                    this.SEPw("setIMDIElement: no such node: " + query);
                    return null;
                }
                if (!IMDIXMLFormat.setFirstChildValue(doc, node, il.getValue())) {
                    this.SEPw("setIMDIElement: cannot set node value: " + query);
                    return null;
                }
                Element el = (Element)node;
                String domId = IMDIXMLFormat.getDomId(el);
                if (domId == null) {
                    this.SEPw("setIMDIElement: no domId attribute at: " + query);
                    return null;
                }
                il.setDomId(domId);
                result = il;
            }
        }
        catch (TransformerException te) {
            this.SEPe("TransformerException while setting IMDI value: " + te.getMessage());
        }
        catch (DOMException de) {
            this.SEPe("DOMException while setting IMDI value: " + de.getMessage());
        }
        if (this.verbose) {
            logger.debug("## setIMDIElement: spec=" + il.getSpec() + " value='" + il.getValue() + "' result=" + result);
        }
        return result;
    }

    @Override
    public boolean setIMDIValue(Document doc, String spec, String value) {
        IMDIElement iEmt = new IMDIElement(spec);
        iEmt.setValue(value);
        return this.setIMDIElement(doc, iEmt) != null;
    }

    @Override
    public IMDIElement addIMDIElement(Document doc, String spec) {
        if (!IMDIXMLFormat.isRemovable(spec)) {
            this.SEPw("addIMDIElement: Forbidden to add an Element of spec " + spec);
            return null;
        }
        if (spec.startsWith("Session.MediaFile") && spec.lastIndexOf(46) == 7) {
            this.SEPw("addIMDIElement: Should not be used for media resources: " + spec);
            IMDILink il = new IMDILink(null, null, 5, null);
            il.setLinkDefinition("");
            return CreateLinks.createMediaFile(doc, il, this);
        }
        if (spec.startsWith("Session.WrittenResource") && spec.lastIndexOf(46) == 7) {
            this.SEPw("addIMDIElement: Should not be used for written resources: " + spec);
            IMDILink il = new IMDILink(null, null, 4, null);
            il.setLinkDefinition("");
            return CreateLinks.createWrittenResource(doc, il, this);
        }
        if (spec.startsWith("Session.LexiconResource") && spec.lastIndexOf(46) == 7) {
            this.SEPw("addIMDIElement: Should not be used for lexicon resources: " + spec);
            IMDILink il = new IMDILink(null, null, 7, null);
            il.setLinkDefinition("");
            return CreateLinks.createLexiconResource(doc, il, this);
        }
        IMDIElement result = null;
        boolean ready = false;
        int index = 0;
        Element root = doc.getDocumentElement();
        String query = IMDIXMLFormat.spec2XPath(spec);
        if (query == null) {
            return null;
        }
        String attrName = IMDIXMLFormat.whichAttribute(spec);
        String templateQuery = query.replaceAll("\\[[^\\[]*\\]", "");
        String lastPathElement = templateQuery.substring(templateQuery.lastIndexOf(58) + 1);
        int bidx = lastPathElement.indexOf("[@");
        if (bidx != -1) {
            lastPathElement = lastPathElement.substring(0, bidx);
        }
        if (lastPathElement.length() == 0) {
            this.SEPw("addIMDIElement: Cannot parse spec: " + spec);
            return null;
        }
        try {
            Document dtemp = null;
            dtemp = spec.startsWith("Session") ? IMDIXMLFormat.loadTemplate(1) : IMDIXMLFormat.loadTemplate(2);
            if (dtemp == null) {
                return null;
            }
            Element roottemp = dtemp.getDocumentElement();
            Node template = XPathAPI.selectSingleNode((Node)roottemp, (String)templateQuery);
            if (template == null) {
                this.SEPi("addIMDIElement: could not find Element in template for XPath " + templateQuery);
                return null;
            }
            Node newChild = doc.importNode(template, true);
            Node node = XPathAPI.selectSingleNode((Node)root, (String)query);
            String genericQuery = query;
            while (node == null && genericQuery.endsWith("]")) {
                genericQuery = genericQuery.substring(0, genericQuery.lastIndexOf("["));
                if (this.verbose) {
                    logger.debug("## addIMDIElement: Retrying with generic query: " + genericQuery + " for " + query);
                }
                node = XPathAPI.selectSingleNode((Node)root, (String)genericQuery);
            }
            if (node != null) {
                Node parent = node.getParentNode();
                if (attrName != null) {
                    if (!(node instanceof Element)) {
                        node = parent;
                    }
                    if (node instanceof Element) {
                        Element e = (Element)node;
                        e.setAttribute(attrName, "");
                        newChild = e;
                        ready = true;
                    } else {
                        this.SEPw("addIMDIElement: unexpected attribute set error");
                    }
                } else if (parent == null) {
                    this.SEPw("addIMDIElement: unexpected parent error");
                }
                if (!ready && parent != null) {
                    NodeList childs = parent.getChildNodes();
                    for (int i = childs.getLength() - 1; i >= 0; --i) {
                        if (!childs.item(i).getNodeName().equals(lastPathElement)) continue;
                        if (!ready) {
                            int j = 1;
                            Node next = null;
                            while (i + j < childs.getLength() && childs.item(i + j).getNodeType() != 1) {
                                ++j;
                            }
                            if (i + j < childs.getLength()) {
                                next = childs.item(i + j);
                            }
                            if (parent.insertBefore(newChild, next) != null) {
                                ready = true;
                            }
                            if (!ready) continue;
                            index = 2;
                            continue;
                        }
                        ++index;
                    }
                    if (!ready) {
                        this.SEPw("addIMDIElement: Cannot add element: " + query);
                    }
                }
            } else if (attrName == null) {
                String parentQuery = query.substring(0, query.lastIndexOf(47));
                Node parent = XPathAPI.selectSingleNode((Node)root, (String)parentQuery);
                Node templateParent = template.getParentNode();
                if (parent != null && templateParent != null) {
                    NodeList templateChilds = templateParent.getChildNodes();
                    for (int i = 0; i < templateChilds.getLength(); ++i) {
                        if (ready || !templateChilds.item(i).getNodeName().equals(lastPathElement)) continue;
                        int j = 1;
                        while (i + j < templateChilds.getLength() && (templateChilds.item(i + j).getNodeType() != 1 || templateChilds.item(i + j).getNodeName().equals(lastPathElement))) {
                            ++j;
                        }
                        if (i + j < templateChilds.getLength()) {
                            String nextQuery = parentQuery + "/:" + templateChilds.item(i + j).getNodeName();
                            Node next = XPathAPI.selectSingleNode((Node)root, (String)nextQuery);
                            logger.debug("addIMDIElement: Insert brand-new " + lastPathElement + " before: " + nextQuery + " " + (next == null ? "(NONE)" : "(ok)"));
                            if (parent.insertBefore(newChild, next) == null) continue;
                            ready = true;
                            continue;
                        }
                        logger.debug("addIMDIElement: Insert brand-new " + lastPathElement + " as last: " + query);
                        if (parent.appendChild(newChild) == null) continue;
                        ready = true;
                    }
                } else {
                    if (parent == null) {
                        this.SEPw("addIMDIElement: Parent not found: " + parentQuery);
                    }
                    if (templateParent == null) {
                        this.SEPw("addIMDIElement: Template parent not found above: " + templateQuery);
                    }
                }
                if (ready) {
                    index = 1;
                }
            } else {
                this.SEPw("addIMDIElement: Cannot add attribute: " + attrName + " no node yet: " + query);
            }
            if (ready) {
                String newdomid = null;
                if (attrName != null || IMDIXMLFormat.addDomIds(doc, newChild)) {
                    newdomid = IMDIXMLFormat.getDomId(newChild);
                } else {
                    this.SEPi("addIMDIElement: could not add domNodeIds to the element " + newChild.getNodeName());
                }
                String newspec = spec;
                if (index > 1) {
                    newspec = spec.lastIndexOf(40) + 1 < spec.length() && spec.lastIndexOf(40) > spec.lastIndexOf(46) ? spec.substring(0, spec.lastIndexOf(40) + 1) + index + ")" : spec + "(" + index + ")";
                }
                if (!spec.equals(newspec)) {
                    this.SEPi("addIMDIElement: Tried to create " + spec + " but got " + newspec + " at " + newdomid);
                }
                result = new IMDIElement(newspec, newdomid);
            } else {
                this.SEPw("addIMDIElement: No place found to insert " + lastPathElement);
            }
        }
        catch (TransformerException te) {
            this.SEPe("TransformerException while adding IMDI element: " + te.getMessage());
        }
        catch (DOMException de) {
            this.SEPe("DOMException while adding IMDI element: " + de);
        }
        if (this.verbose) {
            logger.debug("## addIMDIElement: spec=" + spec + " result=" + result);
        }
        return result;
    }

    @Override
    public boolean removeIMDIElement(Document doc, IMDIElement iEmt) {
        if (iEmt.getSpec() != null && !IMDIXMLFormat.isRemovable(iEmt.getSpec())) {
            this.SEPi("removeIMDIElement: Forbidden to remove an Element with spec " + iEmt.getSpec());
            return false;
        }
        try {
            Element el = null;
            if (iEmt.getDomId() != null) {
                el = IMDIXMLFormat.getElementById(iEmt.getDomId(), doc.getDocumentElement());
                if (el != null) {
                    String spec = iEmt.getSpec();
                    spec = IMDIXMLFormat.generateAttribSpecFromNode(el, iEmt.getAttributeName());
                    if (!IMDIXMLFormat.isRemovable(spec)) {
                        this.SEPi("removeIMDIElement: Forbidden to remove an Element with spec " + spec);
                        return false;
                    }
                }
            } else {
                Element root = doc.getDocumentElement();
                String query = IMDIXMLFormat.spec2XPath(iEmt.getSpec());
                if (query == null) {
                    return false;
                }
                try {
                    Node n = XPathAPI.selectSingleNode((Node)root, (String)query);
                    if (n instanceof Element) {
                        el = (Element)n;
                    }
                }
                catch (TransformerException te) {
                    this.SEPw("TransformerException in removeIMDIElement while getting node: " + te.getMessage());
                }
            }
            if (el == null) {
                this.SEPw("removeIMDIElement: Element not found: " + iEmt);
                return false;
            }
            if (iEmt.isAttribute()) {
                el.removeAttribute(iEmt.getAttributeName());
            } else {
                Node parent = el.getParentNode();
                if (parent == null) {
                    this.SEPw("removeIMDIElement: Cannot remove top element: " + iEmt);
                    return false;
                }
                parent.removeChild(el);
            }
        }
        catch (DOMException de) {
            this.SEPe("DOMException while setting IMDI value: " + de.getMessage());
            return false;
        }
        if (this.verbose) {
            logger.debug("## removeIMDIElement: domId=" + iEmt.getDomId() + " spec=" + iEmt.getSpec());
        }
        return true;
    }

    @Override
    public IMDIElement getIMDIElement(Document doc, String spec) {
        IMDIElement result = null;
        try {
            String query;
            Element el;
            Element root = doc.getDocumentElement();
            if (spec.startsWith("i") && (el = IMDIXMLFormat.getElementById(spec, root)) != null) {
                spec = IMDIXMLFormat.generateSpecFromNode(el);
            }
            if ((query = IMDIXMLFormat.spec2XPath(spec)) == null) {
                return null;
            }
            String value = null;
            String id = null;
            if (IMDIXMLFormat.pointsToAttribute(query)) {
                String attName = IMDIXMLFormat.whichAttribute(spec);
                query = query.substring(0, query.lastIndexOf(64) - 1);
                Node node = XPathAPI.selectSingleNode((Node)root, (String)query);
                value = IMDIXMLFormat.getAttribute(node, attName);
                id = IMDIXMLFormat.getDomId(node);
            } else {
                Node node = XPathAPI.selectSingleNode((Node)root, (String)query);
                value = IMDIXMLFormat.getFirstChildValue(node);
                id = IMDIXMLFormat.getDomId(node);
            }
            if (id != null) {
                result = new IMDIElement(spec, id);
                if (value != null) {
                    result.setValue(value);
                }
                return result;
            }
            if (this.verbose) {
                logger.debug("## getIMDIElement: spec=" + spec + " xpath=" + query + " result=" + result);
            }
        }
        catch (TransformerException te) {
            this.SEPe("TransformerException while getting IMDI value: " + te.getMessage());
        }
        catch (DOMException de) {
            this.SEPe("DOMException while getting IMDI value: " + de.getMessage());
        }
        return null;
    }

    @Override
    public Hashtable getKeyValuePairs(Document doc, String elementName) {
        return KeyValuePairs.getKeyValuePairs(doc, elementName, this);
    }

    @Override
    public boolean setKeyValuePair(Document doc, String elementName, String key, String value) {
        return KeyValuePairs.setKeyValuePair(doc, elementName, key, value, this);
    }

    @Override
    public void SEPi(String errorMessage) {
        this.message = errorMessage;
        logger.info(errorMessage);
    }

    @Override
    public void SEPw(String errorMessage) {
        this.message = errorMessage;
        logger.warn(errorMessage);
    }

    @Override
    public void SEPe(String errorMessage) {
        this.message = errorMessage;
        logger.error(errorMessage);
    }

    private IMDILink getCatalogueLink(Document doc, OurURL url) {
        String urid;
        IMDIElement corpusEl = this.getIMDIElement(doc, "Corpus");
        IMDIElement linkEl = this.getIMDIElement(doc, "Corpus.Catalogue.CatalogueLink");
        IMDIElement uridEl = this.getIMDIElement(doc, "Corpus.Catalogue.CatalogueHandle");
        if (corpusEl == null || linkEl == null || linkEl.getValue().trim().length() == 0) {
            return null;
        }
        OurURL curl = null;
        try {
            curl = new OurURL(url, linkEl.getValue().trim());
        }
        catch (MalformedURLException murl) {
            curl = null;
        }
        IMDILink result = new IMDILink("Corpus.Catalogue.CatalogueLink", corpusEl.getDomId(), 8, curl);
        result.setLinkDefinition(linkEl.getValue().trim());
        String string = urid = uridEl != null ? uridEl.getValue().trim() : null;
        if (urid != null && urid.length() == 0) {
            urid = null;
        }
        result.setURID(urid);
        return result;
    }

    private IMDILink[] getAllCorpusOrResourceLinks(Document doc, OurURL url, int nodeType) {
        String query = IMDIXMLFormat.getXPathQuery(nodeType);
        Vector<IMDILink> linksV = new Vector<IMDILink>();
        try {
            Element node = doc.getDocumentElement();
            NodeList nodes = XPathAPI.selectNodeList((Node)node, (String)query);
            Hashtable specCache = new Hashtable(nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n;
                String childValue;
                if (!nodes.item(i).hasChildNodes() || (childValue = IMDIXMLFormat.getFirstChildValue(n = nodes.item(i))).startsWith("notyet")) continue;
                Node parent = n.getParentNode();
                OurURL u = new OurURL(url, childValue);
                String spec = null;
                String domId = null;
                if (n.getNodeName().equals("ResourceLink")) {
                    spec = IMDIXMLFormat.generateCachedSpecFromNode(parent, specCache);
                    domId = IMDIXMLFormat.getDomId(parent);
                } else {
                    spec = IMDIXMLFormat.generateCachedSpecFromNode(n, specCache);
                    domId = IMDIXMLFormat.getDomId(n);
                    parent = n;
                }
                IMDILink link = new IMDILink(spec, domId, nodeType, u);
                link.setLinkDefinition(childValue.trim());
                if (nodeType == 2 || nodeType == 1) {
                    link.setLinkName(IMDIXMLFormat.getAttribute(n, "Name"));
                    link.setType(null);
                    link.setFormat(null);
                } else {
                    link.setLinkName(null);
                    link.setType(IMDIXMLFormat.getFirstChildValue(IMDIXMLFormat.selectType(parent)));
                    link.setFormat(IMDIXMLFormat.getFirstChildValue(IMDIXMLFormat.selectFormat(parent)));
                }
                link.setURID(IMDIXMLFormat.getAttribute(parent, "ArchiveHandle"));
                if (link.getURID() == null) {
                    link.setURID(IMDIXMLFormat.getAttribute(n, "ArchiveHandle"));
                }
                linksV.add(link);
            }
            specCache.clear();
            return linksV.toArray(new IMDILink[0]);
        }
        catch (MalformedURLException mue) {
            this.SEPe("MalformedURLException while getting links: " + mue.getMessage());
        }
        catch (TransformerException te) {
            this.SEPe("TransformerException while getting Links: " + te.getMessage());
        }
        catch (DOMException de) {
            this.SEPe("DOMException while getting Links: " + de.getMessage());
        }
        return null;
    }

    private IMDILink[] getAllInfoFileLinks(Document doc, OurURL url) {
        String query = "//" + IMDIXMLFormat.getXPathQuery(3) + "[@" + IMDIXMLFormat.getLinkXPath(3) + "]";
        try {
            Element node = doc.getDocumentElement();
            NodeList nodes = XPathAPI.selectNodeList((Node)node, (String)query);
            Vector<IMDILink> results = new Vector<IMDILink>();
            Hashtable specCache = new Hashtable(nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element e = (Element)nodes.item(i);
                String urlstr = IMDIXMLFormat.getAttribute(e, IMDIXMLFormat.getLinkXPath(3));
                if (urlstr == null || urlstr.length() == 0 || urlstr.startsWith("notyet")) continue;
                String spec = IMDIXMLFormat.generateCachedSpecFromNode(e, specCache);
                String domId = IMDIXMLFormat.getDomId(e);
                if (domId == null || spec == null || spec.indexOf("References") != -1) continue;
                String linkUrl = urlstr.trim();
                try {
                    OurURL u = new OurURL(url, linkUrl);
                    IMDILink link = new IMDILink(spec, domId, 3, u);
                    link.setLinkDefinition(linkUrl);
                    link.setLanguageId(IMDIXMLFormat.getAttribute(e, "LanguageId"));
                    link.setURID(IMDIXMLFormat.getAttribute(e, "ArchiveHandle"));
                    link.setValue(IMDIXMLFormat.getFirstChildValue(e));
                    results.add(link);
                    continue;
                }
                catch (MalformedURLException mue) {
                    this.SEPe("MalformedURLException while getting info links: " + mue.getMessage());
                }
            }
            specCache.clear();
            return results.toArray(new IMDILink[0]);
        }
        catch (TransformerException te) {
            this.SEPe("TransformerException while getting Links: " + te.getMessage());
        }
        catch (DOMException de) {
            this.SEPe("DOMException while getting Links: " + de.getMessage());
        }
        return null;
    }
}

