/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.Count;
import net.sf.saxon.functions.GenerateId;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.NotFn;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.StringLength;
import net.sf.saxon.functions.Subsequence;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public final class ValueComparison
extends BinaryExpression
implements ComparisonExpression,
Negatable {
    private AtomicComparer comparer;
    private BooleanValue resultWhenEmpty = null;
    private boolean needsRuntimeCheck;

    public ValueComparison(Expression p1, int op, Expression p2) {
        super(p1, op, p2);
    }

    public String getExpressionName() {
        return "ValueComparison";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.resultWhenEmpty != null) {
            this.resultWhenEmpty = this.resultWhenEmpty.getBooleanValue() ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
    }

    public void setAtomicComparer(AtomicComparer comparer) {
        this.comparer = comparer;
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    public int getSingletonOperator() {
        return this.operator;
    }

    public boolean convertsUntypedToOther() {
        return false;
    }

    public void setResultWhenEmpty(BooleanValue value) {
        this.resultWhenEmpty = value;
    }

    public BooleanValue getResultWhenEmpty() {
        return this.resultWhenEmpty;
    }

    public boolean needsRuntimeComparabilityCheck() {
        return this.needsRuntimeCheck;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        BuiltInAtomicType p1;
        NamePool namePool = visitor.getConfiguration().getNamePool();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        StaticContext env = visitor.getStaticContext();
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        if (Literal.isEmptySequence(this.operand0)) {
            return this.resultWhenEmpty == null ? this.operand0 : Literal.makeLiteral(this.resultWhenEmpty);
        }
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        if (Literal.isEmptySequence(this.operand1)) {
            return this.resultWhenEmpty == null ? this.operand1 : Literal.makeLiteral(this.resultWhenEmpty);
        }
        SequenceType optionalAtomic = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator role0 = new RoleLocator(1, Token.tokens[this.operator], 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, optionalAtomic, false, role0, visitor);
        RoleLocator role1 = new RoleLocator(1, Token.tokens[this.operator], 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, optionalAtomic, false, role1, visitor);
        PlainType t0 = this.operand0.getItemType(th).getAtomizedItemType();
        PlainType t1 = this.operand1.getItemType(th).getAtomizedItemType();
        if (t0.isExternalType() || t1.isExternalType()) {
            XPathException err = new XPathException("Cannot perform comparisons involving external objects");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            throw err;
        }
        BuiltInAtomicType p0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
        if (p0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            p0 = BuiltInAtomicType.STRING;
        }
        if ((p1 = (BuiltInAtomicType)t1.getPrimitiveItemType()).equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            p1 = BuiltInAtomicType.STRING;
        }
        boolean bl = this.needsRuntimeCheck = p0.equals(BuiltInAtomicType.ANY_ATOMIC) || p1.equals(BuiltInAtomicType.ANY_ATOMIC);
        if (!this.needsRuntimeCheck && !Type.isComparable(p0, p1, Token.isOrderedOperator(this.operator))) {
            boolean opt0 = Cardinality.allowsZero(this.operand0.getCardinality());
            boolean opt1 = Cardinality.allowsZero(this.operand1.getCardinality());
            if (opt0 || opt1) {
                String which = null;
                if (opt0) {
                    which = "the first operand is";
                }
                if (opt1) {
                    which = "the second operand is";
                }
                if (opt0 && opt1) {
                    which = "one or both operands are";
                }
                visitor.getStaticContext().issueWarning("Comparison of " + t0.toString(namePool) + (opt0 ? "?" : "") + " to " + t1.toString(namePool) + (opt1 ? "?" : "") + " will fail unless " + which + " empty", this);
                this.needsRuntimeCheck = true;
            } else {
                XPathException err = new XPathException("Cannot compare " + t0.toString(namePool) + " to " + t1.toString(namePool));
                err.setIsTypeError(true);
                err.setErrorCode("XPTY0004");
                err.setLocator(this);
                throw err;
            }
        }
        if (this.operator != 50 && this.operator != 51) {
            if (!p0.isOrdered()) {
                XPathException err = new XPathException("Type " + t0.toString(env.getNamePool()) + " is not an ordered type");
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
            if (!p1.isOrdered()) {
                XPathException err = new XPathException("Type " + t1.toString(env.getNamePool()) + " is not an ordered type");
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
        }
        if (this.comparer == null) {
            String defaultCollationName = env.getDefaultCollationName();
            StringCollator comp = env.getCollation(defaultCollationName);
            if (comp == null) {
                comp = CodepointCollator.getInstance();
            }
            this.comparer = GenericAtomicComparer.makeAtomicComparer(p0, p1, comp, env.getConfiguration().getConversionContext());
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        int p1;
        int p0;
        Expression arg;
        Expression e2;
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.operand0 = visitor.optimize(this.operand0, contextItemType);
        this.operand1 = visitor.optimize(this.operand1, contextItemType);
        Value value0 = null;
        Value value1 = null;
        if (this.operand0 instanceof Literal) {
            value0 = ((Literal)this.operand0).getValue();
        }
        if (this.operand1 instanceof Literal) {
            value1 = ((Literal)this.operand1).getValue();
        }
        if (value0 != null && value1 != null) {
            try {
                AtomicValue r = (AtomicValue)this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext());
                return Literal.makeLiteral(r == null ? EmptySequence.getInstance() : r);
            }
            catch (NoDynamicContextException e) {
                return this;
            }
        }
        if (this.operand0 instanceof Count && Literal.isAtomic(this.operand1) ? (e2 = this.optimizeCount(visitor, contextItemType, false)) != null : this.operand1 instanceof Count && Literal.isAtomic(this.operand0) && (e2 = this.optimizeCount(visitor, contextItemType, true)) != null) {
            return visitor.optimize(e2, contextItemType);
        }
        if (this.operand0 instanceof StringLength && ((StringLength)this.operand0).getNumberOfArguments() == 1 && ValueComparison.isZero(value1)) {
            arg = ((StringLength)this.operand0).getArguments()[0];
            switch (this.operator) {
                case 50: 
                case 55: {
                    return SystemFunction.makeSystemFunction("not", new Expression[]{arg});
                }
                case 51: 
                case 52: {
                    return SystemFunction.makeSystemFunction("boolean", new Expression[]{arg});
                }
                case 54: {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
                case 53: {
                    return Literal.makeLiteral(BooleanValue.FALSE);
                }
            }
        }
        if (this.operand1 instanceof StringLength && ((StringLength)this.operand1).getNumberOfArguments() == 1 && ValueComparison.isZero(value0)) {
            arg = ((StringLength)this.operand1).getArguments()[0];
            switch (this.operator) {
                case 50: 
                case 54: {
                    return SystemFunction.makeSystemFunction("not", new Expression[]{arg});
                }
                case 51: 
                case 53: {
                    return SystemFunction.makeSystemFunction("boolean", new Expression[]{arg});
                }
                case 55: {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
                case 52: {
                    return Literal.makeLiteral(BooleanValue.FALSE);
                }
            }
        }
        if (((p0 = this.operand0.getItemType(th).getPrimitiveType()) == 513 || p0 == 529 || p0 == 631) && this.operand1 instanceof Literal && ((Literal)this.operand1).getValue() instanceof StringValue && ((StringValue)((Literal)this.operand1).getValue()).isZeroLength() && this.comparer instanceof CodepointCollatingComparer) {
            switch (this.operator) {
                case 51: 
                case 52: {
                    return SystemFunction.makeSystemFunction("boolean", new Expression[]{this.operand0});
                }
                case 50: 
                case 55: {
                    if (this.operand0.getCardinality() != 16384) break;
                    return SystemFunction.makeSystemFunction("not", new Expression[]{this.operand0});
                }
            }
        }
        if (((p1 = this.operand1.getItemType(th).getPrimitiveType()) == 513 || p1 == 529 || p1 == 631) && this.operand0 instanceof Literal && ((Literal)this.operand0).getValue() instanceof StringValue && ((StringValue)((Literal)this.operand0).getValue()).isZeroLength() && this.comparer instanceof CodepointCollatingComparer) {
            switch (this.operator) {
                case 51: 
                case 53: {
                    return SystemFunction.makeSystemFunction("boolean", new Expression[]{this.operand1});
                }
                case 50: 
                case 54: {
                    if (this.operand1.getCardinality() != 16384) break;
                    return SystemFunction.makeSystemFunction("not", new Expression[]{this.operand1});
                }
            }
        }
        if (this.operand0 instanceof Position && this.operand1 instanceof Last) {
            switch (this.operator) {
                case 50: 
                case 54: {
                    IsLastExpression iletrue = new IsLastExpression(true);
                    ExpressionTool.copyLocationInfo(this, iletrue);
                    return iletrue;
                }
                case 51: 
                case 53: {
                    IsLastExpression ilefalse = new IsLastExpression(false);
                    ExpressionTool.copyLocationInfo(this, ilefalse);
                    return ilefalse;
                }
                case 52: {
                    return Literal.makeLiteral(BooleanValue.FALSE);
                }
                case 55: {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
            }
        }
        if (this.operand0 instanceof Last && this.operand1 instanceof Position) {
            switch (this.operator) {
                case 50: 
                case 55: {
                    IsLastExpression iletrue = new IsLastExpression(true);
                    ExpressionTool.copyLocationInfo(this, iletrue);
                    return iletrue;
                }
                case 51: 
                case 52: {
                    IsLastExpression ilefalse = new IsLastExpression(false);
                    ExpressionTool.copyLocationInfo(this, ilefalse);
                    return ilefalse;
                }
                case 53: {
                    return Literal.makeLiteral(BooleanValue.FALSE);
                }
                case 54: {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
            }
        }
        if (value1 instanceof Int64Value && this.operand0.getCardinality() == 16384 && th.isSubType(this.operand0.getItemType(th), BuiltInAtomicType.NUMERIC)) {
            return new CompareToIntegerConstant(this.operand0, this.operator, ((Int64Value)value1).longValue());
        }
        if (value0 instanceof Int64Value && this.operand1.getCardinality() == 16384 && th.isSubType(this.operand1.getItemType(th), BuiltInAtomicType.NUMERIC)) {
            return new CompareToIntegerConstant(this.operand1, Token.inverse(this.operator), ((Int64Value)value0).longValue());
        }
        if (p0 == 514 && p1 == 514 && (this.operator == 50 || this.operator == 51) && this.operand0.getCardinality() == 16384 && this.operand1.getCardinality() == 16384 && (this.operand0 instanceof Literal || this.operand1 instanceof Literal)) {
            boolean negate;
            Literal literal = (Literal)(this.operand0 instanceof Literal ? this.operand0 : this.operand1);
            Expression other = this.operand0 instanceof Literal ? this.operand1 : this.operand0;
            boolean bl = negate = this.operator == 50 != ((BooleanValue)literal.getValue()).getBooleanValue();
            if (negate) {
                NotFn fn = (NotFn)SystemFunction.makeSystemFunction("not", new Expression[]{other});
                ExpressionTool.copyLocationInfo(this, fn);
                return fn.optimize(visitor, contextItemType);
            }
            return other;
        }
        if (this.operand0 instanceof GenerateId && this.operand1 instanceof GenerateId) {
            GenerateId f0 = (GenerateId)this.operand0;
            GenerateId f1 = (GenerateId)this.operand1;
            if (!Cardinality.allowsMany(f0.argument[0].getCardinality()) && !Cardinality.allowsMany(f1.argument[0].getCardinality()) && this.operator == 50) {
                IdentityComparison id = new IdentityComparison(f0.argument[0], 20, f1.argument[0]);
                id.setGenerateIdEmulation(true);
                ExpressionTool.copyLocationInfo(this, id);
                return visitor.optimize(visitor.typeCheck(visitor.simplify(id), contextItemType), contextItemType);
            }
        }
        return this;
    }

    private Expression optimizeCount(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType, boolean inverted) throws XPathException {
        int op;
        Count countFn = (Count)(inverted ? this.operand1 : this.operand0);
        Expression sequence = countFn.argument[0];
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        sequence = ExpressionTool.unsorted(opt, sequence, false);
        AtomicValue literalOperand = (AtomicValue)((Literal)(inverted ? this.operand0 : this.operand1)).getValue();
        int n = op = inverted ? Token.inverse(this.operator) : this.operator;
        if (ValueComparison.isZero(literalOperand)) {
            if (op == 50 || op == 55) {
                FunctionCall result = SystemFunction.makeSystemFunction("empty", new Expression[]{sequence});
                opt.trace("Rewrite count()=0 as:", result);
                return result;
            }
            if (op == 51 || op == 52) {
                FunctionCall result = SystemFunction.makeSystemFunction("exists", new Expression[]{sequence});
                opt.trace("Rewrite count()>0 as:", result);
                return result;
            }
            if (op == 54) {
                return Literal.makeLiteral(BooleanValue.TRUE);
            }
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        if (literalOperand instanceof NumericValue) {
            long operand;
            if (literalOperand instanceof IntegerValue) {
                operand = ((IntegerValue)literalOperand).longValue();
            } else {
                if (literalOperand.isNaN()) {
                    return new Literal(BooleanValue.get(op == 51));
                }
                if (((NumericValue)literalOperand).isWholeNumber()) {
                    operand = ((NumericValue)literalOperand).longValue();
                } else {
                    if (op == 50) {
                        return Literal.makeLiteral(BooleanValue.FALSE);
                    }
                    if (op == 51) {
                        return Literal.makeLiteral(BooleanValue.TRUE);
                    }
                    if (op == 52 || op == 54) {
                        operand = ((NumericValue)literalOperand).ceiling().longValue();
                        op = 54;
                    } else {
                        operand = ((NumericValue)literalOperand).floor().longValue();
                        op = 55;
                    }
                }
            }
            if (operand < 0L) {
                switch (op) {
                    case 50: 
                    case 53: 
                    case 55: {
                        return Literal.makeLiteral(BooleanValue.FALSE);
                    }
                }
                return Literal.makeLiteral(BooleanValue.TRUE);
            }
            if (operand > Integer.MAX_VALUE) {
                switch (op) {
                    case 50: 
                    case 52: 
                    case 54: {
                        return Literal.makeLiteral(BooleanValue.FALSE);
                    }
                }
                return Literal.makeLiteral(BooleanValue.TRUE);
            }
            if (sequence instanceof TailExpression || sequence instanceof Subsequence) {
                return null;
            }
            switch (op) {
                case 50: 
                case 51: 
                case 53: 
                case 55: {
                    Subsequence ss = (Subsequence)SystemFunction.makeSystemFunction("subsequence", new Expression[]{sequence, Literal.makeLiteral(IntegerValue.PLUS_ONE), Literal.makeLiteral(Int64Value.makeIntegerValue(operand + 1L))});
                    Count ct = (Count)SystemFunction.makeSystemFunction("count", new Expression[]{ss});
                    CompareToIntegerConstant ctic = new CompareToIntegerConstant(ct, op, operand);
                    opt.trace("Rewrite count()~N as:", ctic);
                    ExpressionTool.copyLocationInfo(this, ctic);
                    return ctic;
                }
                case 52: 
                case 54: {
                    TailExpression tail = new TailExpression(sequence, (int)(op == 54 ? operand : operand + 1L));
                    ExpressionTool.copyLocationInfo(this, tail);
                    FunctionCall result = SystemFunction.makeSystemFunction("exists", new Expression[]{tail});
                    ExpressionTool.copyLocationInfo(this, result);
                    opt.trace("Rewrite count()>=N as:", result);
                    return result;
                }
            }
        }
        return null;
    }

    public boolean isNegatable(ExpressionVisitor visitor) {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        return !this.maybeNaN(this.operand0, th) && !this.maybeNaN(this.operand1, th);
    }

    private boolean maybeNaN(Expression exp, TypeHierarchy th) {
        return th.relationship(exp.getItemType(th), BuiltInAtomicType.DOUBLE) != 4 || th.relationship(exp.getItemType(th), BuiltInAtomicType.FLOAT) != 4;
    }

    public Expression negate() {
        ValueComparison vc = new ValueComparison(this.operand0, Token.negate(this.operator), this.operand1);
        vc.comparer = this.comparer;
        vc.resultWhenEmpty = this.resultWhenEmpty == null || this.resultWhenEmpty == BooleanValue.FALSE ? BooleanValue.TRUE : BooleanValue.FALSE;
        ExpressionTool.copyLocationInfo(this, vc);
        return vc;
    }

    private static boolean isZero(Value v) {
        return v instanceof NumericValue && ((NumericValue)v).compareTo(0L) == 0;
    }

    public Expression copy() {
        ValueComparison vc = new ValueComparison(this.operand0.copy(), this.operator, this.operand1.copy());
        vc.comparer = this.comparer;
        vc.resultWhenEmpty = this.resultWhenEmpty;
        vc.needsRuntimeCheck = this.needsRuntimeCheck;
        return vc;
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        try {
            AtomicValue v0 = (AtomicValue)this.operand0.evaluateItem(context);
            if (v0 == null) {
                return this.resultWhenEmpty == BooleanValue.TRUE;
            }
            AtomicValue v1 = (AtomicValue)this.operand1.evaluateItem(context);
            if (v1 == null) {
                return this.resultWhenEmpty == BooleanValue.TRUE;
            }
            return ValueComparison.compare(v0, this.operator, v1, this.comparer.provideContext(context), this.needsRuntimeCheck);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    static boolean compare(AtomicValue v0, int op, AtomicValue v1, AtomicComparer comparer, boolean checkTypes) throws XPathException {
        if (checkTypes && !Type.isComparable(v0.getPrimitiveType(), v1.getPrimitiveType(), Token.isOrderedOperator(op))) {
            XPathException e2 = new XPathException("Cannot compare " + Type.displayTypeName(v0) + " to " + Type.displayTypeName(v1));
            e2.setErrorCode("XPTY0004");
            e2.setIsTypeError(true);
            throw e2;
        }
        if (v0.isNaN() || v1.isNaN()) {
            return op == 51;
        }
        try {
            switch (op) {
                case 50: {
                    return comparer.comparesEqual(v0, v1);
                }
                case 51: {
                    return !comparer.comparesEqual(v0, v1);
                }
                case 52: {
                    return comparer.compareAtomicValues(v0, v1) > 0;
                }
                case 53: {
                    return comparer.compareAtomicValues(v0, v1) < 0;
                }
                case 54: {
                    return comparer.compareAtomicValues(v0, v1) >= 0;
                }
                case 55: {
                    return comparer.compareAtomicValues(v0, v1) <= 0;
                }
            }
            throw new UnsupportedOperationException("Unknown operator " + op);
        }
        catch (ClassCastException err) {
            XPathException e2 = new XPathException("Cannot compare " + Type.displayTypeName(v0) + " to " + Type.displayTypeName(v1));
            e2.setErrorCode("XPTY0004");
            e2.setIsTypeError(true);
            throw e2;
        }
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        try {
            AtomicValue v0 = (AtomicValue)this.operand0.evaluateItem(context);
            if (v0 == null) {
                return this.resultWhenEmpty;
            }
            AtomicValue v1 = (AtomicValue)this.operand1.evaluateItem(context);
            if (v1 == null) {
                return this.resultWhenEmpty;
            }
            return BooleanValue.get(ValueComparison.compare(v0, this.operator, v1, this.comparer.provideContext(context), this.needsRuntimeCheck));
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public int computeCardinality() {
        if (this.resultWhenEmpty != null) {
            return 16384;
        }
        return super.computeCardinality();
    }

    protected void explainExtraAttribute(ExpressionPresenter out) {
        out.emitAttribute("on-empty", this.resultWhenEmpty.toString());
    }
}

