/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

public final class StringUtil {
    public static final int[] indexesOf(String in, String substr) {
        if (in == null || substr == null || in.length() == 0 || substr.length() == 0) {
            return null;
        }
        int[] result = new int[in.length() / substr.length() + 1];
        int nrHits = 0;
        int i = in.indexOf(substr, 0);
        while (i != -1) {
            result[nrHits] = i;
            i = in.indexOf(substr, i + 1);
            ++nrHits;
        }
        return result;
    }

    public static final boolean contains(String s, int ch) {
        return s != null && s.indexOf(ch) != -1;
    }

    public static final boolean contains(String s, String sub) {
        return s != null && s.indexOf(sub) != -1;
    }

    public static final String[] stringToArr(String s, char separator) {
        if (s == null) {
            return null;
        }
        int separators = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != separator) continue;
            ++separators;
        }
        String[] result = new String[separators + 1];
        int iResult = 0;
        StringBuilder element = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == separator) {
                result[iResult++] = element.toString();
                element = new StringBuilder();
                continue;
            }
            element.append("" + s.charAt(i));
        }
        result[iResult] = element.toString();
        return result;
    }

    public static final String replace(String input, String search, String replace) {
        if (input == null || search == null || search.length() == 0) {
            return input;
        }
        int tlen = search.length();
        int clen = replace.length();
        int pos = input.indexOf(search);
        while (pos != -1) {
            int next = (input = input.substring(0, pos) + replace + input.substring(pos + tlen)).substring(pos + clen).indexOf(search);
            if (next == -1) {
                pos = -1;
                continue;
            }
            pos += next + clen;
        }
        return input;
    }

    public static final String arrToString(String[] arr, char separator) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < arr.length - 1; ++i) {
            result.append(arr[i]).append(separator);
        }
        result = result.append(arr[arr.length - 1]);
        return result.toString();
    }

    public static final String chop(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        return s.substring(0, s.length() - 1);
    }

    public static final String chomp(String s) {
        if (s == null) {
            return null;
        }
        if (s.endsWith("\n")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }
}

