/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin.profiles;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JProgressBar;
import nl.mpi.arbil.clarin.profiles.CmdiProfileProvider;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import org.apache.commons.digester.Digester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdiProfileReader
implements CmdiProfileProvider {
    private static SessionStorage sessionStorage;
    public static final String PARAM_PROFILESELECTION = "profileSelection";
    public static final String PARAM_PROFILES_URL = "profilesUrlAll";
    public static final String PARAM_SELECTED_PROFILES_URL = "profilesUrlSelected";
    public static final String DEFAULT_ALL_PROFILES_URL_STRING = "http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles";
    public static final String DEFAULT_SELECTED_PROFILES_URL_STRING = "http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles?mdEditor=true";
    private ProfileSelection selection;
    public ArrayList<CmdiProfileProvider.CmdiProfile> cmdiProfileArray = null;
    static CmdiProfileReader singleInstance;

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static synchronized CmdiProfileReader getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new CmdiProfileReader(CmdiProfileReader.getStoredProfileSelection());
        }
        return singleInstance;
    }

    public static boolean pathIsProfile(String pathString) {
        return pathString.startsWith("http") || pathString.contains("clarin") || pathString.endsWith(".xsd") || pathString.endsWith("/xsd");
    }

    @Override
    public CmdiProfileProvider.CmdiProfile getProfile(String XsdHref) {
        for (CmdiProfileProvider.CmdiProfile currentProfile : this.cmdiProfileArray) {
            if (!currentProfile.getXsdHref().equals(XsdHref)) continue;
            return currentProfile;
        }
        return null;
    }

    private CmdiProfileReader(ProfileSelection selection) {
        this.setSelection(selection);
        this.loadProfiles(this.getProfilesUrlStringForSelection(this.getSelection()));
    }

    public void refreshProfiles(boolean forceUpdate) {
        this.refreshProfiles(forceUpdate, false, null);
    }

    public void refreshProfilesAndUpdateCache(JProgressBar progressBar, boolean forceUpdate) {
        this.refreshProfiles(forceUpdate, true, progressBar);
    }

    private void refreshProfiles(boolean forceUpdate, boolean updateCache, JProgressBar progressBar) {
        if (updateCache) {
            progressBar.setIndeterminate(true);
            progressBar.setString("");
        }
        int updateDays = forceUpdate ? 0 : 100;
        sessionStorage.updateCache(this.getProfilesUrlStringForSelection(this.getSelection()), updateDays, false);
        this.loadProfiles(this.getProfilesUrlStringForSelection(this.getSelection()));
        if (updateCache) {
            this.storeProfilesInCache(updateDays, this.cmdiProfileArray, progressBar);
        }
    }

    private void storeProfilesInCache(int updateDays, Collection<CmdiProfileProvider.CmdiProfile> profiles, JProgressBar progressBar) {
        progressBar.setIndeterminate(false);
        progressBar.setMinimum(0);
        progressBar.setMaximum(profiles.size() + 1);
        progressBar.setValue(1);
        for (CmdiProfileProvider.CmdiProfile currentCmdiProfile : profiles) {
            progressBar.setString(currentCmdiProfile.name);
            this.storeProfileInCache(currentCmdiProfile.getXsdHref(), updateDays);
            progressBar.setValue(progressBar.getValue() + 1);
        }
        progressBar.setString("");
        progressBar.setValue(0);
    }

    public final void storeProfileInCache(String xsdHref, int updateDays) {
        sessionStorage.updateCache(xsdHref, updateDays, false);
    }

    private void loadProfiles(String profilesUrl) {
        File profileXmlFile = sessionStorage.updateCache(profilesUrl, 10, false);
        try {
            Digester digester = new Digester();
            digester.push((Object)this);
            digester.addCallMethod("profileDescriptions/profileDescription", "addProfile", 6);
            digester.addCallParam("profileDescriptions/profileDescription/id", 0);
            digester.addCallParam("profileDescriptions/profileDescription/description", 1);
            digester.addCallParam("profileDescriptions/profileDescription/name", 2);
            digester.addCallParam("profileDescriptions/profileDescription/registrationDate", 3);
            digester.addCallParam("profileDescriptions/profileDescription/creatorName", 4);
            digester.addCallParam("profileDescriptions/profileDescription/ns2:href", 5);
            this.cmdiProfileArray = new ArrayList();
            digester.parse(profileXmlFile);
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError(e);
        }
    }

    public void addProfile(String id, String description, String name, String registrationDate, String creatorName, String href) {
        CmdiProfileProvider.CmdiProfile cmdiProfile = new CmdiProfileProvider.CmdiProfile();
        cmdiProfile.id = id;
        cmdiProfile.description = description;
        cmdiProfile.name = name;
        cmdiProfile.registrationDate = registrationDate;
        cmdiProfile.creatorName = creatorName;
        cmdiProfile.href = href;
        this.cmdiProfileArray.add(cmdiProfile);
    }

    public final ProfileSelection getSelection() {
        return this.selection;
    }

    public final void setSelection(ProfileSelection selection) {
        this.selection = selection;
        this.storeProfileSelection(selection);
    }

    protected final String getProfilesUrlStringForSelection(ProfileSelection selection) {
        return selection == ProfileSelection.SELECTED ? this.getSelectedProfileUrlString() : this.getAllProfilesUrlString();
    }

    public static void main(String[] args) {
        new CmdiProfileReader(ProfileSelection.SELECTED);
    }

    private static synchronized ProfileSelection getStoredProfileSelection() {
        String selectionString = sessionStorage.loadString(PARAM_PROFILESELECTION);
        if (selectionString == null) {
            selectionString = ProfileSelection.SELECTED.toString();
        }
        return ProfileSelection.valueOf(selectionString);
    }

    private void storeProfileSelection(ProfileSelection selection) {
        sessionStorage.saveString(PARAM_PROFILESELECTION, selection.toString());
    }

    private String getAllProfilesUrlString() {
        String savedProfilesUrlString = sessionStorage.loadString(PARAM_PROFILES_URL);
        if (savedProfilesUrlString == null) {
            sessionStorage.saveString(PARAM_PROFILES_URL, DEFAULT_ALL_PROFILES_URL_STRING);
            return DEFAULT_ALL_PROFILES_URL_STRING;
        }
        return savedProfilesUrlString;
    }

    private String getSelectedProfileUrlString() {
        String savedProfilesUrlString = sessionStorage.loadString(PARAM_SELECTED_PROFILES_URL);
        if (savedProfilesUrlString == null) {
            sessionStorage.saveString(PARAM_SELECTED_PROFILES_URL, DEFAULT_SELECTED_PROFILES_URL_STRING);
            return DEFAULT_SELECTED_PROFILES_URL_STRING;
        }
        return savedProfilesUrlString;
    }

    static {
        singleInstance = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProfileSelection {
        SELECTED,
        ALL;

    }
}

