/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.userstorage.SessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentationLanguages {
    private static final Logger logger = LoggerFactory.getLogger(DocumentationLanguages.class);
    private final String selectedLanguagesKey;
    private final SessionStorage sessionStorage;
    private static final String ALL_LANGUAGES = "_ALL_LANGUAGES_";

    public DocumentationLanguages(String selectedLanguagesKey, SessionStorage sessionStorage) {
        this.selectedLanguagesKey = selectedLanguagesKey;
        this.sessionStorage = sessionStorage;
    }

    private List<String> getDefaultLanguages() {
        List<ArbilVocabularyItem> imdiLanguages = this.getAllLanguages();
        ArrayList<String> selectedLanguages = new ArrayList<String>(imdiLanguages.size());
        for (ArbilVocabularyItem currentTemplate : imdiLanguages) {
            selectedLanguages.add(currentTemplate.itemDisplayName);
        }
        return selectedLanguages;
    }

    public abstract List<ArbilVocabularyItem> getAllLanguages();

    protected synchronized List<ArbilVocabularyItem> getLanguageListSubset(List<ArbilVocabularyItem> allLanguages) {
        ArrayList<ArbilVocabularyItem> languageListSubset = new ArrayList<ArbilVocabularyItem>();
        if (allLanguages != null) {
            List<String> selectedLanguages = this.getSelectedLanguagesOrDefault();
            for (ArbilVocabularyItem currentVocabItem : allLanguages) {
                if (!selectedLanguages.contains(currentVocabItem.itemDisplayName)) continue;
                languageListSubset.add(currentVocabItem);
            }
        }
        return languageListSubset;
    }

    public abstract List<ArbilVocabularyItem> getSortedLanguageListSubset();

    private List<String> getSelectedLanguages() {
        try {
            String[] storedLanguages = this.sessionStorage.loadStringArray(this.selectedLanguagesKey);
            if (storedLanguages != null) {
                if (storedLanguages.length == 1 && storedLanguages[0].equals(ALL_LANGUAGES)) {
                    return this.getDefaultLanguages();
                }
                return new ArrayList<String>(Arrays.asList(storedLanguages));
            }
        }
        catch (Exception e) {
            logger.error("Error while trying to read language file, falling back to defaults", (Throwable)e);
        }
        return null;
    }

    public synchronized List<String> getSelectedLanguagesOrDefault() {
        List<String> storedLanguages = this.getSelectedLanguages();
        if (storedLanguages == null) {
            return this.getDefaultLanguages();
        }
        return storedLanguages;
    }

    public synchronized void addselectedLanguage(String templateString) {
        List<String> selectedLanguages = this.getSelectedLanguages();
        if (selectedLanguages == null) {
            this.saveSelectedLanguages(Collections.singletonList(templateString));
        } else {
            selectedLanguages.add(templateString);
            this.saveSelectedLanguages(selectedLanguages);
        }
    }

    public synchronized void removeselectedLanguages(String templateString) {
        List<String> selectedLanguages = this.getSelectedLanguagesOrDefault();
        while (selectedLanguages.contains(templateString)) {
            selectedLanguages.remove(templateString);
        }
        this.saveSelectedLanguages(selectedLanguages);
    }

    protected void saveSelectedLanguages(List<String> selectedLanguages) {
        try {
            if (selectedLanguages.containsAll(this.getDefaultLanguages())) {
                this.sessionStorage.saveStringArray(this.selectedLanguagesKey, new String[]{ALL_LANGUAGES});
            } else {
                this.sessionStorage.saveStringArray(this.selectedLanguagesKey, selectedLanguages.toArray(new String[0]));
            }
        }
        catch (IOException ex) {
            logger.error("Could not store language selection", (Throwable)ex);
        }
    }
}

