/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Scanner;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.clarin.HandleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataFormat {
    private static final Logger logger = LoggerFactory.getLogger(MetadataFormat.class);
    public static final int DEEP_CHECK_BYTES_TO_READ = 1024;
    private static final Pattern ROOT_ELEMENT_PATTERN = Pattern.compile("<[\\S]*");
    private static final Collection<FormatType> knownFormats = new CopyOnWriteArraySet<FormatType>(Arrays.asList(new FormatType(".imdi", ".METATRANSCRIPT", null, FileType.IMDI), new FormatType(".cmdi", ".CMD.Components", ArbilIcons.clarinIcon, FileType.CMDI), new FormatType(".xml", "", ArbilIcons.clarinIcon, FileType.CMDI), new FormatType(".xml", ".OAI-PMH.GetRecord.record.metadata.olac:olac", ArbilIcons.clarinIcon, FileType.CMDI), new FormatType(".kmdi", ".Kinnate.CustomData", ArbilIcons.kinOathIcon, FileType.KMDI), new FormatType(".trx", "", ArbilIcons.clarinIcon, FileType.CMDI)));

    public FileType shallowCheck(URI targetUri) {
        String urlString = targetUri.toString();
        if (MetadataFormat.isStringChildNode(urlString)) {
            return FileType.CHILD;
        }
        File localFile = MetadataFormat.getFile(targetUri);
        if (localFile != null && localFile.isDirectory()) {
            return FileType.DIRECTORY;
        }
        for (FormatType formatType : knownFormats) {
            if (!urlString.endsWith(formatType.suffixString)) continue;
            return formatType.fileType;
        }
        if (localFile != null && localFile.isFile()) {
            return FileType.FILE;
        }
        if (urlString.lastIndexOf(".") > urlString.length() - 6) {
            logger.debug("Presuming the URI points to non metadata based on its suffix: {}", (Object)urlString);
            return FileType.FILE;
        }
        return FileType.UNKNOWN;
    }

    public FileType deepCheck(URI targetUri) {
        FileType shallowCheckResult = this.shallowCheck(targetUri);
        if (shallowCheckResult != FileType.UNKNOWN) {
            logger.debug("Shallow check was decisive: {}", (Object)shallowCheckResult);
            return shallowCheckResult;
        }
        logger.debug("Deep checking {}", (Object)targetUri);
        try {
            String found;
            URI resolveHandle = new HandleUtils().resolveHandle(targetUri);
            URLConnection uRLConnection = resolveHandle.toURL().openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(true);
            }
            InputStream inputStream = uRLConnection.getInputStream();
            logger.debug("Connected to {}", (Object)uRLConnection.getURL());
            try {
                FileType redirectedShallowCheckResult;
                URL connectionUrl = uRLConnection.getURL();
                if (connectionUrl != null && (redirectedShallowCheckResult = this.shallowCheck(connectionUrl.toURI())) != FileType.UNKNOWN) {
                    logger.debug("Shallow check on URL {} was decisive: {}", (Object)connectionUrl, (Object)shallowCheckResult);
                    return redirectedShallowCheckResult;
                }
            }
            catch (URISyntaxException exception) {
                logger.error("Could not read redirected URI: {}", (Object)exception.getMessage());
            }
            Scanner scanner = new Scanner(inputStream);
            while (null != (found = scanner.findWithinHorizon(ROOT_ELEMENT_PATTERN, 1024))) {
                if ("<?xml".equals(found) || "<!--".equals(found)) continue;
                for (FormatType formatType : knownFormats) {
                    if (formatType.metadataStartXpath == null || formatType.metadataStartXpath.length() <= 0) continue;
                    String foundTag = found.substring(1);
                    if (!formatType.metadataStartXpath.startsWith(foundTag, 1)) continue;
                    scanner.close();
                    inputStream.close();
                    return formatType.fileType;
                }
                logger.debug("found: {}", (Object)found);
                break;
            }
            scanner.close();
            inputStream.close();
        }
        catch (IOException exception) {
            logger.warn("Could not get remote file type for {}", (Object)targetUri);
            logger.info("Could not get remote file type, returning FileType.UNKNOWN", (Throwable)exception);
            return FileType.UNKNOWN;
        }
        return FileType.FILE;
    }

    public static boolean isPathImdi(String urlString) {
        for (FormatType formatType : knownFormats) {
            if (!urlString.endsWith(formatType.suffixString)) continue;
            return formatType.fileType == FileType.IMDI;
        }
        return false;
    }

    public static boolean isPathCmdi(String urlString) {
        for (FormatType formatType : knownFormats) {
            if (!urlString.endsWith(formatType.suffixString)) continue;
            return formatType.fileType == FileType.CMDI;
        }
        return false;
    }

    public static ImageIcon getFormatIcon(FileType fileType) {
        for (FormatType formatType : knownFormats) {
            if (formatType.fileType != fileType) continue;
            return formatType.imageIcon;
        }
        return null;
    }

    public static String getMetadataStartPath(String urlString) {
        for (FormatType formatType : knownFormats) {
            if (!urlString.endsWith(formatType.suffixString)) continue;
            return formatType.metadataStartXpath;
        }
        return null;
    }

    public boolean isMetaDataNode(FileType fileType) {
        return FileType.CHILD == fileType || FileType.IMDI == fileType || FileType.CMDI == fileType || FileType.KMDI == fileType;
    }

    public static boolean isPathMetadata(String urlString) {
        return MetadataFormat.isPathImdi(urlString) || MetadataFormat.isPathCmdi(urlString);
    }

    public static boolean isStringChildNode(String urlString) {
        return urlString.contains("#.");
    }

    public static File getFile(URI nodeUri) throws IllegalArgumentException {
        String scheme = nodeUri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("Expecting an absolute URI, instead was " + nodeUri);
        }
        if (scheme.toLowerCase().equals("file")) {
            return new File(URI.create(nodeUri.toString().split("#")[0]));
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        IMDI,
        CMDI,
        KMDI,
        FILE,
        DIRECTORY,
        CHILD,
        UNKNOWN;

    }

    static class FormatType {
        private FileType fileType;
        private String suffixString;
        private String metadataStartXpath;
        private ImageIcon imageIcon;

        public FormatType(String suffixString, String metadataStartXpath, ImageIcon imageIcon, FileType fileType) {
            this.fileType = fileType;
            this.suffixString = suffixString;
            this.metadataStartXpath = metadataStartXpath;
            this.imageIcon = imageIcon;
        }
    }
}

