/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.applet;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URI;
import javax.swing.JApplet;
import nl.mpi.arbil.ArbilDesktopInjector;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.ui.ArbilDragDrop;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.util.BugCatcherManager;

public class ArbilTableApplet
extends JApplet {
    private DataNodeLoader dataNodeLoader;
    private String tableTitle = "Arbil Table Demo";
    private ArbilTableModel arbilTableModel;

    public void init() {
        final ArbilDesktopInjector injector = new ArbilDesktopInjector();
        injector.injectDefaultHandlers();
        this.dataNodeLoader = injector.getDataNodeLoader();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ArbilTableApplet.this.initComponents(injector);
                    ArbilTableApplet.this.addNodesToTable(ArbilTableApplet.this.getParameter("ImdiFileList"));
                    ArbilTableApplet.this.addShowOnlyColumnsToTable(ArbilTableApplet.this.getParameter("ShowOnlyColumns"));
                    ArbilTableApplet.this.addChildNodesToTable(ArbilTableApplet.this.getParameter("ChildNodeColumns"));
                    ArbilTableApplet.this.addHighlightToTable(ArbilTableApplet.this.getParameter("HighlightText"));
                }
            });
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    private void addNodesToTable(String nodeURLsString) {
        if (nodeURLsString != null) {
            for (String currentUrlString : nodeURLsString.split(",")) {
                try {
                    this.arbilTableModel.addSingleArbilDataNode(this.dataNodeLoader.getArbilDataNode(this.rootPane, new URI(currentUrlString)));
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        }
    }

    private void addShowOnlyColumnsToTable(String showColumnsString) {
        if (showColumnsString != null && showColumnsString.trim().length() > 0) {
            for (String currentshowColumns : showColumnsString.split(",")) {
                this.arbilTableModel.getFieldView().addShowOnlyColumn(currentshowColumns.trim());
            }
        }
    }

    private void addChildNodesToTable(String childNodesString) {
        if (childNodesString != null && childNodesString.trim().length() > 0) {
            for (String currentChildNode : childNodesString.split(",")) {
                this.arbilTableModel.addChildTypeToDisplay(currentChildNode.trim());
            }
        }
    }

    private void addHighlightToTable(String highlightableTextString) {
        if (highlightableTextString != null && highlightableTextString.length() > 0) {
            for (String highlightText : highlightableTextString.split(",")) {
                this.arbilTableModel.highlightMatchingText(highlightText);
            }
        }
    }

    private void initComponents(ArbilDesktopInjector injector) {
        this.arbilTableModel = new ArbilTableModel(injector.getImageBoxRenderer());
        ArbilTable arbilTable = new ArbilTable(this.arbilTableModel, null, this.tableTitle);
        ArbilDragDrop dragDrop = new ArbilDragDrop(injector.getSessionStorage(), injector.getTreeHelper(), injector.getWindowManager(), injector.getWindowManager(), injector.getTableController());
        ArbilSplitPanel arbilSplitPanel = new ArbilSplitPanel(injector.getSessionStorage(), injector.getTreeHelper(), dragDrop, arbilTable);
        this.arbilTableModel.hideContextMenuAndStatusBar = true;
        arbilSplitPanel.setSplitDisplay();
        this.getContentPane().add((Component)arbilSplitPanel, "Center");
    }
}

