/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Vector;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.Common;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.Util;
import nl.mpi.corpusstructure.AccessInfo;
import nl.mpi.corpusstructure.ArchiveAccessContext;
import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.ArchiveObjectsDBImplHS;
import nl.mpi.corpusstructure.ArchiveObjectsDBWrite;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.corpusstructure.UpdateInProgressException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveObjectsDBWriteImplHS
extends ArchiveObjectsDBImplHS
implements ArchiveObjectsDBWrite,
ArchiveObjectsDB {
    private static Logger logger = LoggerFactory.getLogger(ArchiveObjectsDBWriteImplHS.class);
    public boolean _profiling = false;
    private SessionSetupInfo _sessionSetupInfo = null;
    private PublicKeyAuthenticationInfo _auth = null;
    private int handlesWritten = 0;
    private HandleValue adminValue = null;
    private static long beforeTime = 0L;

    @Override
    public void setArchiveRoots(ArchiveAccessContext userAAC) {
        super.setArchiveRoots(userAAC);
        String prefix = userAAC.getHandlePrefix();
        this.adminValue = new HandleValue(100, Common.STD_TYPE_HSADMIN, Encoder.encodeAdminRecord((AdminRecord)new AdminRecord(Util.encodeString((String)("0.NA/" + prefix)), 200, false, false, false, false, true, true, true, true, false, false, false, false)));
    }

    @Override
    public boolean canWrite() {
        return !this.sqlTroubles("canWrite");
    }

    private boolean sqlTroubles(String name) {
        if (this._auth != null) {
            return false;
        }
        if (this.sqlhs == null) {
            logger.error(name + ": No SQL connection, write access not possible");
            return true;
        }
        if (this.useSQL) {
            if (this.readOnlySetting != null && !this.readOnlySetting.equalsIgnoreCase("no")) {
                logger.error(name + ": Write access not allowed in configuration file");
                return true;
            }
            return false;
        }
        if ("ArchiveObjectsDBWriteImplHS".equals(name)) {
            logger.info(name + ": You have to set a locally homed prefix next to get write access.");
        } else {
            logger.error(name + ": Write access blocked until a locally homed prefix is selected");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveObjectsDBWriteImplHS(String authHandle, int authIndex, File keyFile, boolean translate) throws IOException {
        super(translate);
        byte[] keydata;
        this._profiling = true;
        logger.info("ArchiveObjectsDBWriteImplHS trying to log in...");
        this.profile(null);
        FileInputStream iStream = new FileInputStream(keyFile);
        try {
            keydata = new byte[(int)keyFile.length()];
            for (int n = 0; n < keydata.length; ++n) {
                keydata[n] = (byte)iStream.read();
            }
        }
        finally {
            iStream.close();
        }
        PrivateKey privkey = null;
        byte[] passphrase = null;
        try {
            if (Util.requiresSecretKey((byte[])keydata)) {
                passphrase = Util.getPassphrase((String)"Please enter privkey passphrase: ");
            }
            keydata = Util.decrypt((byte[])keydata, (byte[])passphrase);
            privkey = Util.getPrivateKeyFromBytes((byte[])keydata, (int)0);
        }
        catch (Exception e) {
            throw new IOException("Exception in key read: " + e);
        }
        if (passphrase != null) {
            for (int n = 0; n < passphrase.length; ++n) {
                passphrase[n] = -1;
            }
        }
        this._auth = new PublicKeyAuthenticationInfo(authHandle.getBytes("UTF8"), authIndex, privkey);
        try {
            this._sessionSetupInfo = new SessionSetupInfo((AuthenticationInfo)this._auth);
        }
        catch (Exception e) {
            throw new IOException("SessionSetupInfo Exception: " + e);
        }
        this._sessionSetupInfo.authenticated = false;
        this._sessionSetupInfo.encrypted = false;
        this.resolver.setSessionTracker(new ClientSessionTracker());
        this.resolver.getSessionTracker().setSessionSetupInfo(this._sessionSetupInfo);
        this.profile("handle-system-login-session");
        logger.info("ArchiveObjectsDBWriteImplHS logged in as " + authIndex + ":" + authHandle);
    }

    public ArchiveObjectsDBWriteImplHS(String configFile, boolean translate) {
        super(configFile, translate);
        if (this.sqlhs == null) {
            logger.error("Must have SQL connection to write to the DB");
            super.close();
            return;
        }
        this.sqlTroubles("ArchiveObjectsDBWriteImplHS");
        if (this.useSQL) {
            this.setArchiveRoots(this.getAAC());
        }
    }

    public ArchiveObjectsDBWriteImplHS(String configFile) {
        super(configFile);
        if (this.sqlhs == null) {
            logger.error("Must have SQL connection to write to the DB");
            super.close();
            return;
        }
        this.sqlTroubles("ArchiveObjectsDBWriteImplHS");
        if (this.useSQL) {
            this.setArchiveRoots(this.getAAC());
        }
    }

    public ArchiveObjectsDBWriteImplHS(String jdbcurl, String username, String password, String drivername) {
        super(jdbcurl, username, password, drivername);
        if (this.sqlhs == null) {
            logger.error("Must have SQL connection to write to the DB");
            super.close();
            return;
        }
        this.sqlTroubles("ArchiveObjectsDBWriteImplHS");
        if (this.useSQL) {
            this.setArchiveRoots(this.getAAC());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this._auth != null || this._sessionSetupInfo != null) {
            this._auth = null;
            this._sessionSetupInfo = null;
            logger.info("ArchiveObjectsDBWriteImplHS HS auth / session dropped");
        }
        if (this.db == null) {
            logger.info("ArchiveObjectsDBWriteImplHS already closed");
            return;
        }
        if (this.db.dbType == 2) {
            Statement statement = null;
            try {
                statement = this.db.getConnection().createStatement();
                statement.execute("SHUTDOWN COMPACT");
            }
            catch (SQLException sqle) {
                if (sqle.toString().indexOf("is shutdown") != -1) {
                    logger.info("database already shutdown");
                } else {
                    logger.error("shutdown: SQLException: ", (Throwable)sqle);
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        logger.warn("shutdown: Failed to close statement");
                    }
                }
                statement = null;
            }
        }
        this.vacuumPostgreSQL(true);
    }

    @Override
    public String newArchiveObject(String name, URI uri, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo, String checksum) throws UpdateInProgressException, UnknownNodeException {
        return this.newArchiveObject(name, uri, null, crawltime, onsite, size, filetime, ainfo, checksum);
    }

    @Override
    public String newArchiveObject(String node, URI uri, String pid, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo, String checksum) throws UpdateInProgressException, UnknownNodeException {
        if (this.sqlTroubles("newArchiveObject") || this.adminValue == null) {
            throw new UpdateInProgressException("newArchiveObject: invalid prefix active: " + (this.adminValue == null ? "(none set yet)" : this.getAAC().getHandlePrefix()));
        }
        String urlstr = uri.toString();
        Vector<HandleValue> values = new Vector<HandleValue>();
        Object troubles = null;
        String name = this.translateToHandle(node);
        String formattedPid = null;
        if (pid != null) {
            formattedPid = NodeIdUtils.formatPIDForStorage(pid, this.getArchiveRoots().getHandlePrefix());
        }
        if (name == null || !NodeIdUtils.handleToPrefix(name).equals(this.getAAC().getHandlePrefix())) {
            logger.error("newArchiveObject: Tried to create invalid handle named '" + name + "'");
            throw new UpdateInProgressException("newArchiveObject: invalid handle name " + name);
        }
        if (urlstr.indexOf("///") != -1) {
            urlstr = urlstr.replaceFirst("///", "/");
        }
        values.add(this.adminValue);
        this.profile(null);
        values.add(new HandleValue(1, Common.STD_TYPE_URL, Util.encodeString((String)urlstr)));
        values.add(new HandleValue(2, Util.encodeString((String)"CRAWLTIME"), Util.encodeString((String)crawltime.toString())));
        if (size > 0L) {
            values.add(new HandleValue(3, Util.encodeString((String)"FILESIZE"), Util.encodeString((String)Long.toString(size))));
        }
        values.add(new HandleValue(4, Util.encodeString((String)"ONSITE"), Util.encodeString((String)Boolean.toString(onsite))));
        if (checksum != null) {
            values.add(new HandleValue(5, Util.encodeString((String)"CHECKSUM"), Util.encodeString((String)checksum)));
        }
        if (filetime != null) {
            values.add(new HandleValue(6, Util.encodeString((String)"FILETIME"), Util.encodeString((String)filetime.toString())));
        }
        if (formattedPid != null) {
            values.add(new HandleValue(7, Util.encodeString((String)"PID"), Util.encodeString((String)NodeIdUtils.standardizePID(formattedPid))));
        }
        if (ainfo != null) {
            if (ainfo.getReadRights() != null) {
                values.add(new HandleValue(12, Util.encodeString((String)"READRIGHTS"), Util.encodeString((String)ainfo.getReadRights())));
            }
            if (ainfo.getWriteRights() != null) {
                values.add(new HandleValue(13, Util.encodeString((String)"WRITERIGHTS"), Util.encodeString((String)ainfo.getWriteRights())));
            }
        }
        this.writeHandle(name, values, false);
        return node;
    }

    @Override
    public String newArchiveObject(URI uri, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo) throws UpdateInProgressException, UnknownNodeException {
        return this.newArchiveObject(uri, null, crawltime, onsite, size, filetime, ainfo);
    }

    @Override
    public String newArchiveObject(URI uri, String pid, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo) throws UpdateInProgressException, UnknownNodeException {
        if (this.sqlTroubles("newArchiveObject")) {
            throw new UpdateInProgressException("newArchiveObject: invalid prefix active: " + this.getAAC().getHandlePrefix());
        }
        String handle = this.getObjectId(uri);
        String checksum = null;
        if (handle != null) {
            logger.error("newArchiveObject: This URI already belongs to handle: " + handle);
            return null;
        }
        Long now = System.currentTimeMillis();
        int node = (now.hashCode() ^ uri.hashCode()) & 0x3FFFFFFF | 0x40000000;
        String nodeId = NodeIdUtils.nodeToHandle(node, this.getAAC().getHandlePrefix());
        logger.warn("newArchiveObject: Allocated pseudorandom handle " + nodeId + " (node=" + node + ") for URI: " + uri);
        return this.newArchiveObject(nodeId, uri, pid, crawltime, onsite, size, filetime, ainfo, checksum);
    }

    @Override
    public boolean deleteArchiveObject(String nodeId) throws UnknownNodeException {
        if (this.sqlTroubles("deleteArchiveObject")) {
            return false;
        }
        String id = this.translateToHandle(nodeId);
        byte[] idEnc = Util.encodeString((String)id);
        this.vacuumPostgreSQL(false);
        try {
            if (this._auth != null) {
                DeleteHandleRequest dhReq = new DeleteHandleRequest(idEnc, (AuthenticationInfo)this._auth);
                AbstractResponse response = this.resolver.processRequest((AbstractRequest)dhReq);
                if (response.responseCode != 1) {
                    logger.error("deleteArchiveObject: Failed for: " + id + " Response: " + response);
                    return false;
                }
                return true;
            }
            return this.sqlhs.deleteHandle(idEnc);
        }
        catch (HandleException he) {
            if (he.getCode() == 9) {
                logger.warn("deleteArchiveObject: handle " + id + " does not exist");
            } else {
                logger.error("deleteArchiveObject: " + id + " exception " + (Object)((Object)he));
            }
            return false;
        }
    }

    @Override
    public void setArchiveObjectFileInfo(String nodeId, long filesize, Timestamp filetime) throws UpdateInProgressException, UnknownNodeException {
        if (this.sqlTroubles("setArchiveObjectFileInfo")) {
            throw new UpdateInProgressException("setArchiveObjectFileInfo: invalid prefix active: " + this.getAAC().getHandlePrefix());
        }
        String id = this.translateToHandle(nodeId);
        Vector values = this.fetchHandleSQL(id, null);
        values = this.removeValues(values, "FILESIZE");
        values = this.removeValues(values, "FILETIME");
        if (filesize > 0L) {
            values.add(new HandleValue(3, Util.encodeString((String)"FILESIZE"), Util.encodeString((String)Long.toString(filesize))));
        }
        if (filetime != null) {
            values.add(new HandleValue(6, Util.encodeString((String)"FILETIME"), Util.encodeString((String)filetime.toString())));
        }
        this.writeHandle(id, values, true);
    }

    @Override
    public boolean setArchiveObjectPid(String nodeId, String pid) throws UpdateInProgressException, UnknownNodeException {
        boolean result = false;
        if (this.sqlTroubles("setArchiveObjectPid")) {
            throw new UpdateInProgressException("setArchiveObjectPid: invalid prefix active: " + this.getAAC().getHandlePrefix());
        }
        String existingPid = this.getObjectPID(nodeId);
        if (existingPid != null && !NodeIdUtils.arePIDsEqual(pid, existingPid)) {
            logger.warn("PIDs are not supposed to change, change ignored: [existingPid = " + existingPid + ", pid = " + pid + "].");
            return result;
        }
        String id = this.translateToHandle(nodeId);
        Vector values = this.fetchHandleSQL(id, null);
        values = this.removeValues(values, "PID");
        if (pid != null) {
            values.add(new HandleValue(7, Util.encodeString((String)"PID"), Util.encodeString((String)pid)));
        }
        this.writeHandle(id, values, true);
        result = true;
        return result;
    }

    @Override
    public void setObjectCrawlTime(String nodeId, Timestamp time) throws UpdateInProgressException, UnknownNodeException {
        if (this.sqlTroubles("setObjectCrawlTime")) {
            throw new UpdateInProgressException("setObjectCrawlTime: invalid prefix active: " + this.getAAC().getHandlePrefix());
        }
        String id = this.translateToHandle(nodeId);
        Vector values = this.fetchHandleSQL(id, null);
        values = this.removeValues(values, "CRAWLTIME");
        values.add(new HandleValue(2, Util.encodeString((String)"CRAWLTIME"), Util.encodeString((String)time.toString())));
        this.writeHandle(id, values, true);
    }

    @Override
    public boolean moveArchiveObject(String nodeId, URI newUri) throws UpdateInProgressException, UnknownNodeException {
        if (this.sqlTroubles("moveArchiveObject")) {
            return false;
        }
        String urlstr = newUri.toString();
        String id = this.translateToHandle(nodeId);
        Vector values = this.fetchHandleSQL(id, null);
        if (urlstr.indexOf("///") != -1) {
            urlstr = urlstr.replaceFirst("///", "/");
        }
        values = this.removeValues(values, new String(Common.STD_TYPE_URL));
        values.add(new HandleValue(1, Common.STD_TYPE_URL, Util.encodeString((String)urlstr)));
        try {
            this.writeHandle(id, values, true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setObjectAccessInfo(String nodeId, AccessInfo ai) throws UpdateInProgressException, UnknownNodeException {
        if (this.sqlTroubles("setObjectAccessInfo")) {
            throw new UpdateInProgressException("setObjectAccessInfo: invalid prefix active: " + this.getAAC().getHandlePrefix());
        }
        String id = this.translateToHandle(nodeId);
        Vector values = this.fetchHandleSQL(id, null);
        values = this.removeValues(values, "CREATOR");
        values = this.removeValues(values, "OWNER");
        values = this.removeValues(values, "READRIGHTS");
        values = this.removeValues(values, "WRITERIGHTS");
        if (ai != null) {
            if (ai.getReadRights() != null) {
                values.add(new HandleValue(12, Util.encodeString((String)"READRIGHTS"), Util.encodeString((String)ai.getReadRights())));
            }
            if (ai.getWriteRights() != null) {
                values.add(new HandleValue(13, Util.encodeString((String)"WRITERIGHTS"), Util.encodeString((String)ai.getWriteRights())));
            }
        }
        this.writeHandle(id, values, true);
    }

    @Override
    public void setObjectChecksum(String nodeId, String checksum) throws UpdateInProgressException, UnknownNodeException {
        if (this.sqlTroubles("setObjectChecksum")) {
            throw new UpdateInProgressException("setObjectChecksum: invalid prefix active: " + this.getAAC().getHandlePrefix());
        }
        String id = this.translateToHandle(nodeId);
        Vector values = this.fetchHandleSQL(id, null);
        values = this.removeValues(values, "CHECKSUM");
        if (checksum != null) {
            values.add(new HandleValue(5, Util.encodeString((String)"CHECKSUM"), Util.encodeString((String)checksum)));
        }
        this.writeHandle(id, values, true);
    }

    private void profile(String label) {
        if (!this._profiling) {
            return;
        }
        long when = System.currentTimeMillis();
        if (label != null) {
            System.out.println("" + (when - beforeTime) + " msec for " + label);
        }
        beforeTime = when;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void vacuumPostgreSQL(boolean force) {
        if (this.db == null) {
            return;
        }
        ArchiveObjectsDBWriteImplHS archiveObjectsDBWriteImplHS = this;
        synchronized (archiveObjectsDBWriteImplHS) {
            ++this.handlesWritten;
            if ((this.handlesWritten & 0x3FFF) == 0) {
                force = true;
            }
        }
        if (!force) {
            return;
        }
        if (this.db.dbType == 1) {
            Statement statement = null;
            try {
                statement = this.db.getConnection().createStatement();
                statement.execute("VACUUM ANALYZE HANDLES");
            }
            catch (SQLException sqle) {
                logger.warn("vacuumPostgreSQL: SQLException: ", (Throwable)sqle);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        logger.warn("vacuumPostgreSQL: Failed to close statement");
                    }
                }
                statement = null;
            }
        }
    }

    private Vector removeValues(Vector values, String field) {
        Iterator iter = values.iterator();
        Vector<HandleValue> toBeRemoved = new Vector<HandleValue>();
        while (iter.hasNext()) {
            HandleValue hv = (HandleValue)iter.next();
            if (!hv.getTypeAsString().equals(field)) continue;
            toBeRemoved.add(hv);
        }
        if (toBeRemoved.size() > 1) {
            logger.warn("Removed " + toBeRemoved.size() + " values of type " + field + ":");
            for (HandleValue hv : toBeRemoved) {
                logger.warn("Removed: " + field + " -> " + hv.getDataAsString());
            }
        }
        values.removeAll(toBeRemoved);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHandle(String name, Vector values, boolean rewrite) throws UpdateInProgressException {
        Object troubles = null;
        this.vacuumPostgreSQL(false);
        this.profile(null);
        byte[] nameEnc = Util.encodeString((String)name);
        try {
            HandleValue[] theValues = values.toArray(new HandleValue[0]);
            if (this._auth != null) {
                if (rewrite) {
                    ModifyValueRequest mvReq = new ModifyValueRequest(nameEnc, theValues, (AuthenticationInfo)this._auth);
                    AbstractResponse response = this.resolver.processRequest((AbstractRequest)mvReq);
                    if (response.responseCode != 1) {
                        troubles = response.toString();
                    }
                } else {
                    CreateHandleRequest chReq = new CreateHandleRequest(nameEnc, theValues, (AuthenticationInfo)this._auth);
                    AbstractResponse response = this.resolver.processRequest((AbstractRequest)chReq);
                    if (response.responseCode != 1) {
                        troubles = response.toString();
                    }
                }
            } else if (rewrite) {
                this.sqlhs.updateValue(nameEnc, theValues);
            } else {
                this.sqlhs.createHandle(nameEnc, theValues);
            }
        }
        catch (HandleException he) {
            if (he.getCode() == 5) {
                logger.error("writeHandle: handle " + name + " already exists.");
                troubles = "handle already exists: " + name;
            } else {
                logger.error("writeHandle: Could not create/update handle " + name + " reason: " + (Object)((Object)he));
                troubles = he;
            }
        }
        catch (Exception e) {
            logger.error("writeHandle: exception: " + e);
            troubles = e;
        }
        finally {
            this.profile("create-handle");
        }
        if (troubles != null) {
            throw new UpdateInProgressException("writeHandle: " + troubles);
        }
    }
}

