/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.EmptySequence;

public class XSLDocument
extends StyleElement {
    private int validationAction = 4;
    private SchemaType schemaType = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string3 = this.getNamePool().getClarkName(n);
            if (string3 == "validation") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string3 == "type") {
                string2 = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
        } else {
            this.validationAction = Validation.getCode(string);
            if (this.validationAction != 4 && !this.getConfiguration().isSchemaAware(50)) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            if (this.validationAction == -1) {
                this.compileError("Invalid value of @validation attribute", "XTSE0020");
            }
        }
        if (string2 != null) {
            if (!this.getConfiguration().isSchemaAware(50)) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.schemaType = this.getSchemaType(string2);
            this.validationAction = 8;
        }
        if (string2 != null && string != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
    }

    public void validate() throws XPathException {
    }

    public Expression compile(Executable executable) throws XPathException {
        DocumentInstr documentInstr = new DocumentInstr(false, null, this.getBaseURI());
        documentInstr.setValidationAction(this.validationAction);
        documentInstr.setSchemaType(this.schemaType);
        Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
        if (expression == null) {
            expression = Literal.makeLiteral(EmptySequence.getInstance());
        }
        documentInstr.setContentExpression(expression);
        ExpressionTool.makeParentReferences(documentInstr);
        return documentInstr;
    }
}

