/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyParentNodeImpl;
import net.sf.saxon.tinytree.TinyTextImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.tinytree.WhitespaceTextImpl;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

final class TinyElementImpl
extends TinyParentNodeImpl {
    public TinyElementImpl(TinyTree tinyTree, int n) {
        this.tree = tinyTree;
        this.nodeNr = n;
    }

    public final int getNodeKind() {
        return 1;
    }

    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public int getTypeAnnotation() {
        return this.tree.getTypeAnnotation(this.nodeNr);
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        NodeInfo nodeInfo;
        if (!this.tree.usesNamespaces) {
            return;
        }
        int n = this.tree.beta[this.nodeNr];
        if (n > 0) {
            while (n < this.tree.numberOfNamespaces && this.tree.namespaceParent[n] == this.nodeNr) {
                int n2 = this.tree.namespaceCode[n];
                receiver.namespace(n2, 0);
                ++n;
            }
        }
        if (bl && (nodeInfo = this.getParent()) != null) {
            nodeInfo.sendNamespaceDeclarations(receiver, true);
        }
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        return TinyElementImpl.getDeclaredNamespaces(this.tree, this.nodeNr, nArray);
    }

    static final int[] getDeclaredNamespaces(TinyTree tinyTree, int n, int[] nArray) {
        int n2 = tinyTree.beta[n];
        if (n2 > 0) {
            int n3 = 0;
            while (n2 < tinyTree.numberOfNamespaces && tinyTree.namespaceParent[n2] == n) {
                ++n3;
                ++n2;
            }
            if (n3 == 0) {
                return NodeInfo.EMPTY_NAMESPACE_LIST;
            }
            if (n3 <= nArray.length) {
                System.arraycopy(tinyTree.namespaceCode, tinyTree.beta[n], nArray, 0, n3);
                if (n3 < nArray.length) {
                    nArray[n3] = -1;
                }
                return nArray;
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(tinyTree.namespaceCode, tinyTree.beta[n], nArray2, 0, n3);
            return nArray2;
        }
        return NodeInfo.EMPTY_NAMESPACE_LIST;
    }

    static final int[] getInScopeNamespaces(TinyTree tinyTree, int n, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[10];
        }
        nArray[0] = 65537;
        int n2 = 1;
        if (tinyTree.usesNamespaces) {
            int n3;
            int n4;
            int n5;
            do {
                if ((n5 = tinyTree.beta[n]) <= 0) continue;
                while (n5 < tinyTree.numberOfNamespaces && tinyTree.namespaceParent[n5] == n) {
                    n4 = tinyTree.namespaceCode[n5];
                    n3 = (short)(n4 >> 16);
                    boolean bl = false;
                    for (int i = 0; i < n2; ++i) {
                        if (nArray[i] >> 16 != n3) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        if (n2 >= nArray.length) {
                            int[] nArray2 = new int[n2 * 2];
                            System.arraycopy(nArray, 0, nArray2, 0, n2);
                            nArray = nArray2;
                        }
                        nArray[n2++] = n4;
                    }
                    ++n5;
                }
            } while ((n = TinyElementImpl.getParentNodeNr(tinyTree, n)) != -1);
            n5 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = nArray[n4];
                if ((n3 & 0xFFFF) == 0) continue;
                nArray[n5++] = n3;
            }
            n2 = n5;
        }
        if (n2 < nArray.length) {
            nArray[n2] = -1;
        }
        return nArray;
    }

    public String getAttributeValue(int n) {
        int n2 = this.tree.alpha[this.nodeNr];
        if (n2 < 0) {
            return null;
        }
        while (n2 < this.tree.numberOfAttributes && this.tree.attParent[n2] == this.nodeNr) {
            if ((this.tree.attCode[n2] & 0xFFFFF) == n) {
                return ((Object)this.tree.attValue[n2]).toString();
            }
            ++n2;
        }
        return null;
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        short s = -1;
        boolean bl2 = false;
        short s2 = this.tree.depth[this.nodeNr];
        boolean bl3 = true;
        boolean bl4 = n == 0 && bl;
        Configuration configuration = null;
        int n3 = this.nodeNr;
        boolean bl5 = n2 == 0 && receiver instanceof LocationCopier;
        do {
            short s3 = this.tree.depth[n3];
            if (bl2) {
                s = (short)(s + 1);
            }
            while (s > s3) {
                receiver.endElement();
                s = (short)(s - 1);
            }
            s = s3;
            switch (this.tree.nodeKind[n3]) {
                case 1: {
                    int n4;
                    int n5;
                    int n6;
                    int n7 = n6 = bl ? this.tree.getTypeAnnotation(n3) : 630;
                    if (bl4) {
                        if (configuration == null) {
                            configuration = this.getConfiguration();
                        }
                        this.checkNotNamespaceSensitive(configuration, n6);
                    }
                    if (bl5) {
                        ((LocationCopier)receiver).setLineNumber(this.tree.getLineNumber(n3));
                    }
                    receiver.startElement(this.tree.nameCode[n3], n6, n2, 0);
                    bl2 = true;
                    if (n != 0 && this.tree.usesNamespaces) {
                        if (bl3) {
                            this.sendNamespaceDeclarations(receiver, n == 2);
                        } else {
                            n5 = this.tree.beta[n3];
                            if (n5 > 0) {
                                while (n5 < this.tree.numberOfNamespaces && this.tree.namespaceParent[n5] == n3) {
                                    n4 = this.tree.namespaceCode[n5];
                                    receiver.namespace(n4, 0);
                                    ++n5;
                                }
                            }
                        }
                    }
                    bl3 = false;
                    n5 = this.tree.alpha[n3];
                    if (n5 >= 0) {
                        while (n5 < this.tree.numberOfAttributes && this.tree.attParent[n5] == n3) {
                            int n8;
                            n4 = this.tree.attCode[n5];
                            int n9 = n8 = bl ? this.tree.getAttributeAnnotation(n5) : -1;
                            if (bl4) {
                                if (configuration == null) {
                                    configuration = this.getConfiguration();
                                }
                                this.checkNotNamespaceSensitive(configuration, n8);
                            }
                            receiver.attribute(n4, n8, this.tree.attValue[n5], n2, 0);
                            ++n5;
                        }
                    }
                    receiver.startContent();
                    break;
                }
                case 3: {
                    bl2 = false;
                    CharSequence charSequence = TinyTextImpl.getStringValue(this.tree, n3);
                    receiver.characters(charSequence, n2, 1024);
                    break;
                }
                case 4: {
                    bl2 = false;
                    CharSequence charSequence = WhitespaceTextImpl.getStringValue(this.tree, n3);
                    receiver.characters(charSequence, n2, 1024);
                    break;
                }
                case 8: {
                    bl2 = false;
                    int n10 = this.tree.alpha[n3];
                    int n5 = this.tree.beta[n3];
                    if (n5 > 0) {
                        receiver.comment(this.tree.commentBuffer.subSequence(n10, n10 + n5), n2, 0);
                        break;
                    }
                    receiver.comment("", 0, 0);
                    break;
                }
                case 7: {
                    bl2 = false;
                    TinyNodeImpl tinyNodeImpl = this.tree.getNode(n3);
                    receiver.processingInstruction(tinyNodeImpl.getLocalPart(), tinyNodeImpl.getStringValue(), n2, 0);
                    break;
                }
                case 12: {
                    bl2 = false;
                }
            }
        } while (++n3 < this.tree.numberOfNodes && this.tree.depth[n3] > s2);
        if (bl2) {
            s = (short)(s + 1);
        }
        while (s > s2) {
            receiver.endElement();
            s = (short)(s - 1);
        }
    }

    private void checkNotNamespaceSensitive(Configuration configuration, int n) throws DynamicError {
        SchemaType schemaType = configuration.getSchemaType(n & 0xFFFFF);
        if (schemaType instanceof SimpleType && ((SimpleType)schemaType).isNamespaceSensitive()) {
            throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
        }
    }

    public String getURIForPrefix(String string, boolean bl) {
        NodeInfo nodeInfo;
        if (!(bl || string != null && string.length() != 0)) {
            return "";
        }
        short s = this.getNamePool().getCodeForPrefix(string);
        if (s == -1) {
            return null;
        }
        int n = this.tree.beta[this.nodeNr];
        if (n > 0) {
            while (n < this.tree.numberOfNamespaces && this.tree.namespaceParent[n] == this.nodeNr) {
                int n2 = this.tree.namespaceCode[n];
                if (n2 >> 16 == s) {
                    int n3 = n2 & 0xFFFF;
                    if (n3 == 0) {
                        if (s == 0) {
                            return "";
                        }
                        return null;
                    }
                    return this.getNamePool().getURIFromURICode((short)n3);
                }
                ++n;
            }
        }
        if ((nodeInfo = this.getParent()) instanceof NamespaceResolver) {
            return ((NamespaceResolver)((Object)nodeInfo)).getURIForPrefix(string, bl);
        }
        return null;
    }

    public boolean isId() {
        return this.getDocumentRoot().selectID(this.getStringValue()).isSameNodeInfo(this);
    }

    public boolean isIdref() {
        return this.tree.isIdrefElement(this.nodeNr);
    }
}

