/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.ImdiIcons;
import nl.mpi.arbil.ImdiTable;
import nl.mpi.arbil.ImdiToHtmlConverter;
import nl.mpi.arbil.ImdiTree;
import nl.mpi.arbil.LinorgFavourites;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgSplitPanel;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.TreeHelper;
import nl.mpi.arbil.XsdChecker;
import nl.mpi.arbil.clarin.CmdiComponentBuilder;
import nl.mpi.arbil.data.ImdiLoader;
import nl.mpi.arbil.data.ImdiTreeObject;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.importexport.ArbilCsvImporter;
import nl.mpi.arbil.importexport.ImportExportDialog;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.templates.ArbilTemplateManager;

public class ContextMenu {
    private JMenu addFromFavouritesMenu;
    private JMenuItem addLocalDirectoryMenuItem;
    private JCheckBoxMenuItem showHiddenFilesMenuItem;
    private JMenuItem addDefaultLocationsMenuItem;
    private JMenu addMenu;
    private JMenuItem addRemoteCorpusMenuItem;
    private JMenuItem addToFavouritesMenuItem;
    private JMenuItem copyBranchMenuItem;
    private JMenuItem copyImdiUrlMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem exportMenuItem;
    private JMenuItem importCsvMenuItem;
    private JMenuItem importBranchMenuItem;
    private JMenuItem reImportBranchMenuItem;
    private JMenu mergeWithFavouritesMenu;
    private JMenuItem pasteMenuItem1;
    private JMenuItem reloadSubnodesMenuItem;
    private JMenuItem removeCachedCopyMenuItem;
    private JMenuItem removeLocalDirectoryMenuItem;
    private JMenuItem removeRemoteCorpusMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem searchSubnodesMenuItem;
    private JMenuItem sendToServerMenuItem;
    private JPopupMenu treePopupMenu = new JPopupMenu();
    private JMenuItem validateMenuItem;
    private JMenu historyMenu;
    private JMenuItem viewChangesMenuItem;
    private JMenuItem browseForResourceFileMenuItem;
    private JMenuItem viewSelectedNodesMenuItem = new JMenuItem();
    private JMenuItem viewXmlMenuItem;
    private JMenuItem viewInBrrowserMenuItem;
    private JMenuItem viewXmlMenuItemFormatted;
    private JMenuItem openXmlMenuItemFormatted;
    private JMenuItem exportHtmlMenuItemFormatted;
    private JMenuItem overrideTypeCheckerDecision;
    private static ContextMenu singleInstance = null;
    private JMenuItem copySelectedRowsMenuItem;
    private JMenuItem pasteIntoSelectedRowsMenuItem;
    private JMenuItem viewSelectedRowsMenuItem;
    private JMenuItem matchingRowsMenuItem;
    private JMenuItem removeSelectedRowsMenuItem;
    private JMenuItem hideSelectedColumnsMenuItem;
    private JMenuItem searchReplaceMenuItem;
    private JMenuItem deleteFieldMenuItem;
    private JMenuItem revertFieldMenuItem;
    private JMenuItem copyCellToColumnMenuItem;
    private JMenuItem matchingCellsMenuItem;
    private JMenuItem openInLongFieldEditorMenuItem;
    private JMenuItem clearCellColoursMenuItem;
    private JMenuItem jumpToNodeInTreeMenuItem;
    private JMenuItem showChildNodesMenuItem;
    ImdiTreeObject[] selectedTreeNodes = null;
    ImdiTreeObject leadSelectedTreeNode = null;
    ImdiTable currentTable = null;

    public static synchronized ContextMenu getSingleInstance() {
        System.out.println("ContextMenu getSingleInstance");
        if (singleInstance == null) {
            singleInstance = new ContextMenu();
        }
        return singleInstance;
    }

    private ContextMenu() {
        this.copyImdiUrlMenuItem = new JMenuItem();
        this.pasteMenuItem1 = new JMenuItem();
        this.copyBranchMenuItem = new JMenuItem();
        this.searchSubnodesMenuItem = new JMenuItem();
        this.reloadSubnodesMenuItem = new JMenuItem();
        this.addMenu = new JMenu();
        this.addToFavouritesMenuItem = new JMenuItem();
        this.addFromFavouritesMenu = new JMenu();
        this.mergeWithFavouritesMenu = new JMenu();
        this.deleteMenuItem = new JMenuItem();
        this.viewXmlMenuItem = new JMenuItem();
        this.viewXmlMenuItemFormatted = new JMenuItem();
        this.openXmlMenuItemFormatted = new JMenuItem();
        this.exportHtmlMenuItemFormatted = new JMenuItem();
        this.overrideTypeCheckerDecision = new JMenuItem();
        this.viewInBrrowserMenuItem = new JMenuItem();
        this.browseForResourceFileMenuItem = new JMenuItem();
        this.validateMenuItem = new JMenuItem();
        this.historyMenu = new JMenu();
        this.addRemoteCorpusMenuItem = new JMenuItem();
        this.addDefaultLocationsMenuItem = new JMenuItem();
        this.removeRemoteCorpusMenuItem = new JMenuItem();
        this.removeCachedCopyMenuItem = new JMenuItem();
        this.addLocalDirectoryMenuItem = new JMenuItem();
        this.showHiddenFilesMenuItem = new JCheckBoxMenuItem();
        this.removeLocalDirectoryMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.viewChangesMenuItem = new JMenuItem();
        this.sendToServerMenuItem = new JMenuItem();
        this.exportMenuItem = new JMenuItem();
        this.importCsvMenuItem = new JMenuItem();
        this.importBranchMenuItem = new JMenuItem();
        this.reImportBranchMenuItem = new JMenuItem();
        this.copySelectedRowsMenuItem = new JMenuItem();
        this.pasteIntoSelectedRowsMenuItem = new JMenuItem();
        this.viewSelectedRowsMenuItem = new JMenuItem();
        this.matchingRowsMenuItem = new JMenuItem();
        this.removeSelectedRowsMenuItem = new JMenuItem();
        this.hideSelectedColumnsMenuItem = new JMenuItem();
        this.searchReplaceMenuItem = new JMenuItem();
        this.deleteFieldMenuItem = new JMenuItem();
        this.revertFieldMenuItem = new JMenuItem();
        this.copyCellToColumnMenuItem = new JMenuItem();
        this.matchingCellsMenuItem = new JMenuItem();
        this.openInLongFieldEditorMenuItem = new JMenuItem();
        this.clearCellColoursMenuItem = new JMenuItem();
        this.jumpToNodeInTreeMenuItem = new JMenuItem();
        this.showChildNodesMenuItem = new JMenuItem();
        this.copySelectedRowsMenuItem.setText("Copy");
        this.copySelectedRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.currentTable.copySelectedTableRowsToClipBoard();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.copySelectedRowsMenuItem);
        this.pasteIntoSelectedRowsMenuItem.setText("Paste");
        this.pasteIntoSelectedRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.currentTable.pasteIntoSelectedTableRowsFromClipBoard();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.pasteIntoSelectedRowsMenuItem);
        this.treePopupMenu.add(new JSeparator());
        this.openInLongFieldEditorMenuItem.setText("Open in Long Field Editor");
        this.openInLongFieldEditorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.currentTable.startLongFieldEditorForSelectedFields();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.openInLongFieldEditorMenuItem);
        this.hideSelectedColumnsMenuItem.setText("Hide Selected Columns");
        this.hideSelectedColumnsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.currentTable.hideSelectedColumnsFromTable();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.hideSelectedColumnsMenuItem);
        this.showChildNodesMenuItem.setText("Show Child Nodes");
        this.showChildNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.currentTable.showRowChildData();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.showChildNodesMenuItem);
        this.deleteFieldMenuItem.setText("Delete MultiField");
        this.deleteFieldMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ImdiField[] selectedFields = ContextMenu.this.currentTable.getSelectedFields();
                    if (selectedFields != null) {
                        Hashtable<ImdiTreeObject, ArrayList<String>> selectedFieldHashtable = new Hashtable<ImdiTreeObject, ArrayList<String>>();
                        for (ImdiField currentField : selectedFields) {
                            ArrayList<String> currentList = (ArrayList<String>)selectedFieldHashtable.get(currentField.parentImdi);
                            if (currentList == null) {
                                currentList = new ArrayList<String>();
                                selectedFieldHashtable.put(currentField.parentImdi, currentList);
                            }
                            currentList.add(currentField.getFullXmlPath());
                        }
                        Iterator i$ = selectedFieldHashtable.keySet().iterator();
                        while (i$.hasNext()) {
                            CmdiComponentBuilder componentBuilder = new CmdiComponentBuilder();
                            ImdiTreeObject currentImdiObject = (ImdiTreeObject)i$.next();
                            boolean result = componentBuilder.removeChildNodes(currentImdiObject, ((ArrayList)selectedFieldHashtable.get(currentImdiObject)).toArray(new String[0]));
                            if (result) {
                                currentImdiObject.reloadNode();
                                continue;
                            }
                            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error deleting fields, check the log file via the help menu for more information.", "Delete Field");
                        }
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.deleteFieldMenuItem);
        this.revertFieldMenuItem.setText("Revert Selected Fields");
        this.revertFieldMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ImdiField[] selectedFields = ContextMenu.this.currentTable.getSelectedFields();
                    if (selectedFields != null) {
                        for (ImdiField currentField : selectedFields) {
                            currentField.revertChanges();
                        }
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.revertFieldMenuItem);
        this.copyCellToColumnMenuItem.setText("Copy Cell to Whole Column");
        this.copyCellToColumnMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!(ContextMenu.this.currentTable.imdiTableModel.getValueAt(ContextMenu.this.currentTable.getSelectedRow(), ContextMenu.this.currentTable.getSelectedColumn()) instanceof ImdiField)) {
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Cannot copy this type of field", "Copy Cell to Whole Column");
                    } else if (0 == JOptionPane.showConfirmDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "About to replace all values in column \"" + ContextMenu.this.currentTable.imdiTableModel.getColumnName(ContextMenu.this.currentTable.getSelectedColumn()) + "\"\nwith the value \"" + ContextMenu.this.currentTable.imdiTableModel.getValueAt(ContextMenu.this.currentTable.getSelectedRow(), ContextMenu.this.currentTable.getSelectedColumn()) + "\"\n(<multiple values> will not be affected)", "Copy cell to whole column", 0, -1)) {
                        ContextMenu.this.currentTable.imdiTableModel.copyCellToColumn(ContextMenu.this.currentTable.getSelectedRow(), ContextMenu.this.currentTable.getSelectedColumn());
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.copyCellToColumnMenuItem);
        this.matchingCellsMenuItem.setText("Highlight Matching Cells");
        this.matchingCellsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.currentTable.imdiTableModel.highlightMatchingCells(ContextMenu.this.currentTable.getSelectedRow(), ContextMenu.this.currentTable.getSelectedColumn());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.matchingCellsMenuItem);
        this.clearCellColoursMenuItem.setText("Clear Cell Highlight");
        this.clearCellColoursMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.currentTable.imdiTableModel.clearCellColours();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.clearCellColoursMenuItem);
        this.searchReplaceMenuItem.setText("Find/Replace");
        this.searchReplaceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ((LinorgSplitPanel)ContextMenu.this.currentTable.getParent().getParent().getParent().getParent()).showSearchPane();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.searchReplaceMenuItem);
        this.treePopupMenu.add(new JSeparator());
        this.viewSelectedRowsMenuItem.setText("View Selected Rows");
        this.viewSelectedRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.currentTable.viewSelectedTableRows();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.viewSelectedRowsMenuItem);
        this.matchingRowsMenuItem.setText("Select Matching Rows");
        this.matchingRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.currentTable.highlightMatchingRows();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.matchingRowsMenuItem);
        this.removeSelectedRowsMenuItem.setText("Remove Selected Rows");
        this.removeSelectedRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.currentTable.removeSelectedRowsFromTable();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.removeSelectedRowsMenuItem);
        this.jumpToNodeInTreeMenuItem.setText("Jump to in Tree");
        this.jumpToNodeInTreeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeHelper.getSingleInstance().jumpToSelectionInTree(false, ContextMenu.this.currentTable.getImdiNodeForSelection());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.jumpToNodeInTreeMenuItem);
        this.treePopupMenu.add(new JSeparator());
        this.viewSelectedNodesMenuItem.setText("View Selected");
        this.viewSelectedNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArrayList<ImdiTreeObject> filteredNodes = new ArrayList<ImdiTreeObject>();
                    for (ImdiTreeObject currentItem : ((ImdiTree)ContextMenu.this.treePopupMenu.getInvoker()).getSelectedNodes()) {
                        if (currentItem.isMetaDataNode() || currentItem.getFields().size() > 0) {
                            filteredNodes.add(currentItem);
                            continue;
                        }
                        try {
                            LinorgWindowManager.getSingleInstance().openUrlWindowOnce(currentItem.toString(), currentItem.getURI().toURL());
                        }
                        catch (MalformedURLException murle) {
                            GuiHelper.linorgBugCatcher.logError(murle);
                        }
                    }
                    if (filteredNodes.size() > 0) {
                        LinorgWindowManager.getSingleInstance().openFloatingTableOnce(filteredNodes.toArray(new ImdiTreeObject[0]), null);
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.viewSelectedNodesMenuItem);
        this.copyImdiUrlMenuItem.setText("Copy");
        this.copyImdiUrlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (ContextMenu.this.selectedTreeNodes == null) {
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("No node selected", "Copy");
                    } else {
                        ImdiTree sourceTree = (ImdiTree)ContextMenu.this.treePopupMenu.getInvoker();
                        sourceTree.copyNodeUrlToClipboard(ContextMenu.this.selectedTreeNodes);
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.copyImdiUrlMenuItem);
        this.pasteMenuItem1.setText("Paste");
        this.pasteMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ImdiTreeObject currentNode : ContextMenu.this.selectedTreeNodes) {
                        currentNode.pasteIntoNode();
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.pasteMenuItem1);
        this.copyBranchMenuItem.setText("Import to Local Corpus");
        this.copyBranchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.copyBranchMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.copyBranchMenuItem);
        this.searchSubnodesMenuItem.setText("Search");
        this.searchSubnodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.searchSubnodesMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.searchSubnodesMenuItem);
        this.reloadSubnodesMenuItem.setText("Reload");
        this.reloadSubnodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ImdiTreeObject currentNode : ContextMenu.this.selectedTreeNodes) {
                        currentNode.reloadNode();
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.reloadSubnodesMenuItem);
        this.addMenu.setText("Add");
        this.addMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                try {
                    ContextMenu.this.initAddMenu(ContextMenu.this.addMenu, ContextMenu.this.leadSelectedTreeNode);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.addMenu);
        this.addFromFavouritesMenu.setText("Add From Favourites");
        this.addFromFavouritesMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ContextMenu.this.initAddFromFavouritesMenu();
            }
        });
        this.treePopupMenu.add(this.addFromFavouritesMenu);
        this.addToFavouritesMenuItem.setText("Set As Favourite");
        this.addToFavouritesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    LinorgFavourites.getSingleInstance().toggleFavouritesList(((ImdiTree)ContextMenu.this.treePopupMenu.getInvoker()).getSelectedNodes(), ContextMenu.this.addToFavouritesMenuItem.getActionCommand().equals("true"));
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.addToFavouritesMenuItem);
        this.mergeWithFavouritesMenu.setText("Merge With Favourite");
        this.mergeWithFavouritesMenu.setActionCommand("Merge With Favouurite");
        this.browseForResourceFileMenuItem.setText("Browse For Resource File");
        this.browseForResourceFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    File[] selectedFiles = LinorgWindowManager.getSingleInstance().showFileSelectBox("Select Resource File", false, false, false);
                    if (selectedFiles != null && selectedFiles.length > 0) {
                        ContextMenu.this.leadSelectedTreeNode.resourceUrlField.setFieldValue(selectedFiles[0].toURL().toExternalForm(), true, false);
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.browseForResourceFileMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeHelper.getSingleInstance().deleteNode(ContextMenu.this.treePopupMenu.getInvoker());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.deleteMenuItem);
        this.treePopupMenu.add(new JSeparator());
        this.overrideTypeCheckerDecision.setText("Override Type Checker Decision");
        this.overrideTypeCheckerDecision.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    String titleString = "Override Type Checker Decision";
                    String messageString = "The type checker does not recognise the selected file/s, which means that they\nare not an archivable type. This action will override that decision and allow you\nto add the file/s to a session, as either media or written resources,\nhowever it might not be possible to import the result to the copus server.";
                    Object[] optionStrings = new String[]{"WrittenResource", "MediaFile", "Cancel"};
                    int userSelection = JOptionPane.showOptionDialog(LinorgWindowManager.getSingleInstance().linorgFrame.getContentPane(), messageString, titleString, -1, -1, null, optionStrings, optionStrings[2]);
                    if (((String)optionStrings[userSelection]).equals("WrittenResource") || ((String)optionStrings[userSelection]).equals("MediaFile")) {
                        for (ImdiTreeObject currentNode : ContextMenu.this.selectedTreeNodes) {
                            if (currentNode.mpiMimeType != null) continue;
                            currentNode.mpiMimeType = "Manual/" + (String)optionStrings[userSelection];
                            currentNode.typeCheckerMessage = "Manually overridden (might not be compatible with the archive)";
                            currentNode.clearIcon();
                        }
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.overrideTypeCheckerDecision);
        this.viewInBrrowserMenuItem.setText("Open in External Application");
        this.viewInBrrowserMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.openFileInBrowser(ContextMenu.this.selectedTreeNodes);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.viewInBrrowserMenuItem);
        this.viewXmlMenuItem.setText("View XML");
        this.viewXmlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ImdiTreeObject currentNode : ContextMenu.this.selectedTreeNodes) {
                        GuiHelper.getSingleInstance().openImdiXmlWindow(currentNode, false, false);
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.viewXmlMenuItem);
        this.viewXmlMenuItemFormatted.setText("View IMDI Formatted");
        this.viewXmlMenuItemFormatted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ImdiTreeObject currentNode : ContextMenu.this.selectedTreeNodes) {
                        GuiHelper.getSingleInstance().openImdiXmlWindow(currentNode, true, false);
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.viewXmlMenuItemFormatted);
        this.openXmlMenuItemFormatted.setText("Open IMDI Formatted");
        this.openXmlMenuItemFormatted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ImdiTreeObject currentNode : ContextMenu.this.selectedTreeNodes) {
                        GuiHelper.getSingleInstance().openImdiXmlWindow(currentNode, true, true);
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.openXmlMenuItemFormatted);
        this.exportHtmlMenuItemFormatted.setText("Export IMDI to HTML");
        this.exportHtmlMenuItemFormatted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    new ImdiToHtmlConverter().exportImdiToHtml(ContextMenu.this.selectedTreeNodes);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.exportHtmlMenuItemFormatted);
        this.validateMenuItem.setText("Check XML Conformance");
        this.validateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.validateMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.validateMenuItem);
        this.historyMenu.setText("History");
        this.historyMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                try {
                    ContextMenu.this.initHistoryMenu();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.historyMenu);
        this.treePopupMenu.add(new JSeparator());
        this.addRemoteCorpusMenuItem.setText("Add Remote Location");
        this.addRemoteCorpusMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.addRemoteCorpusMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.addRemoteCorpusMenuItem);
        this.addDefaultLocationsMenuItem.setText("Add Default Remote Locations");
        this.addDefaultLocationsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.addDefaultLocationsMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.addDefaultLocationsMenuItem);
        this.removeRemoteCorpusMenuItem.setText("Remove Remote Location");
        this.removeRemoteCorpusMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ImdiTreeObject selectedNode : ContextMenu.this.selectedTreeNodes) {
                        TreeHelper.getSingleInstance().removeLocation(selectedNode);
                    }
                    TreeHelper.getSingleInstance().applyRootLocations();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.removeRemoteCorpusMenuItem);
        this.removeCachedCopyMenuItem.setText("Remove Cache Link");
        this.removeCachedCopyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.removeCachedCopyMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.removeCachedCopyMenuItem);
        this.addLocalDirectoryMenuItem.setText("Add Working Directory");
        this.addLocalDirectoryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.addLocalDirectoryMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.addLocalDirectoryMenuItem);
        this.showHiddenFilesMenuItem.setText("Show Hidden Files");
        this.showHiddenFilesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeHelper.getSingleInstance().setShowHiddenFilesInTree(ContextMenu.this.showHiddenFilesMenuItem.getState());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.showHiddenFilesMenuItem);
        this.removeLocalDirectoryMenuItem.setText("Remove Link to Directory");
        this.removeLocalDirectoryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ImdiTreeObject selectedNode : ContextMenu.this.selectedTreeNodes) {
                        TreeHelper.getSingleInstance().removeLocation(selectedNode);
                    }
                    TreeHelper.getSingleInstance().applyRootLocations();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.removeLocalDirectoryMenuItem);
        this.saveMenuItem.setText("Save Changes to Disk");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ImdiTreeObject selectedNode : ContextMenu.this.selectedTreeNodes) {
                        System.out.println("userObject: " + selectedNode);
                        ImdiLoader.getSingleInstance().requestReload(selectedNode.getParentDomNode());
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.saveMenuItem);
        this.viewChangesMenuItem.setText("View Changes");
        this.viewChangesMenuItem.setEnabled(false);
        this.viewChangesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ImdiTreeObject currentNode : ContextMenu.this.selectedTreeNodes) {
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.viewChangesMenuItem);
        this.sendToServerMenuItem.setText("Send to Server");
        this.sendToServerMenuItem.setEnabled(false);
        this.sendToServerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ContextMenu.this.sendToServerMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.sendToServerMenuItem);
        this.exportMenuItem.setText("Export");
        this.exportMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ImportExportDialog importExportDialog = new ImportExportDialog(TreeHelper.getSingleInstance().arbilTreePanel.remoteCorpusTree);
                    importExportDialog.selectExportDirectoryAndExport(((ImdiTree)ContextMenu.this.treePopupMenu.getInvoker()).getSelectedNodes());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.exportMenuItem);
        this.importCsvMenuItem.setText("Import CSV");
        this.importCsvMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilCsvImporter csvImporter = new ArbilCsvImporter(ContextMenu.this.leadSelectedTreeNode);
                    csvImporter.doImport();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.importCsvMenuItem);
        this.importBranchMenuItem.setText("Import Branch");
        this.importBranchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ImportExportDialog importExportDialog = new ImportExportDialog(TreeHelper.getSingleInstance().arbilTreePanel.localCorpusTree);
                    importExportDialog.setDestinationNode(ContextMenu.this.leadSelectedTreeNode);
                    importExportDialog.importImdiBranch();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.importBranchMenuItem);
        this.reImportBranchMenuItem.setText("Re-Import this Branch");
        this.reImportBranchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    URI remoteImdiFile = LinorgSessionStorage.getSingleInstance().getOriginatingUri(ContextMenu.this.leadSelectedTreeNode.getURI());
                    if (remoteImdiFile != null) {
                        ImdiTreeObject originatingNode = ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(remoteImdiFile);
                        if (originatingNode.isLocal() && !originatingNode.getFile().exists()) {
                            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The origional file location cannot be found", "Re Import Branch");
                        } else if (originatingNode.isMetaDataNode()) {
                            ImportExportDialog importExportDialog = new ImportExportDialog(TreeHelper.getSingleInstance().arbilTreePanel.localCorpusTree);
                            importExportDialog.setDestinationNode(ContextMenu.this.leadSelectedTreeNode);
                            importExportDialog.copyToCache(new ImdiTreeObject[]{originatingNode});
                        } else {
                            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not determine the origional node type", "Re Import Branch");
                        }
                    } else {
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not determine the origional location", "Re Import Branch");
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.treePopupMenu.add(this.reImportBranchMenuItem);
    }

    private void copyBranchMenuItemActionPerformed(ActionEvent evt) {
        if (this.treePopupMenu.getInvoker() instanceof JTree) {
            try {
                ImportExportDialog importExportDialog = new ImportExportDialog(this.treePopupMenu.getInvoker());
                importExportDialog.copyToCache(((ImdiTree)this.treePopupMenu.getInvoker()).getSelectedNodes());
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        }
    }

    private void addLocalDirectoryMenuItemActionPerformed(ActionEvent evt) {
        File[] selectedFiles = LinorgWindowManager.getSingleInstance().showFileSelectBox("Add Working Directory", true, true, false);
        if (selectedFiles != null && selectedFiles.length > 0) {
            for (File currentDirectory : selectedFiles) {
                TreeHelper.getSingleInstance().addLocationGui(currentDirectory.toURI());
            }
        }
    }

    private void addRemoteCorpusMenuItemActionPerformed(ActionEvent evt) {
        String addableLocation = JOptionPane.showInputDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "Enter the URL", "Add Location", -1);
        if (addableLocation != null && addableLocation.length() > 0) {
            TreeHelper.getSingleInstance().addLocationGui(ImdiTreeObject.conformStringToUrl(addableLocation));
        }
    }

    private void addDefaultLocationsMenuItemActionPerformed(ActionEvent evt) {
        if (0 < TreeHelper.getSingleInstance().addDefaultCorpusLocations()) {
            TreeHelper.getSingleInstance().applyRootLocations();
        } else {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The defalut locations already exists and will not be added again", "Add Default Locations");
        }
    }

    private void removeCachedCopyMenuItemActionPerformed(ActionEvent evt) {
        Object selectedTreeNode = null;
    }

    private void searchSubnodesMenuItemActionPerformed(ActionEvent evt) {
        LinorgWindowManager.getSingleInstance().openSearchTable(TreeHelper.getSingleInstance().arbilTreePanel.localCorpusTree.getSelectedNodes(), "Search");
    }

    private void sendToServerMenuItemActionPerformed(ActionEvent evt) {
    }

    private void validateMenuItemActionPerformed(ActionEvent evt) {
        for (ImdiTreeObject currentNode : this.selectedTreeNodes) {
            XsdChecker xsdChecker = new XsdChecker();
            LinorgWindowManager.getSingleInstance().createWindow("XsdChecker", xsdChecker);
            xsdChecker.checkXML(currentNode);
            xsdChecker.setDividerLocation(0.5);
        }
    }

    private void openFileInBrowser(ImdiTreeObject[] selectedNodes) {
        for (ImdiTreeObject currentNode : selectedNodes) {
            URI targetUri = null;
            targetUri = currentNode.hasResource() ? currentNode.getFullResourceURI() : currentNode.getURI();
            GuiHelper.getSingleInstance().openFileInExternalApplication(targetUri);
        }
    }

    public void initAddMenu(JMenu addMenu, Object targetNodeUserObject) {
        boolean menuItemsAdded = false;
        addMenu.removeAll();
        if (targetNodeUserObject instanceof ImdiTreeObject && !((ImdiTreeObject)targetNodeUserObject).isCorpus()) {
            ImdiIcons imdiIcons = ImdiIcons.getSingleInstance();
            ArbilTemplate currentTemplate = ((ImdiTreeObject)targetNodeUserObject).getNodeTemplate();
            Enumeration menuItemName = currentTemplate.listTypesFor(targetNodeUserObject);
            while (menuItemName.hasMoreElements()) {
                String[] currentField = (String[])menuItemName.nextElement();
                JMenuItem addMenuItem = new JMenuItem();
                addMenuItem.setText(currentField[0]);
                addMenuItem.setName(currentField[0]);
                addMenuItem.setToolTipText(currentField[1]);
                addMenuItem.setActionCommand(currentField[1]);
                if (null != currentTemplate.pathIsChildNode(currentField[1])) {
                    addMenuItem.setIcon(imdiIcons.dataIcon);
                } else {
                    addMenuItem.setIcon(imdiIcons.fieldIcon);
                }
                addMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            if (ContextMenu.this.leadSelectedTreeNode != null) {
                                new MetadataBuilder().requestAddNode(ContextMenu.this.leadSelectedTreeNode, evt.getActionCommand(), ((JMenuItem)evt.getSource()).getText());
                            } else {
                                new MetadataBuilder().requestRootAddNode(evt.getActionCommand(), ((JMenuItem)evt.getSource()).getText());
                            }
                        }
                        catch (Exception ex) {
                            GuiHelper.linorgBugCatcher.logError(ex);
                        }
                    }
                });
                addMenu.add(addMenuItem);
                menuItemsAdded = true;
            }
        } else {
            for (ArbilTemplateManager.MenuItemData currentAddable : ArbilTemplateManager.getSingleInstance().getSelectedTemplates()) {
                JMenuItem addMenuItem = new JMenuItem();
                addMenuItem.setText(currentAddable.menuText);
                addMenuItem.setName(currentAddable.menuText);
                addMenuItem.setActionCommand(currentAddable.menuAction);
                addMenuItem.setToolTipText(currentAddable.menuToolTip);
                addMenuItem.setIcon(currentAddable.menuIcon);
                addMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            if (ContextMenu.this.leadSelectedTreeNode != null) {
                                new MetadataBuilder().requestAddNode(ContextMenu.this.leadSelectedTreeNode, evt.getActionCommand(), ((JMenuItem)evt.getSource()).getText());
                            } else {
                                new MetadataBuilder().requestRootAddNode(evt.getActionCommand(), ((JMenuItem)evt.getSource()).getText());
                            }
                        }
                        catch (Exception ex) {
                            GuiHelper.linorgBugCatcher.logError(ex);
                        }
                    }
                });
                addMenu.add(addMenuItem);
            }
        }
    }

    public void initHistoryMenu() {
        this.historyMenu.removeAll();
        for (String[] currentHistory : this.leadSelectedTreeNode.getHistoryList()) {
            JMenuItem revertHistoryMenuItem = new JMenuItem();
            revertHistoryMenuItem.setText(currentHistory[0]);
            revertHistoryMenuItem.setName(currentHistory[0]);
            revertHistoryMenuItem.setActionCommand(currentHistory[1]);
            revertHistoryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        if (!ContextMenu.this.leadSelectedTreeNode.resurrectHistory(evt.getActionCommand())) {
                            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not revert version, no changes made", "History");
                        }
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                }
            });
            this.historyMenu.add(revertHistoryMenuItem);
        }
    }

    public void initAddFromFavouritesMenu() {
        this.addFromFavouritesMenu.removeAll();
        Enumeration menuItemName = LinorgFavourites.getSingleInstance().listFavouritesFor(this.leadSelectedTreeNode);
        while (menuItemName.hasMoreElements()) {
            String[] currentField = (String[])menuItemName.nextElement();
            JMenuItem addFavouriteMenuItem = new JMenuItem();
            addFavouriteMenuItem.setText(currentField[0]);
            addFavouriteMenuItem.setName(currentField[0]);
            addFavouriteMenuItem.setActionCommand(currentField[1]);
            addFavouriteMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        String imdiFavouriteUrlString = evt.getActionCommand();
                        ImdiTreeObject templateImdiObject = ImdiLoader.getSingleInstance().getImdiObject(null, ImdiTreeObject.conformStringToUrl(imdiFavouriteUrlString));
                        if (ContextMenu.this.leadSelectedTreeNode != null) {
                            new MetadataBuilder().requestAddNode(ContextMenu.this.leadSelectedTreeNode, ((JMenuItem)evt.getSource()).getText(), templateImdiObject);
                        }
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                }
            });
            this.addFromFavouritesMenu.add(addFavouriteMenuItem);
        }
    }

    public void showTreePopup(Object eventSource, int posX, int posY) {
        if (((Component)eventSource).isShowing()) {
            this.removeCachedCopyMenuItem.setVisible(false);
            this.removeLocalDirectoryMenuItem.setVisible(false);
            this.addLocalDirectoryMenuItem.setVisible(false);
            this.showHiddenFilesMenuItem.setVisible(false);
            this.removeRemoteCorpusMenuItem.setVisible(false);
            this.addRemoteCorpusMenuItem.setVisible(false);
            this.copyBranchMenuItem.setVisible(false);
            this.copyImdiUrlMenuItem.setVisible(false);
            this.pasteMenuItem1.setVisible(false);
            this.viewXmlMenuItem.setVisible(false);
            this.viewXmlMenuItemFormatted.setVisible(false);
            this.openXmlMenuItemFormatted.setVisible(false);
            this.exportHtmlMenuItemFormatted.setVisible(false);
            this.overrideTypeCheckerDecision.setVisible(false);
            this.viewInBrrowserMenuItem.setVisible(false);
            this.browseForResourceFileMenuItem.setVisible(false);
            this.searchSubnodesMenuItem.setVisible(false);
            this.reloadSubnodesMenuItem.setVisible(false);
            this.addDefaultLocationsMenuItem.setVisible(false);
            this.addMenu.setVisible(false);
            this.deleteMenuItem.setVisible(false);
            this.viewSelectedNodesMenuItem.setVisible(false);
            this.addFromFavouritesMenu.setVisible(false);
            this.saveMenuItem.setVisible(false);
            this.viewChangesMenuItem.setVisible(false);
            this.sendToServerMenuItem.setVisible(false);
            this.validateMenuItem.setVisible(false);
            this.historyMenu.setVisible(false);
            this.exportMenuItem.setVisible(false);
            this.importCsvMenuItem.setVisible(false);
            this.importBranchMenuItem.setVisible(false);
            this.reImportBranchMenuItem.setVisible(false);
            this.addToFavouritesMenuItem.setVisible(false);
            this.copySelectedRowsMenuItem.setVisible(false);
            this.pasteIntoSelectedRowsMenuItem.setVisible(false);
            this.viewSelectedRowsMenuItem.setVisible(false);
            this.matchingRowsMenuItem.setVisible(false);
            this.removeSelectedRowsMenuItem.setVisible(false);
            this.hideSelectedColumnsMenuItem.setVisible(false);
            this.deleteFieldMenuItem.setVisible(false);
            this.revertFieldMenuItem.setVisible(false);
            this.copyCellToColumnMenuItem.setVisible(false);
            this.matchingCellsMenuItem.setVisible(false);
            this.openInLongFieldEditorMenuItem.setVisible(false);
            this.clearCellColoursMenuItem.setVisible(false);
            this.searchReplaceMenuItem.setVisible(false);
            this.jumpToNodeInTreeMenuItem.setVisible(false);
            this.showChildNodesMenuItem.setVisible(false);
            this.currentTable = null;
            if (eventSource instanceof ImdiTable) {
                this.currentTable = (ImdiTable)eventSource;
                this.selectedTreeNodes = this.currentTable.getSelectedRowsFromTable();
                this.leadSelectedTreeNode = this.currentTable.getImdiNodeForSelection();
                this.setupTableMenuItems();
            } else if (eventSource instanceof JList) {
                JList currentJList = (JList)eventSource;
                Object[] selectedObjects = currentJList.getSelectedValues();
                this.selectedTreeNodes = new ImdiTreeObject[selectedObjects.length];
                for (int objectCounter = 0; objectCounter < selectedObjects.length; ++objectCounter) {
                    this.selectedTreeNodes[objectCounter] = (ImdiTreeObject)selectedObjects[objectCounter];
                }
                this.leadSelectedTreeNode = (ImdiTreeObject)currentJList.getSelectedValue();
                this.setUpImagePreviewMenu();
            } else if (eventSource instanceof ImdiTree) {
                this.selectedTreeNodes = ((ImdiTree)eventSource).getSelectedNodes();
                this.leadSelectedTreeNode = ((ImdiTree)eventSource).getLeadSelectionNode();
                this.setUpTreeMenuItems(eventSource);
            }
            this.setCommonMenuItems();
            if (eventSource instanceof Component) {
                this.treePopupMenu.setInvoker((Component)eventSource);
            }
            this.configureMenuSeparators();
            this.treePopupMenu.show((Component)eventSource, posX, posY);
            this.treePopupMenu.requestFocusInWindow();
        }
    }

    private void configureMenuSeparators() {
        boolean lastWasSeparator = true;
        Component lastVisibleComponent = null;
        for (Component currentComponent : this.treePopupMenu.getComponents()) {
            if (currentComponent instanceof JSeparator) {
                currentComponent.setVisible(!lastWasSeparator);
                lastWasSeparator = true;
            } else if (currentComponent.isVisible()) {
                lastWasSeparator = false;
            }
            if (!currentComponent.isVisible()) continue;
            lastVisibleComponent = currentComponent;
        }
        if (lastVisibleComponent != null && lastVisibleComponent instanceof JSeparator) {
            lastVisibleComponent.setVisible(false);
        }
    }

    private void setCommonMenuItems() {
        if (this.leadSelectedTreeNode != null) {
            if (this.leadSelectedTreeNode.hasResource()) {
                this.browseForResourceFileMenuItem.setVisible(true);
            }
            if (!this.leadSelectedTreeNode.isImdiChild() && this.leadSelectedTreeNode.isMetaDataNode()) {
                this.viewXmlMenuItem.setVisible(true);
                this.viewXmlMenuItemFormatted.setVisible(true);
                this.openXmlMenuItemFormatted.setVisible(true);
                this.exportHtmlMenuItemFormatted.setVisible(true);
            }
            this.viewInBrrowserMenuItem.setVisible(true);
            this.overrideTypeCheckerDecision.setVisible(!this.leadSelectedTreeNode.isMetaDataNode() && this.leadSelectedTreeNode.mpiMimeType == null);
        }
    }

    private void setUpTreeMenuItems(Object eventSource) {
        int nodeLevel = -1;
        int selectionCount = 0;
        boolean showRemoveLocationsTasks = false;
        boolean showAddLocationsTasks = false;
        selectionCount = ((JTree)eventSource).getSelectionCount();
        if (selectionCount > 0) {
            nodeLevel = ((JTree)eventSource).getSelectionPath().getPathCount();
        }
        showRemoveLocationsTasks = selectionCount == 1 && nodeLevel == 2 || selectionCount > 1;
        showAddLocationsTasks = selectionCount == 1 && nodeLevel == 1;
        this.viewSelectedNodesMenuItem.setText("View Selected");
        this.mergeWithFavouritesMenu.setEnabled(false);
        this.deleteMenuItem.setEnabled(true);
        if (eventSource == TreeHelper.getSingleInstance().arbilTreePanel.remoteCorpusTree) {
            this.removeRemoteCorpusMenuItem.setVisible(showRemoveLocationsTasks);
            this.addRemoteCorpusMenuItem.setVisible(showAddLocationsTasks);
            this.copyBranchMenuItem.setVisible(selectionCount > 0 && nodeLevel > 1);
            this.addDefaultLocationsMenuItem.setVisible(showAddLocationsTasks);
        }
        if (eventSource == TreeHelper.getSingleInstance().arbilTreePanel.localCorpusTree) {
            this.viewSelectedNodesMenuItem.setText("View/Edit Selected");
            this.pasteMenuItem1.setVisible(selectionCount > 0 && nodeLevel > 1);
            this.searchSubnodesMenuItem.setVisible(selectionCount > 0 && nodeLevel > 1);
            this.addMenu.setVisible(selectionCount == 1);
            this.deleteMenuItem.setVisible(nodeLevel > 1);
            boolean nodeIsImdiChild = false;
            if (this.leadSelectedTreeNode != null) {
                nodeIsImdiChild = this.leadSelectedTreeNode.isImdiChild();
                this.validateMenuItem.setVisible(!nodeIsImdiChild);
                this.historyMenu.setVisible(this.leadSelectedTreeNode.hasHistory());
                this.exportMenuItem.setVisible(!nodeIsImdiChild);
                this.importCsvMenuItem.setVisible(this.leadSelectedTreeNode.isCorpus());
                this.importBranchMenuItem.setVisible(this.leadSelectedTreeNode.isCorpus());
                this.reImportBranchMenuItem.setVisible(this.leadSelectedTreeNode.hasArchiveHandle && !this.leadSelectedTreeNode.isImdiChild());
                this.addFromFavouritesMenu.setVisible(true);
            }
        }
        if (eventSource == TreeHelper.getSingleInstance().arbilTreePanel.localDirectoryTree) {
            this.removeLocalDirectoryMenuItem.setVisible(showRemoveLocationsTasks);
            if (showAddLocationsTasks) {
                this.showHiddenFilesMenuItem.setState(TreeHelper.getSingleInstance().showHiddenFilesInTree);
                this.showHiddenFilesMenuItem.setVisible(true);
            }
            this.addLocalDirectoryMenuItem.setVisible(showAddLocationsTasks);
            if (this.leadSelectedTreeNode != null) {
                this.copyBranchMenuItem.setVisible(this.leadSelectedTreeNode.isCorpus() || this.leadSelectedTreeNode.isSession());
            }
        }
        if (this.leadSelectedTreeNode != null) {
            this.saveMenuItem.setVisible(this.leadSelectedTreeNode.getNeedsSaveToDisk());
            if (this.leadSelectedTreeNode.isFavorite()) {
                this.addToFavouritesMenuItem.setVisible(true);
                this.addToFavouritesMenuItem.setEnabled(true);
                this.addMenu.setVisible(this.selectedTreeNodes.length == 1);
                this.viewSelectedNodesMenuItem.setText("View/Edit Selected");
                this.addToFavouritesMenuItem.setText("Remove From Favourites List");
                this.addToFavouritesMenuItem.setActionCommand("false");
                this.deleteMenuItem.setEnabled(false);
            } else {
                this.addToFavouritesMenuItem.setVisible(this.leadSelectedTreeNode.isMetaDataNode());
                this.addToFavouritesMenuItem.setEnabled(!this.leadSelectedTreeNode.isCorpus() && this.leadSelectedTreeNode.isMetaDataNode());
                this.addToFavouritesMenuItem.setText("Add To Favourites List");
                this.addToFavouritesMenuItem.setActionCommand("true");
            }
        } else {
            this.addToFavouritesMenuItem.setVisible(false);
        }
        this.copyImdiUrlMenuItem.setVisible(selectionCount == 1 && nodeLevel > 1 || selectionCount > 1);
        this.viewSelectedNodesMenuItem.setVisible(selectionCount >= 1 && nodeLevel > 1);
        this.reloadSubnodesMenuItem.setVisible(selectionCount > 0 && nodeLevel > 1);
    }

    private void setupTableMenuItems() {
        if (this.currentTable != null) {
            if (this.currentTable.getSelectedRow() != -1) {
                ImdiField[] currentSelection;
                this.copySelectedRowsMenuItem.setVisible(true);
                this.pasteIntoSelectedRowsMenuItem.setVisible(true);
                if (this.currentTable.imdiTableModel.horizontalView) {
                    this.viewSelectedRowsMenuItem.setVisible(true);
                    this.matchingRowsMenuItem.setVisible(true);
                    this.removeSelectedRowsMenuItem.setVisible(true);
                    this.showChildNodesMenuItem.setVisible(true);
                }
                boolean canDeleteSelectedFields = true;
                for (ImdiField currentField : currentSelection = this.currentTable.getSelectedFields()) {
                    if (currentField.parentImdi.getNodeTemplate().pathIsDeleteableField(currentField.getGenericFullXmlPath())) continue;
                    canDeleteSelectedFields = false;
                    break;
                }
                if (canDeleteSelectedFields && currentSelection.length > 0) {
                    String menuText = "Delete " + currentSelection[0].getTranslateFieldName();
                    if (currentSelection.length > 1) {
                        menuText = menuText + " X " + currentSelection.length;
                    }
                    this.deleteFieldMenuItem.setText(menuText);
                    this.deleteFieldMenuItem.setVisible(true);
                }
                for (ImdiField currentField : currentSelection) {
                    if (!currentField.fieldNeedsSaveToDisk()) continue;
                    this.revertFieldMenuItem.setVisible(true);
                    break;
                }
            }
            if (this.currentTable.getSelectedRow() != -1 && this.currentTable.getSelectedColumn() != -1) {
                if (this.currentTable.imdiTableModel.horizontalView && this.currentTable.getSelectionModel().getSelectionMode() == 1) {
                    this.copyCellToColumnMenuItem.setVisible(true);
                    this.hideSelectedColumnsMenuItem.setVisible(true);
                }
                if (!this.currentTable.imdiTableModel.horizontalView || this.currentTable.getSelectionModel().getSelectionMode() == 1) {
                    this.openInLongFieldEditorMenuItem.setVisible(true);
                    this.matchingCellsMenuItem.setVisible(true);
                }
                this.jumpToNodeInTreeMenuItem.setVisible(true);
                this.clearCellColoursMenuItem.setVisible(true);
            }
            if (this.currentTable.getParent().getParent().getParent().getParent() instanceof LinorgSplitPanel) {
                this.searchReplaceMenuItem.setVisible(true);
            }
        }
    }

    private void setUpImagePreviewMenu() {
    }

    public static void main(String[] args) {
        new ContextMenu().treePopupMenu.setVisible(true);
    }
}

