/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiNodeSearchTerm;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.data.ImdiTreeObject;

public class ImdiNodeSearchPanel
extends JPanel {
    ImdiNodeSearchPanel thisPanel = this;
    JInternalFrame parentFrame;
    ImdiTableModel resultsTableModel;
    private Vector<ImdiTreeObject> selectedNodes;
    private Vector<ImdiTreeObject> searchNodes;
    private JButton addButton;
    public JPanel searchTermsPanel;
    private JPanel inputNodePanel;
    private JPanel jPanel2;
    private JButton searchButton;
    private JProgressBar searchProgressBar;
    private JButton stopButton;
    private boolean stopSearch = false;
    private boolean threadRunning = false;
    int totalNodesToSearch = -1;

    public ImdiNodeSearchPanel(JInternalFrame parentFrameLocal, ImdiTableModel resultsTableModelLocal, ImdiTreeObject[] localSelectedNodes) {
        this.parentFrame = parentFrameLocal;
        this.resultsTableModel = resultsTableModelLocal;
        this.selectedNodes = new Vector<ImdiTreeObject>(Arrays.asList(localSelectedNodes));
        this.searchTermsPanel = new JPanel();
        this.inputNodePanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.addButton = new JButton();
        this.stopButton = new JButton();
        this.searchProgressBar = new JProgressBar();
        this.searchButton = new JButton();
        this.setLayout(new BoxLayout(this, 3));
        this.inputNodePanel.setLayout(new GridLayout());
        this.add(this.inputNodePanel);
        Enumeration<ImdiTreeObject> selectedNodesEnum = this.selectedNodes.elements();
        while (selectedNodesEnum.hasMoreElements()) {
            ImdiTreeObject currentNode = selectedNodesEnum.nextElement();
            JLabel currentLabel = new JLabel(currentNode.toString(), currentNode.getIcon(), 0);
            this.inputNodePanel.add(currentLabel);
        }
        this.searchTermsPanel.setLayout(new BoxLayout(this.searchTermsPanel, 3));
        this.searchTermsPanel.add(new ImdiNodeSearchTerm(this));
        this.add(this.searchTermsPanel);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.addButton.setText("+");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    System.out.println("adding new term");
                    ImdiNodeSearchPanel.this.stopSearch();
                    ImdiNodeSearchPanel.this.searchTermsPanel.add(new ImdiNodeSearchTerm(ImdiNodeSearchPanel.this.thisPanel));
                    ImdiNodeSearchPanel.this.hideFirstBooleanOption();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.jPanel2.add(this.addButton);
        this.searchProgressBar.setString("");
        this.searchProgressBar.setStringPainted(true);
        this.jPanel2.add(this.searchProgressBar);
        this.stopButton.setText("stop");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ImdiNodeSearchPanel.this.stopSearch();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.stopButton.setEnabled(false);
        this.jPanel2.add(this.stopButton);
        this.searchButton.setText("search");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ImdiNodeSearchPanel.this.startSearch();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.jPanel2.add(this.searchButton);
        this.add(this.jPanel2);
        this.hideFirstBooleanOption();
    }

    private void hideFirstBooleanOption() {
        boolean firstTerm = true;
        for (Component currentTermComp : this.searchTermsPanel.getComponents()) {
            ((ImdiNodeSearchTerm)currentTermComp).setBooleanVisible(!firstTerm);
            firstTerm = false;
        }
        this.searchTermsPanel.revalidate();
    }

    public void stopSearch() {
        System.out.println("stop search");
        this.hideFirstBooleanOption();
        this.stopSearch = true;
    }

    public void startSearch() {
        System.out.println("start search");
        this.stopSearch = false;
        this.searchButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.searchNodes = new Vector<ImdiTreeObject>(this.selectedNodes);
        this.resultsTableModel.removeAllImdiRows();
        this.performSearch();
    }

    private void performSearch() {
        new Thread("performSearch"){

            public void run() {
                this.setPriority(4);
                ImdiNodeSearchPanel.this.threadRunning = true;
                Vector<ImdiTreeObject> foundNodes = new Vector<ImdiTreeObject>();
                try {
                    ImdiNodeSearchPanel.this.searchProgressBar.setIndeterminate(false);
                    ImdiNodeSearchPanel.this.searchProgressBar.setMinimum(0);
                    ImdiNodeSearchPanel.this.searchProgressBar.setMaximum(ImdiNodeSearchPanel.this.totalNodesToSearch);
                    ImdiNodeSearchPanel.this.searchProgressBar.setValue(0);
                    for (Component currentTermComp : ImdiNodeSearchPanel.this.searchTermsPanel.getComponents()) {
                        ((ImdiNodeSearchTerm)currentTermComp).populateSearchTerm();
                    }
                    int totalSearched = 0;
                    while (ImdiNodeSearchPanel.this.searchNodes.size() > 0 && !ImdiNodeSearchPanel.this.stopSearch) {
                        System.out.println("parentFrame: " + ImdiNodeSearchPanel.this.parentFrame.isVisible());
                        Object currentElement = ImdiNodeSearchPanel.this.searchNodes.remove(0);
                        if (currentElement instanceof ImdiTreeObject) {
                            ImdiTreeObject currentImdiNode = (ImdiTreeObject)currentElement;
                            if (currentImdiNode.isLoading()) {
                                System.out.println("searching: " + currentImdiNode.getUrlString());
                                System.out.println("still loading so putting back into the list: " + currentImdiNode);
                                if (!currentImdiNode.fileNotFound) {
                                    ImdiNodeSearchPanel.this.searchNodes.add(currentImdiNode);
                                }
                            } else {
                                System.out.println("searching: " + currentImdiNode);
                                for (ImdiTreeObject currentChildNode : currentImdiNode.getChildArray()) {
                                    System.out.println("adding to search list: " + currentChildNode);
                                    currentChildNode.registerContainer(this);
                                    ImdiNodeSearchPanel.this.searchNodes.add(currentChildNode);
                                }
                                boolean nodePassedFilter = true;
                                for (Component currentTermComponent : ImdiNodeSearchPanel.this.searchTermsPanel.getComponents()) {
                                    ImdiNodeSearchTerm currentTermPanel = (ImdiNodeSearchTerm)currentTermComponent;
                                    boolean termPassedFilter = true;
                                    if (currentTermPanel.nodeType.equals("Corpus")) {
                                        termPassedFilter = currentImdiNode.isCorpus();
                                    } else if (currentTermPanel.nodeType.equals("Session")) {
                                        termPassedFilter = currentImdiNode.isSession();
                                    } else if (currentTermPanel.nodeType.equals("Catalogue")) {
                                        termPassedFilter = currentImdiNode.isCatalogue();
                                    } else if (!currentTermPanel.nodeType.equals("All")) {
                                        termPassedFilter = currentImdiNode.getUrlString().matches(".*" + currentTermPanel.nodeType + "\\(\\d*?\\)$");
                                    }
                                    if (currentTermPanel.searchFieldName.length() > 0) {
                                        termPassedFilter = termPassedFilter && currentImdiNode.containsFieldValue(currentTermPanel.searchFieldName, currentTermPanel.searchString);
                                    } else if (currentTermPanel.searchString.length() > 0) {
                                        termPassedFilter = termPassedFilter && currentImdiNode.containsFieldValue(currentTermPanel.searchString);
                                    }
                                    boolean bl = termPassedFilter = currentTermPanel.notEqual != termPassedFilter;
                                    if (!currentTermPanel.booleanAnd && nodePassedFilter) break;
                                    nodePassedFilter = currentTermPanel.booleanAnd ? nodePassedFilter && termPassedFilter : nodePassedFilter || termPassedFilter;
                                }
                                ++totalSearched;
                                if (nodePassedFilter) {
                                    foundNodes.add(currentImdiNode);
                                    ImdiNodeSearchPanel.this.resultsTableModel.addSingleImdiObject(currentImdiNode);
                                } else {
                                    currentImdiNode.removeContainer(this);
                                }
                                if (ImdiNodeSearchPanel.this.totalNodesToSearch < totalSearched + ImdiNodeSearchPanel.this.searchNodes.size()) {
                                    ImdiNodeSearchPanel.this.totalNodesToSearch = totalSearched + ImdiNodeSearchPanel.this.searchNodes.size();
                                }
                                ImdiNodeSearchPanel.this.searchProgressBar.setMaximum(ImdiNodeSearchPanel.this.totalNodesToSearch);
                                ImdiNodeSearchPanel.this.searchProgressBar.setValue(totalSearched);
                                ImdiNodeSearchPanel.this.searchProgressBar.setString("searched: " + totalSearched + " found: " + foundNodes.size());
                            }
                        }
                        if (ImdiNodeSearchPanel.this.parentFrame.isVisible()) continue;
                        ImdiNodeSearchPanel.this.stopSearch = true;
                    }
                    if (ImdiNodeSearchPanel.this.stopSearch) {
                        ImdiNodeSearchPanel.this.searchProgressBar.setString("search canceled");
                    } else {
                        ImdiNodeSearchPanel.this.totalNodesToSearch = totalSearched;
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
                ImdiNodeSearchPanel.this.searchProgressBar.setIndeterminate(false);
                ImdiNodeSearchPanel.this.searchProgressBar.setValue(0);
                ImdiNodeSearchPanel.this.searchProgressBar.setMaximum(1000);
                ImdiNodeSearchPanel.this.searchButton.setEnabled(true);
                ImdiNodeSearchPanel.this.stopButton.setEnabled(false);
                ImdiNodeSearchPanel.this.threadRunning = false;
                ImdiNodeSearchPanel.this.resultsTableModel.addImdiObjects(foundNodes.elements());
                foundNodes.removeAllElements();
            }
        }.start();
    }
}

