/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import nl.mpi.arbil.data.ImdiTreeObject;

public class ImdiTreeRenderer
implements TreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel returnComponent;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getUserObject() instanceof ImdiTreeObject) {
            ImdiTreeObject imdiTreeObject = (ImdiTreeObject)node.getUserObject();
            returnComponent = new JLabel(imdiTreeObject.toString(), imdiTreeObject.getIcon(), 2);
            if (imdiTreeObject.hasSchemaError) {
                returnComponent.setForeground(Color.RED);
            }
            if (imdiTreeObject.getNeedsSaveToDisk()) {
                returnComponent.setForeground(Color.BLUE);
            }
        } else if (node.getUserObject() instanceof JLabel) {
            returnComponent = new JLabel(((JLabel)node.getUserObject()).getText(), ((JLabel)node.getUserObject()).getIcon(), 2);
        } else {
            return new JLabel();
        }
        if (selected) {
            returnComponent.setOpaque(true);
            returnComponent.setBackground(tree.getBackground().darker());
        }
        return returnComponent;
    }
}

