/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import nl.mpi.arbil.DocumentationLanguages;
import nl.mpi.arbil.ImdiVocabularies;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.templates.TemplateDialogue;

public class LanguageListDialogue
extends TemplateDialogue {
    ArrayList<JCheckBox> checkBoxArray;

    public LanguageListDialogue(JDialog parentFrameLocal) {
        super(parentFrameLocal);
    }

    public static void showLanguageDialogue() {
        JDialog dialog = new JDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "Available Languages", true);
        LanguageListDialogue templateDialogue = new LanguageListDialogue(dialog);
        templateDialogue.populateLists();
        dialog.setContentPane(templateDialogue);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (((JCheckBox)e.getSource()).isSelected()) {
            new DocumentationLanguages().addselectedLanguages(e.getActionCommand());
        } else {
            new DocumentationLanguages().removeselectedLanguages(e.getActionCommand());
        }
    }

    protected void populateLists() {
        this.clarinProfilesPanel.getParent().remove(this.clarinProfilesPanel);
        this.internalTemplatesPanel.setBorder(BorderFactory.createTitledBorder("Languages to display in the feild language select box"));
        ArrayList<String> selectedLanguages = new DocumentationLanguages().getSelectedLanguagesArrayList();
        this.checkBoxArray = new ArrayList();
        for (ImdiVocabularies.VocabularyItem currentTemplate : new DocumentationLanguages().getallLanguages()) {
            JCheckBox languageCheckBox = new JCheckBox();
            languageCheckBox.setText(currentTemplate.languageName);
            languageCheckBox.setName(currentTemplate.languageName);
            languageCheckBox.setActionCommand(currentTemplate.languageName);
            languageCheckBox.setSelected(selectedLanguages.contains(currentTemplate.languageName));
            languageCheckBox.setToolTipText(currentTemplate.languageName);
            languageCheckBox.addActionListener(this);
            this.checkBoxArray.add(languageCheckBox);
        }
        this.addSorted(this.templatesPanel, this.checkBoxArray);
        JButton selectAllButton = new JButton();
        selectAllButton.setText("Select All");
        selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (JCheckBox currentCheckBox : LanguageListDialogue.this.checkBoxArray) {
                    currentCheckBox.setSelected(true);
                    new DocumentationLanguages().addselectedLanguages(currentCheckBox.getActionCommand());
                }
            }
        });
        JButton selectNoneButton = new JButton();
        selectNoneButton.setText("Clear Selection");
        selectNoneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (JCheckBox currentCheckBox : LanguageListDialogue.this.checkBoxArray) {
                    currentCheckBox.setSelected(false);
                    new DocumentationLanguages().removeselectedLanguages(currentCheckBox.getActionCommand());
                }
            }
        });
        this.internalTemplatesButtonPanel.removeAll();
        this.internalTemplatesButtonPanel.add(selectNoneButton);
        this.internalTemplatesButtonPanel.add(selectAllButton);
    }
}

