/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import nl.mpi.arbil.ArbilDragDrop;
import nl.mpi.arbil.ArbilMenuBar;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiNodeSearchPanel;
import nl.mpi.arbil.ImdiTable;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.LinorgHelp;
import nl.mpi.arbil.LinorgHyperlinkListener;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgSplitPanel;
import nl.mpi.arbil.LinorgVersion;
import nl.mpi.arbil.TreeHelper;
import nl.mpi.arbil.data.ImdiLoader;
import nl.mpi.arbil.data.ImdiTreeObject;

public class LinorgWindowManager {
    Hashtable<String, Component[]> windowList = new Hashtable();
    Hashtable windowStatesHashtable;
    public JDesktopPane desktopPane;
    public JFrame linorgFrame;
    int nextWindowX = 50;
    int nextWindowY = 50;
    int nextWindowWidth = 800;
    int nextWindowHeight = 600;
    private Hashtable<String, String> messageDialogQueue = new Hashtable();
    private boolean messagesCanBeShown = false;
    boolean showMessageThreadrunning = false;
    private static LinorgWindowManager singleInstance = null;

    public static synchronized LinorgWindowManager getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new LinorgWindowManager();
        }
        return singleInstance;
    }

    private LinorgWindowManager() {
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setBackground(new Color(204, 204, 204));
        ArbilDragDrop.getSingleInstance().addTransferHandler(this.desktopPane);
    }

    public void loadGuiState(JFrame linorgFrameLocal) {
        this.linorgFrame = linorgFrameLocal;
        try {
            int screenDeviceCount;
            this.windowStatesHashtable = (Hashtable)LinorgSessionStorage.getSingleInstance().loadObject("windowStates");
            this.linorgFrame.setExtendedState((Integer)this.windowStatesHashtable.get("linorgFrameExtendedState"));
            if (this.linorgFrame.getExtendedState() == 1) {
                this.linorgFrame.setExtendedState(0);
            }
            Object linorgFrameBounds = this.windowStatesHashtable.get("linorgFrameBounds");
            this.linorgFrame.setBounds((Rectangle)linorgFrameBounds);
            if (this.windowStatesHashtable.containsKey("ScreenDeviceCount") && (screenDeviceCount = ((Integer)this.windowStatesHashtable.get("ScreenDeviceCount")).intValue()) > GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length) {
                this.linorgFrame.setLocationRelativeTo(null);
                Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
                if (this.linorgFrame.getBounds().intersects(new Rectangle(screenDimension))) {
                    this.linorgFrame.setBounds(this.linorgFrame.getBounds().intersection(new Rectangle(screenDimension)));
                } else {
                    this.linorgFrame.setBounds(0, 0, 800, 600);
                    this.linorgFrame.setLocationRelativeTo(null);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("load windowStates failed: " + ex.getMessage());
            System.out.println("setting default windowStates");
            this.windowStatesHashtable = new Hashtable();
            this.linorgFrame.setBounds(0, 0, 800, 600);
            this.linorgFrame.setLocationRelativeTo(null);
            this.linorgFrame.setExtendedState(6);
        }
        this.loadSplitPlanes(this.linorgFrame.getContentPane().getComponent(0));
    }

    public void openAboutPage() {
        LinorgVersion linorgVersion = new LinorgVersion();
        String messageString = "Archive Builder\nA local tool for organising linguistic data.\nMax Planck Institute for Psycholinguistics\nApplication design and programming by Peter Withers\nArbil also uses components of the IMDI API and Lamus Type Checker\nVersion: " + linorgVersion.currentMajor + "." + linorgVersion.currentMinor + "." + linorgVersion.currentRevision + "\n" + linorgVersion.lastCommitDate + "\n" + "Compile Date: " + linorgVersion.compileDate + "\n";
        JOptionPane.showMessageDialog(this.linorgFrame, messageString, "About Arbil", -1);
    }

    public void offerUserToSaveChanges() throws Exception {
        if (ImdiLoader.getSingleInstance().nodesNeedSave()) {
            if (0 == JOptionPane.showConfirmDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "There are unsaved changes.\nSave now?", "Save Changes", 2, -1)) {
                ImdiLoader.getSingleInstance().saveNodesNeedingSave(true);
            } else {
                throw new Exception("user canceled save action");
            }
        }
    }

    public File showEmptyExportDirectoryDialogue(String titleText) {
        boolean fileSelectDone = false;
        try {
            while (!fileSelectDone) {
                File[] selectedFiles = LinorgWindowManager.getSingleInstance().showFileSelectBox(titleText + " Destination Directory", true, false, false);
                if (selectedFiles != null && selectedFiles.length > 0) {
                    File destinationDirectory = selectedFiles[0];
                    if (!destinationDirectory.exists()) {
                        destinationDirectory.mkdirs();
                    }
                    if (!destinationDirectory.exists()) {
                        JOptionPane.showMessageDialog(this.linorgFrame, "The export directory\n\"" + destinationDirectory + "\"\ndoes not exist.\nPlease select or create a directory.", titleText, -1);
                        continue;
                    }
                    if (destinationDirectory == null || !destinationDirectory.exists()) continue;
                    if (destinationDirectory.list().length == 0) {
                        fileSelectDone = true;
                        return destinationDirectory;
                    }
                    if (!this.showMessageDialogBox("The selected export directory is not empty.\nTo continue will merge and may overwrite files.\nDo you want to continue?", titleText)) continue;
                    return destinationDirectory;
                }
                fileSelectDone = true;
            }
        }
        catch (Exception e) {
            System.out.println("aborting export: " + e.getMessage());
        }
        return null;
    }

    public File[] showFileSelectBox(String titleText, boolean directorySelectOnly, boolean multipleSelect, boolean requireMetadataFiles) {
        Object returnFile;
        File lastUsedWorkingDirectory;
        File workingDirectory = null;
        String workingDirectoryPathString = LinorgSessionStorage.getSingleInstance().loadString("fileSelect." + titleText);
        workingDirectory = workingDirectoryPathString == null ? new File(System.getProperty("user.home")) : new File(workingDirectoryPathString);
        boolean isMac = true;
        boolean useAtwSelect = false;
        if (useAtwSelect) {
            if (directorySelectOnly) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
            } else {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
            FileDialog fileDialog = new FileDialog(this.linorgFrame);
            if (requireMetadataFiles) {
                fileDialog.setFilenameFilter(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".imdi");
                    }
                });
            }
            fileDialog.setDirectory(workingDirectory.getAbsolutePath());
            fileDialog.setVisible(true);
            String selectedFile = fileDialog.getFile();
            lastUsedWorkingDirectory = new File(fileDialog.getDirectory());
            returnFile = selectedFile != null ? new File[]{new File(selectedFile)} : null;
        } else {
            FileFilter imdiFileFilter;
            JFileChooser fileChooser = new JFileChooser();
            if (requireMetadataFiles) {
                imdiFileFilter = new FileFilter(){

                    public String getDescription() {
                        return "IMDI";
                    }

                    public boolean accept(File selectedFile) {
                        return selectedFile.exists() && (selectedFile.isDirectory() || selectedFile.getName().toLowerCase().endsWith(".imdi"));
                    }
                };
                fileChooser.addChoosableFileFilter(imdiFileFilter);
            }
            if (directorySelectOnly) {
                imdiFileFilter = new FileFilter(){

                    public String getDescription() {
                        return "Directories";
                    }

                    public boolean accept(File selectedFile) {
                        return selectedFile.exists() && selectedFile.isDirectory();
                    }
                };
                fileChooser.addChoosableFileFilter(imdiFileFilter);
            }
            if (directorySelectOnly) {
                fileChooser.setFileSelectionMode(1);
            } else {
                fileChooser.setFileSelectionMode(0);
            }
            fileChooser.setCurrentDirectory(workingDirectory);
            fileChooser.setMultiSelectionEnabled(multipleSelect);
            if (0 == fileChooser.showDialog(LinorgWindowManager.getSingleInstance().linorgFrame, titleText)) {
                returnFile = fileChooser.getSelectedFiles();
                if (((File[])returnFile).length == 0) {
                    returnFile = new File[]{fileChooser.getSelectedFile()};
                }
            } else {
                returnFile = null;
            }
            if (returnFile != null && ((File[])returnFile).length == 1 && !returnFile[0].exists()) {
                returnFile[0] = returnFile[0].getParentFile();
                if (!returnFile[0].exists()) {
                    returnFile = null;
                }
            }
            lastUsedWorkingDirectory = fileChooser.getCurrentDirectory();
        }
        LinorgSessionStorage.getSingleInstance().saveString("fileSelect." + titleText, lastUsedWorkingDirectory.getAbsolutePath());
        return returnFile;
    }

    public boolean showMessageDialogBox(String messageString, String messageTitle) {
        if (messageTitle == null) {
            messageTitle = "Arbil";
        }
        return 0 == JOptionPane.showConfirmDialog(LinorgWindowManager.getSingleInstance().linorgFrame, messageString, messageTitle, 2, -1);
    }

    public void addMessageDialogToQueue(String messageString, String messageTitle) {
        String currentMessage;
        if (messageTitle == null) {
            messageTitle = "Arbil";
        }
        if ((currentMessage = this.messageDialogQueue.get(messageTitle)) != null) {
            messageString = messageString + "\n-------------------------------\n" + currentMessage;
        }
        this.messageDialogQueue.put(messageTitle, messageString);
        this.showMessageDialogQueue();
    }

    private synchronized void showMessageDialogQueue() {
        if (!this.showMessageThreadrunning) {
            new Thread("showMessageThread"){

                public void run() {
                    try {
                        4.sleep(100L);
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                    LinorgWindowManager.this.showMessageThreadrunning = true;
                    if (LinorgWindowManager.this.messagesCanBeShown) {
                        while (LinorgWindowManager.this.messageDialogQueue.size() > 0) {
                            String messageTitle = (String)LinorgWindowManager.this.messageDialogQueue.keys().nextElement();
                            String messageText = (String)LinorgWindowManager.this.messageDialogQueue.remove(messageTitle);
                            if (messageText == null) continue;
                            JOptionPane.showMessageDialog(LinorgWindowManager.getSingleInstance().linorgFrame, messageText, messageTitle, -1);
                        }
                    }
                    LinorgWindowManager.this.showMessageThreadrunning = false;
                }
            }.start();
        }
    }

    public void openIntroductionPage() {
        try {
            Hashtable windowListHashtable = (Hashtable)LinorgSessionStorage.getSingleInstance().loadObject("openWindows");
            Enumeration windowNamesEnum = windowListHashtable.keys();
            while (windowNamesEnum.hasMoreElements()) {
                String currentWindowName = windowNamesEnum.nextElement().toString();
                System.out.println("currentWindowName: " + currentWindowName);
                Vector imdiURLs = (Vector)windowListHashtable.get(currentWindowName);
                ImdiTreeObject[] imdiObjectsArray = new ImdiTreeObject[imdiURLs.size()];
                for (int arrayCounter = 0; arrayCounter < imdiObjectsArray.length; ++arrayCounter) {
                    try {
                        imdiObjectsArray[arrayCounter] = ImdiLoader.getSingleInstance().getImdiObject(null, new URI(imdiURLs.elementAt(arrayCounter).toString()));
                        continue;
                    }
                    catch (URISyntaxException ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                }
                this.openFloatingTable(imdiObjectsArray, currentWindowName);
            }
            System.out.println("done loading windowStates");
        }
        catch (Exception ex) {
            this.windowStatesHashtable = new Hashtable();
            System.out.println("load windowStates failed: " + ex.getMessage());
        }
        if (!TreeHelper.getSingleInstance().locationsHaveBeenAdded()) {
            System.out.println("no local locations found, showing help window");
            LinorgHelp helpComponent = LinorgHelp.getSingleInstance();
            if (null == this.focusWindow(LinorgHelp.helpWindowTitle)) {
                this.createWindow(LinorgHelp.helpWindowTitle, helpComponent);
            }
            helpComponent.setCurrentPage(LinorgHelp.IntroductionPage);
        }
        this.startKeyListener();
        this.messagesCanBeShown = true;
        this.showMessageDialogQueue();
    }

    public void loadSplitPlanes(Component targetComponent) {
        if (targetComponent instanceof JSplitPane) {
            System.out.println("loadSplitPlanes: " + targetComponent.getName());
            Object linorgSplitPosition = this.windowStatesHashtable.get(targetComponent.getName());
            if (linorgSplitPosition instanceof Integer) {
                System.out.println(targetComponent.getName() + ": " + linorgSplitPosition);
                ((JSplitPane)targetComponent).setDividerLocation((Integer)linorgSplitPosition);
            } else if (targetComponent.getName().equals("rightSplitPane")) {
                ((JSplitPane)targetComponent).setDividerLocation(150);
            } else {
                ((JSplitPane)targetComponent).setDividerLocation(200);
            }
            for (Component childComponent : ((JSplitPane)targetComponent).getComponents()) {
                this.loadSplitPlanes(childComponent);
            }
        }
        if (targetComponent instanceof JPanel) {
            for (Component childComponent : ((JPanel)targetComponent).getComponents()) {
                this.loadSplitPlanes(childComponent);
            }
        }
    }

    public void saveSplitPlanes(Component targetComponent) {
        if (targetComponent instanceof JSplitPane) {
            System.out.println("saveSplitPlanes: " + targetComponent.getName());
            this.windowStatesHashtable.put(targetComponent.getName(), ((JSplitPane)targetComponent).getDividerLocation());
            for (Component childComponent : ((JSplitPane)targetComponent).getComponents()) {
                this.saveSplitPlanes(childComponent);
            }
        }
        if (targetComponent instanceof JPanel) {
            for (Component childComponent : ((JPanel)targetComponent).getComponents()) {
                this.saveSplitPlanes(childComponent);
            }
        }
    }

    public void saveWindowStates() {
        try {
            if (this.linorgFrame.getExtendedState() != 6) {
                this.windowStatesHashtable.put("linorgFrameBounds", this.linorgFrame.getBounds());
            }
            this.windowStatesHashtable.put("ScreenDeviceCount", GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length);
            this.windowStatesHashtable.put("linorgFrameExtendedState", this.linorgFrame.getExtendedState());
            this.saveSplitPlanes(this.linorgFrame.getContentPane().getComponent(0));
            LinorgSessionStorage.getSingleInstance().saveObject(this.windowStatesHashtable, "windowStates");
            Hashtable windowListHashtable = new Hashtable();
            Enumeration<String> windowNamesEnum = this.windowList.keys();
            while (windowNamesEnum.hasMoreElements()) {
                String currentWindowName = windowNamesEnum.nextElement().toString();
                System.out.println("currentWindowName: " + currentWindowName);
                Component windowObject = this.windowList.get(currentWindowName)[0];
                try {
                    Component currentComponent;
                    if (windowObject == null || (currentComponent = ((JInternalFrame)windowObject).getContentPane().getComponent(0)) == null || !(currentComponent instanceof LinorgSplitPanel) || 0 >= ((LinorgSplitPanel)currentComponent).imdiTable.getRowCount()) continue;
                    Vector<String> currentNodesVector = new Vector<String>();
                    for (String currentUrlString : ((ImdiTableModel)((LinorgSplitPanel)currentComponent).imdiTable.getModel()).getImdiNodesURLs()) {
                        currentNodesVector.add(currentUrlString);
                    }
                    windowListHashtable.put(currentWindowName, currentNodesVector);
                    System.out.println("saved");
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
            LinorgSessionStorage.getSingleInstance().saveObject(windowListHashtable, "openWindows");
            System.out.println("saved windowStates");
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    private String addWindowToList(String windowName, JInternalFrame windowFrame) {
        int instanceCount = 0;
        String currentWindowName = windowName;
        while (this.windowList.containsKey(currentWindowName)) {
            currentWindowName = windowName + "(" + ++instanceCount + ")";
        }
        JMenuItem windowMenuItem = new JMenuItem();
        windowMenuItem.setText(currentWindowName);
        windowMenuItem.setName(currentWindowName);
        windowFrame.setName(currentWindowName);
        windowMenuItem.setActionCommand(currentWindowName);
        windowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    LinorgWindowManager.this.focusWindow(evt.getActionCommand());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        windowFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent e) {
                String windowName = e.getInternalFrame().getName();
                Component[] windowAndMenu = LinorgWindowManager.this.windowList.get(windowName);
                if (ArbilMenuBar.windowMenu != null) {
                    ArbilMenuBar.windowMenu.remove(windowAndMenu[1]);
                }
                LinorgWindowManager.this.windowList.remove(windowName);
                super.internalFrameClosed(e);
            }
        });
        this.windowList.put(currentWindowName, new Component[]{windowFrame, windowMenuItem});
        if (ArbilMenuBar.windowMenu != null) {
            ArbilMenuBar.windowMenu.add(windowMenuItem);
        }
        return currentWindowName;
    }

    public void closeAllWindows() {
        for (JInternalFrame focusedWindow : this.desktopPane.getAllFrames()) {
            if (focusedWindow == null) continue;
            String windowName = focusedWindow.getName();
            Component[] windowAndMenu = this.windowList.get(windowName);
            if (windowAndMenu != null && ArbilMenuBar.windowMenu != null) {
                ArbilMenuBar.windowMenu.remove(windowAndMenu[1]);
            }
            this.windowList.remove(windowName);
            this.desktopPane.remove(focusedWindow);
        }
        this.desktopPane.repaint();
    }

    public JInternalFrame focusWindow(String windowName) {
        if (this.windowList.containsKey(windowName)) {
            Component windowObject = this.windowList.get(windowName)[0];
            try {
                if (windowObject != null) {
                    ((JInternalFrame)windowObject).setIcon(false);
                    ((JInternalFrame)windowObject).setSelected(true);
                    return (JInternalFrame)windowObject;
                }
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        }
        return null;
    }

    private void startKeyListener() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent e) {
                boolean isKeybordRepeat = false;
                if (e instanceof KeyEvent && e.getID() == 402) {
                    KeyEvent nextPress = (KeyEvent)Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent(401);
                    if (nextPress != null && nextPress.getWhen() == ((KeyEvent)e).getWhen() && nextPress.getKeyCode() == ((KeyEvent)e).getKeyCode()) {
                        isKeybordRepeat = true;
                    }
                    if (!isKeybordRepeat) {
                        if ((((KeyEvent)e).isMetaDown() || ((KeyEvent)e).isControlDown()) && ((KeyEvent)e).getKeyCode() == 87) {
                            JInternalFrame[] windowsToClose = ((KeyEvent)e).isShiftDown() ? LinorgWindowManager.this.desktopPane.getAllFrames() : new JInternalFrame[]{LinorgWindowManager.this.desktopPane.getSelectedFrame()};
                            for (JInternalFrame focusedWindow : windowsToClose) {
                                if (focusedWindow == null) continue;
                                String windowName = focusedWindow.getName();
                                Component[] windowAndMenu = LinorgWindowManager.this.windowList.get(windowName);
                                if (windowAndMenu != null && ArbilMenuBar.windowMenu != null) {
                                    ArbilMenuBar.windowMenu.remove(windowAndMenu[1]);
                                }
                                LinorgWindowManager.this.windowList.remove(windowName);
                                LinorgWindowManager.this.desktopPane.remove(focusedWindow);
                                try {
                                    JInternalFrame topMostWindow;
                                    JInternalFrame[] allWindows = LinorgWindowManager.this.desktopPane.getAllFrames();
                                    if (allWindows.length <= 0 || (topMostWindow = allWindows[0]) == null) continue;
                                    System.out.println("topMostWindow: " + topMostWindow);
                                    topMostWindow.setIcon(false);
                                    topMostWindow.setSelected(true);
                                }
                                catch (Exception ex) {
                                    GuiHelper.linorgBugCatcher.logError(ex);
                                }
                            }
                            LinorgWindowManager.this.desktopPane.repaint();
                        }
                        if (((KeyEvent)e).getKeyCode() == 9 && ((KeyEvent)e).isControlDown()) {
                            try {
                                int targetLayerInt;
                                JInternalFrame[] allWindows = LinorgWindowManager.this.desktopPane.getAllFrames();
                                if (((KeyEvent)e).isShiftDown()) {
                                    allWindows[0].moveToBack();
                                    targetLayerInt = 1;
                                } else {
                                    targetLayerInt = allWindows.length - 1;
                                }
                                allWindows[targetLayerInt].setIcon(false);
                                allWindows[targetLayerInt].setSelected(true);
                            }
                            catch (Exception ex) {
                                GuiHelper.linorgBugCatcher.logError(ex);
                            }
                        }
                        if ((((KeyEvent)e).isMetaDown() || ((KeyEvent)e).isControlDown()) && ((KeyEvent)e).getKeyCode() == 70) {
                            JInternalFrame windowToSearch = LinorgWindowManager.this.desktopPane.getSelectedFrame();
                            for (Component childComponent : windowToSearch.getContentPane().getComponents()) {
                                if (!(childComponent instanceof LinorgSplitPanel)) continue;
                                ((LinorgSplitPanel)childComponent).showSearchPane();
                            }
                        }
                    }
                }
            }
        }, 8L);
    }

    public JInternalFrame createWindow(String windowTitle, Component contentsComponent) {
        JInternalFrame currentInternalFrame = new JInternalFrame();
        currentInternalFrame.setLayout(new BorderLayout());
        currentInternalFrame.add(contentsComponent, "Center");
        windowTitle = this.addWindowToList(windowTitle, currentInternalFrame);
        int tempWindowWidth = this.desktopPane.getWidth() > this.nextWindowWidth ? this.nextWindowWidth : this.desktopPane.getWidth() - 50;
        int tempWindowHeight = this.desktopPane.getHeight() > this.nextWindowHeight ? this.nextWindowHeight : this.desktopPane.getHeight() - 50;
        if (tempWindowHeight < 100) {
            tempWindowHeight = 100;
        }
        currentInternalFrame.setSize(tempWindowWidth, tempWindowHeight);
        currentInternalFrame.setClosable(true);
        currentInternalFrame.setIconifiable(true);
        currentInternalFrame.setMaximizable(true);
        currentInternalFrame.setResizable(true);
        currentInternalFrame.setTitle(windowTitle);
        currentInternalFrame.setToolTipText(windowTitle);
        currentInternalFrame.setName(windowTitle);
        currentInternalFrame.setVisible(true);
        currentInternalFrame.setLocation(this.nextWindowX, this.nextWindowY);
        this.nextWindowX += 10;
        this.nextWindowY += 10;
        if (this.nextWindowX + tempWindowWidth > this.desktopPane.getWidth()) {
            this.nextWindowX = 0;
        }
        if (this.nextWindowY + tempWindowHeight > this.desktopPane.getHeight()) {
            this.nextWindowY = 0;
        }
        this.desktopPane.add((Component)currentInternalFrame, 0);
        try {
            currentInternalFrame.setSelected(true);
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
        return currentInternalFrame;
    }

    public JEditorPane openUrlWindowOnce(String frameTitle, URL locationUrl) {
        JEditorPane htmlDisplay = new JEditorPane();
        htmlDisplay.setEditable(false);
        htmlDisplay.setContentType("text/html");
        try {
            htmlDisplay.setPage(locationUrl);
            htmlDisplay.addHyperlinkListener(new LinorgHyperlinkListener());
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
        JInternalFrame existingWindow = this.focusWindow(frameTitle);
        if (existingWindow == null) {
            JScrollPane jScrollPane6 = new JScrollPane();
            jScrollPane6.setViewportView(htmlDisplay);
            this.createWindow(frameTitle, jScrollPane6);
        } else {
            ((JScrollPane)existingWindow.getContentPane().getComponent(0)).setViewportView(htmlDisplay);
        }
        return htmlDisplay;
    }

    public void openSearchTable(ImdiTreeObject[] selectedNodes, String frameTitle) {
        ImdiTableModel resultsTableModel = new ImdiTableModel();
        ImdiTable imdiTable = new ImdiTable(resultsTableModel, frameTitle);
        LinorgSplitPanel imdiSplitPanel = new LinorgSplitPanel(imdiTable);
        JInternalFrame searchFrame = this.createWindow(frameTitle, imdiSplitPanel);
        searchFrame.add((Component)new ImdiNodeSearchPanel(searchFrame, resultsTableModel, selectedNodes), "North");
        imdiSplitPanel.setSplitDisplay();
        imdiSplitPanel.addFocusListener(searchFrame);
    }

    public ImdiTableModel openFloatingTableOnce(URI[] rowNodesArray, String frameTitle) {
        ImdiTreeObject[] tableNodes = new ImdiTreeObject[rowNodesArray.length];
        ArrayList<String> fieldPathsToHighlight = new ArrayList<String>();
        for (int arrayCounter = 0; arrayCounter < rowNodesArray.length; ++arrayCounter) {
            try {
                if (rowNodesArray[arrayCounter] == null) continue;
                ImdiTreeObject parentNode = ImdiLoader.getSingleInstance().getImdiObject(null, new URI(rowNodesArray[arrayCounter].toString().split("#")[0]));
                String fieldPath = rowNodesArray[arrayCounter].getFragment();
                String parentNodeFragment = parentNode.nodeTemplate.getParentOfField(fieldPath);
                URI targetNode = parentNodeFragment.length() > 0 ? new URI(rowNodesArray[arrayCounter].toString().split("#")[0] + "#" + parentNodeFragment) : new URI(rowNodesArray[arrayCounter].toString().split("#")[0]);
                tableNodes[arrayCounter] = ImdiLoader.getSingleInstance().getImdiObject(null, targetNode);
                fieldPathsToHighlight.add(fieldPath);
                continue;
            }
            catch (URISyntaxException ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        }
        ImdiTableModel targetTableModel = this.openFloatingTableOnce(tableNodes, frameTitle);
        targetTableModel.highlightMatchingFieldPaths(fieldPathsToHighlight.toArray(new String[0]));
        return targetTableModel;
    }

    public ImdiTableModel openAllChildNodesInFloatingTableOnce(URI[] rowNodesArray, String frameTitle) {
        HashSet<ImdiTreeObject> tableNodes = new HashSet<ImdiTreeObject>();
        for (int arrayCounter = 0; arrayCounter < rowNodesArray.length; ++arrayCounter) {
            ImdiTreeObject currentNode = ImdiLoader.getSingleInstance().getImdiObject(null, rowNodesArray[arrayCounter]);
            tableNodes.add(currentNode);
            for (ImdiTreeObject currentChildNode : currentNode.getAllChildren()) {
                tableNodes.add(currentChildNode);
            }
        }
        return this.openFloatingTableOnce(tableNodes.toArray(new ImdiTreeObject[0]), frameTitle);
    }

    public ImdiTableModel openFloatingTableOnce(ImdiTreeObject[] rowNodesArray, String frameTitle) {
        if (rowNodesArray.length == 1 && rowNodesArray[0] != null && rowNodesArray[0].isInfoLink) {
            try {
                if (rowNodesArray[0].getUrlString().toLowerCase().endsWith(".html") || rowNodesArray[0].getUrlString().toLowerCase().endsWith(".txt")) {
                    this.openUrlWindowOnce(rowNodesArray[0].toString(), rowNodesArray[0].getURI().toURL());
                    return null;
                }
            }
            catch (MalformedURLException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
            }
        }
        for (Component[] currentWindow : (Component[][])this.windowList.values().toArray((T[])new Component[0][])) {
            for (Component childComponent : ((JInternalFrame)currentWindow[0]).getContentPane().getComponents()) {
                ImdiTableModel currentTableModel;
                if (!(childComponent instanceof LinorgSplitPanel) || (currentTableModel = (ImdiTableModel)((LinorgSplitPanel)childComponent).imdiTable.getModel()).getImdiNodeCount() != rowNodesArray.length) continue;
                boolean tableMatches = true;
                for (ImdiTreeObject currentItem : rowNodesArray) {
                    if (currentTableModel.containsImdiNode(currentItem)) continue;
                    tableMatches = false;
                    break;
                }
                if (!tableMatches) continue;
                try {
                    ((JInternalFrame)currentWindow[0]).setIcon(false);
                    ((JInternalFrame)currentWindow[0]).setSelected(true);
                    return currentTableModel;
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        }
        return this.openFloatingTable(rowNodesArray, frameTitle);
    }

    public ImdiTableModel openFloatingTable(ImdiTreeObject[] rowNodesArray, String frameTitle) {
        if (frameTitle == null) {
            frameTitle = rowNodesArray.length == 1 ? rowNodesArray[0].toString() : "Selection";
        }
        ImdiTableModel imdiTableModel = new ImdiTableModel();
        ImdiTable imdiTable = new ImdiTable(imdiTableModel, frameTitle);
        LinorgSplitPanel imdiSplitPanel = new LinorgSplitPanel(imdiTable);
        imdiTableModel.addImdiObjects(rowNodesArray);
        imdiSplitPanel.setSplitDisplay();
        JInternalFrame tableFrame = this.createWindow(frameTitle, imdiSplitPanel);
        imdiSplitPanel.addFocusListener(tableFrame);
        return imdiTableModel;
    }
}

