/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.MetadataFile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.ImdiVocabularies;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgVersion;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.clarin.CmdiComponentBuilder;
import nl.mpi.arbil.clarin.CmdiComponentLinkReader;
import nl.mpi.arbil.clarin.CmdiProfileReader;
import nl.mpi.arbil.data.ImdiLoader;
import nl.mpi.arbil.data.ImdiTreeObject;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataReader {
    private static MetadataReader singleInstance = null;
    public static String imdiPathSeparator = ".";
    public boolean copyNewResourcesToCache = LinorgSessionStorage.getSingleInstance().loadBoolean("copyNewResources", false);

    public static synchronized MetadataReader getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new MetadataReader();
        }
        return singleInstance;
    }

    private MetadataReader() {
    }

    public boolean nodeCanExistInNode(ImdiTreeObject targetImdiObject, ImdiTreeObject childImdiObject) {
        String targetImdiPath = MetadataReader.getNodePath(targetImdiObject);
        String childPath = MetadataReader.getNodePath(childImdiObject);
        targetImdiPath = targetImdiPath.replaceAll("\\(\\d*?\\)", "\\(x\\)");
        childPath = childPath.replaceAll("\\(\\d*?\\)", "\\(x\\)");
        int targetBranchCount = targetImdiPath.replaceAll("[^(]*", "").length();
        int childBranchCount = childPath.replaceAll("[^(]*", "").length();
        boolean hasCorrectSubNodeCount = childBranchCount - targetBranchCount < 2;
        return hasCorrectSubNodeCount && !childPath.equals(targetImdiPath) && childPath.startsWith(targetImdiPath);
    }

    public static String getNodePath(ImdiTreeObject targetImdiObject) {
        String xpath = targetImdiObject.isSession() ? imdiPathSeparator + "METATRANSCRIPT" + imdiPathSeparator + "Session" : (targetImdiObject.isCatalogue() ? imdiPathSeparator + "METATRANSCRIPT" + imdiPathSeparator + "Catalogue" : imdiPathSeparator + "METATRANSCRIPT" + imdiPathSeparator + "Corpus");
        String[] nodePathArray = targetImdiObject.getUrlString().split("#");
        if (nodePathArray.length > 1) {
            String nodePath;
            xpath = nodePath = nodePathArray[1].toString();
        }
        return xpath;
    }

    public URI addFromTemplate(File destinationFile, String templateType) {
        URL templateUrl;
        System.out.println("addFromJarTemplateFile: " + templateType + " : " + destinationFile);
        URI addedPathUri = null;
        if (CmdiProfileReader.pathIsProfile(templateType)) {
            try {
                templateUrl = new URL(templateType);
            }
            catch (MalformedURLException ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
                return null;
            }
        } else {
            templateUrl = MetadataReader.class.getResource("/nl/mpi/arbil/resources/templates/" + templateType.substring(1) + ".xml");
        }
        addedPathUri = this.copyToDisk(templateUrl, destinationFile);
        try {
            CmdiComponentBuilder componentBuilder = new CmdiComponentBuilder();
            Document addedDocument = componentBuilder.getDocument(addedPathUri);
            if (addedDocument == null) {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error inserting create date", "Add from Template");
            } else {
                Node linkNode = XPathAPI.selectSingleNode((Node)addedDocument, (String)"/:METATRANSCRIPT");
                NamedNodeMap metatranscriptAttributes = linkNode.getAttributes();
                LinorgVersion currentVersion = new LinorgVersion();
                String arbilVersionString = "Arbil." + currentVersion.currentMajor + "." + currentVersion.currentMinor + "." + currentVersion.currentRevision;
                arbilVersionString = arbilVersionString + ":" + metatranscriptAttributes.getNamedItem("Originator").getNodeValue();
                metatranscriptAttributes.getNamedItem("Originator").setNodeValue(arbilVersionString);
                metatranscriptAttributes.getNamedItem("Date").setNodeValue(new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime()));
                componentBuilder.savePrettyFormatting(addedDocument, new File(addedPathUri));
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
        return addedPathUri;
    }

    private URI copyToDisk(URL sourceURL, File targetFile) {
        try {
            int len;
            InputStream in = sourceURL.openStream();
            FileOutputStream out = new FileOutputStream(targetFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            out.flush();
            ((OutputStream)out).close();
            return targetFile.toURI();
        }
        catch (Exception ex) {
            System.out.println("copyToDisk: " + ex);
            GuiHelper.linorgBugCatcher.logError(ex);
            return null;
        }
    }

    public String getNodeTypeFromMimeType(String mimeType) {
        System.out.println("getNodeTypeFromMimeType: " + mimeType);
        for (String[] formatType : new String[][]{{"http://www.mpi.nl/IMDI/Schema/WrittenResource-Format.xml", ".METATRANSCRIPT.Session.Resources.WrittenResource", "Manual/WrittenResource"}, {"http://www.mpi.nl/IMDI/Schema/MediaFile-Format.xml", ".METATRANSCRIPT.Session.Resources.MediaFile", "Manual/MediaFile"}}) {
            if (formatType[2].equals(mimeType)) {
                System.out.println("UsingOverrideNodeType: " + formatType[1]);
                return formatType[1];
            }
            if (!ImdiVocabularies.getSingleInstance().vocabularyContains(formatType[0], mimeType)) continue;
            System.out.println("NodeType: " + formatType[1]);
            return formatType[1];
        }
        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("There is no controlled vocabulary for either Written Resource or Media File that match \"" + mimeType + "\"", "Add Resource");
        return null;
    }

    private String getNamedAttributeValue(NamedNodeMap namedNodeMap, String attributeName) {
        Node nameNode = namedNodeMap.getNamedItem(attributeName);
        if (nameNode != null) {
            return nameNode.getNodeValue();
        }
        return null;
    }

    public URI insertFromTemplate(ArbilTemplate currentTemplate, URI targetMetadataUri, File resourceDestinationDirectory, String elementName, String targetXmlPath, Document targetImdiDom, URI resourceUrl, String mimeType) {
        System.out.println("insertFromTemplate: " + elementName + " : " + resourceUrl);
        System.out.println("targetXpath: " + targetXmlPath);
        URI addedPathURI = null;
        String targetXpath = targetXmlPath;
        String templateFileString = null;
        try {
            CmdiComponentBuilder componentBuilder;
            Document insertableSectionDoc;
            templateFileString = elementName.substring(1);
            System.out.println("templateFileString: " + templateFileString);
            templateFileString = templateFileString.replaceAll("\\(\\d*?\\)", "(x)");
            System.out.println("templateFileString(x): " + templateFileString);
            templateFileString = templateFileString.replaceAll("\\(x\\)$", "");
            File templateFile = new File(currentTemplate.getTemplateComponentDirectory(), templateFileString + ".xml");
            System.out.println("templateFile: " + templateFile.getAbsolutePath());
            URL templateUrl = templateFile.exists() ? templateFile.toURI().toURL() : MetadataReader.class.getResource("/nl/mpi/arbil/resources/templates/" + templateFileString + ".xml");
            if (targetXpath == null) {
                targetXpath = elementName;
            } else {
                String[] targetXpathArray = targetXpath.split("\\)");
                String[] elementNameArray = elementName.split("\\)");
                targetXpath = "";
                for (int partCounter = 0; partCounter < elementNameArray.length; ++partCounter) {
                    targetXpath = targetXpathArray.length > partCounter ? targetXpath + targetXpathArray[partCounter] + ")" : targetXpath + elementNameArray[partCounter] + ")";
                }
                targetXpath = targetXpath.replaceAll("\\)$", "");
            }
            String targetRef = targetXpath = targetXpath.substring(0, targetXpath.lastIndexOf("."));
            targetXpath = targetXpath.replace(".", "/:");
            targetXpath = targetXpath.replace(")", "]");
            targetXpath = targetXpath.replace("(", "[");
            System.out.println("targetXpath: " + targetXpath);
            System.out.println("templateUrl: " + templateUrl);
            if (templateUrl == null) {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("No template found for: " + elementName.substring(1), "Load Template");
                GuiHelper.linorgBugCatcher.logError(new Exception("No template found for: " + elementName.substring(1)));
            }
            if ((insertableSectionDoc = (componentBuilder = new CmdiComponentBuilder()).getDocument(templateUrl.toURI())) != null) {
                Node addedNode;
                Node insertableNode;
                if (resourceUrl != null) {
                    URI finalResourceUrl = resourceUrl;
                    try {
                        if (this.copyNewResourcesToCache) {
                            File originalFile = new File(resourceUrl);
                            int suffixIndex = originalFile.getName().lastIndexOf(".");
                            String targetFilename = originalFile.getName().substring(0, suffixIndex);
                            String targetSuffix = originalFile.getName().substring(suffixIndex);
                            System.out.println("targetFilename: " + targetFilename + " targetSuffix: " + targetSuffix);
                            File destinationFileCopy = File.createTempFile(targetFilename, targetSuffix, resourceDestinationDirectory);
                            URI fullURI = destinationFileCopy.toURI();
                            finalResourceUrl = targetMetadataUri.relativize(fullURI);
                            this.copyToDisk(resourceUrl.toURL(), destinationFileCopy);
                            System.out.println("destinationFileCopy: " + destinationFileCopy.toString());
                        }
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                    Node linkNode = XPathAPI.selectSingleNode((Node)insertableSectionDoc, (String)"/:InsertableSection/:*/:ResourceLink");
                    String decodeUrlString = URLDecoder.decode(finalResourceUrl.toString(), "UTF-8");
                    linkNode.setTextContent(decodeUrlString);
                }
                if (mimeType != null) {
                    if (mimeType.equals("image/jpeg")) {
                        // empty if block
                    }
                    Node linkNode = XPathAPI.selectSingleNode((Node)insertableSectionDoc, (String)"/:InsertableSection/:*/:Format");
                    linkNode.setTextContent(mimeType);
                }
                if ((insertableNode = XPathAPI.selectSingleNode((Node)insertableSectionDoc, (String)"/:InsertableSection/:*")) == null) {
                    GuiHelper.linorgBugCatcher.logError(new Exception("InsertableSection not found in the template"));
                }
                Node addableNode = targetImdiDom.importNode(insertableNode, true);
                Node insertBeforeNode = null;
                String insertBeforeCSL = insertableSectionDoc.getDocumentElement().getAttribute("InsertBefore");
                if (insertBeforeCSL != null && insertBeforeCSL.length() > 0) {
                    String[] insertBeforeArray = insertableSectionDoc.getDocumentElement().getAttribute("InsertBefore").split(",");
                    int insertBeforeCounter = 0;
                    while (insertBeforeNode == null & insertBeforeCounter < insertBeforeArray.length) {
                        System.out.println("insertbefore: " + insertBeforeArray);
                        insertBeforeNode = XPathAPI.selectSingleNode((Node)targetImdiDom, (String)(targetXpath + "/:" + insertBeforeArray[insertBeforeCounter]));
                        ++insertBeforeCounter;
                    }
                }
                Node targetNode = XPathAPI.selectSingleNode((Node)targetImdiDom, (String)targetXpath);
                if (insertBeforeNode != null) {
                    System.out.println("inserting before: " + insertBeforeNode.getNodeName());
                    addedNode = targetNode.insertBefore(addableNode, insertBeforeNode);
                } else {
                    System.out.println("inserting");
                    addedNode = targetNode.appendChild(addableNode);
                }
                String nodeFragment = new CmdiComponentBuilder().convertNodeToNodePath(targetImdiDom, addedNode, targetRef);
                System.out.println("nodeFragment: " + nodeFragment);
                return new URI(targetMetadataUri.toString().split("#")[0] + "#" + nodeFragment);
            }
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading template", "Insert from Template");
        }
        catch (URISyntaxException ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
        catch (MalformedURLException ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
        catch (DOMException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
        catch (IOException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
        catch (ParserConfigurationException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
        catch (SAXException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
        catch (TransformerException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
        System.out.println("addedPathString: " + addedPathURI);
        return addedPathURI;
    }

    public URI correctLinkPath(URI parentPath, String linkString) {
        URI linkURI = null;
        try {
            linkURI = !linkString.toLowerCase().startsWith("http:") && !linkString.toLowerCase().startsWith("file:") ? parentPath.resolve(new URI(null, linkString, null)) : (linkString.toLowerCase().startsWith("&root;") ? parentPath.resolve(new URI(null, linkString.substring(6), null)) : parentPath.resolve(linkString));
        }
        catch (URISyntaxException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        if (linkURI != null) {
            linkURI = ImdiTreeObject.normaliseURI(linkURI);
        }
        return linkURI;
    }

    private void showDomIdFoundMessage() {
        if (!ImdiLoader.getSingleInstance().nodesNeedSave()) {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("A dom id attribute has been found in one or more files, these files will need to be saved to correct this.", "Load IMDI Files");
        }
    }

    public int iterateChildNodes(ImdiTreeObject parentNode, Vector<String[]> childLinks, Node startNode, String nodePath, String fullNodePath, Hashtable<ImdiTreeObject, HashSet<ImdiTreeObject>> parentChildTree, Hashtable<String, Integer> siblingNodePathCounter, int nodeOrderCounter) {
        if (!parentChildTree.containsKey(parentNode)) {
            parentChildTree.put(parentNode, new HashSet());
        }
        for (Node childNode = startNode; childNode != null; childNode = childNode.getNextSibling()) {
            ImdiTreeObject destinationNode;
            String localName = childNode.getLocalName();
            if (localName == null || (nodePath + imdiPathSeparator + localName).equals(".CMD.Header") || (nodePath + imdiPathSeparator + localName).equals(".CMD.Resources")) continue;
            NamedNodeMap attributesMap = childNode.getAttributes();
            if (attributesMap != null) {
                String catalogueLink;
                Node catalogueLinkAtt;
                if (attributesMap.getNamedItem("id") != null && !parentNode.hasDomIdAttribute && !parentNode.isCmdiMetaDataNode()) {
                    parentNode.hasDomIdAttribute = true;
                    this.showDomIdFoundMessage();
                    parentNode.setImdiNeedsSaveToDisk(null, false);
                }
                if (childNode.getLocalName().equals("CMD")) {
                    try {
                        String schemaLocationString = null;
                        Node schemaLocationNode = childNode.getAttributes().getNamedItem("xsi:noNamespaceSchemaLocation");
                        if (schemaLocationNode == null) {
                            schemaLocationNode = childNode.getAttributes().getNamedItem("xsi:schemaLocation");
                        }
                        if (schemaLocationNode == null) {
                            throw new Exception("Could not find the schema url: schemaLocationNode = " + schemaLocationNode);
                        }
                        schemaLocationString = schemaLocationNode.getNodeValue();
                        String[] schemaLocation = schemaLocationString.split("\\s");
                        schemaLocationString = schemaLocation[schemaLocation.length - 1];
                        schemaLocationString = parentNode.getURI().resolve(schemaLocationString).toString();
                        parentNode.nodeTemplate = ArbilTemplateManager.getSingleInstance().getCmdiTemplate(schemaLocationString);
                    }
                    catch (Exception exception) {
                        GuiHelper.linorgBugCatcher.logError(exception);
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not find the schema url, some nodes will not display correctly.", "CMDI Schema Location");
                    }
                }
                if (childNode.getLocalName().equals("METATRANSCRIPT")) {
                    Node templateOriginatorAtt;
                    Node archiveHandleAtt = attributesMap.getNamedItem("ArchiveHandle");
                    if (archiveHandleAtt != null) {
                        parentNode.hasArchiveHandle = true;
                    }
                    if ((templateOriginatorAtt = attributesMap.getNamedItem("Originator")) != null) {
                        String templateOriginator = templateOriginatorAtt.getNodeValue();
                        int separatorIndex = templateOriginator.indexOf(":");
                        if (separatorIndex > -1) {
                            parentNode.nodeTemplate = ArbilTemplateManager.getSingleInstance().getTemplate(templateOriginator.substring(separatorIndex + 1));
                        } else {
                            Node templateTypeAtt = attributesMap.getNamedItem("Type");
                            if (templateTypeAtt != null) {
                                String templateType = templateTypeAtt.getNodeValue();
                                parentNode.nodeTemplate = ArbilTemplateManager.getSingleInstance().getTemplate(templateType);
                            }
                        }
                    }
                }
                if ((catalogueLinkAtt = attributesMap.getNamedItem("CatalogueLink")) != null && (catalogueLink = catalogueLinkAtt.getNodeValue()).length() > 0) {
                    URI correcteLink = this.correctLinkPath(parentNode.getURI(), catalogueLink);
                    childLinks.add(new String[]{correcteLink.toString(), "CatalogueLink"});
                    parentChildTree.get(parentNode).add(ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(correcteLink));
                }
            }
            String siblingNodePath = nodePath + imdiPathSeparator + localName;
            String fullSubNodePath = fullNodePath + imdiPathSeparator + localName;
            String parentNodePath = parentNode.getURI().getFragment();
            parentNodePath = parentNodePath == null ? "" : parentNodePath.replaceAll("\\(\\d+\\)", "");
            String childsMetaNode = parentNode.getParentDomNode().getNodeTemplate().pathIsChildNode(parentNodePath + siblingNodePath);
            if (localName != null && childsMetaNode != null) {
                try {
                    String siblingSpacer = "";
                    String pathUrlXpathSeparator = "";
                    if (!parentNode.getUrlString().contains("#")) {
                        pathUrlXpathSeparator = "#";
                    }
                    ImdiTreeObject metaNodeImdiTreeObject = ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(new URI(parentNode.getURI().toString() + pathUrlXpathSeparator + siblingNodePath));
                    metaNodeImdiTreeObject.setNodeText(childsMetaNode);
                    if (!parentChildTree.containsKey(metaNodeImdiTreeObject)) {
                        parentChildTree.put(metaNodeImdiTreeObject, new HashSet());
                    }
                    parentChildTree.get(parentNode).add(metaNodeImdiTreeObject);
                    siblingSpacer = "(" + (parentChildTree.get(metaNodeImdiTreeObject).size() + 1) + ")";
                    fullSubNodePath = fullSubNodePath + siblingSpacer;
                    ImdiTreeObject subNodeImdiTreeObject = ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(new URI(parentNode.getURI().toString() + pathUrlXpathSeparator + siblingNodePath + siblingSpacer));
                    parentChildTree.get(metaNodeImdiTreeObject).add(subNodeImdiTreeObject);
                    if (!parentChildTree.containsKey(subNodeImdiTreeObject)) {
                        parentChildTree.put(subNodeImdiTreeObject, new HashSet());
                    }
                    destinationNode = subNodeImdiTreeObject;
                }
                catch (URISyntaxException ex) {
                    destinationNode = parentNode;
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
                siblingNodePath = "";
            } else {
                destinationNode = parentNode;
            }
            boolean shouldAddCurrent = false;
            NodeList childNodes = childNode.getChildNodes();
            if (childNodes.getLength() == 0 && localName != null || childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3) {
                shouldAddCurrent = true;
            }
            String fieldValue = childNodes.getLength() == 1 ? childNodes.item(0).getTextContent() : "";
            if (!siblingNodePathCounter.containsKey(fullSubNodePath)) {
                siblingNodePathCounter.put(fullSubNodePath, 0);
            } else {
                siblingNodePathCounter.put(fullSubNodePath, siblingNodePathCounter.get(fullSubNodePath) + 1);
            }
            if (parentNode.getParentDomNode().getNodeTemplate().pathIsEditableField(parentNodePath + siblingNodePath)) {
                ImdiField fieldToAdd = new ImdiField(nodeOrderCounter++, destinationNode, siblingNodePath, fieldValue, siblingNodePathCounter.get(fullSubNodePath));
                NamedNodeMap namedNodeMap = childNode.getAttributes();
                if (namedNodeMap != null) {
                    String clarinRefId;
                    String cvType = this.getNamedAttributeValue(namedNodeMap, "Type");
                    String cvUrlString = this.getNamedAttributeValue(namedNodeMap, "Link");
                    String languageId = this.getNamedAttributeValue(namedNodeMap, "LanguageId");
                    if (languageId == null) {
                        languageId = this.getNamedAttributeValue(namedNodeMap, "xml:lang");
                    }
                    String keyName = this.getNamedAttributeValue(namedNodeMap, "Name");
                    fieldToAdd.setFieldAttribute(cvType, cvUrlString, languageId, keyName);
                    if (fieldToAdd.xmlPath.endsWith("Description") && cvUrlString != null && cvUrlString.length() > 0) {
                        URI correcteLink = this.correctLinkPath(parentNode.getURI(), cvUrlString);
                        childLinks.add(new String[]{correcteLink.toString(), "Info Link"});
                        ImdiTreeObject descriptionLinkNode = ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(correcteLink);
                        descriptionLinkNode.isInfoLink = true;
                        descriptionLinkNode.imdiDataLoaded = true;
                        parentChildTree.get(parentNode).add(descriptionLinkNode);
                        descriptionLinkNode.addField(fieldToAdd);
                    }
                    if ((clarinRefId = this.getNamedAttributeValue(namedNodeMap, "ref")) != null && clarinRefId.length() > 0) {
                        URI clarinLink;
                        System.out.println("clarinRefId: " + clarinRefId);
                        CmdiComponentLinkReader cmdiComponentLinkReader = parentNode.getParentDomNode().cmdiComponentLinkReader;
                        if (cmdiComponentLinkReader != null && (clarinLink = cmdiComponentLinkReader.getLinkUrlString(clarinRefId)) != null) {
                            clarinLink = parentNode.getURI().resolve(clarinLink);
                            childLinks.add(new String[]{clarinLink.toString(), clarinRefId});
                            parentChildTree.get(destinationNode).add(ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(clarinLink));
                        }
                    }
                }
                if (shouldAddCurrent && fieldToAdd.isDisplayable()) {
                    destinationNode.addField(fieldToAdd);
                } else if (shouldAddCurrent && fieldToAdd.xmlPath.contains("CorpusLink") && fieldValue.length() > 0) {
                    try {
                        URI linkPath = this.correctLinkPath(parentNode.getURI(), fieldToAdd.getFieldValue());
                        childLinks.add(new String[]{linkPath.toString(), "IMDI Link"});
                        parentChildTree.get(parentNode).add(ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(linkPath));
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                        System.out.println("Exception CorpusLink: " + ex.getMessage());
                    }
                }
                fieldToAdd.finishLoading();
            }
            nodeOrderCounter = this.iterateChildNodes(destinationNode, childLinks, childNode.getFirstChild(), siblingNodePath, fullSubNodePath, parentChildTree, siblingNodePathCounter, nodeOrderCounter);
        }
        return nodeOrderCounter;
    }
}

